/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthenticationScheme;
import HTTPClient.AuthorizationInfo;
import HTTPClient.CIHashtable;
import HTTPClient.HttpClientConfiguration;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.NVPair;
import HTTPClient.config.CommonCollectionWrappers;
import HTTPClient.config.Configuration;
import HTTPClient.config.HTTPClientProperties;
import HTTPClient.config.Property;
import HTTPClient.config.PropertyInitializer;
import HTTPClient.i18n.HTTPClientMessages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public final class AuthenticationSchemeRegistry {
    public static final String RESP_AUTH_HEADER = "www-authenticate";
    public static final String RESP_AUTH_PROXY_HEADER = "proxy-authenticate";
    private static final Logger logger = HttpClientLoggerFactory.getLogger(AuthenticationSchemeRegistry.class.getName());
    private Map map = new Hashtable(10);
    private static final String[] BUILT_IN_AUTHENTICATION_SCHEMES = new String[]{"HTTPClient.ntlm.NtlmAuthenticationScheme", "HTTPClient.negotiate.NegotiateAuthenticationScheme"};

    protected AuthenticationSchemeRegistry() {
    }

    public static AuthenticationSchemeRegistry newInstance(boolean preLoad) {
        AuthenticationSchemeRegistry registry = new AuthenticationSchemeRegistry();
        if (preLoad) {
            registry.loadSchemes();
        }
        return registry;
    }

    private static String makeCaseInsensitive(String input) {
        if (null == input) {
            return input;
        }
        return input.toLowerCase();
    }

    private static void validateSchemeName(String schemeName) throws IllegalArgumentException {
        if (null == schemeName || "".equals(schemeName)) {
            throw new IllegalArgumentException(HTTPClientMessages.msg_unexpectedNullOrEmptyString("schemeName"));
        }
    }

    public AuthenticationScheme addScheme(AuthenticationScheme schemeObject) throws IllegalArgumentException {
        if (null == schemeObject) {
            throw new IllegalArgumentException(HTTPClientMessages.msg_unexpectedNullObject("AuthenticationScheme"));
        }
        String schemeName = schemeObject.getSchemeName();
        AuthenticationSchemeRegistry.validateSchemeName(schemeName);
        AuthenticationScheme previous = this.map.put(AuthenticationSchemeRegistry.makeCaseInsensitive(schemeName), schemeObject);
        return previous;
    }

    public AuthenticationScheme getScheme(String schemeName) throws IllegalArgumentException {
        AuthenticationSchemeRegistry.validateSchemeName(schemeName);
        Object obj = this.map.get(AuthenticationSchemeRegistry.makeCaseInsensitive(schemeName));
        return (AuthenticationScheme)obj;
    }

    public boolean hasScheme(String schemeName) throws IllegalArgumentException {
        AuthenticationSchemeRegistry.validateSchemeName(schemeName);
        return this.map.containsKey(AuthenticationSchemeRegistry.makeCaseInsensitive(schemeName));
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int getSchemeCount() {
        return this.map.size();
    }

    public AuthenticationScheme removeScheme(String schemeName) throws IllegalArgumentException {
        AuthenticationSchemeRegistry.validateSchemeName(schemeName);
        Object previous = this.map.remove(AuthenticationSchemeRegistry.makeCaseInsensitive(schemeName));
        return (AuthenticationScheme)previous;
    }

    public void removeAllSchemes() {
        this.map.clear();
    }

    public Iterator getSchemeNameIterator() {
        Set schemeSet = this.map.keySet();
        return schemeSet.iterator();
    }

    protected AuthenticationScheme createScheme(String schemeClassName) throws IllegalArgumentException, ClassNotFoundException, InstantiationException, IllegalAccessException, ClassCastException {
        if (null == schemeClassName || "".equals(schemeClassName)) {
            throw new IllegalArgumentException(HTTPClientMessages.msg_unexpectedNullOrEmptyString("schemeClassName"));
        }
        Class<?> schemeClass = Class.forName(schemeClassName);
        Object obj = schemeClass.newInstance();
        if (!(obj instanceof AuthenticationScheme)) {
            throw new ClassCastException(HTTPClientMessages.msg_objectNotInstanceOfClass("scheme", schemeClassName, AuthenticationScheme.class.getName()));
        }
        AuthenticationScheme schemeObj = (AuthenticationScheme)obj;
        return schemeObj;
    }

    public int loadSchemes() {
        int failureCount = 0;
        for (int i = 0; i < BUILT_IN_AUTHENTICATION_SCHEMES.length; ++i) {
            String schemeClassName = BUILT_IN_AUTHENTICATION_SCHEMES[i];
            try {
                AuthenticationScheme schemeObj = this.createScheme(schemeClassName);
                this.addScheme(schemeObj);
                continue;
            }
            catch (Exception e) {
                ++failureCount;
                HTTPClientMessages.log_unableToRegisterBuiltInAuthenticationScheme(logger, schemeClassName, e);
            }
        }
        List<NVPair> sysPropSchemes = HttpClientConfiguration.getAuthenticationSchemes();
        if (null != sysPropSchemes) {
            for (NVPair scheme : sysPropSchemes) {
                String schemeName = scheme.getName();
                String schemeClassName = scheme.getValue();
                try {
                    AuthenticationScheme schemeObj = this.createScheme(schemeClassName);
                    schemeObj.setSchemeName(schemeName);
                    this.addScheme(schemeObj);
                }
                catch (Exception e) {
                    ++failureCount;
                    HTTPClientMessages.log_unableToRegisterAuthenticationScheme(logger, schemeClassName, schemeName, e);
                }
            }
        }
        return failureCount;
    }

    public boolean isAnyAuthChallengeConnectionOriented(CIHashtable headers, boolean forProxy) throws IllegalArgumentException {
        if (null == headers) {
            throw new IllegalArgumentException(HTTPClientMessages.msg_unexpectedNullObject("headers"));
        }
        String headerName = null;
        headerName = forProxy ? RESP_AUTH_PROXY_HEADER : RESP_AUTH_HEADER;
        String headerValue = (String)headers.get(headerName);
        if (null == headerValue) {
            return false;
        }
        String dummyHost = "";
        int dummyPort = -1;
        Iterator iter = this.getSchemeNameIterator();
        while (iter.hasNext()) {
            String schemeName = (String)iter.next();
            boolean isConnectionOriented = this.getScheme(schemeName).isConnectionOriented();
            if (!isConnectionOriented) continue;
            try {
                AuthorizationInfo[] challenges = AuthorizationInfo.parseAuthString(headerValue, "", -1);
                if (null == challenges) continue;
                for (int i = 0; i < challenges.length; ++i) {
                    if (!challenges[i].getScheme().equalsIgnoreCase(schemeName)) continue;
                    return true;
                }
            }
            catch (Exception e) {
                HTTPClientMessages.log_unableToParseHeaderValue(logger, headerName, headerValue, e);
            }
        }
        return false;
    }

    public static final class PropertyInitializer_AuthenticationSchemes
    implements PropertyInitializer {
        public void initialize(Property property, Configuration config) throws Exception {
            if (!property.equals(HTTPClientProperties.SysProp.AUTHENTICATION_SCHEMES)) {
                return;
            }
            String sysPropNamePrefix = HTTPClientProperties.SysProp.AUTHENTICATION_SCHEMES.getName();
            int sysPropNamePrefixLength = sysPropNamePrefix.length();
            int initialSchemeCount = 4;
            ArrayList<NVPair> list = new ArrayList<NVPair>(4);
            Map<String, String> rawSysProps = config.getRawSystemProperties();
            if (null != rawSysProps) {
                for (String propName : rawSysProps.keySet()) {
                    if (!propName.startsWith(sysPropNamePrefix)) continue;
                    String schemeName = propName.substring(sysPropNamePrefixLength).trim();
                    String schemeClassName = rawSysProps.get(propName).trim();
                    list.add(new NVPair(schemeName, schemeClassName));
                }
            }
            if (0 == list.size()) {
                config.setValue(HTTPClientProperties.SysProp.AUTHENTICATION_SCHEMES, null);
            } else {
                CommonCollectionWrappers.List_NVPair readOnlyList = new CommonCollectionWrappers.List_NVPair(Collections.unmodifiableList(list));
                config.setValue(HTTPClientProperties.SysProp.AUTHENTICATION_SCHEMES, readOnlyList);
            }
        }
    }
}

