/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.IPushBackInputStream;
import HTTPClient.Util;
import HTTPClient.i18n.HTTPClientMessages;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

class BufferedInputStream
extends FilterInputStream
implements IPushBackInputStream {
    static final int READ_BUFFER_SIZE = 8192;
    private byte[] buffer = new byte[8192];
    private int pos = 0;
    private int end = 0;
    private int mark_pos = -1;
    private int lr_thrshld = 8192;
    private int lastReadByteCount = 0;
    private static final Logger logger = HttpClientLoggerFactory.getLogger(BufferedInputStream.class.getName());

    BufferedInputStream(InputStream stream) {
        super(stream);
    }

    public int read() throws IOException {
        if (this.pos >= this.end) {
            this.fillBuff();
        }
        return this.end > this.pos ? this.buffer[this.pos++] & 0xFF : -1;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        if (len <= 0) {
            return 0;
        }
        if (this.pos >= this.end && len >= this.lr_thrshld && this.mark_pos < 0) {
            int got;
            this.lastReadByteCount = got = this.in.read(buf, off, len);
            return got;
        }
        if (this.pos >= this.end) {
            this.fillBuff();
        }
        if (this.pos >= this.end) {
            return -1;
        }
        int left = this.end - this.pos;
        if (len > left) {
            len = left;
        }
        System.arraycopy(this.buffer, this.pos, buf, off, len);
        this.pos += len;
        return len;
    }

    public synchronized void unread(byte[] b, int off, int len) throws IOException {
        if (len > this.pos) {
            throw new IOException(HTTPClientMessages.msg_bufferIsFull());
        }
        this.pos -= len;
        System.arraycopy(b, off, this.buffer, this.pos, len);
    }

    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        int left = this.end - this.pos;
        if (n <= (long)left) {
            this.pos = (int)((long)this.pos + n);
            return n;
        }
        this.pos = this.end;
        return (long)left + this.in.skip(n - (long)left);
    }

    private final void fillBuff() throws IOException {
        int got;
        if (this.mark_pos > 0) {
            if (this.end >= this.buffer.length) {
                System.arraycopy(this.buffer, this.mark_pos, this.buffer, 0, this.end - this.mark_pos);
                this.pos = this.end - this.mark_pos;
            }
        } else if (this.mark_pos != 0 || this.end >= this.buffer.length) {
            this.pos = 0;
        }
        this.end = this.pos;
        this.lastReadByteCount = got = this.in.read(this.buffer, this.pos, this.buffer.length - this.pos);
        if (got > 0) {
            this.end = this.pos + got;
        }
    }

    final void topOffBuff() throws IOException {
        int got;
        if (-1 != this.mark_pos) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "topOffBuff: mark_pos=" + this.mark_pos);
            }
            return;
        }
        int len = this.end - this.pos;
        if (len >= this.buffer.length) {
            return;
        }
        if (this.pos > 0 && len > 0) {
            System.arraycopy(this.buffer, this.pos, this.buffer, 0, len);
        }
        this.pos = 0;
        this.end = len;
        this.lastReadByteCount = got = this.in.read(this.buffer, this.end, this.buffer.length - this.end);
        if (got > 0) {
            this.end += got;
        }
    }

    public int available() throws IOException {
        int avail = this.end - this.pos;
        if (avail == 0) {
            return this.in.available();
        }
        try {
            avail += this.in.available();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return avail;
    }

    void markForSearch() {
        this.mark_pos = this.pos;
    }

    int pastEnd(byte[] search, int[] search_cmp) {
        int idx = Util.findStr(search, search_cmp, this.buffer, this.mark_pos, this.pos);
        if (idx == -1) {
            this.mark_pos = this.pos > search.length ? this.pos - search.length : 0;
        } else {
            int eos = idx + search.length;
            idx = this.pos - eos;
            this.pos = eos;
            this.mark_pos = -1;
        }
        return idx;
    }

    final int getLastReadByteCount() {
        return this.lastReadByteCount;
    }

    final void zeroLastReadByteCount() {
        this.lastReadByteCount = 0;
    }
}

