/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.i18n.HTTPClientMessages;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassDetector {
    private static final Logger LOGGER = HttpClientLoggerFactory.getLogger(ClassDetector.class.getName());
    private static final String LOG_PREFIX = "ClsDet: ";
    private boolean classAvailable;
    private String className;
    private Class resolvedClass;

    public ClassDetector(String className) {
        block3: {
            this.classAvailable = false;
            this.className = null;
            this.resolvedClass = null;
            if (null == className || "".equals(className)) {
                throw new IllegalArgumentException(HTTPClientMessages.msg_unexpectedNullOrEmptyString("className"));
            }
            this.className = className;
            try {
                this.resolvedClass = Class.forName(this.className);
                this.classAvailable = true;
            }
            catch (Throwable e) {
                if (!LOGGER.isLoggable(Level.FINEST)) break block3;
                LOGGER.log(Level.FINEST, "ClsDet: Unable to resolve class '" + this.className + "'.", e);
            }
        }
    }

    public boolean isClassAvailable() {
        return this.classAvailable;
    }

    public String getClassName() {
        return this.className;
    }

    public Class getResolvedClass() {
        return this.resolvedClass;
    }
}

