/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.Base64Encoder;
import HTTPClient.ChunkedTransferEncoder;
import HTTPClient.FilenameMangler;
import HTTPClient.MultipartFormDataEncoder;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.QuotedPrintableEncoder;
import HTTPClient.UUEncoder;
import HTTPClient.i18n.HTTPClientMessages;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class Codecs {
    private Codecs() {
    }

    public static final String base64Encode(String str) {
        if (str == null) {
            return null;
        }
        try {
            return new String(Codecs.base64Encode(str.getBytes("8859_1")), "8859_1");
        }
        catch (UnsupportedEncodingException uee) {
            throw new Error(uee.toString());
        }
    }

    public static final byte[] base64Encode(byte[] data) {
        return Base64Encoder.encode(data);
    }

    public static final String base64Decode(String str) {
        if (str == null) {
            return null;
        }
        try {
            return new String(Codecs.base64Decode(str.getBytes("8859_1")), "8859_1");
        }
        catch (UnsupportedEncodingException uee) {
            throw new Error(uee.toString());
        }
    }

    public static final byte[] base64Decode(byte[] data) {
        return Base64Encoder.decode(data);
    }

    public static final char[] uuencode(byte[] data) {
        return UUEncoder.encode(data);
    }

    private static final byte[] uudecode(BufferedReader rdr) throws ParseException, IOException {
        return UUEncoder.decode(rdr);
    }

    public static final byte[] uudecode(char[] data) {
        return UUEncoder.decode(data);
    }

    public static final String quotedPrintableEncode(String str) {
        return QuotedPrintableEncoder.encode(str);
    }

    public static final String quotedPrintableDecode(String str) throws ParseException {
        return QuotedPrintableEncoder.decode(str);
    }

    public static final String URLEncode(String str) {
        return Codecs.URLEncode(str, null);
    }

    public static final String URLEncode(String str, String encoding) {
        if (str == null) {
            return null;
        }
        String stringToReturn = null;
        String encodingToUse = null;
        encodingToUse = encoding == null ? "UTF-8" : encoding;
        try {
            stringToReturn = URLEncoder.encode(str, encodingToUse);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            stringToReturn = null;
        }
        return stringToReturn;
    }

    public static final String URLDecode(String str) throws ParseException {
        return Codecs.URLDecode(str, null);
    }

    public static final String URLDecode(String s, String encoding) throws ParseException {
        String encodingToUse = null;
        String strToReturn = null;
        if (s == null) {
            return null;
        }
        encodingToUse = encoding == null ? "UTF-8" : encoding;
        try {
            strToReturn = URLDecoder.decode(s, encodingToUse);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            strToReturn = null;
            throw new ParseException(e.getMessage());
        }
        return strToReturn;
    }

    public static final NVPair[] mpFormDataDecode(byte[] data, String cont_type, String dir) throws IOException, ParseException {
        return MultipartFormDataEncoder.decode(data, cont_type, dir, null);
    }

    public static final NVPair[] mpFormDataDecode(byte[] data, String cont_type, String dir, FilenameMangler mangler) throws IOException, ParseException {
        return MultipartFormDataEncoder.decode(data, cont_type, dir, mangler);
    }

    public static final byte[] mpFormDataEncode(NVPair[] opts, NVPair[] files, NVPair[] ct_hdr) throws IOException {
        return MultipartFormDataEncoder.encode(opts, files, ct_hdr, null);
    }

    public static final byte[] mpFormDataEncode(NVPair[] opts, NVPair[] files, NVPair[] ct_hdr, FilenameMangler mangler) throws IOException {
        return MultipartFormDataEncoder.encode(opts, files, ct_hdr, mangler);
    }

    public static final String nv2query(NVPair[] pairs) {
        return Codecs.nv2query(pairs, null);
    }

    public static final String nv2query(NVPair[] pairs, String encoding) {
        if (pairs == null) {
            return null;
        }
        StringBuffer qbuf = new StringBuffer();
        for (int idx = 0; idx < pairs.length; ++idx) {
            if (pairs[idx] == null) continue;
            qbuf.append(Codecs.URLEncode(pairs[idx].getName(), encoding) + "=" + Codecs.URLEncode(pairs[idx].getValue(), encoding) + "&");
        }
        if (qbuf.length() > 0) {
            qbuf.setLength(qbuf.length() - 1);
        }
        return qbuf.toString();
    }

    public static final NVPair[] query2nv(String query) throws ParseException {
        return Codecs.query2nv(query, null);
    }

    public static final NVPair[] query2nv(String query, String encoding) throws ParseException {
        if (query == null) {
            return null;
        }
        int idx = -1;
        int cnt = 1;
        while ((idx = query.indexOf(38, idx + 1)) != -1) {
            ++cnt;
        }
        NVPair[] pairs = new NVPair[cnt];
        idx = 0;
        for (cnt = 0; cnt < pairs.length; ++cnt) {
            int eq = query.indexOf(61, idx);
            int end = query.indexOf(38, idx);
            if (end == -1) {
                end = query.length();
            }
            if (eq == -1 || eq >= end) {
                throw new ParseException(HTTPClientMessages.msg_missingTokenInContext("=", query.substring(idx, end)));
            }
            pairs[cnt] = new NVPair(Codecs.URLDecode(query.substring(idx, eq), encoding), Codecs.URLDecode(query.substring(eq + 1, end), encoding));
            idx = end + 1;
        }
        return pairs;
    }

    public static final byte[] chunkedEncode(byte[] data, NVPair[] ftrs, boolean last) {
        return Codecs.chunkedEncode(data, 0, data == null ? 0 : data.length, ftrs, last);
    }

    public static final byte[] chunkedEncode(byte[] data, int off, int len, NVPair[] ftrs, boolean last) {
        return ChunkedTransferEncoder.encode(data, off, len, ftrs, last);
    }

    public static final Object chunkedDecode(InputStream input) throws ParseException, IOException {
        return ChunkedTransferEncoder.decode(input);
    }
}

