/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.Cookie;
import HTTPClient.Cookie2;
import HTTPClient.CookiePolicyHandler;
import HTTPClient.DefaultCookiePolicyHandler;
import HTTPClient.HTTPClientModule;
import HTTPClient.HTTPConnection;
import HTTPClient.HttpClientConfiguration;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.NVPair;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import HTTPClient.Util;
import HTTPClient.config.Configuration;
import HTTPClient.config.HTTPClientProperties;
import HTTPClient.config.Property;
import HTTPClient.config.PropertyInitializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ProtocolException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieModule
implements HTTPClientModule {
    private static final Logger logger = HttpClientLoggerFactory.getLogger(CookieModule.class.getName());

    protected CookieModule() {
    }

    protected CookiePolicyHandler cookieHandler() {
        MutableStatics ms = CookieModule.getMutableStatics();
        return ms.cookie_handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int requestHandler(Request req, Response[] resp) {
        MutableStatics ms = CookieModule.getMutableStatics();
        NVPair[] hdrs = req.getHeaders();
        if (!req.getConnection().usedByHttpURLConnection) {
            int length = hdrs.length;
            for (int idx = 0; idx < hdrs.length; ++idx) {
                int beg = idx;
                while (idx < hdrs.length && hdrs[idx].getName().equalsIgnoreCase("Cookie")) {
                    if (++idx - beg <= 0) continue;
                    System.arraycopy(hdrs, idx, hdrs, beg, (length -= idx - beg) - beg);
                }
            }
            if (length < hdrs.length) {
                hdrs = Util.resizeArray(hdrs, length);
                req.setHeaders(hdrs);
            }
        }
        Map cookie_list = null;
        cookie_list = req.getConnection().getCookieStore() == null ? Util.getList(ms.cookie_cntxt_list, req.getConnection().getContext()) : req.getConnection().getCookieStore();
        if (cookie_list.size() == 0) {
            return 0;
        }
        Vector<String> names = new Vector<String>();
        Vector<Integer> lens = new Vector<Integer>();
        int version = 0;
        Map map = cookie_list;
        synchronized (map) {
            Enumeration list = Collections.enumeration(cookie_list.values());
            Vector<Cookie> remove_list = null;
            while (list.hasMoreElements()) {
                int idx;
                Cookie cookie = (Cookie)list.nextElement();
                if (cookie.hasExpired()) {
                    logger.log(Level.FINEST, "CookM - requestHandler : cookie has expired and is being removed: {0}", cookie);
                    if (remove_list == null) {
                        remove_list = new Vector<Cookie>();
                    }
                    remove_list.addElement(cookie);
                    continue;
                }
                CookiePolicyHandler cookie_handler = this.cookieHandler();
                if (!cookie.sendWith(req) || cookie_handler != null && !cookie_handler.sendCookie(cookie, req)) continue;
                int len = cookie.getPath().length();
                for (idx = 0; idx < lens.size() && (Integer)lens.elementAt(idx) >= len; ++idx) {
                }
                names.insertElementAt(cookie.toExternalForm(), idx);
                lens.insertElementAt(new Integer(len), idx);
                if (!(cookie instanceof Cookie2)) continue;
                version = Math.max(version, ((Cookie2)cookie).getVersion());
            }
            if (remove_list != null) {
                for (int idx = 0; idx < remove_list.size(); ++idx) {
                    cookie_list.remove(remove_list.elementAt(idx));
                    remove_list.remove(idx);
                }
            }
        }
        if (!names.isEmpty()) {
            int idx;
            StringBuffer value = new StringBuffer();
            if (version > 0) {
                value.append("$Version=\"" + version + "\"; ");
            }
            value.append((String)names.elementAt(0));
            for (idx = 1; idx < names.size(); ++idx) {
                value.append("; ");
                value.append((String)names.elementAt(idx));
            }
            hdrs = Util.resizeArray(hdrs, hdrs.length + 1);
            hdrs[hdrs.length - 1] = new NVPair("Cookie", value.toString());
            if (version != 1) {
                for (idx = 0; idx < hdrs.length && !hdrs[idx].getName().equalsIgnoreCase("Cookie2"); ++idx) {
                }
                if (idx == hdrs.length) {
                    hdrs = Util.resizeArray(hdrs, hdrs.length + 1);
                    hdrs[hdrs.length - 1] = new NVPair("Cookie2", "$Version=\"1\"");
                }
            }
            req.setHeaders(hdrs);
            if (value.length() > 0) {
                logger.log(Level.FINEST, "CookM: Sending cookies: {0}", value);
            }
        }
        return 0;
    }

    @Override
    public void responsePhase1Handler(Response resp, RoRequest req) throws IOException {
        String set_cookie = resp.getHeader("Set-Cookie");
        String set_cookie2 = resp.getHeader("Set-Cookie2");
        if (set_cookie == null && set_cookie2 == null) {
            return;
        }
        resp.deleteHeader("Set-Cookie");
        resp.deleteHeader("Set-Cookie2");
        if (set_cookie != null) {
            this.handleCookie(set_cookie, false, req, resp);
        }
        if (set_cookie2 != null) {
            this.handleCookie(set_cookie2, true, req, resp);
        }
    }

    @Override
    public int responsePhase2Handler(Response resp, Request req) {
        return 10;
    }

    @Override
    public void responsePhase3Handler(Response resp, RoRequest req) {
    }

    @Override
    public void trailerHandler(Response resp, RoRequest req) throws IOException {
        String set_cookie = resp.getTrailer("Set-Cookie");
        String set_cookie2 = resp.getTrailer("Set-Cookie2");
        if (set_cookie == null && set_cookie2 == null) {
            return;
        }
        resp.deleteTrailer("Set-Cookie");
        resp.deleteTrailer("Set-Cookie2");
        if (set_cookie != null) {
            this.handleCookie(set_cookie, false, req, resp);
        }
        if (set_cookie2 != null) {
            this.handleCookie(set_cookie2, true, req, resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCookie(String set_cookie, boolean cookie2, RoRequest req, Response resp) throws ProtocolException {
        Cookie[] cookies = cookie2 ? Cookie2.parse(set_cookie, req.getConnection().getHost(), req.getRequestURI(), req.getConnection().getPort()) : Cookie.parse(set_cookie, req.getConnection().getHost(), req.getRequestURI());
        logger.log(Level.FINEST, "CookM: Received and parsed {0} cookies:", Integer.toString(cookies.length));
        for (int idx = 0; idx < cookies.length; ++idx) {
            logger.log(Level.FINEST, "CookM: Cookie {0} : {1}", new Object[]{Integer.toString(idx), cookies[idx]});
        }
        Map cookie_list = null;
        if (req.getConnection().getCookieStore() == null) {
            MutableStatics ms = CookieModule.getMutableStatics();
            cookie_list = Util.getList(ms.cookie_cntxt_list, req.getConnection().getContext());
        } else {
            cookie_list = req.getConnection().getCookieStore();
        }
        Map map = cookie_list;
        synchronized (map) {
            CookiePolicyHandler cookie_handler = this.cookieHandler();
            for (int idx = 0; idx < cookies.length; ++idx) {
                Cookie cookie = (Cookie)cookie_list.get(cookies[idx]);
                if (cookie != null) {
                    if (cookies[idx].hasExpired()) {
                        logger.log(Level.FINEST, "CookM - handleCookie : cookie has expired and is being removed: {0}", cookie);
                        cookie_list.remove(cookie);
                        continue;
                    }
                    if (cookie_handler != null && !cookie_handler.acceptCookie(cookies[idx], req, resp)) continue;
                    cookie_list.put(cookies[idx], cookies[idx]);
                    continue;
                }
                if (cookie_handler != null && !cookie_handler.acceptCookie(cookies[idx], req, resp)) continue;
                cookie_list.put(cookies[idx], cookies[idx]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void discardAllCookies() {
        MutableStatics ms = CookieModule.getMutableStatics();
        WeakHashMap weakHashMap = ms.cookie_cntxt_list;
        synchronized (weakHashMap) {
            ms.cookie_cntxt_list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void discardAllCookies(Object context) {
        if (context != null) {
            MutableStatics ms = CookieModule.getMutableStatics();
            WeakHashMap weakHashMap = ms.cookie_cntxt_list;
            synchronized (weakHashMap) {
                ms.cookie_cntxt_list.remove(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cookie[] listAllCookies() {
        MutableStatics ms = CookieModule.getMutableStatics();
        Cookie[] cookies = new Cookie[]{};
        int idx = 0;
        WeakHashMap weakHashMap = ms.cookie_cntxt_list;
        synchronized (weakHashMap) {
            Collection values = ms.cookie_cntxt_list.values();
            for (Object o : values) {
                Hashtable cntxt;
                Hashtable hashtable = cntxt = (Hashtable)o;
                synchronized (hashtable) {
                    cookies = Util.resizeArray(cookies, idx + cntxt.size());
                    Enumeration cookie_list = cntxt.elements();
                    while (cookie_list.hasMoreElements()) {
                        cookies[idx++] = (Cookie)cookie_list.nextElement();
                    }
                }
            }
        }
        return cookies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cookie[] listAllCookies(Object context) {
        Hashtable cookie_list;
        MutableStatics ms = CookieModule.getMutableStatics();
        Hashtable hashtable = cookie_list = Util.getList(ms.cookie_cntxt_list, context);
        synchronized (hashtable) {
            Cookie[] cookies = new Cookie[cookie_list.size()];
            int idx = 0;
            Enumeration enum5 = cookie_list.elements();
            while (enum5.hasMoreElements()) {
                cookies[idx++] = (Cookie)enum5.nextElement();
            }
            return cookies;
        }
    }

    public static void addCookie(Cookie cookie) {
        MutableStatics ms = CookieModule.getMutableStatics();
        Hashtable cookie_list = Util.getList(ms.cookie_cntxt_list, HTTPConnection.getDefaultContext());
        cookie_list.put(cookie, cookie);
    }

    public static void addCookie(Cookie cookie, Object context) {
        MutableStatics ms = CookieModule.getMutableStatics();
        Hashtable cookie_list = Util.getList(ms.cookie_cntxt_list, context);
        cookie_list.put(cookie, cookie);
    }

    public static void removeCookie(Cookie cookie) {
        MutableStatics ms = CookieModule.getMutableStatics();
        Hashtable cookie_list = Util.getList(ms.cookie_cntxt_list, HTTPConnection.getDefaultContext());
        cookie_list.remove(cookie);
    }

    public static void removeCookie(Cookie cookie, Object context) {
        MutableStatics ms = CookieModule.getMutableStatics();
        Hashtable cookie_list = Util.getList(ms.cookie_cntxt_list, context);
        cookie_list.remove(cookie);
    }

    public static synchronized CookiePolicyHandler setCookiePolicyHandler(CookiePolicyHandler handler) {
        MutableStatics ms = CookieModule.getMutableStatics();
        CookiePolicyHandler old = ms.cookie_handler;
        ms.cookie_handler = handler;
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadCookies(String cookieJarName, WeakHashMap<Object, Hashtable> cookie_cntxt_list) {
        block16: {
            ObjectInputStream ois = null;
            try {
                File cookie_jar = new File(cookieJarName);
                if (!cookie_jar.isFile() || !cookie_jar.canRead()) break block16;
                ois = new ObjectInputStream(new FileInputStream(cookie_jar));
                WeakHashMap<Object, Hashtable> weakHashMap = cookie_cntxt_list;
                synchronized (weakHashMap) {
                    cookie_cntxt_list.put(HTTPConnection.getDefaultContext(), (Hashtable)ois.readObject());
                }
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Unable to load persisted cookies from " + cookieJarName + ".", e);
                }
            }
            finally {
                block17: {
                    if (null != ois) {
                        try {
                            ois.close();
                        }
                        catch (IOException e) {
                            if (!logger.isLoggable(Level.FINE)) break block17;
                            logger.log(Level.FINE, "Unable to close stream for loading persisted cookies from " + cookieJarName + ".", e);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveCookies(String cookieJarName, WeakHashMap<Object, Hashtable> cookie_cntxt_map) {
        block20: {
            ObjectOutputStream oos = null;
            try {
                File cookie_jar = new File(cookieJarName);
                if (cookie_jar != null && (!cookie_jar.exists() || cookie_jar.isFile() && cookie_jar.canWrite())) {
                    Hashtable cookiesForContext;
                    Hashtable<Cookie, Cookie> cookie_list = new Hashtable<Cookie, Cookie>();
                    Hashtable hashtable = cookiesForContext = Util.getList(cookie_cntxt_map, HTTPConnection.getDefaultContext());
                    synchronized (hashtable) {
                        Collection values = cookiesForContext.values();
                        for (Object o : values) {
                            Cookie cookie = (Cookie)o;
                            if (cookie.discard()) continue;
                            cookie_list.put(cookie, cookie);
                        }
                    }
                    if (cookie_list.size() > 0) {
                        oos = new ObjectOutputStream(new FileOutputStream(cookie_jar));
                        oos.writeObject(cookie_list);
                    }
                    break block20;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Unable to save persisted cookies to " + cookieJarName + ", file is not writable.");
                }
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Unable to save persisted cookies to " + cookieJarName + ".", e);
                }
            }
            finally {
                block21: {
                    if (null != oos) {
                        try {
                            oos.close();
                        }
                        catch (IOException e) {
                            if (!logger.isLoggable(Level.FINE)) break block21;
                            logger.log(Level.FINE, "Exception while closing persisted cookie stream to " + cookieJarName + ".", e);
                        }
                    }
                }
            }
        }
    }

    static MutableStatics getMutableStatics() {
        return (MutableStatics)HttpClientConfiguration.getConfiguration().getValue(HTTPClientProperties.Prop.COOKIEMODULE_MUTABLE_STATICS);
    }

    public static final class PersistedCookiesPathPropertyInitializer
    implements PropertyInitializer {
        public void initialize(Property property, Configuration config) throws Exception {
            if (!property.equals(HTTPClientProperties.SysProp.PERSISTED_COOKIES_PATH)) {
                return;
            }
            String filePath = (String)config.getValue(HTTPClientProperties.SysProp.PERSISTED_COOKIES_PATH);
            if (filePath != null) {
                return;
            }
            String os = config.getRawSystemProperty("os.name");
            if (null != os) {
                if (os.equalsIgnoreCase("Windows 95") || os.equalsIgnoreCase("16-bit Windows") || os.equalsIgnoreCase("Windows")) {
                    String javaHome = config.getRawSystemProperty("java.home");
                    if (null != javaHome) {
                        filePath = javaHome + File.separator + ".httpclient_cookies";
                    }
                } else if (os.equalsIgnoreCase("Windows NT")) {
                    String userHome = config.getRawSystemProperty("user.home");
                    if (null != userHome) {
                        filePath = userHome + File.separator + ".httpclient_cookies";
                    }
                } else if (os.equalsIgnoreCase("OS/2")) {
                    String userHome = config.getRawSystemProperty("user.home");
                    if (null != userHome) {
                        filePath = userHome + File.separator + ".httpclient_cookies";
                    }
                } else if (os.equalsIgnoreCase("Mac OS") || os.equalsIgnoreCase("MacOS")) {
                    filePath = "System Folder" + File.separator + "Preferences" + File.separator + "HTTPClientCookies";
                } else {
                    String userHome = config.getRawSystemProperty("user.home");
                    if (null != userHome) {
                        filePath = userHome + File.separator + ".httpclient_cookies";
                    }
                }
            }
            config.setValue(HTTPClientProperties.SysProp.PERSISTED_COOKIES_PATH, filePath);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SaveCookiesShutdownHook
    implements Runnable {
        private static final String cookieJarFilename = (String)HttpClientConfiguration.getConfiguration().getValue(HTTPClientProperties.SysProp.PERSISTED_COOKIES_PATH);
        private static final Map<String, WeakHashMap<Object, Hashtable>> persistedCookies = Collections.synchronizedMap(new HashMap(50));

        private SaveCookiesShutdownHook() {
        }

        private static final void addPersistedCookies(String contextId, WeakHashMap<Object, Hashtable> cookieMap) {
            persistedCookies.put(contextId, cookieMap);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map<String, WeakHashMap<Object, Hashtable>> map = persistedCookies;
            synchronized (map) {
                Object CONFIG_CONTEXT_ID = null;
                WeakHashMap<Object, Hashtable> cookieMap = persistedCookies.get(CONFIG_CONTEXT_ID);
                if (null != cookieMap) {
                    CookieModule.saveCookies(SaveCookiesShutdownHook.cookieJarFilename, cookieMap);
                }
            }
        }

        static {
            if (HttpClientConfiguration.getConfiguration().getBoolean(HTTPClientProperties.SysProp.ENABLE_COOKIES_SAVE) && null != cookieJarFilename) {
                Runtime.getRuntime().addShutdownHook(new Thread(new SaveCookiesShutdownHook()));
            }
        }
    }

    public static final class MutableStatics {
        private final WeakHashMap<Object, Hashtable> cookie_cntxt_list = new WeakHashMap();
        private CookiePolicyHandler cookie_handler = new DefaultCookiePolicyHandler();

        public MutableStatics() {
            String cookieJarName;
            Configuration config = HttpClientConfiguration.getConfiguration();
            if (null == config.getContextId() && config.getBoolean(HTTPClientProperties.SysProp.ENABLE_COOKIES_SAVE) && null != (cookieJarName = (String)config.getValue(HTTPClientProperties.SysProp.PERSISTED_COOKIES_PATH))) {
                CookieModule.loadCookies(cookieJarName, this.cookie_cntxt_list);
                SaveCookiesShutdownHook.addPersistedCookies(config.getContextId(), this.cookie_cntxt_list);
            }
        }
    }
}

