/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.HTTPClientModule;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import HTTPClient.i18n.HTTPClientMessages;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.logging.Level;
import java.util.logging.Logger;

class DefaultModule
implements HTTPClientModule {
    private int req_timeout_retries = 3;
    private static final Logger logger = HttpClientLoggerFactory.getLogger(DefaultModule.class.getName());

    DefaultModule() {
    }

    public int requestHandler(Request req, Response[] resp) {
        return 0;
    }

    public void responsePhase1Handler(Response resp, RoRequest req) {
    }

    public int responsePhase2Handler(Response resp, Request req) throws IOException {
        int sts = resp.getStatusCode();
        switch (sts) {
            case 408: {
                if (this.req_timeout_retries-- == 0 || req.getStream() != null) {
                    HTTPClientMessages.log_unhandledStatus(logger, sts, resp.getReasonLine());
                    return 10;
                }
                logger.log(Level.FINEST, "DefM:  Handling {0} {1} - resending request", new Object[]{Integer.toString(sts), resp.getReasonLine()});
                return 13;
            }
            case 411: {
                if (req.getStream() != null && req.getStream().getLength() == -1) {
                    return 10;
                }
                try {
                    resp.getInputStream().close();
                }
                catch (IOException ioe) {
                    HTTPClientMessages.log_status411(logger, ioe.getMessage());
                }
                if (req.getData() != null) {
                    throw new ProtocolException("Received status code 411 even though Content-Length was sent");
                }
                logger.log(Level.FINEST, "DefM:  Handling {0} {1} - resending request with 'Content-Length: 0'", new Object[]{Integer.toString(sts), resp.getReasonLine()});
                req.setData(new byte[0]);
                return 13;
            }
            case 505: {
                return 10;
            }
        }
        return 10;
    }

    public void responsePhase3Handler(Response resp, RoRequest req) {
    }

    public void trailerHandler(Response resp, RoRequest req) {
    }
}

