/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.HTTPClientModule;
import HTTPClient.HttpClientConfiguration;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.NVPair;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.context.ExecutionContext;

public final class ExecutionContextModule
implements HTTPClientModule {
    private static final Logger logger = HttpClientLoggerFactory.getLogger(ExecutionContextModule.class.getName());
    private static final String LOG_PREFIX = "ExecCtx: ";
    private static boolean executionContextAvailable;

    ExecutionContextModule() {
    }

    public int requestHandler(Request req, Response[] respArr) {
        if (!ExecutionContextModule.isExecutionContextProcessed()) {
            return 0;
        }
        String execCtxKey = "ECID-Context";
        String execCtxValue = ExecutionContext.wrapContext();
        int result = this.requestHandlerImpl(req, respArr, execCtxKey, execCtxValue);
        return result;
    }

    public void responsePhase1Handler(Response resp, RoRequest req) {
    }

    public int responsePhase2Handler(Response resp, Request req) throws IOException {
        return 10;
    }

    public void responsePhase3Handler(Response resp, RoRequest req) {
    }

    public void trailerHandler(Response resp, RoRequest req) {
    }

    public static boolean isExecutionContextAvailable() {
        return executionContextAvailable;
    }

    public static boolean isExecutionContextProcessed() {
        return ExecutionContextModule.isExecutionContextAvailable() && !HttpClientConfiguration.isDisableExecutionContext();
    }

    int requestHandlerImpl(Request req, Response[] respArr, String execCtxKey, String execCtxValue) {
        NVPair execCtxHeader;
        if (null == req) {
            throw new IllegalArgumentException("ExecCtx: Expected non-null Request object.");
        }
        if (null == execCtxKey || "".equals(execCtxKey)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "ExecCtx: Unable to send ExecutionContext since no ExecutionContext key is available.");
            }
            return 0;
        }
        execCtxValue = null == execCtxValue ? "" : execCtxValue;
        NVPair[] headersCurr = req.getHeaders();
        NVPair[] headersOut = new NVPair[]{};
        if (null != headersCurr) {
            headersOut = new NVPair[headersCurr.length];
            System.arraycopy(headersCurr, 0, headersOut, 0, headersCurr.length);
        }
        int NOT_FOUND = -1;
        int foundIndex = -1;
        if (null != headersOut && headersOut.length > 0) {
            for (int i = 0; i < headersOut.length; ++i) {
                String headerName = headersOut[i].getName();
                if (null == headerName || !execCtxKey.equalsIgnoreCase(headerName)) continue;
                foundIndex = i;
                if (!logger.isLoggable(Level.FINER)) break;
                logger.log(Level.FINER, "Overwriting found execution context header: name={0}, found value=''{1}''", new Object[]{headerName, headersOut[i].getValue()});
                break;
            }
        }
        if (-1 == foundIndex) {
            NVPair[] headersOutPlusOne = new NVPair[headersOut.length + 1];
            System.arraycopy(headersOut, 0, headersOutPlusOne, 0, headersOut.length);
            headersOut = headersOutPlusOne;
            foundIndex = headersOutPlusOne.length - 1;
        }
        headersOut[foundIndex] = execCtxHeader = new NVPair(execCtxKey, execCtxValue);
        req.setHeaders(headersOut);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "ExecCtx: requestHandler setting request header '" + execCtxKey + "' to value '" + execCtxValue + "'.");
        }
        return 0;
    }

    static {
        try {
            Class.forName("oracle.dms.context.ExecutionContext");
            executionContextAvailable = true;
        }
        catch (Exception e) {
            executionContextAvailable = false;
        }
    }
}

