/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.ClassDetector;
import HTTPClient.HttpClientLoggerFactory;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jrf.ServerPlatformSupport;
import oracle.jrf.ServerPlatformSupportFactory;

public final class ExecutorHelper {
    private static final Logger logger = HttpClientLoggerFactory.getLogger(ExecutorHelper.class.getName());
    static final ClassDetector WLS_WORK_MANAGER_FACTORY = new ClassDetector("weblogic.work.WorkManagerFactory");
    static final ClassDetector WLS_WORK_MANAGER_IMPL = new ClassDetector("weblogic.work.SelfTuningWorkManagerImpl");
    static final ClassDetector WLS_WORK_MANAGER = new ClassDetector("weblogic.work.WorkManager");
    static final ClassDetector WLS_WORK_EXTHREAD = new ClassDetector("weblogic.work.ExecuteThread");
    static final ClassDetector JRF_SERVER_PLATFORM = new ClassDetector("oracle.jrf.ServerPlatformSupport");

    public static Executor getExecutor() {
        Executor executor = null;
        if (JRF_SERVER_PLATFORM.isClassAvailable() && WLS_WORK_MANAGER_FACTORY.isClassAvailable() && WLS_WORK_MANAGER.isClassAvailable() && WLS_WORK_EXTHREAD.isClassAvailable() && JRF_SERVER_PLATFORM.isClassAvailable()) {
            boolean isWebLogic;
            block13: {
                isWebLogic = false;
                try {
                    isWebLogic = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                        @Override
                        public Boolean run() throws Exception {
                            ServerPlatformSupport platform = ServerPlatformSupportFactory.getInstance();
                            return platform.isWebLogic();
                        }
                    });
                }
                catch (Exception e) {
                    if (e instanceof PrivilegedActionException) {
                        e = ((PrivilegedActionException)e).getException();
                    }
                    if (!logger.isLoggable(Level.FINE)) break block13;
                    logger.log(Level.FINE, "Unable to determine whether the app server is WebLogic. ", e);
                }
            }
            if (isWebLogic) {
                Object wm;
                block14: {
                    Thread c = Thread.currentThread();
                    wm = null;
                    try {
                        Class wlsExThreadClass = WLS_WORK_EXTHREAD.getResolvedClass();
                        if (wlsExThreadClass != null && wlsExThreadClass.isInstance(c)) {
                            String mName = "getWorkManager";
                            Method m = c.getClass().getMethod(mName, new Class[0]);
                            wm = m.invoke((Object)c, new Object[0]);
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "Using Weblogic Work Manager from the current thread.");
                            }
                        }
                        if (wm == null) {
                            String m1 = "getInstance";
                            String m2 = "getDefault";
                            Class wlsWorkManagerFactory = WLS_WORK_MANAGER_FACTORY.getResolvedClass();
                            if (wlsWorkManagerFactory != null) {
                                Method getInstance = wlsWorkManagerFactory.getMethod(m1, null);
                                Object wlsWorkManagerFactoryInstance = getInstance.invoke(null, null);
                                Method getDefault = wlsWorkManagerFactoryInstance.getClass().getMethod(m2, null);
                                wm = getDefault.invoke(wlsWorkManagerFactoryInstance, null);
                                if (logger.isLoggable(Level.FINE)) {
                                    logger.log(Level.FINE, "Using the default Weblogic Work Manager instance.");
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(Level.SEVERE)) break block14;
                        logger.log(Level.SEVERE, "Unable to obtain the Weblogic Work Manager: " + e);
                    }
                }
                class WorkManagerExecutor
                implements Executor {
                    private Object wm;

                    WorkManagerExecutor(Object wm) {
                        this.wm = wm;
                    }

                    public void execute(Runnable command) {
                        block2: {
                            String methName = "schedule";
                            try {
                                Method m = this.wm.getClass().getMethod(methName, Runnable.class);
                                m.invoke(this.wm, command);
                            }
                            catch (Exception e) {
                                if (!logger.isLoggable(Level.SEVERE)) break block2;
                                logger.log(Level.SEVERE, "Error scheduling the runnable task: " + e);
                            }
                        }
                    }
                }
                executor = wm != null ? new WorkManagerExecutor(wm) : Executors.newSingleThreadExecutor();
            }
        } else {
            executor = Executors.newSingleThreadExecutor();
        }
        return executor;
    }
}

