/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.HTTPClientSSL;
import HTTPClient.HttpClientConfiguration;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.JsseSSL;
import HTTPClient.config.HTTPClientProperties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocketFactory;

public class HTTPClientSSLFactory {
    private static final Logger logger = HttpClientLoggerFactory.getLogger(HTTPClientSSLFactory.class.getName());

    static void setDefaultSSLSocketFactory(SSLSocketFactory factory) {
        MutableStatics ms = HTTPClientSSLFactory.getMutableStatics();
        ms.defaultSocketFactory = factory;
    }

    static SSLSocketFactory getDefaultSSLSocketFactory() {
        MutableStatics ms = HTTPClientSSLFactory.getMutableStatics();
        return ms.defaultSocketFactory;
    }

    static HTTPClientSSL mk(SSLSocketFactory factory) {
        if (factory == null) {
            MutableStatics ms = HTTPClientSSLFactory.getMutableStatics();
            factory = ms.defaultSocketFactory;
        }
        logger.log(Level.FINEST, "Conn: using SSL version JSSE");
        return new JsseSSL(factory);
    }

    static MutableStatics getMutableStatics() {
        return (MutableStatics)HttpClientConfiguration.getConfiguration().getValue(HTTPClientProperties.Prop.HTTPCLIENTSSLFACTORY_MUTABLE_STATICS);
    }

    public static final class MutableStatics {
        private SSLSocketFactory defaultSocketFactory = null;
    }
}

