/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthorizationInfo;
import HTTPClient.AuthorizationPrompter;
import HTTPClient.CIHashtable;
import HTTPClient.CachedConfigAction;
import HTTPClient.CachedConfigActionException;
import HTTPClient.CachedConfigExceptionAction;
import HTTPClient.Codecs;
import HTTPClient.GlobalConstants;
import HTTPClient.HTTPClientModule;
import HTTPClient.HTTPClientModuleConstants;
import HTTPClient.HTTPClientSSL;
import HTTPClient.HTTPClientSSLFactory;
import HTTPClient.HTTPResponse;
import HTTPClient.HttpClientConfiguration;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.HttpHeaderElement;
import HTTPClient.HttpOutputStream;
import HTTPClient.IdempotentSequence;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.ProtocolNotSuppException;
import HTTPClient.Request;
import HTTPClient.RespInputStreamForSSLTunneling;
import HTTPClient.Response;
import HTTPClient.SocksClient;
import HTTPClient.SocksException;
import HTTPClient.StreamDemultiplexor;
import HTTPClient.Timeouts;
import HTTPClient.URI;
import HTTPClient.Util;
import HTTPClient.config.CommonCollectionWrappers;
import HTTPClient.config.Configuration;
import HTTPClient.config.HTTPClientProperties;
import HTTPClient.config.JRFUtils;
import HTTPClient.config.Property;
import HTTPClient.config.PropertyInitializer;
import HTTPClient.i18n.HTTPClientMessages;
import HTTPClient.loadbalance.LoadBalanceEndpoint;
import HTTPClient.loadbalance.LoadBalanceProvider;
import HTTPClient.loadbalance.LoadBalanceProviderBase;
import HTTPClient.loadbalance.LoadBalanceProviderFactory;
import HTTPClient.negotiate.GSSSpnegoCredentials;
import java.applet.Applet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPConnection
implements GlobalConstants,
HTTPClientModuleConstants {
    public static final String DEFAULT_MODULES_LIST = "HTTPClient.RetryModule|HTTPClient.CookieModule|HTTPClient.RedirectionModule|HTTPClient.AuthorizationModule|HTTPClient.DefaultModule|HTTPClient.TransferEncodingModule|HTTPClient.ContentMD5Module|HTTPClient.ContentEncodingModule|HTTPClient.ExecutionContextModule";
    private static final Logger logger = HttpClientLoggerFactory.getLogger(HTTPConnection.class.getName());
    private static final Object dflt_context = new Object();
    private Object Context = null;
    private int Protocol;
    int ServerProtocolVersion;
    boolean ServProtVersKnown;
    private String RequestProtocolVersion;
    private String Host;
    private int Port;
    private boolean ipAddressesForHost_set = false;
    private List<InetAddress> ipAddressesForHost = null;
    private InetAddress LocalAddr;
    private int LocalPort;
    private String Proxy_Host = null;
    private int Proxy_Port;
    private SocksClient Socks_client = null;
    private StreamDemultiplexor input_demux = null;
    List DemuxList = Collections.synchronizedList(new LinkedList());
    private List RequestList = Collections.synchronizedList(new LinkedList());
    private boolean doesKeepAlive = false;
    private boolean keepAliveUnknown = true;
    private int keepAliveReqMax = -1;
    private int keepAliveReqLeft;
    private boolean no_chunked_instance = false;
    private int chunkSize = 4096;
    private Timeouts Timeout;
    private NVPair[] DefaultHeaders = new NVPair[0];
    private Vector ModuleList;
    private boolean allowUI;
    private HTTPClientSSL m_ssl;
    private AuthorizationPrompter m_authPrompter = null;
    private SSLSocketFactory m_SSLSocketFactory;
    private SocketFactory m_socketFactory;
    private HostnameVerifier hostnameVerifier = null;
    private static final HostnameVerifier NULL_HOSTNAME_VERIFIER = new HostnameVerifier(){

        public boolean verify(String hostname, SSLSession session) {
            return false;
        }
    };
    private Map m_cookieMap = null;
    private String urlEncoding;
    private static final char[] CR_LF = "\r\n".toCharArray();
    private static final int MAX_INITIAL_CONNECT_SSL_TUNNELING_SUBREQUESTS = 10;
    boolean usedByHttpURLConnection = false;
    private LoadBalanceEndpoint loadBalanceEndpoint = null;
    private final Configuration cachedConfiguration = HttpClientConfiguration.getConfiguration();
    private static final Pattern IPV4_COARSE_PATTERN;
    private volatile Response early_stall = null;
    private volatile Response late_stall = null;
    private volatile Response prev_resp = null;
    private boolean output_finished = true;

    public HTTPConnection(Applet applet) throws ProtocolNotSuppException {
        this(applet.getCodeBase().getProtocol(), applet.getCodeBase().getHost(), applet.getCodeBase().getPort());
    }

    public HTTPConnection(String host) {
        this.Setup(0, host, 80, null, -1);
    }

    public HTTPConnection(String host, int port) {
        this.Setup(0, host, port, null, -1);
    }

    public HTTPConnection(String prot, String host, int port) throws ProtocolNotSuppException {
        this(prot, host, port, null, -1);
    }

    public HTTPConnection(String prot, String host, int port, InetAddress localAddr, int localPort) throws ProtocolNotSuppException {
        prot = prot.trim().toLowerCase();
        if (!prot.equals("http") && !prot.equals("https")) {
            throw new ProtocolNotSuppException("Unsupported protocol '" + prot + "'");
        }
        this.Setup(this.getProtocol(prot), host, port, localAddr, localPort);
    }

    public HTTPConnection(URL url) throws ProtocolNotSuppException {
        this(url.getProtocol(), url.getHost(), url.getPort());
    }

    public HTTPConnection(URL url, boolean oracleSSL) throws ProtocolNotSuppException {
        this(url.getProtocol(), url.getHost(), url.getPort());
    }

    public HTTPConnection(URI uri) throws ProtocolNotSuppException {
        this(uri.getScheme(), uri.getHost(), uri.getPort());
    }

    private void Setup(final int prot, final String host, final int port, final InetAddress localAddr, final int localPort) {
        this.doAction(new CachedConfigAction<Object>(){

            @Override
            public Object run() {
                MutableStatics ms;
                HTTPConnection.this.Protocol = prot;
                HTTPConnection.this.Host = host.trim().toLowerCase();
                HTTPConnection.this.Port = port;
                HTTPConnection.this.LocalAddr = localAddr;
                HTTPConnection.this.LocalPort = localPort;
                if (HTTPConnection.this.Port == -1) {
                    HTTPConnection.this.Port = URI.defaultPort(HTTPConnection.this.getProtocol());
                }
                if ((ms = HTTPConnection.getMutableStatics()).defaultProxyHost != null && !HTTPConnection.this.matchNonProxy(HTTPConnection.this.Host)) {
                    HTTPConnection.this.setCurrentProxy(ms.defaultProxyHost, ms.defaultProxyPort);
                } else {
                    HTTPConnection.this.setCurrentProxy(null, 0);
                }
                HTTPConnection.this.Socks_client = ms.default_Socks_client;
                HTTPConnection.this.Timeout = ms.defaultTimeout;
                HTTPConnection.this.ModuleList = (Vector)ms.defaultModuleList.clone();
                HTTPConnection.this.allowUI = ms.defaultAllowUI;
                if (HttpClientConfiguration.getNoKeepAlives()) {
                    HTTPConnection.this.setDefaultHeaders(new NVPair[]{new NVPair("Connection", "close")});
                }
                HTTPConnection.this.setChunking(!HttpClientConfiguration.getNoChunkingFlag());
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchNonProxy(String host) {
        MutableStatics mutableStatics = HTTPConnection.getMutableStatics();
        CIHashtable cIHashtable = mutableStatics.non_proxy_host_list;
        synchronized (cIHashtable) {
            if (mutableStatics.non_proxy_host_list.get(host) != null) {
                return true;
            }
        }
        for (int idx = 0; idx < mutableStatics.non_proxy_dom_list.size(); ++idx) {
            if (!host.endsWith((String)mutableStatics.non_proxy_dom_list.elementAt(idx))) continue;
            return true;
        }
        if (mutableStatics.non_proxy_addr_list.size() == 0) {
            return false;
        }
        InetAddress[] host_addr = null;
        try {
            host_addr = InetAddress.getAllByName(host);
        }
        catch (UnknownHostException uhe) {
            return false;
        }
        if (host_addr != null && host_addr.length > 0) {
            for (int i = 0; i < host_addr.length; ++i) {
                try {
                    if (HTTPConnection.findIP(host_addr[i].getHostAddress()) >= 0) {
                        return true;
                    }
                    continue;
                }
                catch (ParseException pe) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public HTTPResponse Head(String file) throws IOException, ModuleException {
        return this.Head(file, (String)null, null);
    }

    public HTTPResponse Head(String file, NVPair[] form_data) throws IOException, ModuleException {
        return this.Head(file, form_data, null);
    }

    public HTTPResponse Head(String file, NVPair[] form_data, NVPair[] headers) throws IOException, ModuleException {
        String File2 = this.addQueryToFile(file, form_data);
        return this.setupRequest("HEAD", File2, headers, null, null);
    }

    public HTTPResponse Head(String file, String query) throws IOException, ModuleException {
        return this.Head(file, query, null);
    }

    public HTTPResponse Head(String file, String query, NVPair[] headers) throws IOException, ModuleException {
        String File2 = this.addQueryToFile(file, query);
        return this.setupRequest("HEAD", File2, headers, null, null);
    }

    public HTTPResponse Get(String file) throws IOException, ModuleException {
        return this.Get(file, (String)null, null);
    }

    public HTTPResponse Get(String file, NVPair[] form_data) throws IOException, ModuleException {
        return this.Get(file, form_data, null);
    }

    public HTTPResponse Get(String file, NVPair[] form_data, NVPair[] headers) throws IOException, ModuleException {
        String File2 = this.addQueryToFile(file, form_data);
        return this.setupRequest("GET", File2, headers, null, null);
    }

    public HTTPResponse Get(String file, String query) throws IOException, ModuleException {
        return this.Get(file, query, null);
    }

    public HTTPResponse Get(String file, String query, NVPair[] headers) throws IOException, ModuleException {
        String File2 = this.addQueryToFile(file, query);
        return this.setupRequest("GET", File2, headers, null, null);
    }

    public HTTPResponse Post(String file) throws IOException, ModuleException {
        return this.Post(file, (byte[])null, null);
    }

    public HTTPResponse Post(String file, NVPair[] form_data) throws IOException, ModuleException {
        NVPair[] headers = new NVPair[]{new NVPair("Content-type", "application/x-www-form-urlencoded")};
        return this.Post(file, Codecs.nv2query(form_data, this.urlEncoding), headers);
    }

    public HTTPResponse Post(String file, NVPair[] form_data, NVPair[] headers) throws IOException, ModuleException {
        int idx;
        for (idx = 0; idx < headers.length && !headers[idx].getName().equalsIgnoreCase("Content-type"); ++idx) {
        }
        if (idx == headers.length) {
            headers = Util.resizeArray(headers, idx + 1);
            headers[idx] = new NVPair("Content-type", "application/x-www-form-urlencoded");
        }
        return this.Post(file, Codecs.nv2query(form_data, this.urlEncoding), headers);
    }

    public HTTPResponse Post(String file, String data) throws IOException, ModuleException {
        return this.Post(file, data, null);
    }

    public HTTPResponse Post(String file, String data, NVPair[] headers) throws IOException, ModuleException {
        byte[] tmp = null;
        if (data != null && data.length() > 0) {
            tmp = data.getBytes();
        }
        return this.Post(file, tmp, headers);
    }

    public HTTPResponse Post(String file, byte[] data) throws IOException, ModuleException {
        return this.Post(file, data, null);
    }

    public HTTPResponse Post(String file, byte[] data, NVPair[] headers) throws IOException, ModuleException {
        if (data == null) {
            data = new byte[]{};
        }
        return this.setupRequest("POST", HTTPConnection.stripRef(file), headers, data, null);
    }

    public HTTPResponse Post(String file, HttpOutputStream stream) throws IOException, ModuleException {
        return this.Post(file, stream, null);
    }

    public HTTPResponse Post(String file, HttpOutputStream stream, NVPair[] headers) throws IOException, ModuleException {
        return this.setupRequest("POST", HTTPConnection.stripRef(file), headers, null, stream);
    }

    public HTTPResponse Post(String file, byte[] data, HttpOutputStream stream, NVPair[] headers) throws IOException, ModuleException {
        return this.setupRequest("POST", HTTPConnection.stripRef(file), headers, data, stream);
    }

    public HTTPResponse Put(String file, String data) throws IOException, ModuleException {
        return this.Put(file, data, null);
    }

    public HTTPResponse Put(String file, String data, NVPair[] headers) throws IOException, ModuleException {
        byte[] tmp = null;
        if (data != null && data.length() > 0) {
            tmp = data.getBytes();
        }
        return this.Put(file, tmp, headers);
    }

    public HTTPResponse Put(String file, byte[] data) throws IOException, ModuleException {
        return this.Put(file, data, null);
    }

    public HTTPResponse Put(String file, byte[] data, NVPair[] headers) throws IOException, ModuleException {
        if (data == null) {
            data = new byte[]{};
        }
        return this.setupRequest("PUT", HTTPConnection.stripRef(file), headers, data, null);
    }

    public HTTPResponse Put(String file, HttpOutputStream stream) throws IOException, ModuleException {
        return this.Put(file, stream, null);
    }

    public HTTPResponse Put(String file, HttpOutputStream stream, NVPair[] headers) throws IOException, ModuleException {
        return this.setupRequest("PUT", HTTPConnection.stripRef(file), headers, null, stream);
    }

    public HTTPResponse Options(String file) throws IOException, ModuleException {
        return this.Options(file, null, (byte[])null);
    }

    public HTTPResponse Options(String file, NVPair[] headers) throws IOException, ModuleException {
        return this.Options(file, headers, (byte[])null);
    }

    public HTTPResponse Options(String file, NVPair[] headers, byte[] data) throws IOException, ModuleException {
        return this.setupRequest("OPTIONS", HTTPConnection.stripRef(file), headers, data, null);
    }

    public HTTPResponse Options(String file, NVPair[] headers, HttpOutputStream stream) throws IOException, ModuleException {
        return this.setupRequest("OPTIONS", HTTPConnection.stripRef(file), headers, null, stream);
    }

    public HTTPResponse Delete(String file) throws IOException, ModuleException {
        return this.Delete(file, null);
    }

    public HTTPResponse Delete(String file, NVPair[] headers) throws IOException, ModuleException {
        return this.setupRequest("DELETE", HTTPConnection.stripRef(file), headers, null, null);
    }

    public HTTPResponse Trace(String file, NVPair[] headers) throws IOException, ModuleException {
        return this.setupRequest("TRACE", HTTPConnection.stripRef(file), headers, null, null);
    }

    public HTTPResponse Trace(String file) throws IOException, ModuleException {
        return this.Trace(file, null);
    }

    public HTTPResponse ExtensionMethod(String method, String file, byte[] data, NVPair[] headers) throws IOException, ModuleException {
        return this.setupRequest(method.trim(), HTTPConnection.stripRef(file), headers, data, null);
    }

    public HTTPResponse ExtensionMethod(String method, String file, HttpOutputStream os, NVPair[] headers) throws IOException, ModuleException {
        return this.setupRequest(method.trim(), HTTPConnection.stripRef(file), headers, null, os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        List list = this.RequestList;
        synchronized (list) {
            for (Request req : this.RequestList) {
                req.aborted = true;
            }
        }
        ArrayList abortedDemuxers = new ArrayList(this.DemuxList.size());
        Iterator iterator = this.DemuxList;
        synchronized (iterator) {
            Iterator iterator2 = this.DemuxList.iterator();
            while (iterator2.hasNext()) {
                abortedDemuxers.add(iterator2.next());
            }
        }
        for (StreamDemultiplexor demux : abortedDemuxers) {
            demux.abort();
            this.DemuxList.remove(demux);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultHeaders(NVPair[] headers) {
        int length = headers == null ? 0 : headers.length;
        NVPair[] def_hdrs = new NVPair[length];
        int didx = 0;
        for (int sidx = 0; sidx < length; ++sidx) {
            String name;
            if (headers[sidx] == null || (name = headers[sidx].getName().trim()).equalsIgnoreCase("Content-Length")) continue;
            def_hdrs[didx++] = headers[sidx];
        }
        if (didx < length) {
            def_hdrs = Util.resizeArray(def_hdrs, didx);
        }
        NVPair[] nVPairArray = this.DefaultHeaders;
        synchronized (this.DefaultHeaders) {
            this.DefaultHeaders = def_hdrs;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NVPair[] getDefaultHeaders() {
        NVPair[] nVPairArray = this.DefaultHeaders;
        synchronized (this.DefaultHeaders) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (NVPair[])this.DefaultHeaders.clone();
        }
    }

    public String getProtocol() {
        switch (this.Protocol) {
            case 0: {
                return "http";
            }
            case 1: {
                return "https";
            }
            case 2: {
                return "shttp";
            }
            case 3: {
                return "http-ng";
            }
        }
        throw new Error("HTTPClient Internal Error: invalid protocol " + this.Protocol);
    }

    public String getHost() {
        return this.Host;
    }

    public int getPort() {
        return this.Port;
    }

    public String getProxyHost() {
        return this.Proxy_Host;
    }

    public int getProxyPort() {
        return this.Proxy_Port;
    }

    public boolean isCompatibleWith(URI uri) {
        if (!uri.getScheme().equals(this.getProtocol()) || !uri.getHost().equalsIgnoreCase(this.Host)) {
            return false;
        }
        int port = uri.getPort();
        if (port == -1) {
            port = URI.defaultPort(uri.getScheme());
        }
        return port == this.Port;
    }

    public void setRawMode(boolean raw) {
        String[] modules = new String[]{"HTTPClient.CookieModule", "HTTPClient.RedirectionModule", "HTTPClient.AuthorizationModule", "HTTPClient.DefaultModule", "HTTPClient.TransferEncodingModule", "HTTPClient.ContentMD5Module", "HTTPClient.ContentEncodingModule", "HTTPClient.ExecutionContextModule"};
        for (int idx = 0; idx < modules.length; ++idx) {
            try {
                if (raw) {
                    this.removeModule(Class.forName(modules[idx]));
                    continue;
                }
                this.addModule(Class.forName(modules[idx]), -1);
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
    }

    public static void setDefaultTimeout(int time) {
        HTTPConnection.getMutableStatics().defaultTimeout = new Timeouts(time);
    }

    public static void setDefaultConnectionTimeout(int time) {
        int readTimeout = HTTPConnection.getDefaultTimeout();
        HTTPConnection.getMutableStatics().defaultTimeout = new Timeouts(readTimeout, time);
    }

    public static int getDefaultTimeout() {
        return ((MutableStatics)HTTPConnection.getMutableStatics()).defaultTimeout.read;
    }

    public static int getDefaultConnectionTimeout() {
        return ((MutableStatics)HTTPConnection.getMutableStatics()).defaultTimeout.connection;
    }

    public void setTimeout(int time) {
        this.Timeout = new Timeouts(time);
    }

    public void setConnectionTimeout(int time) {
        this.Timeout = new Timeouts(this.Timeout.read, time);
    }

    public int getTimeout() {
        return this.Timeout.read;
    }

    public int getConnectionTimeout() {
        return this.Timeout.connection;
    }

    public void setAllowUserInteraction(boolean allow) {
        this.allowUI = allow;
    }

    public boolean getAllowUserInteraction() {
        return this.allowUI;
    }

    public static void setDefaultAllowUserInteraction(boolean allow) {
        HTTPConnection.getMutableStatics().defaultAllowUI = allow;
    }

    public static boolean getDefaultAllowUserInteraction() {
        return HTTPConnection.getMutableStatics().defaultAllowUI;
    }

    public static Class[] getDefaultModules() {
        return HTTPConnection.getModules(HTTPConnection.getMutableStatics().defaultModuleList);
    }

    public static boolean addDefaultModule(Class module, int pos) {
        return HTTPConnection.addModule(HTTPConnection.getMutableStatics().defaultModuleList, module, pos);
    }

    public static boolean removeDefaultModule(Class module) {
        return HTTPConnection.removeModule(HTTPConnection.getMutableStatics().defaultModuleList, module);
    }

    public Class[] getModules() {
        return HTTPConnection.getModules(this.ModuleList);
    }

    public boolean addModule(final Class module, final int pos) {
        return this.doAction(new CachedConfigAction<Boolean>(){

            @Override
            public Boolean run() {
                return HTTPConnection.addModule(HTTPConnection.this.ModuleList, module, pos);
            }
        });
    }

    public boolean removeModule(final Class module) {
        return this.doAction(new CachedConfigAction<Boolean>(){

            @Override
            public Boolean run() {
                return HTTPConnection.removeModule(HTTPConnection.this.ModuleList, module);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Class[] getModules(Vector list) {
        Vector vector = list;
        synchronized (vector) {
            Object[] modules = new Class[list.size()];
            list.copyInto(modules);
            return modules;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean addModule(Vector list, Class module, int pos) {
        if (module == null) {
            return false;
        }
        try {
            HTTPClientModule tmp = (HTTPClientModule)module.newInstance();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        MutableStatics mutableStatics = HTTPConnection.getMutableStatics();
        Vector vector = list;
        synchronized (vector) {
            if (list.contains(module)) {
                return false;
            }
            if (pos < 0) {
                list.insertElementAt(module, mutableStatics.defaultModuleList.size() + pos + 1);
            } else {
                list.insertElementAt(module, pos);
            }
        }
        String moduleListName = null;
        moduleListName = list == mutableStatics.defaultModuleList ? "default" : "";
        HTTPClientMessages.log_config_addedModuleToList(logger, module.getName(), moduleListName);
        return true;
    }

    private static final boolean removeModule(Vector list, Class module) {
        if (module == null) {
            return false;
        }
        boolean removed = list.removeElement(module);
        String moduleListName = "";
        if (list == HTTPConnection.getMutableStatics().defaultModuleList) {
            moduleListName = "default";
        }
        if (removed) {
            HTTPClientMessages.log_config_removedModuleFromList(logger, module.getName(), moduleListName);
        }
        return removed;
    }

    public void setContext(Object context) {
        if (context == null) {
            throw new IllegalArgumentException("Context must be non-null");
        }
        if (this.Context != null) {
            throw new IllegalStateException("Context already set");
        }
        this.Context = context;
    }

    public Object getContext() {
        if (this.Context != null) {
            return this.Context;
        }
        return dflt_context;
    }

    public static Object getDefaultContext() {
        return dflt_context;
    }

    public void addDigestAuthorization(final String realm, final String user, final String passwd) {
        this.doAction(new CachedConfigAction<Object>(){

            @Override
            public Object run() {
                AuthorizationInfo.addDigestAuthorization(HTTPConnection.this.Host, HTTPConnection.this.Port, realm, user, passwd, HTTPConnection.this.getContext());
                return null;
            }
        });
    }

    public void addBasicAuthorization(final String realm, final String user, final String passwd) {
        this.doAction(new CachedConfigAction<Object>(){

            @Override
            public Object run() {
                AuthorizationInfo.addBasicAuthorization(HTTPConnection.this.Host, HTTPConnection.this.Port, realm, user, passwd, HTTPConnection.this.getContext());
                return null;
            }
        });
    }

    public void addNtlmAuthentication(String username, String password) {
        this.addNtlmAuthentication(null, username, password);
    }

    public void addNtlmAuthentication(final String ntlmAuthMethod, final String username, final String password) {
        this.doAction(new CachedConfigAction<Object>(){

            @Override
            public Object run() {
                AuthorizationInfo.addNtlmAuthentication(HTTPConnection.this.Host, HTTPConnection.this.Port, ntlmAuthMethod, username, password, HTTPConnection.this.getContext());
                return null;
            }
        });
    }

    public void addNegotiateAuthentication(String userName, String password, String spn) {
        this.addNegotiateAuthentication(new GSSSpnegoCredentials(userName, password, spn));
    }

    public void addNegotiateAuthentication(final GSSSpnegoCredentials cred) {
        this.doAction(new CachedConfigAction<Object>(){

            @Override
            public Object run() {
                AuthorizationInfo.addNegotiateAuthentication(HTTPConnection.this.Host, HTTPConnection.this.Port, cred, HTTPConnection.this.getContext());
                return null;
            }
        });
    }

    public static void setProxyServer(String host, int port) {
        HTTPConnection.setProxyServer(HTTPConnection.getMutableStatics(), host, port);
    }

    private static void setProxyServer(MutableStatics ms, String host, int port) {
        if (host == null || host.trim().length() == 0) {
            ms.defaultProxyHost = null;
        } else {
            ms.defaultProxyHost = host.trim().toLowerCase();
            ms.defaultProxyPort = port;
        }
    }

    public synchronized void setCurrentProxy(final String host, final int port) {
        this.doAction(new CachedConfigAction<Object>(){

            @Override
            public Object run() {
                if (host == null || host.trim().length() == 0) {
                    HTTPConnection.this.Proxy_Host = null;
                } else {
                    HTTPConnection.this.Proxy_Host = host.trim().toLowerCase();
                    if (port <= 0) {
                        HTTPConnection.this.Proxy_Port = 80;
                    } else {
                        HTTPConnection.this.Proxy_Port = port;
                    }
                }
                switch (HTTPConnection.this.Protocol) {
                    case 0: 
                    case 1: {
                        if (HttpClientConfiguration.getForceHTTP1_0()) {
                            HTTPConnection.this.ServerProtocolVersion = 65536;
                            HTTPConnection.this.ServProtVersKnown = true;
                            HTTPConnection.this.RequestProtocolVersion = "HTTP/1.0";
                            break;
                        }
                        HTTPConnection.this.ServerProtocolVersion = 65537;
                        HTTPConnection.this.ServProtVersKnown = false;
                        HTTPConnection.this.RequestProtocolVersion = "HTTP/1.1";
                        break;
                    }
                    case 3: {
                        HTTPConnection.this.ServerProtocolVersion = -1;
                        HTTPConnection.this.ServProtVersKnown = false;
                        HTTPConnection.this.RequestProtocolVersion = "";
                        break;
                    }
                    case 2: {
                        HTTPConnection.this.ServerProtocolVersion = -1;
                        HTTPConnection.this.ServProtVersKnown = false;
                        HTTPConnection.this.RequestProtocolVersion = "Secure-HTTP/1.3";
                        break;
                    }
                    default: {
                        throw new Error("HTTPClient Internal Error: invalid protocol " + HTTPConnection.this.Protocol);
                    }
                }
                HTTPConnection.this.keepAliveUnknown = true;
                HTTPConnection.this.doesKeepAlive = false;
                HTTPConnection.this.input_demux = null;
                HTTPConnection.this.early_stall = null;
                HTTPConnection.this.late_stall = null;
                HTTPConnection.this.prev_resp = null;
                return null;
            }
        });
    }

    public static void dontProxyFor(String host) throws ParseException {
        HTTPConnection.dontProxyFor(HTTPConnection.getMutableStatics(), host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dontProxyFor(MutableStatics mutableStatics, String host) throws ParseException {
        if ((host = host.trim().toLowerCase()).startsWith("*.")) {
            host = host.substring(1);
        }
        if (host.charAt(0) == '.') {
            if (!mutableStatics.non_proxy_dom_list.contains(host)) {
                mutableStatics.non_proxy_dom_list.addElement(host);
            }
            return;
        }
        if (!HTTPConnection.isStringAnIP(host)) {
            CIHashtable cIHashtable = mutableStatics.non_proxy_host_list;
            synchronized (cIHashtable) {
                mutableStatics.non_proxy_host_list.put(host, "");
            }
            return;
        }
        byte[] ip_addr = null;
        byte[] ip_mask = null;
        boolean isIPv6 = false;
        int slash = host.indexOf(47);
        if (slash != -1) {
            String h = host.substring(0, slash);
            ip_addr = Util.string2arr(h);
            isIPv6 = HTTPConnection.isAddressIPv6(h);
            if (isIPv6) {
                ip_mask = HTTPConnection.extractIPv6NetMask(host);
            } else {
                ip_mask = Util.string2arr(host.substring(slash + 1));
                if (ip_addr.length != ip_mask.length) {
                    throw new ParseException("length of IP-address (" + ip_addr.length + ") != length of netmask (" + ip_mask.length + ")");
                }
            }
        } else {
            ip_addr = Util.string2arr(host);
            ip_mask = new byte[ip_addr.length];
            for (int idx = 0; idx < ip_mask.length; ++idx) {
                ip_mask[idx] = -1;
            }
        }
        block4: for (int idx = 0; idx < mutableStatics.non_proxy_addr_list.size(); ++idx) {
            byte[] addr = (byte[])mutableStatics.non_proxy_addr_list.elementAt(idx);
            if (addr.length != ip_addr.length || mutableStatics.non_proxy_mask_list.size() == 0) continue;
            byte[] mask = (byte[])mutableStatics.non_proxy_mask_list.elementAt(idx);
            for (int idx2 = 0; idx2 < addr.length; ++idx2) {
                if ((ip_addr[idx2] & mask[idx2]) != (addr[idx2] & mask[idx2]) || mask[idx2] != ip_mask[idx2]) continue block4;
            }
            return;
        }
        mutableStatics.non_proxy_addr_list.addElement(ip_addr);
        mutableStatics.non_proxy_mask_list.addElement(ip_mask);
    }

    private static boolean isAddressIPv6(String h) {
        boolean ipv6;
        block2: {
            ipv6 = false;
            try {
                ipv6 = InetAddress.getByName(h) instanceof Inet6Address;
            }
            catch (UnknownHostException e) {
                if (!logger.isLoggable(Level.FINE)) break block2;
                logger.log(Level.FINE, "Expected address to be in IPv6 Hex format.  Cannot resolve host: " + h, e);
            }
        }
        return ipv6;
    }

    public static void dontProxyFor(String[] hosts) {
        HTTPConnection.dontProxyFor(HTTPConnection.getMutableStatics(), hosts);
    }

    private static void dontProxyFor(MutableStatics mutableStatics, String[] hosts) {
        if (hosts == null || hosts.length == 0) {
            return;
        }
        for (int idx = 0; idx < hosts.length; ++idx) {
            try {
                if (hosts[idx] == null) continue;
                HTTPConnection.dontProxyFor(mutableStatics, hosts[idx]);
                continue;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doProxyFor(String host) throws ParseException {
        MutableStatics mutableStatics = HTTPConnection.getMutableStatics();
        if ((host = host.trim().toLowerCase()).charAt(0) == '.') {
            return mutableStatics.non_proxy_dom_list.removeElement(host);
        }
        Cloneable cloneable = mutableStatics.non_proxy_host_list;
        synchronized (cloneable) {
            if (!HTTPConnection.isStringAnIP(host)) {
                return mutableStatics.non_proxy_host_list.remove(host) != null;
            }
        }
        cloneable = mutableStatics.non_proxy_addr_list;
        synchronized (cloneable) {
            int idx = HTTPConnection.findIP(host);
            if (idx >= 0) {
                mutableStatics.non_proxy_addr_list.removeElementAt(idx);
                mutableStatics.non_proxy_mask_list.removeElementAt(idx);
                return true;
            }
        }
        return false;
    }

    static int findIP(String host) throws ParseException {
        MutableStatics mutableStatics = HTTPConnection.getMutableStatics();
        int foundIndex = -1;
        byte[] ip_addr = null;
        byte[] ip_mask = null;
        boolean isIPV6 = false;
        int slash = host.indexOf(47);
        if (slash != -1) {
            String h = host.substring(0, slash);
            isIPV6 = HTTPConnection.isAddressIPv6(h);
            ip_addr = Util.string2arr(h);
            if (isIPV6) {
                ip_mask = HTTPConnection.extractIPv6NetMask(host);
            } else {
                ip_mask = Util.string2arr(host.substring(slash + 1));
                if (ip_addr.length != ip_mask.length) {
                    throw new ParseException("length of IP-address (" + ip_addr.length + ") != length of netmask (" + ip_mask.length + ")");
                }
            }
        } else {
            ip_addr = Util.string2arr(host);
            ip_mask = new byte[ip_addr.length];
            for (int idx = 0; idx < ip_mask.length; ++idx) {
                ip_mask[idx] = -1;
            }
        }
        block1: for (int idx = 0; idx < mutableStatics.non_proxy_addr_list.size(); ++idx) {
            byte[] addr = (byte[])mutableStatics.non_proxy_addr_list.elementAt(idx);
            byte[] mask = (byte[])mutableStatics.non_proxy_mask_list.elementAt(idx);
            if (addr.length != ip_addr.length) continue;
            for (int idx2 = 0; idx2 < addr.length; ++idx2) {
                if ((ip_addr[idx2] & mask[idx2]) != (addr[idx2] & mask[idx2])) continue block1;
            }
            foundIndex = idx;
            break;
        }
        return foundIndex;
    }

    static byte[] extractIPv6NetMask(String ipWithPrefixLength) {
        int slashIdx = ipWithPrefixLength.indexOf(47);
        int prefixLength = Integer.parseInt(ipWithPrefixLength.substring(slashIdx + 1));
        byte[] netmask_addr = new byte[16];
        InetAddress ia = null;
        try {
            ia = InetAddress.getByName(ipWithPrefixLength.substring(0, slashIdx));
        }
        catch (UnknownHostException e) {
            return netmask_addr;
        }
        byte[] rawB = ia.getAddress();
        String ipInBinary = "";
        int totalBits = 0;
        for (int i = 0; i < rawB.length; ++i) {
            int t = 0xFF & rawB[i];
            String binaryStr = Integer.toBinaryString(t);
            binaryStr = HTTPConnection.padBits(binaryStr, 8, '0', true);
            ipInBinary = ipInBinary + binaryStr;
            totalBits += binaryStr.length();
        }
        String netmaskStr = HTTPConnection.padBits(ipInBinary.substring(0, prefixLength), 128, '0', false);
        for (int i = 0; i < netmask_addr.length; ++i) {
            netmask_addr[i] = (byte)Integer.parseInt(netmaskStr.substring(i * 8, (i + 1) * 8), 2);
        }
        return netmask_addr;
    }

    private static String padBits(String str, int totalLength, char c, boolean prepended) {
        String tmp = str;
        int diff = totalLength - str.length();
        if (diff > 0) {
            for (int i = 0; i < diff; ++i) {
                tmp = prepended ? c + tmp : tmp + c;
            }
        }
        return tmp;
    }

    private static int getHostIndexInNonProxyList(byte[] ip_addr) {
        MutableStatics mutableStatics = HTTPConnection.getMutableStatics();
        int idx = -1;
        for (int i = 0; i < mutableStatics.non_proxy_addr_list.size(); ++i) {
            byte[] addr = (byte[])mutableStatics.non_proxy_addr_list.elementAt(i);
            if (!Arrays.equals(ip_addr, addr)) continue;
            idx = i;
            break;
        }
        return idx;
    }

    static boolean isStringAnIP(String hostAddr) {
        boolean isIP = false;
        if (hostAddr != null && hostAddr.trim().length() > 0) {
            if (hostAddr.indexOf(58) >= 0) {
                String nodeAddr = hostAddr;
                int idx = nodeAddr.indexOf(47);
                if (idx > -1) {
                    nodeAddr = nodeAddr.substring(0, idx);
                }
                try {
                    InetAddress inetAddr = InetAddress.getByName(nodeAddr);
                    isIP = inetAddr instanceof Inet6Address;
                }
                catch (UnknownHostException uhe) {}
            } else {
                String[] ipFields = hostAddr.split("\\Q.\\E");
                if (ipFields != null && ipFields.length == 4) {
                    for (int idx = 0; idx < ipFields.length; ++idx) {
                        for (int j = 0; j < ipFields[idx].length(); ++j) {
                            if (Character.isDigit(ipFields[idx].charAt(j))) continue;
                            return false;
                        }
                    }
                    isIP = true;
                }
            }
        }
        return isIP;
    }

    static boolean isStringAnIPv6(String hostAddr) {
        boolean ipv6 = false;
        if (hostAddr != null && hostAddr.trim().length() > 0 && hostAddr.indexOf(58) >= 0) {
            try {
                InetAddress inetAddr = InetAddress.getByName(hostAddr);
                ipv6 = inetAddr instanceof Inet6Address;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return ipv6;
    }

    public static void setSocksServer(String host) {
        HTTPConnection.setSocksServer(host, 1080);
    }

    public static void setSocksServer(String host, int port) {
        HTTPConnection.setSocksServer(HTTPConnection.getMutableStatics(), host, port);
    }

    private static void setSocksServer(MutableStatics ms, String host, int port) {
        if (port <= 0) {
            port = 1080;
        }
        if (host == null || host.length() == 0) {
            ms.default_Socks_client = null;
        } else {
            ms.default_Socks_client = new SocksClient(host, port);
        }
    }

    public static void setSocksServer(String host, int port, int version) throws SocksException {
        HTTPConnection.setSocksServer(HTTPConnection.getMutableStatics(), host, port, version);
    }

    private static void setSocksServer(MutableStatics ms, String host, int port, int version) throws SocksException {
        if (port <= 0) {
            port = 1080;
        }
        if (host == null || host.length() == 0) {
            ms.default_Socks_client = null;
        } else {
            ms.default_Socks_client = new SocksClient(host, port, version);
        }
    }

    private static final String stripRef(String file) {
        if (file == null) {
            return "";
        }
        int hash = file.indexOf(35);
        if (hash != -1) {
            file = file.substring(0, hash);
        }
        return file.trim();
    }

    protected final HTTPResponse setupRequest(final String method, final String resource, final NVPair[] headers, final byte[] entity, final HttpOutputStream stream) throws IOException, ModuleException {
        try {
            return this.doAction(new CachedConfigExceptionAction<HTTPResponse>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public HTTPResponse run() throws Exception {
                    Request req = new Request(HTTPConnection.this, method, resource, HTTPConnection.this.mergedHeaders(headers), entity, stream, HTTPConnection.this.allowUI);
                    HTTPConnection.this.RequestList.add(req);
                    try {
                        HTTPResponse resp = new HTTPResponse(HTTPConnection.this.gen_mod_insts(), HTTPConnection.this.Timeout, req);
                        HTTPConnection.this.handleRequest(req, resp, null, true);
                        HTTPResponse hTTPResponse = resp;
                        return hTTPResponse;
                    }
                    finally {
                        HTTPConnection.this.RequestList.remove(req);
                    }
                }
            });
        }
        catch (CachedConfigActionException e) {
            Throwable causeEx = e.getCause();
            if (causeEx instanceof IOException) {
                throw (IOException)causeEx;
            }
            if (causeEx instanceof ModuleException) {
                throw (ModuleException)causeEx;
            }
            throw new RuntimeException("Unexpected throwable during setupRequest", causeEx);
        }
    }

    private void closeStaleSocket() {
        if (HttpClientConfiguration.isStaleSocketCheckEnabled() && this.input_demux != null && this.DemuxList.size() > 0 && this.input_demux.getSocket() != null && !this.input_demux.evaluateSocketFullyConnected()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Closing partially-open socket: " + this.input_demux.getSocket());
            }
            this.input_demux.abort();
            this.DemuxList.remove(this.input_demux);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NVPair[] mergedHeaders(NVPair[] spec) {
        int spec_len = spec != null ? spec.length : 0;
        NVPair[] nVPairArray = this.DefaultHeaders;
        synchronized (this.DefaultHeaders) {
            int defs_len = this.DefaultHeaders != null ? this.DefaultHeaders.length : 0;
            NVPair[] merged = new NVPair[spec_len + defs_len];
            System.arraycopy(this.DefaultHeaders, 0, merged, 0, defs_len);
            // ** MonitorExit[var5_3] (shouldn't be in output)
            int didx = defs_len;
            for (int sidx = 0; sidx < spec_len; ++sidx) {
                int search;
                String s_name;
                if (spec[sidx] == null || (s_name = spec[sidx].getName().trim()).equalsIgnoreCase("Content-Length")) continue;
                for (search = 0; search < didx && !merged[search].getName().trim().equalsIgnoreCase(s_name); ++search) {
                }
                merged[search] = spec[sidx];
                if (search != didx) continue;
                ++didx;
            }
            if (didx < merged.length) {
                merged = Util.resizeArray(merged, didx);
            }
            return merged;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPClientModule[] gen_mod_insts() {
        Vector vector = this.ModuleList;
        synchronized (vector) {
            HTTPClientModule[] mod_insts = new HTTPClientModule[this.ModuleList.size()];
            for (int idx = 0; idx < this.ModuleList.size(); ++idx) {
                Class mod = (Class)this.ModuleList.elementAt(idx);
                try {
                    mod_insts[idx] = (HTTPClientModule)mod.newInstance();
                    continue;
                }
                catch (Exception e) {
                    throw new Error("HTTPClient Internal Error: could not create instance of " + mod.getName() + " -\n" + e);
                }
            }
            return mod_insts;
        }
    }

    void handleRequest(Request req, HTTPResponse http_resp, Response resp, boolean usemodules) throws IOException, ModuleException {
        int idx;
        Response[] rsp_arr = new Response[]{resp};
        HTTPClientModule[] modules = http_resp.getModules();
        if (usemodules) {
            block10: for (idx = 0; idx < modules.length; ++idx) {
                int sts = modules[idx].requestHandler(req, rsp_arr);
                switch (sts) {
                    case 0: {
                        continue block10;
                    }
                    case 1: {
                        idx = -1;
                        continue block10;
                    }
                    case 2: {
                        break block10;
                    }
                    case 3: 
                    case 4: {
                        if (rsp_arr[0] == null) {
                            throw new Error("HTTPClient Internal Error: no response returned by module " + modules[idx].getClass().getName());
                        }
                        http_resp.set(req, rsp_arr[0]);
                        if (req.getStream() != null) {
                            req.getStream().ignoreData(req);
                        }
                        if (req.internal_subrequest) {
                            return;
                        }
                        if (sts == 3) {
                            http_resp.handleResponse();
                        } else {
                            http_resp.init(rsp_arr[0]);
                        }
                        return;
                    }
                    case 5: {
                        if (req.internal_subrequest) {
                            return;
                        }
                        req.getConnection().handleRequest(req, http_resp, rsp_arr[0], true);
                        return;
                    }
                    case 6: {
                        if (req.internal_subrequest) {
                            return;
                        }
                        req.getConnection().handleRequest(req, http_resp, rsp_arr[0], false);
                        return;
                    }
                    default: {
                        throw new Error("HTTPClient Internal Error: invalid status " + sts + " returned by module " + modules[idx].getClass().getName());
                    }
                }
            }
        }
        if (req.internal_subrequest) {
            return;
        }
        if (req.getStream() != null && req.getStream().getLength() == -1) {
            if (!this.ServProtVersKnown || this.ServerProtocolVersion < 65537 || this.no_chunked_instance) {
                req.getStream().goAhead(req, null, http_resp.getTimeout());
                if (req.getData() != null && req.getData().length > 0) {
                    http_resp.set(req, this.sendRequest(req, http_resp.getTimeout()));
                } else {
                    http_resp.set(req, req.getStream());
                }
            } else {
                NVPair[] hdrs = req.getHeaders();
                for (idx = 0; idx < hdrs.length && !hdrs[idx].getName().equalsIgnoreCase("Transfer-Encoding"); ++idx) {
                }
                if (idx == hdrs.length) {
                    logger.finer("Conn: setting chunking header");
                    hdrs = Util.resizeArray(hdrs, idx + 1);
                    hdrs[idx] = new NVPair("Transfer-Encoding", "chunked");
                    req.setHeaders(hdrs);
                } else {
                    String v = hdrs[idx].getValue();
                    try {
                        if (!Util.hasToken(v, "chunked")) {
                            hdrs[idx] = new NVPair("Transfer-Encoding", v + ", chunked");
                        }
                    }
                    catch (ParseException pe) {
                        throw new IOException(pe.toString());
                    }
                }
                http_resp.set(req, this.sendRequest(req, http_resp.getTimeout()));
            }
        } else {
            http_resp.set(req, this.sendRequest(req, http_resp.getTimeout()));
        }
        this.checkForAbortedRequest(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response sendRequest(Request req, Timeouts con_timeout) throws IOException, ModuleException {
        ByteArrayOutputStream hdr_buf = new ByteArrayOutputStream(600);
        Response resp = null;
        this.handleEarlyStall(req);
        String[] con_hdrs = this.assembleHeaders(req, hdr_buf);
        boolean keep_alive = this.determineKeepAlive(con_hdrs);
        HTTPConnection hTTPConnection = this;
        synchronized (hTTPConnection) {
            this.handleLateStall(req);
            this.waitForPreviousRequest(req);
            this.waitForOutputStreamToFinish();
            this.checkForAbortedRequest(req);
            int try_count = HttpClientConfiguration.getMaxRequestTryCount();
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "The maximum tries of sendRequest is {0}.", Integer.toString(try_count));
            }
            while (try_count-- > 0) {
                try {
                    this.closeStaleSocket();
                    int numOfSocketConnections = this.doConnect(con_timeout, req);
                    Socket sock = this.input_demux.getSocket();
                    this.checkForAbortedRequest(req);
                    logger.log(Level.FINE, "Conn:  Sending Request:\n{0}", hdr_buf);
                    OutputStream sock_out = HTTPConnection.getOutputStream(sock);
                    hdr_buf.writeTo(sock_out);
                    try {
                        if (this.isUsing100Continue(con_hdrs)) {
                            resp = new Response(req, this.Proxy_Host != null && this.Protocol != 1, this.input_demux);
                            resp.setPhysicalConnections(numOfSocketConnections);
                            resp.timeout = this.getTimeout() != 0 ? this.Timeout : HTTPConnection.getMutableStatics().defaultContinueTimeout;
                            if (resp.getContinue() != 100) {
                                if (req.getStream() == null) break;
                                req.getStream().ignoreData(req);
                                break;
                            }
                        }
                    }
                    catch (ParseException pe) {
                        throw new IOException(pe.toString());
                    }
                    catch (InterruptedIOException iioe) {
                    }
                    finally {
                        if (resp != null) {
                            resp.timeout = Timeouts.zero;
                        }
                    }
                    keep_alive = this.writeEntityData(req, sock_out, keep_alive);
                    if (req.getStream() != null) {
                        req.getStream().goAhead(req, sock_out, Timeouts.zero);
                    }
                    if (resp != null) break;
                    resp = new Response(req, this.Proxy_Host != null && this.Protocol != 1, this.input_demux);
                    resp.setPhysicalConnections(numOfSocketConnections);
                    resp.setTimeout(con_timeout);
                    break;
                }
                catch (IOException ioe) {
                    logger.log(Level.FINER, "Conn:  ", ioe);
                    this.closeDemux(ioe, true);
                    if (try_count == 0 || ioe instanceof UnknownHostException || ioe instanceof ConnectException || ioe instanceof NoRouteToHostException || ioe instanceof InterruptedIOException || req.aborted) {
                        throw ioe;
                    }
                    logger.finer("Conn:  Retrying request");
                }
            }
            this.prev_resp = resp;
            if (this.keepAliveReqMax != -1) {
                logger.log(Level.FINER, "Conn:  Number of requests left: {0}", Integer.toString(this.keepAliveReqLeft));
            }
            if (!this.ServProtVersKnown) {
                this.early_stall = resp;
                resp.markAsFirstResponse(req);
            }
            if (this.isPipeliningDisabled(req)) {
                this.late_stall = resp;
            }
            this.notifyOutputStream(req);
            this.handleEndOfRequestSend(keep_alive, resp);
            logger.finer("Conn:  Request sent");
        }
        return resp;
    }

    private Socket getSocket(Timeouts con_timeout) throws IOException {
        Socket sock = null;
        boolean tryAnotherEndpoint = false;
        ArrayList<LoadBalanceEndpoint> triedLoadProviderEndpoints = new ArrayList<LoadBalanceEndpoint>(4);
        do {
            int candidate_port;
            String candidate_host;
            if (this.Proxy_Host != null) {
                candidate_host = this.Proxy_Host;
                candidate_port = this.Proxy_Port;
            } else {
                candidate_host = this.Host;
                candidate_port = this.Port;
            }
            LoadBalanceProvider lbProvider = HTTPConnection.getLoadBalanceProvider();
            this.loadBalanceEndpoint = null;
            tryAnotherEndpoint = false;
            if (null != lbProvider && lbProvider.isAvailable()) {
                String origHost = candidate_host;
                int origPort = candidate_port;
                try {
                    LoadBalanceProvider.SupportedProtocol protocol = LoadBalanceProviderBase.toSupportedProtocol(this.getProtocol());
                    this.loadBalanceEndpoint = lbProvider.getNextEndpoint(protocol, origHost, origPort);
                    if (null != this.loadBalanceEndpoint) {
                        candidate_host = this.loadBalanceEndpoint.getEndpointHost();
                        candidate_port = this.loadBalanceEndpoint.getEndpointPort();
                        if (logger.isLoggable(Level.FINER)) {
                            logger.log(Level.FINER, "Successfully determined next endpoint as {0}:{1} for virtual server {2}:{3} from load balance provider {4}.", new Object[]{candidate_host, Integer.toString(candidate_port), origHost, Integer.toString(origPort), lbProvider.getClass().getName()});
                        }
                    } else if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "{0}:{1} is not supported by load balance provider {2}.", new Object[]{origHost, Integer.toString(origPort), lbProvider.getClass().getName()});
                    }
                }
                catch (Exception e) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Failed to get next endpoint from load balance provider '" + lbProvider.getClass().getName() + "', for host '" + origHost + "', port " + origPort + ".", e);
                    }
                    candidate_host = origHost;
                    candidate_port = origPort;
                    this.loadBalanceEndpoint = null;
                    tryAnotherEndpoint = false;
                }
                if (null != this.loadBalanceEndpoint) {
                    if (triedLoadProviderEndpoints.contains(this.loadBalanceEndpoint)) {
                        tryAnotherEndpoint = false;
                    } else {
                        tryAnotherEndpoint = true;
                        triedLoadProviderEndpoints.add(this.loadBalanceEndpoint);
                    }
                }
            }
            try {
                final String actual_host = candidate_host;
                int actual_port = candidate_port;
                logger.log(Level.FINER, "Conn:  Creating Socket: {0}:{1}", new Object[]{HTTPConnection.isStringAnIPv6(actual_host) ? "[" + actual_host + "]" : actual_host, Integer.toString(actual_port)});
                if (con_timeout.connection == 0) {
                    if (this.Socks_client != null) {
                        sock = this.Socks_client.getSocket(actual_host, actual_port);
                    } else {
                        InetAddress[] addr_list;
                        try {
                            addr_list = (InetAddress[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws UnknownHostException {
                                    return InetAddress.getAllByName(actual_host);
                                }
                            });
                        }
                        catch (PrivilegedActionException e) {
                            throw (UnknownHostException)e.getException();
                        }
                        for (int idx = 0; idx < addr_list.length; ++idx) {
                            try {
                                sock = this.LocalAddr == null ? this.getCurrentSocketFactory().createSocket(addr_list[idx], actual_port) : this.getCurrentSocketFactory().createSocket(addr_list[idx], actual_port, this.LocalAddr, this.LocalPort);
                                break;
                            }
                            catch (SocketException se) {
                                if (idx != addr_list.length - 1) continue;
                                throw se;
                            }
                        }
                    }
                } else if (JRFUtils.isExalogicOptimizationsEnabled()) {
                    sock = this.getSocketWithConnectTimeout(actual_host, actual_port, con_timeout.connection);
                } else {
                    EstablishConnection con = new EstablishConnection(actual_host, actual_port, this.Socks_client);
                    con.start();
                    try {
                        con.join(con_timeout.connection);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    if (con.getException() != null) {
                        throw con.getException();
                    }
                    sock = con.getSocket();
                    if (sock == null) {
                        con.forget();
                        sock = con.getSocket();
                        if (sock == null) {
                            throw new InterruptedIOException("Connection establishment timed out");
                        }
                    }
                }
                tryAnotherEndpoint = false;
            }
            catch (IOException e) {
                if (null == this.loadBalanceEndpoint) {
                    throw e;
                }
                if (!tryAnotherEndpoint) {
                    throw e;
                }
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.log(Level.FINER, "Exception reported while trying to connect to '" + this.loadBalanceEndpoint.toString() + "', trying next load balance endpoint.", e);
            }
        } while (tryAnotherEndpoint);
        sock.setTcpNoDelay(!HttpClientConfiguration.getNagleAlgorithmEnabled());
        sock.setSoTimeout(con_timeout.read);
        return sock;
    }

    private Socket getSocketWithConnectTimeout(String host, int port, int timeout) throws IOException {
        Socket sock = null;
        if (this.Socks_client != null) {
            sock = this.Socks_client.getSocketWithConnectTimeout(host, port, timeout);
        } else {
            InetAddress[] addr_list = HTTPConnection.privilegedInetAddressGetAllByName(host);
            for (int idx = 0; idx < addr_list.length; ++idx) {
                try {
                    if (this.LocalAddr == null) {
                        sock = this.getCurrentSocketFactory().createSocket();
                        sock.connect(new InetSocketAddress(addr_list[idx], port), timeout);
                        break;
                    }
                    sock = this.getCurrentSocketFactory().createSocket();
                    sock.bind(new InetSocketAddress(this.LocalAddr, this.LocalPort));
                    sock.connect(new InetSocketAddress(addr_list[idx], port), timeout);
                    break;
                }
                catch (SocketException se) {
                    if (idx != addr_list.length - 1) continue;
                    throw se;
                }
            }
        }
        return sock;
    }

    private Response enableSSLTunneling(Socket[] sock, Request req, Timeouts timeout) throws IOException, ModuleException {
        Vector<NVPair> hdrs = new Vector<NVPair>();
        for (int idx = 0; idx < req.getHeaders().length; ++idx) {
            String name = req.getHeaders()[idx].getName();
            if (!name.equalsIgnoreCase("User-Agent") && !name.equalsIgnoreCase("Proxy-Authorization")) continue;
            hdrs.addElement(req.getHeaders()[idx]);
        }
        Object[] h = new NVPair[hdrs.size()];
        hdrs.copyInto(h);
        Request connect = new Request(this, "CONNECT", this.Host + ":" + this.Port, (NVPair[])h, null, null, req.allowUI());
        connect.internal_subrequest = true;
        ByteArrayOutputStream hdr_buf = new ByteArrayOutputStream(600);
        HTTPResponse r = new HTTPResponse(this.gen_mod_insts(), timeout, connect);
        boolean disconnect = true;
        boolean connectionOrientedStatusChecked = false;
        Response resp = null;
        for (int i = 0; i < 10; ++i) {
            this.handleRequest(connect, r, resp, true);
            hdr_buf.reset();
            this.assembleHeaders(connect, hdr_buf);
            logger.log(Level.FINER, "Conn:  Sending SSL-Tunneling Subrequest: {0}", hdr_buf);
            hdr_buf.writeTo(HTTPConnection.getOutputStream(sock[0]));
            resp = new Response(connect, HTTPConnection.getInputStream(sock[0]));
            if (resp.getStatusCode() == 200) {
                return null;
            }
            if (!connectionOrientedStatusChecked) {
                disconnect = !resp.isConnectionOriented(true);
                connectionOrientedStatusChecked = true;
            }
            try {
                resp.getData(disconnect);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            r.set(connect, resp);
            boolean handleResponse = r.handleResponse();
            if (disconnect || !handleResponse || this.Proxy_Host != null && resp.isProxyConnectionClosed()) {
                try {
                    logger.log(Level.FINER, "Conn:  closing socket: {0}", sock[0]);
                    sock[0].close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            if (!handleResponse) {
                return resp;
            }
            if (!disconnect && (this.Proxy_Host == null || !resp.isProxyConnectionClosed())) continue;
            sock[0] = this.getSocket(timeout);
        }
        try {
            logger.log(Level.FINER, "Conn:  closing socket: {0} because number of ssl tunneling subrequests exceeded {1}", new Object[]{sock[0], 10});
            sock[0].close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String[] assembleHeaders(Request req, ByteArrayOutputStream hdr_buf) throws IOException {
        con_hdrs = new String[]{"", ""};
        hdrs = req.getHeaders();
        var6_6 = headerBuffer = new StringBuffer(1000);
        synchronized (var6_6) {
            ho_idx = -1;
            ct_idx = -1;
            ua_idx = -1;
            un_idx = -1;
            co_idx = -1;
            pc_idx = -1;
            ka_idx = -1;
            ex_idx = -1;
            te_idx = -1;
            tc_idx = -1;
            ug_idx = -1;
            for (idx = 0; idx < hdrs.length; ++idx) {
                name = hdrs[idx].getName().toLowerCase();
                if (name.equals("host")) {
                    ho_idx = idx;
                    continue;
                }
                if (name.equals("content-type")) {
                    ct_idx = idx;
                    continue;
                }
                if (name.equals("user-agent")) {
                    ua_idx = idx;
                    continue;
                }
                if (name.equals("user-agent-noversion")) {
                    un_idx = idx;
                    continue;
                }
                if (name.equals("connection")) {
                    co_idx = idx;
                    continue;
                }
                if (name.equals("proxy-connection")) {
                    pc_idx = idx;
                    continue;
                }
                if (name.equals("keep-alive")) {
                    ka_idx = idx;
                    continue;
                }
                if (name.equals("expect")) {
                    ex_idx = idx;
                    continue;
                }
                if (name.equals("te")) {
                    te_idx = idx;
                    continue;
                }
                if (name.equals("transfer-encoding")) {
                    tc_idx = idx;
                    continue;
                }
                if (!name.equals("upgrade")) continue;
                ug_idx = idx;
            }
            file = Util.escapeUnsafeChars(req.getRequestURI());
            portString = ":" + this.Port;
            if (this.Protocol == 0 && this.Port == 80) {
                portString = "";
            }
            if (this.Proxy_Host != null && this.Protocol != 1 && !file.equals("*")) {
                headerBuffer.append(req.getMethod()).append(" http://").append(this.Host);
                headerBuffer.append(portString).append(file).append(" ").append(this.RequestProtocolVersion);
                headerBuffer.append(HTTPConnection.CR_LF);
            } else {
                headerBuffer.append(req.getMethod()).append(" ").append(file);
                headerBuffer.append(" ").append(this.RequestProtocolVersion).append(HTTPConnection.CR_LF);
            }
            v0 = h_hdr = ho_idx >= 0 ? hdrs[ho_idx].getValue() : this.Host;
            if (this.Port != URI.defaultPort(this.getProtocol())) {
                if (h_hdr.indexOf(58) < 0) {
                    headerBuffer.append("Host: ").append(h_hdr).append(":").append(this.Port).append(HTTPConnection.CR_LF);
                } else if (HTTPConnection.isStringAnIPv6(h_hdr)) {
                    headerBuffer.append("Host: ").append("[" + h_hdr + "]").append(":").append(this.Port).append(HTTPConnection.CR_LF);
                }
            } else if (HTTPConnection.isStringAnIPv6(h_hdr)) {
                headerBuffer.append("Host: ").append("[" + h_hdr + "]").append(HTTPConnection.CR_LF);
            } else {
                headerBuffer.append("Host: ").append(h_hdr).append(HTTPConnection.CR_LF);
            }
            co_hdr = null;
            if (!this.ServProtVersKnown || this.ServerProtocolVersion < 65537 || co_idx != -1) {
                if (co_idx == -1) {
                    co_hdr = "Keep-Alive";
                    con_hdrs[0] = "Keep-Alive";
                } else {
                    con_hdrs[0] = hdrs[co_idx].getValue();
                    co_hdr = con_hdrs[0];
                }
                try {
                    if (ka_idx != -1 && Util.hasToken(con_hdrs[0], "keep-alive")) {
                        headerBuffer.append("Keep-Alive: ").append(hdrs[ka_idx].getValue()).append(HTTPConnection.CR_LF);
                    }
                }
                catch (ParseException pe) {
                    throw new IOException(pe.toString());
                }
            }
            if (!(this.Proxy_Host == null || this.Protocol == 1 || this.ServProtVersKnown && this.ServerProtocolVersion >= 65537 || co_hdr == null)) {
                headerBuffer.append("Proxy-Connection: ").append(co_hdr).append(HTTPConnection.CR_LF);
                co_hdr = null;
            }
            if (co_hdr != null) {
                try {
                    if (Util.hasToken(co_hdr, "TE")) ** GOTO lbl111
                    co_hdr = co_hdr + ", TE";
                }
                catch (ParseException pe) {
                    throw new IOException(pe.toString());
                }
            } else {
                co_hdr = "TE";
            }
lbl111:
            // 3 sources

            if (ug_idx != -1) {
                co_hdr = co_hdr + ", Upgrade";
            }
            if (co_hdr != null) {
                headerBuffer.append("Connection: ").append(co_hdr).append(HTTPConnection.CR_LF);
            }
            if (te_idx != -1) {
                headerBuffer.append("TE: ");
                try {
                    pte = Util.parseHeader(hdrs[te_idx].getValue());
                }
                catch (ParseException pe) {
                    throw new IOException(pe.toString());
                }
                if (!pte.contains(new HttpHeaderElement("trailers"))) {
                    headerBuffer.append("trailers, ");
                }
                headerBuffer.append(hdrs[te_idx].getValue()).append(HTTPConnection.CR_LF);
            } else {
                headerBuffer.append("TE: trailers\r\n");
            }
            if (un_idx != -1) {
                headerBuffer.append("User-Agent: ").append(hdrs[un_idx].getValue()).append(HTTPConnection.CR_LF);
            } else if (ua_idx != -1) {
                headerBuffer.append("User-Agent: ").append(hdrs[ua_idx].getValue()).append(" ");
                headerBuffer.append(HttpClientConfiguration.getVersion()).append(HTTPConnection.CR_LF);
            } else {
                headerBuffer.append("User-Agent: ").append(HttpClientConfiguration.getVersion()).append(HTTPConnection.CR_LF);
            }
            for (idx = 0; idx < hdrs.length; ++idx) {
                if (idx == ct_idx || idx == ua_idx || idx == un_idx || idx == co_idx || idx == pc_idx || idx == ka_idx || idx == ex_idx || idx == te_idx || idx == ho_idx) continue;
                headerBuffer.append(hdrs[idx].getName()).append(": ");
                headerBuffer.append(hdrs[idx].getValue()).append(HTTPConnection.CR_LF);
            }
            if (req.getData() != null || req.getStream() != null) {
                headerBuffer.append("Content-type: ");
                if (ct_idx != -1) {
                    headerBuffer.append(hdrs[ct_idx].getValue());
                } else {
                    headerBuffer.append("application/octet-stream");
                }
                headerBuffer.append(HTTPConnection.CR_LF);
                if (req.getData() != null && tc_idx == -1) {
                    headerBuffer.append("Content-Length: ").append(req.getData().length);
                    headerBuffer.append(HTTPConnection.CR_LF);
                } else if (tc_idx == -1 && req.getStream() != null && req.getStream().getLength() != -1) {
                    headerBuffer.append("Content-Length: ").append(req.getStream().getLength());
                    headerBuffer.append(HTTPConnection.CR_LF);
                }
                if (ex_idx != -1) {
                    con_hdrs[1] = hdrs[ex_idx].getValue();
                    headerBuffer.append("Expect: ").append(con_hdrs[1]).append(HTTPConnection.CR_LF);
                }
            } else if (ex_idx != -1) {
                try {
                    expect_tokens = Util.parseHeader(hdrs[ex_idx].getValue());
                }
                catch (ParseException pe) {
                    throw new IOException(pe.toString());
                }
                cont = new HttpHeaderElement("100-continue");
                while (expect_tokens.removeElement(cont)) {
                }
                if (!expect_tokens.isEmpty()) {
                    con_hdrs[1] = Util.assembleHeader(expect_tokens);
                    headerBuffer.append("Expect: ").append(con_hdrs[1]).append(HTTPConnection.CR_LF);
                }
            }
            headerBuffer.append(HTTPConnection.CR_LF);
            hdr_buf.write(Util.buildByteArray(headerBuffer));
        }
        return con_hdrs;
    }

    boolean handleFirstRequest(Request req, Response resp) throws IOException {
        this.ServerProtocolVersion = HTTPConnection.String2ProtVers(resp.getVersion());
        this.ServProtVersKnown = true;
        int sts = resp.getStatusCode();
        if (this.Proxy_Host != null && this.Protocol != 1 && resp.getHeader("Via") == null && sts != 407 && sts != 502 && sts != 504) {
            this.ServerProtocolVersion = 65536;
        }
        logger.log(Level.FINER, "Conn:  Protocol Version established: {0}", HTTPConnection.ProtVers2String(this.ServerProtocolVersion));
        if (this.ServerProtocolVersion == 65536 && (resp.getStatusCode() == 400 || resp.getStatusCode() == 500) && IdempotentSequence.methodIsIdempotent(req.getMethod())) {
            if (this.input_demux != null) {
                this.input_demux.markForClose(resp);
            }
            this.input_demux = null;
            this.RequestProtocolVersion = "HTTP/1.0";
            return false;
        }
        return true;
    }

    private void determineKeepAlive(Response resp) throws IOException {
        try {
            HttpHeaderElement max;
            String con;
            if (this.ServerProtocolVersion >= 65537 || ((this.Proxy_Host == null || this.Protocol == 1) && (con = resp.getHeader("Connection")) != null || this.Proxy_Host != null && this.Protocol != 1 && (con = resp.getHeader("Proxy-Connection")) != null) && Util.hasToken(con, "keep-alive")) {
                this.doesKeepAlive = true;
                this.keepAliveUnknown = false;
                logger.finer("Conn:  Keep-Alive enabled");
            } else if (resp.getStatusCode() < 400) {
                this.keepAliveUnknown = false;
            }
            if (this.doesKeepAlive && this.ServerProtocolVersion == 65536 && (con = resp.getHeader("Keep-Alive")) != null && (max = Util.getElement(Util.parseHeader(con), "max")) != null && max.getValue() != null) {
                this.keepAliveReqLeft = this.keepAliveReqMax = Integer.parseInt(max.getValue());
                logger.log(Level.FINER, "Conn:  Max Keep-Alive requests: {0}", Integer.toString(this.keepAliveReqMax));
            }
        }
        catch (ParseException pe) {
        }
        catch (NumberFormatException nfe) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    synchronized void outputFinished() {
        this.output_finished = true;
        if (this.input_demux != null) {
            this.input_demux.restartTimer();
        }
        this.notify();
    }

    synchronized void closeDemux(IOException ioe, boolean was_reset) {
        if (this.input_demux != null) {
            this.input_demux.close(ioe, was_reset);
        }
        this.early_stall = null;
        this.late_stall = null;
        this.prev_resp = null;
    }

    static final String ProtVers2String(int prot_vers) {
        return "HTTP/" + (prot_vers >>> 16) + "." + (prot_vers & 0xFFFF);
    }

    static final int String2ProtVers(String prot_vers) {
        String vers = prot_vers.substring(5);
        int dot = vers.indexOf(46);
        return Integer.parseInt(vers.substring(0, dot)) << 16 | Integer.parseInt(vers.substring(dot + 1));
    }

    public String toString() {
        String str = this.getProtocol() + "://";
        str = HTTPConnection.isStringAnIPv6(this.getHost()) ? str + "[" + this.getHost() + "]" : str + this.getHost();
        return str + (this.getPort() != URI.defaultPort(this.getProtocol()) ? ":" + this.getPort() : "");
    }

    public void connect() throws IOException {
        try {
            this.doAction(new CachedConfigExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    Request req = new Request(HTTPConnection.this, "", "", null, null, null, HTTPConnection.this.allowUI);
                    try {
                        HTTPConnection.this.doConnect(HTTPConnection.this.Timeout, req);
                    }
                    catch (ModuleException e) {
                        throw new IOException(e.toString());
                    }
                    return null;
                }
            });
        }
        catch (CachedConfigActionException e) {
            Throwable causeEx = e.getCause();
            if (causeEx instanceof IOException) {
                throw (IOException)causeEx;
            }
            throw new RuntimeException("Unexpected throwable", causeEx);
        }
    }

    private int doConnect(Timeouts con_timeout, Request req) throws IOException, ModuleException {
        Response resp = null;
        int numOfSocketConnections = 0;
        if (this.input_demux == null || this.input_demux.getSocket() == null) {
            Socket sock = this.getSocket(con_timeout);
            ++numOfSocketConnections;
            if (this.Protocol == 1) {
                if (this.Proxy_Host != null) {
                    Socket[] sarr = new Socket[]{sock};
                    resp = this.enableSSLTunneling(sarr, req, con_timeout);
                    if (resp != null) {
                        resp.final_resp = true;
                        throw new IOException("Cannot establish proxy connection: " + resp.getStatusCode() + " " + resp.getReasonLine());
                    }
                    sock = sarr[0];
                }
                sock = this.getSSLSocket(sock);
            }
            this.input_demux = new StreamDemultiplexor(this.Protocol, sock, this);
            this.DemuxList.add(this.input_demux);
            this.keepAliveReqLeft = this.keepAliveReqMax;
        }
        return numOfSocketConnections;
    }

    static InputStream getInputStream(final Socket socket) throws IOException {
        try {
            return (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new RespInputStreamForSSLTunneling(socket.getInputStream());
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    static OutputStream getOutputStream(final Socket socket) throws IOException {
        try {
            return (OutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return socket.getOutputStream();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    public void addTrustPoint(byte[] certificate) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "addTrustPoint is not supported.");
        }
    }

    public void addTrustPoint(String certificate) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "addTrustPoint is not supported.");
        }
    }

    public void addTrustPoint(Certificate certificate) throws CertificateEncodingException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "addTrustPoint is not supported.");
        }
    }

    public static void setDefaultSSLSocketFactory(SSLSocketFactory factory) {
        HTTPConnection.getMutableStatics().defaultSSLSocketFactory = factory;
    }

    public void setSSLSocketFactory(SSLSocketFactory factory) {
        this.m_SSLSocketFactory = factory;
        this.m_ssl = null;
    }

    public static SocketFactory getDefaultSocketFactory() {
        MutableStatics ms = HTTPConnection.getMutableStatics();
        if (ms.defaultSocketFactory == null) {
            ms.defaultSocketFactory = SocketFactory.getDefault();
        }
        return ms.defaultSocketFactory;
    }

    public static void setDefaultSocketFactory(SocketFactory factory) {
        HTTPConnection.getMutableStatics().defaultSocketFactory = factory;
    }

    public void setCurrentSocketFactory(SocketFactory factory) {
        this.m_socketFactory = factory;
    }

    public SocketFactory getCurrentSocketFactory() {
        return this.doAction(new CachedConfigAction<SocketFactory>(){

            @Override
            public SocketFactory run() {
                SocketFactory factory = HTTPConnection.this.m_socketFactory;
                if (factory == null) {
                    factory = HTTPConnection.getDefaultSocketFactory();
                }
                return factory;
            }
        });
    }

    HTTPClientSSL getSSL() {
        return this.doAction(new CachedConfigAction<HTTPClientSSL>(){

            @Override
            public HTTPClientSSL run() {
                MutableStatics ms = HTTPConnection.getMutableStatics();
                if (HTTPConnection.this.m_ssl == null) {
                    SSLSocketFactory factory = null;
                    factory = HTTPConnection.this.m_SSLSocketFactory != null ? HTTPConnection.this.m_SSLSocketFactory : (ms.defaultSSLSocketFactory != null ? ms.defaultSSLSocketFactory : null);
                    HTTPConnection.this.m_ssl = HTTPClientSSLFactory.mk(factory);
                }
                return HTTPConnection.this.m_ssl;
            }
        });
    }

    public Object getSSLCredential() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "getSSLCredential is not supported.");
        }
        return null;
    }

    public String[] getSSLEnabledCipherSuites() {
        return this.doAction(new CachedConfigAction<String[]>(){

            @Override
            public String[] run() {
                return HTTPConnection.this.getSSL().getSSLEnabledCipherSuites();
            }
        });
    }

    public SSLSession getSSLSession() {
        return this.doAction(new CachedConfigAction<SSLSession>(){

            @Override
            public SSLSession run() {
                return HTTPConnection.this.getSSL().getSSLSession();
            }
        });
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.doAction(new CachedConfigAction<SSLSocketFactory>(){

            @Override
            public SSLSocketFactory run() {
                return HTTPConnection.this.getSSL().getSSLSocketFactory();
            }
        });
    }

    public Socket getSSLSocket(final Socket proxy) throws IOException {
        try {
            return this.doAction(new CachedConfigExceptionAction<Socket>(){

                @Override
                public Socket run() throws Exception {
                    boolean hostNameOk;
                    Socket sslSocket = HTTPConnection.this.getSSL().getSSLSocket(proxy, HTTPConnection.this.Host, HTTPConnection.this.Port);
                    HostnameVerifier verifier = HTTPConnection.this.getHostnameVerifier();
                    if (null != verifier && !(hostNameOk = verifier.verify(HTTPConnection.this.Host, HTTPConnection.this.getSSL().getSSLSession()))) {
                        String message = MessageFormat.format("HostnameVerifier ''{0}'' reports a mismatch between the connection hostname ''{1}'' and the hostname in the SSL session certificate, or hostname verification otherwise failed.", verifier.getClass().getName(), HTTPConnection.this.Host);
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, message);
                        }
                        throw new SSLPeerUnverifiedException(message);
                    }
                    return sslSocket;
                }
            });
        }
        catch (CachedConfigActionException e) {
            Throwable causeEx = e.getCause();
            if (causeEx instanceof IOException) {
                throw (IOException)causeEx;
            }
            throw new RuntimeException("Unexpected throwable", causeEx);
        }
    }

    void setSSL(HTTPClientSSL ssl) {
        this.m_ssl = ssl;
    }

    public boolean setSSLCredential(Object cred) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "setSSLCredential is not supported.");
        }
        return false;
    }

    public boolean setSSLEnabledCipherSuites(String[] cipherSuites) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "setSSLEnabledCipherSuites is not supported.");
        }
        return false;
    }

    public String getQueryEncoding() {
        return this.urlEncoding;
    }

    public void setQueryEncoding(String encoding) {
        this.urlEncoding = encoding;
    }

    public void setChunking(boolean chunkingEnabled) {
        boolean bl = this.no_chunked_instance = !chunkingEnabled;
        if (!this.no_chunked_instance) {
            this.ServProtVersKnown = true;
        }
        HTTPClientMessages.log_connection_chunkingEnabled(logger, this, !this.no_chunked_instance);
    }

    public void setChunkSize(int size) {
        this.chunkSize = size;
        HTTPClientMessages.log_connection_chunkSize(logger, this, this.chunkSize);
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setAuthorizationPrompter(final AuthorizationPrompter prompter) {
        this.doAction(new CachedConfigAction<Object>(){

            @Override
            public Object run() {
                if (HTTPConnection.this.Context == null) {
                    AuthorizationInfo.removeAuthorization(dflt_context);
                } else {
                    AuthorizationInfo.removeAuthorization(HTTPConnection.this.Context);
                }
                HTTPConnection.this.m_authPrompter = prompter;
                return null;
            }
        });
    }

    public AuthorizationPrompter getAuthorizationPrompter() {
        return this.m_authPrompter;
    }

    public void setCookieStore(Map cookieMap) {
        this.m_cookieMap = cookieMap;
    }

    public Map getCookieStore() {
        return this.m_cookieMap;
    }

    public LoadBalanceEndpoint getLoadBalanceEndpoint() {
        return this.loadBalanceEndpoint;
    }

    public static LoadBalanceProvider getLoadBalanceProvider() {
        return HTTPConnection.getMutableStatics().loadBalanceProvider;
    }

    public static LoadBalanceProvider setLoadBalanceProvider(LoadBalanceProvider provider) {
        MutableStatics ms = HTTPConnection.getMutableStatics();
        LoadBalanceProvider previous = ms.loadBalanceProvider;
        ms.loadBalanceProvider = provider;
        return previous;
    }

    public static HostnameVerifier getDefaultHostnameVerifier() {
        return HTTPConnection.getMutableStatics().defaultHostnameVerifier;
    }

    public static HostnameVerifier setDefaultHostnameVerifier(HostnameVerifier defaultHostnameVerifier) {
        MutableStatics ms = HTTPConnection.getMutableStatics();
        HostnameVerifier previous = ms.defaultHostnameVerifier;
        ms.defaultHostnameVerifier = defaultHostnameVerifier;
        return previous;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.doAction(new CachedConfigAction<HostnameVerifier>(){

            @Override
            public HostnameVerifier run() {
                if (null == HTTPConnection.this.hostnameVerifier) {
                    return HTTPConnection.getMutableStatics().defaultHostnameVerifier;
                }
                if (NULL_HOSTNAME_VERIFIER == HTTPConnection.this.hostnameVerifier) {
                    return null;
                }
                return HTTPConnection.this.hostnameVerifier;
            }
        });
    }

    public HostnameVerifier setHostnameVerifier(final HostnameVerifier hostnameVerifier) {
        return this.doAction(new CachedConfigAction<HostnameVerifier>(){

            @Override
            public HostnameVerifier run() {
                HostnameVerifier previous = HTTPConnection.this.getHostnameVerifier();
                if (null == hostnameVerifier) {
                    HTTPConnection.this.hostnameVerifier = NULL_HOSTNAME_VERIFIER;
                } else {
                    HTTPConnection.this.hostnameVerifier = hostnameVerifier;
                }
                return previous;
            }
        });
    }

    public boolean applyDontProxyForList(List<String> hostPatterns) {
        boolean match = this.isMatchForProxy(hostPatterns);
        if (match) {
            this.setCurrentProxy(null, -1);
        }
        return match;
    }

    public boolean applyProxyForList(String proxyHost, int proxyPort, List<String> hostPatterns) {
        boolean match = this.isMatchForProxy(hostPatterns);
        if (match) {
            this.setCurrentProxy(proxyHost, proxyPort);
        }
        return match;
    }

    final boolean isMatchForProxy(List<String> hostPatterns) {
        if (null == hostPatterns) {
            return false;
        }
        for (String pattern : hostPatterns) {
            if (null == pattern || "".equals(pattern = pattern.trim())) continue;
            String endsWithPattern = null;
            if ('.' == pattern.charAt(0)) {
                endsWithPattern = pattern;
            } else if (pattern.startsWith("*.")) {
                endsWithPattern = pattern.substring(1);
            }
            if (null == endsWithPattern) {
                HostAddressFormat hostFormat = HTTPConnection.getHostAddressProxyPatternFormat(pattern);
                if (!(HostAddressFormat.IPV4ADDRESS == hostFormat || HostAddressFormat.IPV6ADDRESS == hostFormat ? this.isMatchIpAddressForProxy(hostFormat, pattern) : this.getHost().equalsIgnoreCase(pattern))) continue;
                return true;
            }
            endsWithPattern = endsWithPattern.toLowerCase();
            if (!this.getHost().endsWith(endsWithPattern)) continue;
            return true;
        }
        return false;
    }

    static HostAddressFormat getHostAddressProxyPatternFormat(String pattern) {
        if (null == pattern) {
            throw new IllegalArgumentException("Expected non-null pattern.");
        }
        if (pattern.length() > 1 && pattern.charAt(0) == '[' && pattern.charAt(pattern.length() - 1) == ']') {
            return HostAddressFormat.IPV6ADDRESS;
        }
        if ("127.0.0.1".equals(pattern)) {
            return HostAddressFormat.IPV4ADDRESS;
        }
        if (Character.isDigit(pattern.charAt(0)) && pattern.indexOf(46) != -1) {
            Matcher addressMatcher;
            Pattern ipv4RegExpPattern;
            String patternPrefix = pattern;
            int maskIndex = pattern.indexOf(47);
            if (maskIndex != -1) {
                patternPrefix = pattern.substring(0, maskIndex);
            }
            if (null != (ipv4RegExpPattern = HTTPConnection.getIpv4CoarseRegExpPattern()) && (addressMatcher = ipv4RegExpPattern.matcher(patternPrefix)).matches()) {
                return HostAddressFormat.IPV4ADDRESS;
            }
        }
        return HostAddressFormat.NAME;
    }

    private static Pattern getIpv4CoarseRegExpPattern() {
        if (null == IPV4_COARSE_PATTERN) {
            logger.log(Level.FINE, "Failed attempt to use IPV4_COARSE_PATTERN, compile error occurred.");
        }
        return IPV4_COARSE_PATTERN;
    }

    final boolean isMatchIpAddressForProxy(HostAddressFormat hostPatternFormat, String pattern) {
        if (null == hostPatternFormat) {
            throw new IllegalArgumentException("Expected non-null hostPatternFormat.");
        }
        if (HostAddressFormat.IPV4ADDRESS != hostPatternFormat && HostAddressFormat.IPV6ADDRESS != hostPatternFormat) {
            throw new IllegalArgumentException("Unexpected host format '" + (Object)((Object)hostPatternFormat) + "'");
        }
        if (null == pattern || "".equals(pattern)) {
            return false;
        }
        if (pattern.length() > 1 && pattern.charAt(0) == '[' && pattern.charAt(pattern.length() - 1) == ']') {
            if (HostAddressFormat.IPV6ADDRESS != hostPatternFormat) {
                throw new IllegalArgumentException("Unexpected host format '" + (Object)((Object)hostPatternFormat) + "', expected '" + (Object)((Object)HostAddressFormat.IPV6ADDRESS) + "'.");
            }
            pattern = pattern.substring(1, pattern.length() - 1);
        }
        String patternIpAddressString = pattern;
        int maskIndex = pattern.indexOf(47);
        if (maskIndex != -1) {
            patternIpAddressString = pattern.substring(0, maskIndex);
        }
        InetAddress patternIpAddress = null;
        try {
            patternIpAddress = InetAddress.getByName(patternIpAddressString);
        }
        catch (UnknownHostException e) {
            logger.log(Level.FINE, "Unable to resolve '" + patternIpAddressString + "'");
            return false;
        }
        List<InetAddress> hostIpAddresses = this.getAddressesForHost();
        if (null == hostIpAddresses) {
            return false;
        }
        for (InetAddress hostIpAddress : hostIpAddresses) {
            if (null == hostIpAddress || !hostIpAddress.equals(patternIpAddress)) continue;
            return true;
        }
        return false;
    }

    final List<InetAddress> getAddressesForHost() {
        if (this.ipAddressesForHost_set) {
            return this.ipAddressesForHost;
        }
        if (null != this.ipAddressesForHost) {
            throw new IllegalStateException("Expected ipAddressesForHost to be null.");
        }
        InetAddress[] addressArray = null;
        try {
            addressArray = (InetAddress[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UnknownHostException {
                    return InetAddress.getAllByName(HTTPConnection.this.getHost());
                }
            });
        }
        catch (PrivilegedActionException e) {
            logger.log(Level.FINER, "Host unresolvable '" + this.getHost() + "'", e.getException());
        }
        if (null != addressArray) {
            this.ipAddressesForHost = Collections.unmodifiableList(Arrays.asList(addressArray));
        }
        this.ipAddressesForHost_set = true;
        return this.ipAddressesForHost;
    }

    final Configuration getCachedConfiguration() {
        return this.cachedConfiguration;
    }

    final <T> T doAction(CachedConfigAction<T> action) {
        return HttpClientConfiguration.doAction(action, this.getCachedConfiguration());
    }

    final <T> T doAction(CachedConfigExceptionAction<T> action) throws CachedConfigActionException {
        return HttpClientConfiguration.doAction(action, this.getCachedConfiguration());
    }

    private boolean isPipeliningDisabled(Request req) {
        return this.keepAliveUnknown || !IdempotentSequence.methodIsIdempotent(req.getMethod()) || req.dont_pipeline || HttpClientConfiguration.getNeverPipeline();
    }

    private void notifyOutputStream(Request req) {
        if (req.getStream() != null && !req.getStream().ignoring()) {
            this.output_finished = false;
        } else {
            this.output_finished = true;
            this.notify();
        }
    }

    private boolean isUsing100Continue(String[] con_hdrs) throws ParseException {
        return this.ServProtVersKnown && this.ServerProtocolVersion >= 65537 && Util.hasToken(con_hdrs[1], "100-continue");
    }

    private void handleEndOfRequestSend(boolean keep_alive, Response resp) {
        if (!this.keepAliveUnknown && !this.doesKeepAlive || !keep_alive || this.keepAliveReqMax != -1 && this.keepAliveReqLeft-- == 0) {
            this.input_demux.markForClose(resp);
            logger.finer("Conn: Closing stream");
            this.input_demux = null;
        } else if (this.output_finished) {
            this.input_demux.restartTimer();
        }
    }

    private void checkForAbortedRequest(Request req) throws IOException {
        if (req.aborted) {
            throw new IOException("Request aborted by user");
        }
    }

    private void waitForPreviousRequest(Request req) {
        if ((req.getMethod().equals("POST") || req.dont_pipeline) && this.prev_resp != null && this.input_demux != null) {
            logger.log(Level.FINER, "Conn:  Stalling Request: {0} {1}", new Object[]{req.getMethod(), req.getRequestURI()});
            try {
                this.prev_resp.getVersion();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void waitForOutputStreamToFinish() throws IOException {
        if (!this.output_finished) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie.toString());
            }
        }
    }

    private boolean writeEntityData(Request req, OutputStream sock_out, boolean keep_alive) throws IOException {
        if (req.getData() != null && req.getData().length > 0) {
            if (req.delay_entity > 0L) {
                long num_units = req.delay_entity / 100L;
                long one_unit = req.delay_entity / num_units;
                int idx = 0;
                while ((long)idx < num_units && this.input_demux.available(null) == 0) {
                    try {
                        Thread.sleep(one_unit);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    ++idx;
                }
                if (this.input_demux.available(null) == 0) {
                    this.sendData(req, sock_out);
                } else {
                    keep_alive = false;
                }
            } else {
                this.sendData(req, sock_out);
            }
        }
        return keep_alive;
    }

    private void sendData(Request req, OutputStream sock_out) throws IOException {
        if (req.getStream() == null || this.no_chunked_instance) {
            sock_out.write(req.getData());
            sock_out.flush();
        } else {
            req.getStream().goAhead(req, sock_out, Timeouts.zero);
            int dataSize = req.getData().length;
            int offset = 0;
            int length = 0;
            do {
                length = dataSize < this.chunkSize ? dataSize : this.chunkSize;
                req.getStream().write(req.getData(), offset, length);
                offset += length;
            } while ((dataSize -= length) > 0);
            req.getStream().close();
        }
    }

    private void handleLateStall(Request req) {
        if (this.late_stall != null) {
            if (this.input_demux != null || this.keepAliveUnknown) {
                logger.log(Level.FINER, "Conn:  Stalling Request: {0} {1}", new Object[]{req.getMethod(), req.getRequestURI()});
                try {
                    this.late_stall.getVersion();
                    if (this.keepAliveUnknown) {
                        this.determineKeepAlive(this.late_stall);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.late_stall = null;
        }
    }

    private boolean determineKeepAlive(String[] con_hdrs) throws IOException {
        boolean keep_alive;
        try {
            keep_alive = this.ServerProtocolVersion >= 65537 && !Util.hasToken(con_hdrs[0], "close") || this.ServerProtocolVersion == 65536 && Util.hasToken(con_hdrs[0], "keep-alive");
        }
        catch (ParseException pe) {
            throw new IOException(pe.toString());
        }
        return keep_alive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEarlyStall(Request req) {
        if (this.early_stall != null) {
            try {
                logger.log(Level.FINER, "Conn:  Early-stalling Request: {0} {1}", new Object[]{req.getMethod(), req.getRequestURI()});
                Response response = this.early_stall;
                synchronized (response) {
                    try {
                        this.early_stall.getVersion();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.early_stall = null;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private String addQueryToFile(String file, NVPair[] form_data) {
        String File2 = HTTPConnection.stripRef(file);
        String query = Codecs.nv2query(form_data, this.urlEncoding);
        if (query != null && query.length() > 0) {
            File2 = File2 + "?" + query;
        }
        return File2;
    }

    private String addQueryToFile(String file, String query) {
        String File2 = HTTPConnection.stripRef(file);
        if (query != null && query.length() > 0) {
            File2 = File2 + "?" + Codecs.URLEncode(query, this.urlEncoding);
        }
        return File2;
    }

    private int getProtocol(String protocol) {
        if (protocol.equals("http")) {
            return 0;
        }
        if (protocol.equals("https")) {
            return 1;
        }
        return -1;
    }

    private static void initDefaultSocksClient(MutableStatics ms) {
        try {
            String socksHost = HttpClientConfiguration.getSocksHost();
            if (socksHost != null && socksHost.length() > 0) {
                int socksPort = HttpClientConfiguration.getSocksPort();
                int socksVersion = HttpClientConfiguration.getSocksVersion();
                logger.log(Level.FINER, "Conn:  using SOCKS {0}:{1}", new Object[]{socksHost, Integer.toString(socksPort)});
                if (socksVersion == -1) {
                    HTTPConnection.setSocksServer(ms, socksHost, socksPort);
                } else {
                    HTTPConnection.setSocksServer(ms, socksHost, socksPort, socksVersion);
                }
            }
        }
        catch (Exception e) {
            ms.default_Socks_client = null;
        }
    }

    private static void initNonProxyLists(MutableStatics ms) {
        HTTPConnection.dontProxyFor(ms, HttpClientConfiguration.getNonProxyHosts());
    }

    private static void initDefaultProxy(MutableStatics ms) {
        String proxyHost = HttpClientConfiguration.getProxyHost();
        int proxyPort = HttpClientConfiguration.getProxyPort();
        if (proxyHost != null) {
            HTTPClientMessages.log_config_defaultProxy(logger, proxyHost, proxyPort);
            HTTPConnection.setProxyServer(ms, proxyHost, proxyPort);
        }
    }

    private static InetAddress[] privilegedInetAddressGetAllByName(final String host) throws UnknownHostException {
        InetAddress[] retVal = null;
        try {
            retVal = (InetAddress[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UnknownHostException {
                    return InetAddress.getAllByName(host);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (UnknownHostException)e.getException();
        }
        return retVal;
    }

    static void initDefaultHostnameVerifier(MutableStatics ms) {
        block4: {
            String hostnameVerifierClassName = HttpClientConfiguration.getDefaultHostnameVerifier();
            if (null == hostnameVerifierClassName || hostnameVerifierClassName.length() <= 0) {
                return;
            }
            try {
                Class<?> cls = Class.forName(hostnameVerifierClassName);
                Object obj = cls.newInstance();
                if (!(obj instanceof HostnameVerifier)) {
                    throw new ClassCastException("Specified implementation '" + hostnameVerifierClassName + "' is not an instance of '" + HostnameVerifier.class.getName() + "'.");
                }
                ms.defaultHostnameVerifier = (HostnameVerifier)obj;
            }
            catch (Exception e) {
                String message = "Unable to instantiate HostnameVerifier '" + hostnameVerifierClassName + "'.";
                if (!logger.isLoggable(Level.FINE)) break block4;
                logger.log(Level.FINE, message, e);
            }
        }
    }

    static void initLoadBalanceProvider(MutableStatics ms) {
        block4: {
            if (null != ms.loadBalanceProvider) {
                return;
            }
            String loadBalanceProviderKey = HttpClientConfiguration.getLoadBalanceProvider();
            if (null == loadBalanceProviderKey || loadBalanceProviderKey.length() <= 0) {
                return;
            }
            try {
                ms.loadBalanceProvider = LoadBalanceProviderFactory.getInstance(loadBalanceProviderKey);
            }
            catch (Exception e) {
                String message = "Unable to instantiate LoadBalanceProvider '" + loadBalanceProviderKey + "'.";
                if (!logger.isLoggable(Level.FINE)) break block4;
                logger.log(Level.FINE, message, e);
            }
        }
    }

    private static void initDefaultTimeout(MutableStatics ms) {
        Configuration config = HttpClientConfiguration.getConfiguration();
        ms.defaultTimeout = new Timeouts((Integer)config.getValue(HTTPClientProperties.SysProp.SOCKET_READ_TIMEOUT), (Integer)config.getValue(HTTPClientProperties.SysProp.CONNECTION_TIMEOUT));
    }

    static MutableStatics getMutableStatics() {
        return (MutableStatics)HttpClientConfiguration.getConfiguration().getValue(HTTPClientProperties.Prop.HTTPCONNECTION_MUTABLE_STATICS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Pattern ipv4CoarsePattern = null;
        try {
            String ipv4CoarseRegExp = "\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}";
            ipv4CoarsePattern = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Unable to parse IPv4 regexp.", e);
        }
        finally {
            IPV4_COARSE_PATTERN = ipv4CoarsePattern;
        }
    }

    public static final class MutableStatics {
        private volatile String defaultProxyHost = null;
        private volatile int defaultProxyPort = -1;
        private final CIHashtable non_proxy_host_list = new CIHashtable();
        private final Vector non_proxy_dom_list = new Vector();
        private final Vector non_proxy_addr_list = new Vector();
        private final Vector non_proxy_mask_list = new Vector();
        private volatile SocksClient default_Socks_client = null;
        private final Vector<Class> defaultModuleList = HttpClientConfiguration.setupDefaultModuleList();
        private volatile boolean defaultAllowUI = true;
        private volatile SocketFactory defaultSocketFactory;
        private volatile SSLSocketFactory defaultSSLSocketFactory;
        private volatile HostnameVerifier defaultHostnameVerifier = null;
        private volatile Timeouts defaultContinueTimeout = new Timeouts(6000);
        private volatile LoadBalanceProvider loadBalanceProvider = null;
        private volatile Timeouts defaultTimeout;

        public MutableStatics() {
            HTTPConnection.initDefaultProxy(this);
            HTTPConnection.initNonProxyLists(this);
            HTTPConnection.initDefaultSocksClient(this);
            HTTPConnection.initDefaultHostnameVerifier(this);
            HTTPConnection.initLoadBalanceProvider(this);
            HTTPConnection.initDefaultTimeout(this);
        }
    }

    public static final class NonProxyHostsPropertyInitializer
    implements PropertyInitializer {
        public void initialize(Property property, Configuration config) throws Exception {
            if (!property.equals(HTTPClientProperties.Prop.NON_PROXY_HOSTS)) {
                return;
            }
            String hosts = (String)config.getValue(HTTPClientProperties.SysProp.HTTPCLIENT_NON_PROXY_HOSTS);
            if (hosts == null) {
                hosts = (String)config.getValue(HTTPClientProperties.SysProp.HTTP_NON_PROXY_HOSTS);
            }
            CommonCollectionWrappers.List_String nonProxyHosts = null;
            if (hosts != null) {
                nonProxyHosts = new CommonCollectionWrappers.List_String(Collections.unmodifiableList(Arrays.asList(Util.splitProperty(hosts))));
            }
            config.setValue(HTTPClientProperties.Prop.NON_PROXY_HOSTS, nonProxyHosts);
        }
    }

    private class EstablishConnection
    extends Thread {
        String actual_host;
        int actual_port;
        IOException exception;
        Socket sock;
        SocksClient Socks_client;
        boolean close;

        EstablishConnection(String host, int port, SocksClient socks) {
            super("EstablishConnection (" + host + ":" + port + ")");
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    EstablishConnection.this.setDaemon(true);
                    return null;
                }
            });
            this.actual_host = host;
            this.actual_port = port;
            this.Socks_client = socks;
            this.exception = null;
            this.sock = null;
            this.close = false;
        }

        public void run() {
            HTTPConnection.this.doAction(new CachedConfigAction<Object>(){

                @Override
                public Object run() {
                    block9: {
                        try {
                            if (EstablishConnection.this.Socks_client != null) {
                                EstablishConnection.this.sock = EstablishConnection.this.Socks_client.getSocket(EstablishConnection.this.actual_host, EstablishConnection.this.actual_port);
                                break block9;
                            }
                            InetAddress[] addr_list = HTTPConnection.privilegedInetAddressGetAllByName(EstablishConnection.this.actual_host);
                            for (int idx = 0; idx < addr_list.length; ++idx) {
                                try {
                                    EstablishConnection.this.sock = HTTPConnection.this.LocalAddr == null ? HTTPConnection.this.getCurrentSocketFactory().createSocket(addr_list[idx], EstablishConnection.this.actual_port) : HTTPConnection.this.getCurrentSocketFactory().createSocket(addr_list[idx], EstablishConnection.this.actual_port, HTTPConnection.this.LocalAddr, HTTPConnection.this.LocalPort);
                                    break;
                                }
                                catch (SocketException se) {
                                    if (idx != addr_list.length - 1 && !EstablishConnection.this.close) continue;
                                    throw se;
                                }
                            }
                        }
                        catch (IOException ioe) {
                            EstablishConnection.this.exception = ioe;
                        }
                    }
                    if (EstablishConnection.this.close && EstablishConnection.this.sock != null) {
                        try {
                            EstablishConnection.this.sock.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        EstablishConnection.this.sock = null;
                    }
                    return null;
                }
            });
        }

        IOException getException() {
            return this.exception;
        }

        Socket getSocket() {
            return this.sock;
        }

        void forget() {
            this.close = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum HostAddressFormat {
        NAME,
        IPV4ADDRESS,
        IPV6ADDRESS;

    }
}

