/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.CachedConfigAction;
import HTTPClient.CachedConfigActionException;
import HTTPClient.CachedConfigExceptionAction;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.NVPair;
import HTTPClient.Util;
import HTTPClient.config.CommonCollectionWrappers;
import HTTPClient.config.Configuration;
import HTTPClient.config.ConfigurationFactory;
import HTTPClient.config.HTTPClientProperties;
import HTTPClient.config.Property;
import HTTPClient.i18n.HTTPClientMessages;
import HTTPClient.loadbalance.LoadBalanceEndpoint;
import HTTPClient.loadbalance.LoadBalanceProvider;
import HTTPClient.loadbalance.PropertyLoadBalanceProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientConfiguration {
    private static final Logger logger = HttpClientLoggerFactory.getLogger(HttpClientConfiguration.class.getName());
    private static boolean logVerbose;
    private static final ConfigurationFactory configFactory;
    private static final String version = "Oracle HTTPClient Version 10h";

    public static final Configuration getConfiguration() {
        return configFactory.getConfiguration();
    }

    @Deprecated
    public static void setDefaults() {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Attempted to use HttpClientConfiguration.setDefaults(), which is obsolete.");
        }
    }

    @Deprecated
    public static void readConfigurationProperties() {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Attempted to use HttpClientConfiguration.readConfigurationProperties(), which is obsolete.");
        }
    }

    private HttpClientConfiguration() {
    }

    public static boolean getNoChunkingFlag() {
        return HttpClientConfiguration.getConfiguration().getBoolean(HTTPClientProperties.SysProp.DONT_CHUNK_REQUESTS);
    }

    public static String getVersion() {
        return version;
    }

    public static boolean getNoKeepAlives() {
        return HttpClientConfiguration.getConfiguration().getBoolean(HTTPClientProperties.SysProp.NO_KEEP_ALIVES);
    }

    public static boolean getForceHTTP1_0() {
        return HttpClientConfiguration.getConfiguration().getBoolean(HTTPClientProperties.SysProp.FORCE_1_0);
    }

    public static boolean getNeverPipeline() {
        return HttpClientConfiguration.getConfiguration().getBoolean(HTTPClientProperties.SysProp.NEVER_PIPELINE);
    }

    public static boolean getDeferStreamed() {
        return HttpClientConfiguration.getConfiguration().getBoolean(HTTPClientProperties.SysProp.DEFER_STREAMED);
    }

    public static boolean getNagleAlgorithmEnabled() {
        return HttpClientConfiguration.getConfiguration().getBoolean(HTTPClientProperties.SysProp.ENABLE_NAGLE_ALGORITHM);
    }

    public static String getProxyHost() {
        return (String)HttpClientConfiguration.getConfiguration().getValue(HTTPClientProperties.SysProp.PROXY_HOST);
    }

    public static int getProxyPort() {
        return HttpClientConfiguration.convertIntegerPropertyToInt(HTTPClientProperties.SysProp.PROXY_PORT);
    }

    public static String[] getNonProxyHosts() {
        CommonCollectionWrappers.List_String list = (CommonCollectionWrappers.List_String)HttpClientConfiguration.getConfiguration().getValue(HTTPClientProperties.Prop.NON_PROXY_HOSTS);
        if (null == list) {
            return null;
        }
        return list.getList().toArray(new String[0]);
    }

    public static String getSocksHost() {
        return (String)HttpClientConfiguration.getConfiguration().getValue(HTTPClientProperties.SysProp.SOCKS_HOST);
    }

    public static String getDefaultNtlmDomainName() {
        return (String)HttpClientConfiguration.getConfiguration().getValue(HTTPClientProperties.SysProp.DEFAULT_NTLM_DOMAIN_NAME);
    }

    public static String getDefaultNtlmAuthMethod() {
        return (String)HttpClientConfiguration.getConfiguration().getValue(HTTPClientProperties.SysProp.DEFAULT_NTLM_AUTH_METHOD);
    }

    public static String getDefaultHostnameVerifier() {
        return (String)HttpClientConfiguration.getConfiguration().getValue(HTTPClientProperties.SysProp.DEFAULT_HOSTNAME_VERIFIER);
    }

    public static List<String> getCipherSuites() {
        CommonCollectionWrappers.List_String list = (CommonCollectionWrappers.List_String)HttpClientConfiguration.getConfiguration().getValue(HTTPClientProperties.SysProp.JSSE_CIPHERSUITES);
        if (null == list) {
            return null;
        }
        return list.getList();
    }

    public static boolean isLogVerbose() {
        return logVerbose;
    }

    public static boolean isDisableExecutionContext() {
        return HttpClientConfiguration.getConfiguration().getBoolean(HTTPClientProperties.SysProp.DISABLE_EXECUTION_CONTEXT);
    }

    public static String getLoadBalanceProvider() {
        return (String)HttpClientConfiguration.getConfiguration().getValue(HTTPClientProperties.SysProp.LOAD_BALANCE_PROVIDER);
    }

    public static LoadBalanceProvider.LoadBalanceMethod getDefaultLoadBalanceMethod() {
        return (LoadBalanceProvider.LoadBalanceMethod)((Object)HttpClientConfiguration.getConfiguration().getValue(HTTPClientProperties.SysProp.DEFAULT_LOAD_BALANCE_METHOD));
    }

    public static List<LoadBalanceEndpoint> getLoadBalanceServerClusters() {
        PropertyLoadBalanceProvider.List_LoadBalanceEndpoint list = (PropertyLoadBalanceProvider.List_LoadBalanceEndpoint)HttpClientConfiguration.getConfiguration().getValue(HTTPClientProperties.SysProp.LOAD_BALANCE_SERVER_CLUSTERS);
        if (null == list) {
            return null;
        }
        return list.getList();
    }

    public static List<NVPair> getAuthenticationSchemes() {
        CommonCollectionWrappers.List_NVPair list = (CommonCollectionWrappers.List_NVPair)HttpClientConfiguration.getConfiguration().getValue(HTTPClientProperties.SysProp.AUTHENTICATION_SCHEMES);
        if (null == list) {
            return null;
        }
        return list.getList();
    }

    public static int getSocksPort() {
        return HttpClientConfiguration.convertIntegerPropertyToInt(HTTPClientProperties.SysProp.SOCKS_PORT);
    }

    public static int getSocksVersion() {
        return HttpClientConfiguration.convertIntegerPropertyToInt(HTTPClientProperties.SysProp.SOCKS_VERSION);
    }

    public static int getSocketIdleTimeout() {
        return HttpClientConfiguration.convertIntegerPropertyToInt(HTTPClientProperties.SysProp.SOCKET_IDLE_TIMEOUT);
    }

    public static void setSocketIdleTime(int idleTimeout) {
        HttpClientConfiguration.getConfiguration().setValue(HTTPClientProperties.SysProp.SOCKET_IDLE_TIMEOUT, idleTimeout);
    }

    public static void setConnectionTimeout(int timeout) {
        HttpClientConfiguration.getConfiguration().setValue(HTTPClientProperties.SysProp.CONNECTION_TIMEOUT, timeout);
    }

    public static int getConnectionTimeout() {
        return HttpClientConfiguration.convertIntegerPropertyToInt(HTTPClientProperties.SysProp.CONNECTION_TIMEOUT);
    }

    public static void setSocketReadTimeout(int timeout) {
        HttpClientConfiguration.getConfiguration().setValue(HTTPClientProperties.SysProp.SOCKET_READ_TIMEOUT, timeout);
    }

    public static int getSocketReadTimeout() {
        return HttpClientConfiguration.convertIntegerPropertyToInt(HTTPClientProperties.SysProp.SOCKET_READ_TIMEOUT);
    }

    public static boolean isStaleSocketCheckEnabled() {
        return HttpClientConfiguration.getConfiguration().getBoolean(HTTPClientProperties.SysProp.ENABLE_STALE_SOCKET_CHECK);
    }

    public static void setStaleSocketCheckEnabled(boolean enabled) {
        HttpClientConfiguration.getConfiguration().setValue(HTTPClientProperties.SysProp.ENABLE_STALE_SOCKET_CHECK, enabled);
    }

    public static int getMaxAuthTries() {
        return HttpClientConfiguration.convertIntegerPropertyToInt(HTTPClientProperties.SysProp.MAXIMUM_AUTHORIZATION_RETRIES);
    }

    public static int getMaxRequestTryCount() {
        return HttpClientConfiguration.convertIntegerPropertyToInt(HTTPClientProperties.SysProp.MAX_REQUEST_TRY_COUNT);
    }

    public static boolean isRetryNonIdempotentRequest() {
        return HttpClientConfiguration.getConfiguration().getBoolean(HTTPClientProperties.SysProp.RETRY_NON_IDEMPOTENT_REQUEST);
    }

    static Vector<Class> setupDefaultModuleList() {
        String defaultModules = (String)HttpClientConfiguration.getConfiguration().getValue(HTTPClientProperties.SysProp.DEFAULT_MODULES);
        if (null == defaultModules || "".equals(defaultModules)) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Empty modules list given, using default modules list.");
            }
            defaultModules = "HTTPClient.RetryModule|HTTPClient.CookieModule|HTTPClient.RedirectionModule|HTTPClient.AuthorizationModule|HTTPClient.DefaultModule|HTTPClient.TransferEncodingModule|HTTPClient.ContentMD5Module|HTTPClient.ContentEncodingModule|HTTPClient.ExecutionContextModule";
        }
        Vector<Class> vectorToReturn = new Vector<Class>();
        String[] list = Util.splitProperty(defaultModules);
        for (int idx = 0; idx < list.length; ++idx) {
            try {
                vectorToReturn.addElement(Class.forName(list[idx]));
                HTTPClientMessages.log_config_addedModule(logger, list[idx]);
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Unable to generate default module list.", cnfe);
            }
        }
        return vectorToReturn;
    }

    private static int convertIntegerPropertyToInt(Property prop) {
        if (null != prop.getPropertyInitializer()) {
            throw new IllegalArgumentException("A Property with a PropertyInitializer is not supported.");
        }
        Integer value = (Integer)HttpClientConfiguration.getConfiguration().getValue(prop);
        if (null != value) {
            return value;
        }
        value = (Integer)prop.getDefaultValue();
        if (null != value) {
            return value;
        }
        return 0;
    }

    static void initLogVerbose() {
        logVerbose = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean("HTTPClient.log.verbose");
            }
        });
    }

    private static final boolean setThreadLocalConfiguration(Configuration localCache) {
        return configFactory.setThreadLocalConfiguration(localCache);
    }

    private static final void clearThreadLocalConfiguration() {
        configFactory.clearThreadLocalConfiguration();
    }

    static final Configuration getThreadLocalConfiguration() {
        return configFactory.getThreadLocalConfiguration();
    }

    static final <T> T doAction(CachedConfigExceptionAction<T> action, Configuration localCache) throws CachedConfigActionException {
        if (null == action) {
            throw new IllegalArgumentException("Expected non-null CachedConfigExceptionAction object.");
        }
        boolean cachedConfig = false;
        try {
            cachedConfig = HttpClientConfiguration.setThreadLocalConfiguration(localCache);
            T t = action.run();
            return t;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new CachedConfigActionException(e);
        }
        finally {
            if (cachedConfig) {
                HttpClientConfiguration.clearThreadLocalConfiguration();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final <T> T doAction(CachedConfigAction<T> action, Configuration localCache) {
        if (null == action) {
            throw new IllegalArgumentException("Expected non-null CachedConfigAction object.");
        }
        boolean cachedConfig = false;
        try {
            cachedConfig = HttpClientConfiguration.setThreadLocalConfiguration(localCache);
            T t = action.run();
            return t;
        }
        finally {
            if (cachedConfig) {
                HttpClientConfiguration.clearThreadLocalConfiguration();
            }
        }
    }

    static {
        HttpClientConfiguration.initLogVerbose();
        configFactory = ConfigurationFactory.getInstance();
        HTTPClientMessages.log_config_version(logger, HttpClientConfiguration.getVersion());
    }
}

