/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class HttpClientLoggerFactory {
    private static final String ROOT_LOGGER = "HTTPClient";

    public static Logger getLogger() {
        return Logger.getLogger(ROOT_LOGGER);
    }

    public static Logger getLogger(String name) {
        if (null != name) {
            name = name.trim();
        }
        if (null == name || "".equals(name)) {
            name = ROOT_LOGGER;
        } else if (!name.startsWith(ROOT_LOGGER)) {
            StringBuffer buff = new StringBuffer(256);
            buff.append(ROOT_LOGGER);
            if ('.' != name.charAt(0)) {
                buff.append('.');
            }
            buff.append(name);
            name = buff.toString();
        }
        return Logger.getLogger(name);
    }

    private static void configureLogging() {
        String logLevel = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("HTTPClient.log.level");
            }
        });
        if (logLevel != null) {
            final LogManager logMgr = LogManager.getLogManager();
            String rootLevel = ".level = " + logMgr.getProperty(".level");
            String handlerProperty = " handlers= " + logMgr.getProperty("handlers");
            String consoleLevel = "java.util.logging.ConsoleHandler.level = " + logLevel;
            String consoleFormatter = "java.util.logging.ConsoleHandler.formatter = HTTPClient.HttpClientSimpleFormatter";
            String httpClientLogLevel = "HTTPClient.level = " + logLevel;
            String propertyList = rootLevel + "\n" + handlerProperty + "\n" + consoleLevel + "\n" + consoleFormatter + "\n" + httpClientLogLevel + "\n";
            final ByteArrayInputStream inputStream = new ByteArrayInputStream(propertyList.getBytes());
            try {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            logMgr.readConfiguration(inputStream);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException ex) {
                    throw (IOException)ex.getException();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        HttpClientLoggerFactory.configureLogging();
    }
}

