/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.HttpClientConfiguration;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class HttpClientSimpleFormatter
extends SimpleFormatter {
    private static final String CLASSIC_DATE_FORMAT = "[{0,number,00}:{1,number,00}:{2,number,00}.{3,number,000}]";
    private static final String CLASSIC_FORMAT = "'{'Thread-{0}'}' {1} {2}{3}";
    private static final String VERBOSE_FORMAT = "'{'Thread-{0}'}' {1}";
    private static final String NEWLINE_SEPARATOR = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return System.getProperty("line.separator", "\n");
        }
    });
    private Calendar calendar = Calendar.getInstance();

    public synchronized String format(LogRecord record) {
        if (HttpClientConfiguration.isLogVerbose()) {
            return this.verboseFormat(record);
        }
        return this.classicFormat(record);
    }

    private String verboseFormat(LogRecord record) {
        record.setSourceClassName(null);
        record.setSourceMethodName(null);
        String output = MessageFormat.format(VERBOSE_FORMAT, record.getThreadID(), super.format(record));
        return output;
    }

    private String classicFormat(LogRecord record) {
        this.calendar.setTimeInMillis(record.getMillis());
        String timeValue = MessageFormat.format(CLASSIC_DATE_FORMAT, this.calendar.get(10), this.calendar.get(12), this.calendar.get(13), this.calendar.get(14));
        String output = MessageFormat.format(CLASSIC_FORMAT, record.getThreadID(), timeValue, super.formatMessage(record), NEWLINE_SEPARATOR);
        return output;
    }
}

