/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.CachedConfigActionException;
import HTTPClient.CachedConfigExceptionAction;
import HTTPClient.Codecs;
import HTTPClient.HTTPConnection;
import HTTPClient.HttpClientConfiguration;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.Timeouts;
import HTTPClient.Util;
import HTTPClient.config.Configuration;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpOutputStream
extends OutputStream {
    private static final NVPair[] empty = new NVPair[0];
    private int length;
    private long rcvd = 0L;
    private Request req = null;
    private Response resp = null;
    private OutputStream os = null;
    private ByteArrayOutputStream bos = null;
    private NVPair[] trailers = empty;
    private Timeouts con_to = Timeouts.zero;
    private boolean ignore = false;
    private static final Logger logger = HttpClientLoggerFactory.getLogger(HttpOutputStream.class.getName());

    public HttpOutputStream() {
        this.length = -1;
    }

    public HttpOutputStream(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Length must be greater equal 0");
        }
        this.length = length;
    }

    void goAhead(Request req, OutputStream os, Timeouts con_to) {
        this.req = req;
        this.os = os;
        this.con_to = con_to;
        if (os == null) {
            this.bos = new ByteArrayOutputStream();
        }
        logger.fine("OutS:  Stream ready for writing");
        if (this.bos != null) {
            logger.fine("OutS:  Buffering all data before sending request");
        }
    }

    void ignoreData(Request req) {
        this.req = req;
        this.ignore = true;
    }

    boolean ignoring() {
        return this.ignore;
    }

    synchronized Response getResponse() {
        while (this.resp == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.resp;
    }

    public int getLength() {
        return this.length;
    }

    public NVPair[] getTrailers() {
        return this.trailers;
    }

    public void setTrailers(NVPair[] trailers) {
        this.trailers = trailers != null ? trailers : empty;
    }

    public void reset() {
        this.rcvd = 0L;
        this.req = null;
        this.resp = null;
        this.os = null;
        this.bos = null;
        this.con_to = Timeouts.zero;
        this.ignore = false;
    }

    public void write(int b) throws IOException, IllegalAccessError {
        byte[] tmp = new byte[]{(byte)b};
        this.write(tmp, 0, 1);
    }

    public synchronized void write(byte[] buf, int off, int len) throws IOException, IllegalAccessError {
        if (this.req == null) {
            throw new IllegalAccessError("Stream not associated with a request");
        }
        if (this.ignore) {
            return;
        }
        if (this.length != -1 && this.rcvd + (long)len > (long)this.length) {
            IOException ioe = new IOException("Tried to write too many bytes (" + (this.rcvd + (long)len) + " > " + this.length + ")");
            this.req.getConnection().closeDemux(ioe, false);
            this.req.getConnection().outputFinished();
            throw ioe;
        }
        try {
            if (this.bos != null) {
                this.bos.write(buf, off, len);
            } else if (this.length != -1) {
                this.os.write(buf, off, len);
            } else {
                int chunkSize = this.req.getConnection().getChunkSize();
                if (chunkSize >= len) {
                    this.os.write(Codecs.chunkedEncode(buf, off, len, null, false));
                } else {
                    int writeLength;
                    int offset = off;
                    int dataSize = len;
                    do {
                        writeLength = dataSize < chunkSize ? dataSize : chunkSize;
                        this.os.write(Codecs.chunkedEncode(buf, offset, writeLength, null, false));
                        offset += writeLength;
                    } while ((dataSize -= writeLength) > 0);
                }
            }
        }
        catch (IOException ioe) {
            this.req.getConnection().closeDemux(ioe, true);
            this.req.getConnection().outputFinished();
            throw ioe;
        }
        this.rcvd += (long)len;
    }

    public synchronized void close() throws IOException, IllegalAccessError {
        HTTPConnection conn;
        if (this.req == null) {
            throw new IllegalAccessError("Stream not associated with a request");
        }
        if (this.ignore) {
            return;
        }
        Request req = this.req;
        Configuration config = null;
        if (null != req && null != (conn = req.getConnection())) {
            config = conn.getCachedConfiguration();
        }
        try {
            HttpClientConfiguration.doAction(new CachedConfigExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    HttpOutputStream.this.closeImpl();
                    return null;
                }
            }, config);
        }
        catch (CachedConfigActionException e) {
            Throwable causeEx = e.getCause();
            if (causeEx instanceof IOException) {
                throw (IOException)causeEx;
            }
            throw new RuntimeException("Unexpected throwable during close", causeEx);
        }
    }

    private void closeImpl() throws IOException {
        if (this.bos != null) {
            this.req.setData(this.bos.toByteArray());
            this.req.setStream(null);
            if (this.trailers.length > 0) {
                NVPair[] hdrs = this.req.getHeaders();
                int len = hdrs.length;
                for (int idx = 0; idx < len; ++idx) {
                    if (!hdrs[idx].getName().equalsIgnoreCase("Trailer")) continue;
                    System.arraycopy(hdrs, idx + 1, hdrs, idx, len - idx - 1);
                    --len;
                }
                hdrs = Util.resizeArray(hdrs, len + this.trailers.length);
                System.arraycopy(this.trailers, 0, hdrs, len, this.trailers.length);
                this.req.setHeaders(hdrs);
            }
            logger.fine("OutS:  Sending request");
            try {
                this.resp = this.req.getConnection().sendRequest(this.req, this.con_to);
                this.ignore = true;
            }
            catch (ModuleException me) {
                throw new IOException(me.toString());
            }
            this.notify();
        } else {
            if (this.length != -1 && this.rcvd < (long)this.length) {
                IOException ioe = new IOException("Premature close: only " + this.rcvd + " bytes written instead of the " + "expected " + this.length);
                this.req.getConnection().closeDemux(ioe, false);
                this.req.getConnection().outputFinished();
                throw ioe;
            }
            try {
                if (this.length == -1) {
                    logger.fine("OutS:  Sending trailers:");
                    for (int idx = 0; idx < this.trailers.length; ++idx) {
                        logger.log(Level.FINE, "       {0}: {1}", new Object[]{this.trailers[idx].getName(), this.trailers[idx].getValue()});
                    }
                    this.os.write(Codecs.chunkedEncode(null, 0, 0, this.trailers, true));
                }
                this.os.flush();
                logger.fine("OutS:  All data sent");
            }
            catch (IOException ioe) {
                this.req.getConnection().closeDemux(ioe, true);
                throw ioe;
            }
            finally {
                this.req.getConnection().outputFinished();
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + "[length=" + this.length + "]" + (this.req != null ? "READY" : " not ready ");
    }
}

