/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.CachedConfigActionException;
import HTTPClient.CachedConfigExceptionAction;
import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.HttpClientConfiguration;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.HttpOutputStream;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ProtocolNotSuppException;
import HTTPClient.RedirectionModule;
import HTTPClient.URI;
import HTTPClient.Util;
import HTTPClient.config.HTTPClientProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpURLConnection
extends java.net.HttpURLConnection {
    protected HTTPConnection con;
    private String urlString;
    private String resource;
    private String method;
    private boolean method_set;
    private NVPair[] headers;
    protected HTTPResponse resp;
    private boolean do_redir;
    private static final Class redir_mod = RedirectionModule.class;
    private OutputStream output_stream;
    private static final Logger logger = HttpClientLoggerFactory.getLogger(HttpURLConnection.class.getName());
    private String[] hdr_keys;
    private String[] hdr_values;

    public HttpURLConnection(final URL url) throws ProtocolNotSuppException, IOException {
        super(url);
        try {
            HttpClientConfiguration.doAction(new CachedConfigExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    MutableStatics ms = HttpURLConnection.getMutableStatics();
                    HttpURLConnection.this.con = HttpURLConnection.this.getConnection(url);
                    HttpURLConnection.this.method = "GET";
                    HttpURLConnection.this.method_set = false;
                    HttpURLConnection.this.resource = url.getFile();
                    HttpURLConnection.access$302(HttpURLConnection.this, ms.default_headers);
                    HttpURLConnection.this.do_redir = java.net.HttpURLConnection.getFollowRedirects();
                    HttpURLConnection.this.output_stream = null;
                    HttpURLConnection.this.urlString = HttpURLConnection.this.cacheString(url);
                    return null;
                }
            }, null);
        }
        catch (CachedConfigActionException e) {
            Throwable causeEx = e.getCause();
            if (causeEx instanceof IOException) {
                throw (IOException)causeEx;
            }
            throw new RuntimeException("Unexpected throwable during HttpURLConnection", causeEx);
        }
    }

    public static void clearConnectionList() {
        HashMap mapOfConnections = HttpURLConnection.getMapOfConnections();
        mapOfConnections.clear();
    }

    public HTTPConnection getConnection() {
        return this.con;
    }

    public HttpURLConnection(URL url, Map cookieStore) throws ProtocolNotSuppException, IOException {
        this(url);
        this.con.setCookieStore(cookieStore);
    }

    private String cacheString(URL url) {
        String php = url.getProtocol() + ":" + url.getHost() + ":" + (url.getPort() != -1 ? url.getPort() : URI.defaultPort(url.getProtocol()));
        php = php.toLowerCase();
        return php;
    }

    protected HTTPConnection getConnection(URL url) throws ProtocolNotSuppException {
        String php = this.cacheString(url);
        HashMap mapOfConnections = HttpURLConnection.getMapOfConnections();
        HTTPConnection connection = (HTTPConnection)mapOfConnections.get(php);
        if (connection != null) {
            return connection;
        }
        connection = new HTTPConnection(url);
        mapOfConnections.put(php, connection);
        return connection;
    }

    private static HashMap getMapOfConnections() {
        MutableStatics ms = HttpURLConnection.getMutableStatics();
        HashMap mapOfConnections = (HashMap)ms.connectionsThreadLocal.get();
        return mapOfConnections;
    }

    public void setRequestMethod(String method) throws ProtocolException {
        if (this.connected) {
            throw new ProtocolException("Already connected!");
        }
        logger.log(Level.FINE, "URLC:  ({0}) Setting request method: {1}", new Object[]{this.urlString, method});
        this.method = method.trim().toUpperCase();
        this.method_set = true;
    }

    public String getRequestMethod() {
        return this.method;
    }

    public int getResponseCode() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        try {
            return this.resp.getStatusCode();
        }
        catch (ModuleException me) {
            throw new IOException(me.toString());
        }
    }

    public String getResponseMessage() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        try {
            return this.resp.getReasonLine();
        }
        catch (ModuleException me) {
            throw new IOException(me.toString());
        }
    }

    public String getHeaderField(String name) {
        try {
            if (!this.connected) {
                this.connect();
            }
            return this.resp.getHeader(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getHeaderFieldInt(String name, int def) {
        try {
            if (!this.connected) {
                this.connect();
            }
            return this.resp.getHeaderAsInt(name);
        }
        catch (Exception e) {
            return def;
        }
    }

    public long getHeaderFieldDate(String name, long def) {
        try {
            if (!this.connected) {
                this.connect();
            }
            return this.resp.getHeaderAsDate(name).getTime();
        }
        catch (Exception e) {
            return def;
        }
    }

    public String getHeaderFieldKey(int n) {
        if (this.hdr_keys == null) {
            this.fill_hdr_arrays();
        }
        if (n >= 0 && n < this.hdr_keys.length) {
            return this.hdr_keys[n];
        }
        return null;
    }

    public String getHeaderField(int n) {
        if (this.hdr_values == null) {
            this.fill_hdr_arrays();
        }
        if (n >= 0 && n < this.hdr_values.length) {
            return this.hdr_values[n];
        }
        return null;
    }

    private void fill_hdr_arrays() {
        try {
            if (!this.connected) {
                this.connect();
            }
            int num = 1;
            Enumeration enum5 = this.resp.listHeaders();
            while (enum5.hasMoreElements()) {
                ++num;
                enum5.nextElement();
            }
            this.hdr_keys = new String[num];
            this.hdr_values = new String[num];
            enum5 = this.resp.listHeaders();
            for (int idx = 1; idx < num; ++idx) {
                this.hdr_keys[idx] = (String)enum5.nextElement();
                this.hdr_values[idx] = this.resp.getHeader(this.hdr_keys[idx]);
            }
            this.hdr_values[0] = this.resp.getVersion() + " " + this.resp.getStatusCode() + " " + this.resp.getReasonLine();
        }
        catch (Exception e) {
            this.hdr_values = new String[0];
            this.hdr_keys = this.hdr_values;
        }
    }

    public InputStream getInputStream() throws IOException {
        InputStream stream;
        if (!this.doInput) {
            throw new ProtocolException("Input not enabled! (use setDoInput(true))");
        }
        if (!this.connected) {
            this.connect();
        }
        try {
            stream = this.resp.getInputStream();
        }
        catch (ModuleException e) {
            throw new IOException(e.toString());
        }
        logger.log(Level.FINE, "URLC: getInputStream returning {0}", stream);
        return stream;
    }

    public InputStream getErrorStream() {
        try {
            if (!this.doInput || !this.connected || this.resp.getStatusCode() < 300 || this.resp.getHeaderAsInt("Content-Length") <= 0) {
                return null;
            }
            return this.resp.getInputStream();
        }
        catch (Exception e) {
            return null;
        }
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.connected) {
            throw new ProtocolException("Already connected!");
        }
        if (!this.doOutput) {
            throw new ProtocolException("Output not enabled! (use setDoOutput(true))");
        }
        if (!this.method_set) {
            this.method = "POST";
        } else if (this.method.equals("HEAD") || this.method.equals("GET") || this.method.equals("TRACE")) {
            throw new ProtocolException("Method " + this.method + " does not support output!");
        }
        if (this.getRequestProperty("Content-type") == null) {
            this.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
        }
        if (this.output_stream == null) {
            logger.log(Level.FINE, "URLC:  ({0}) creating output stream", this.urlString);
            String cl = this.getRequestProperty("Content-Length");
            this.output_stream = cl != null ? new HttpOutputStream(Integer.parseInt(cl.trim())) : (this.getRequestProperty("Content-type").equals("application/x-www-form-urlencoded") ? new ByteArrayOutputStream(300) : new HttpOutputStream());
            if (this.output_stream instanceof HttpOutputStream) {
                this.connect();
            }
        }
        return this.output_stream;
    }

    public URL getURL() {
        if (this.connected) {
            try {
                return this.resp.getEffectiveURI().toURL();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.url;
    }

    public void setIfModifiedSince(long time) {
        super.setIfModifiedSince(time);
        this.setRequestProperty("If-Modified-Since", Util.httpDate(new Date(time)));
    }

    public void setRequestProperty(String name, String value) {
        int idx;
        logger.log(Level.FINE, "URLC:  ({0}) Setting request property: {1} : {2}", new Object[]{this.urlString, name, value});
        for (idx = 0; idx < this.headers.length && !this.headers[idx].getName().equalsIgnoreCase(name); ++idx) {
        }
        if (idx == this.headers.length) {
            this.headers = Util.resizeArray(this.headers, idx + 1);
        }
        this.headers[idx] = new NVPair(name, value);
    }

    public String getRequestProperty(String name) {
        for (int idx = 0; idx < this.headers.length; ++idx) {
            if (!this.headers[idx].getName().equalsIgnoreCase(name)) continue;
            return this.headers[idx].getValue();
        }
        return null;
    }

    public static void setDefaultRequestProperty(String name, String value) {
        HttpURLConnection.setDefaultRequestProperty(HttpURLConnection.getMutableStatics(), name, value);
    }

    private static void setDefaultRequestProperty(MutableStatics ms, String name, String value) {
        int idx;
        logger.log(Level.FINE, "URLC:  Setting default request property: {0} : {1}", new Object[]{name, value});
        for (idx = 0; idx < ms.default_headers.length && !ms.default_headers[idx].getName().equalsIgnoreCase(name); ++idx) {
        }
        if (idx == ms.default_headers.length) {
            MutableStatics.access$402(ms, Util.resizeArray(ms.default_headers, idx + 1));
        }
        ((MutableStatics)ms).default_headers[idx] = new NVPair(name, value);
    }

    public static String getDefaultRequestProperty(String name) {
        MutableStatics ms = HttpURLConnection.getMutableStatics();
        for (int idx = 0; idx < ms.default_headers.length; ++idx) {
            if (!ms.default_headers[idx].getName().equalsIgnoreCase(name)) continue;
            return ms.default_headers[idx].getValue();
        }
        return null;
    }

    public void setInstanceFollowRedirects(boolean set) {
        if (this.connected) {
            throw new IllegalStateException("Already connected!");
        }
        this.do_redir = set;
    }

    public boolean getInstanceFollowRedirects() {
        return this.do_redir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connect() throws IOException {
        if (this.connected) {
            return;
        }
        logger.log(Level.FINE, "URLC:  ({0}) Connecting ...", this.urlString);
        HTTPConnection hTTPConnection = this.con;
        synchronized (hTTPConnection) {
            this.con.setAllowUserInteraction(this.allowUserInteraction);
            this.con.usedByHttpURLConnection = true;
            if (this.do_redir) {
                this.con.addModule(redir_mod, 2);
            } else {
                this.con.removeModule(redir_mod);
            }
            try {
                this.resp = this.output_stream instanceof ByteArrayOutputStream ? this.con.ExtensionMethod(this.method, this.resource, ((ByteArrayOutputStream)this.output_stream).toByteArray(), this.headers) : this.con.ExtensionMethod(this.method, this.resource, (HttpOutputStream)this.output_stream, this.headers);
            }
            catch (ModuleException e) {
                throw new IOException(e.toString());
            }
        }
        this.connected = true;
    }

    public synchronized void disconnect() {
        logger.log(Level.FINE, "URLC:  ({0}) Disconnecting ...", this.urlString);
        this.con.stop();
        String hashValue = this.urlString;
        HashMap mapOfConnections = HttpURLConnection.getMapOfConnections();
        mapOfConnections.remove(hashValue);
    }

    public boolean usingProxy() {
        return this.con.getProxyHost() != null;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.url + "]";
    }

    private static String getPrivilegedProperty(final String name) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(name);
            }
        });
    }

    private static String getPrivilegedPropertywithDefault(final String name, final String defaultValue) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(name, defaultValue);
            }
        });
    }

    static MutableStatics getMutableStatics() {
        return (MutableStatics)HttpClientConfiguration.getConfiguration().getValue(HTTPClientProperties.Prop.HTTPURLCONNECTION_MUTABLE_STATICS);
    }

    static /* synthetic */ NVPair[] access$302(HttpURLConnection x0, NVPair[] x1) {
        x0.headers = x1;
        return x1;
    }

    static {
        if (HttpClientConfiguration.getConfiguration().getBoolean(HTTPClientProperties.SysProp.HTTPURLCONNECTION_ALLOWUI)) {
            HttpURLConnection.setDefaultAllowUserInteraction(true);
        }
    }

    public static final class MutableStatics {
        final int MAX_NUMBER_CACHED_CONNECTIONS = (Integer)HttpClientConfiguration.getConfiguration().getValue(HTTPClientProperties.SysProp.HTTPURLCONNECTION_MAX_CACHED_CONNECTIONS);
        private ThreadLocal connectionsThreadLocal = new ThreadLocal(){

            protected Object initialValue() {
                return new LinkedHashMap(){

                    protected boolean removeEldestEntry(Map.Entry eldest) {
                        return this.size() > MutableStatics.this.MAX_NUMBER_CACHED_CONNECTIONS;
                    }
                };
            }
        };
        private NVPair[] default_headers = new NVPair[0];

        public MutableStatics() {
            String agent = (String)HttpClientConfiguration.getConfiguration().getValue(HTTPClientProperties.SysProp.HTTP_AGENT);
            if (agent != null) {
                HttpURLConnection.setDefaultRequestProperty(this, "User-Agent", agent);
            }
        }

        static /* synthetic */ NVPair[] access$402(MutableStatics x0, NVPair[] x1) {
            x0.default_headers = x1;
            return x1;
        }
    }
}

