/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import java.text.MessageFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OptionalValue<T> {
    private static final String TO_STRING_SPECIFIED_NON_NULL_TEMPLATE = "[specified]\"{0}\"";
    private static final String TO_STRING_SPECIFIED_NULL_TEMPLATE = "[specified]<null>";
    private static final String TO_STRING_UNSPECIFIED_TEMPLATE = "[unspecified]";
    private final boolean specified;
    private final T value;

    public OptionalValue(boolean specified, T value) {
        this.specified = specified;
        this.value = value;
    }

    public T getValue() {
        if (this.isSpecified()) {
            return this.value;
        }
        throw new IllegalStateException("Attempting to get unspecified value.");
    }

    public boolean isSpecified() {
        return this.specified;
    }

    public boolean equals(Object object) {
        if (!(object instanceof OptionalValue)) {
            return false;
        }
        OptionalValue otherOptionalValue = (OptionalValue)object;
        if (!this.isSpecified()) {
            boolean otherSpecified = otherOptionalValue.isSpecified();
            return !otherSpecified;
        }
        if (!otherOptionalValue.isSpecified()) {
            return false;
        }
        T otherValue = otherOptionalValue.getValue();
        if (this.value == null) {
            return null == otherValue;
        }
        if (null == otherValue) {
            return false;
        }
        boolean isValueEqual = this.value.equals(otherValue);
        return isValueEqual;
    }

    public int hashCode() {
        if (!this.isSpecified()) {
            return -2147483647;
        }
        int output = -1;
        T value = this.getValue();
        output = value == null ? 0 : value.hashCode();
        return output;
    }

    public String toString() {
        Object[] args = new Object[]{};
        String template = null;
        if (this.isSpecified()) {
            T localValue = this.getValue();
            if (null == localValue) {
                template = TO_STRING_SPECIFIED_NULL_TEMPLATE;
            } else {
                template = TO_STRING_SPECIFIED_NON_NULL_TEMPLATE;
                args = new Object[]{localValue};
            }
        } else {
            template = TO_STRING_UNSPECIFIED_TEMPLATE;
        }
        String output = MessageFormat.format(template, args);
        return output;
    }
}

