/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.ExecutorHelper;
import HTTPClient.GlobalConstants;
import HTTPClient.HttpClientConfiguration;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.IPushBackInputStream;
import HTTPClient.ModuleException;
import HTTPClient.ResponseHandler;
import HTTPClient.SequenceByteArrayInputStream;
import HTTPClient.StreamDemultiplexor;
import HTTPClient.Timeouts;
import HTTPClient.config.HTTPClientProperties;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

final class RespInputStream
extends InputStream
implements GlobalConstants,
IPushBackInputStream {
    private static final boolean dontTimeoutBody = HttpClientConfiguration.getConfiguration().getBoolean(HTTPClientProperties.SysProp.DISABLE_TIMEOUT_FOR_RESPONSE_BODY);
    private StreamDemultiplexor demux = null;
    private ResponseHandler resph;
    private volatile boolean closed = false;
    private volatile boolean dont_truncate = false;
    private volatile SequenceByteArrayInputStream buffer = null;
    private volatile boolean interrupted = false;
    private volatile int count = 0;
    private static final Logger logger = HttpClientLoggerFactory.getLogger(RespInputStream.class.getName());
    private static final Executor RESP_INPUT_STREAM_CLOSER = ExecutorHelper.getExecutor();

    RespInputStream(StreamDemultiplexor demux, ResponseHandler resph) {
        this.demux = demux;
        this.resph = resph;
    }

    public int read() throws IOException {
        byte[] ch = new byte[1];
        int rcvd = this.read(ch, 0, 1);
        if (rcvd == 1) {
            return ch[0] & 0xFF;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            return -1;
        }
        StreamDemultiplexor streamDemultiplexor = this.demux;
        synchronized (streamDemultiplexor) {
            int rcvd;
            int left;
            if (this.closed) {
                return -1;
            }
            int n = left = this.buffer != null ? this.buffer.available() : -1;
            if (!(this.buffer == null || left == 0 && this.interrupted)) {
                if (left == 0) {
                    return -1;
                }
                len = len > left ? left : len;
                return this.buffer.read(b, off, len);
            }
            try {
                rcvd = dontTimeoutBody && this.resph.resp.cd_type != 1 ? this.demux.read(b, off, len, this.resph, 0) : this.demux.read(b, off, len, this.resph, this.resph.resp.timeout.read);
            }
            catch (EOFException eofex) {
                rcvd = -1;
            }
            if (rcvd != -1 && this.resph.resp.got_headers) {
                this.addToCount(rcvd);
            }
            return rcvd;
        }
    }

    public void unread(byte[] b, int off, int len) throws IOException {
        this.demux.unread(b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long num) throws IOException {
        if (this.closed) {
            return 0L;
        }
        StreamDemultiplexor streamDemultiplexor = this.demux;
        synchronized (streamDemultiplexor) {
            int left;
            if (this.closed) {
                return 0L;
            }
            int n = left = this.buffer != null ? this.buffer.available() : -1;
            if (!(this.buffer == null || left == 0 && this.interrupted)) {
                num = num > (long)left ? (long)left : num;
                return this.buffer.skip(num);
            }
            int skpd = this.demux.skip(num, this.resph);
            if (this.resph.resp.got_headers) {
                this.addToCount(skpd);
            }
            return skpd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        if (this.closed) {
            return 0;
        }
        StreamDemultiplexor streamDemultiplexor = this.demux;
        synchronized (streamDemultiplexor) {
            int left;
            if (this.closed) {
                return 0;
            }
            int n = left = this.buffer != null ? this.buffer.available() : -1;
            if (!(this.buffer == null || left == 0 && this.interrupted)) {
                return left;
            }
            return this.demux.available(this.resph);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.closed) {
            StreamDemultiplexor streamDemultiplexor = this.demux;
            synchronized (streamDemultiplexor) {
                this.closed = true;
            }
            if (this.dont_truncate && (this.buffer == null || this.interrupted)) {
                this.readAll(this.resph.resp.timeout.read);
            }
            this.demux.closeSocketIfAllStreamsClosed();
            if (this.dont_truncate) {
                try {
                    this.resph.resp.http_resp.invokeTrailerHandlers(false);
                }
                catch (ModuleException me) {
                    throw new IOException(me.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            RESP_INPUT_STREAM_CLOSER.execute(new RISClosingTask(this));
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readAll(int timeout) throws IOException {
        GlobalConstants globalConstants = this.resph.resp;
        synchronized (globalConstants) {
            if (!this.resph.resp.got_headers) {
                Timeouts sav_to = this.resph.resp.timeout;
                this.resph.resp.timeout = new Timeouts(timeout);
                this.resph.resp.getStatusCode();
                this.resph.resp.timeout = sav_to;
            }
        }
        globalConstants = this.demux;
        synchronized (globalConstants) {
            if (this.buffer != null && !this.interrupted) {
                return;
            }
            int rcvd = 0;
            try {
                if (this.closed) {
                    byte[] bytes = new byte[4096];
                    do {
                        this.addToCount(rcvd);
                    } while ((rcvd = this.demux.read(bytes, 0, bytes.length, this.resph, timeout)) != -1);
                    this.buffer = null;
                } else {
                    if (this.buffer == null) {
                        this.buffer = new SequenceByteArrayInputStream(40960);
                    }
                    byte[] bytes = new byte[4096];
                    while ((rcvd = this.demux.read(bytes, 0, bytes.length, this.resph, timeout)) >= 0) {
                        this.buffer.write(bytes, 0, rcvd);
                        this.addToCount(rcvd);
                    }
                }
            }
            catch (InterruptedIOException iioe) {
                this.interrupted = true;
                throw iioe;
            }
            catch (IOException ioe) {
                this.buffer = null;
            }
            this.interrupted = false;
        }
    }

    void dontTruncate() {
        this.dont_truncate = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addToCount(int addend) {
        StreamDemultiplexor streamDemultiplexor = this.demux;
        synchronized (streamDemultiplexor) {
            this.count += addend;
            return this.count;
        }
    }

    int getCount() {
        return this.count;
    }

    boolean isClosed() {
        return this.closed;
    }

    private class RISClosingTask
    implements Runnable {
        RespInputStream is;

        RISClosingTask(RespInputStream is) {
            this.is = is;
        }

        public void run() {
            block3: {
                if (this.is != null && !this.is.isClosed()) {
                    try {
                        this.is.close();
                    }
                    catch (IOException e) {
                        if (!logger.isLoggable(Level.WARNING)) break block3;
                        logger.log(Level.WARNING, "Error closing the response input stream: " + e);
                    }
                }
            }
        }
    }
}

