/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.GlobalConstants;
import HTTPClient.HTTPClientModule;
import HTTPClient.HTTPConnection;
import HTTPClient.HttpClientConfiguration;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.IdempotentSequence;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RetryException;
import HTTPClient.RoRequest;
import HTTPClient.Util;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

class RetryModule
implements HTTPClientModule,
GlobalConstants {
    private static final Logger logger = HttpClientLoggerFactory.getLogger(RetryModule.class.getName());
    private static final Level logLevel = Level.FINEST;
    private static final boolean retryNonIdempotentRequest = HttpClientConfiguration.isRetryNonIdempotentRequest();

    RetryModule() {
    }

    public int requestHandler(Request req, Response[] resp) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void responsePhase1Handler(Response resp, RoRequest roreq) throws IOException, ModuleException {
        try {
            resp.getStatusCode();
        }
        catch (RetryException re) {
            logger.log(logLevel, "RtryM: Caught RetryException");
            boolean got_lock = false;
            try {
                RetryException retryException = re.first;
                synchronized (retryException) {
                    got_lock = true;
                    IdempotentSequence seq = new IdempotentSequence();
                    RetryException e = re.first;
                    while (e != null) {
                        seq.add(e.request);
                        e = e.next;
                    }
                    e = re.first;
                    while (e != null) {
                        boolean retriable;
                        logger.log(logLevel, "RtryM: handling exception ", e);
                        Request req = e.request;
                        HTTPConnection con = req.getConnection();
                        boolean bl = retriable = e.firstByte && retryNonIdempotentRequest || seq.isIdempotent(req);
                        if (!retriable || con.ServProtVersKnown && con.ServerProtocolVersion >= 65537 && req.num_retries > 0 || (!con.ServProtVersKnown || con.ServerProtocolVersion <= 65536) && req.num_retries > 4 || e.response.got_headers) {
                            logger.log(logLevel, "RtryM: not retryable: firstByte {0} retryNonIdempotentReqeust {1} idempotent {2} retries {3}", new Object[]{Boolean.toString(e.firstByte), Boolean.toString(retryNonIdempotentRequest), Boolean.toString(seq.isIdempotent(req)), Integer.toString(req.num_retries)});
                            e.first = null;
                        } else if (req.getStream() != null) {
                            if (HttpClientConfiguration.getDeferStreamed()) {
                                req.getStream().reset();
                                e.response.setRetryRequest(true);
                            }
                            e.first = null;
                            logger.log(logLevel, "RtryM: not retryable, output stream used");
                        } else {
                            if (req.getData() != null && e.conn_reset && (!con.ServProtVersKnown || con.ServerProtocolVersion < 65537)) {
                                req.delay_entity = 5000L << req.num_retries;
                            }
                            if (e.next != null && e.next.request.getData() != null && (!con.ServProtVersKnown || con.ServerProtocolVersion < 65537) && e.conn_reset) {
                                this.addToken(req, "Connection", "close");
                            }
                            if (con.ServProtVersKnown && con.ServerProtocolVersion >= 65537 && e.conn_reset) {
                                req.dont_pipeline = true;
                            }
                            req.dont_pipeline = true;
                            logger.log(logLevel, "RtryM: Retrying request {0} {1} ", new Object[]{req.getMethod(), req.getRequestURI()});
                            if (e.conn_reset) {
                                ++req.num_retries;
                            }
                            e.response.http_resp.set(req, con.sendRequest(req, e.response.timeout));
                            e.exception = null;
                            e.first = null;
                        }
                        e = e.next;
                    }
                }
            }
            catch (NullPointerException npe) {
                if (got_lock) {
                    throw npe;
                }
            }
            catch (ParseException pe) {
                throw new IOException(pe.getMessage());
            }
            if (re.exception != null) {
                throw re.exception;
            }
            re.restart = true;
            throw re;
        }
    }

    public int responsePhase2Handler(Response resp, Request req) {
        req.delay_entity = 0L;
        req.dont_pipeline = false;
        req.num_retries = 0;
        return 10;
    }

    public void responsePhase3Handler(Response resp, RoRequest req) {
    }

    public void trailerHandler(Response resp, RoRequest req) {
    }

    private void addToken(Request req, String hdr, String tok) throws ParseException {
        int idx;
        NVPair[] hdrs = req.getHeaders();
        for (idx = 0; idx < hdrs.length && !hdrs[idx].getName().equalsIgnoreCase(hdr); ++idx) {
        }
        if (idx == hdrs.length) {
            hdrs = Util.resizeArray(hdrs, idx + 1);
            hdrs[idx] = new NVPair(hdr, tok);
            req.setHeaders(hdrs);
        } else if (!Util.hasToken(hdrs[idx].getValue(), tok)) {
            hdrs[idx] = new NVPair(hdr, hdrs[idx].getValue() + ", " + tok);
        }
    }
}

