/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;

class SequenceByteArrayInputStream
extends InputStream {
    private LinkedList<byte[]> byteArrayList;
    private int index = 0;
    private byte[] read1Byte = new byte[1];
    private byte[] currentBytes;
    private byte[] appendBytes;
    private boolean lastBytes = false;
    private int lastLen = 0;
    private int available;
    private int unitLength;

    public SequenceByteArrayInputStream(int unitLen) {
        this.byteArrayList = new LinkedList();
        this.unitLength = unitLen;
        this.available = 0;
    }

    public int read() throws IOException {
        int len = this.read(this.read1Byte, 0, 1);
        return len != -1 ? this.read1Byte[0] : -1;
    }

    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    public int read(byte[] bytes, int pos, int len) throws IOException {
        if (this.byteArrayList == null) {
            throw new IOException("Stream is closed.");
        }
        if (this.currentBytes == null) {
            if (this.byteArrayList.size() > 0) {
                this.updateCurrentBytes();
            } else {
                return -1;
            }
        }
        int totalLen = 0;
        int remainLen = (this.lastBytes ? this.lastLen : this.currentBytes.length) - this.index;
        while (remainLen > 0) {
            int copyLen = len <= remainLen ? len : remainLen;
            System.arraycopy(this.currentBytes, this.index, bytes, pos, copyLen);
            this.index += copyLen;
            totalLen += copyLen;
            pos += copyLen;
            this.available -= copyLen;
            if ((len -= copyLen) <= 0) {
                if ((remainLen -= copyLen) > 0) break;
                this.updateCurrentBytes();
                break;
            }
            if (this.lastBytes) {
                this.currentBytes = null;
                break;
            }
            this.updateCurrentBytes();
            remainLen = (this.lastBytes ? this.lastLen : this.currentBytes.length) - this.index;
        }
        return totalLen;
    }

    public int available() {
        return this.available;
    }

    public void close() throws IOException {
        this.byteArrayList = null;
        this.currentBytes = null;
        this.appendBytes = null;
        this.available = 0;
    }

    public void write(byte[] bytes, int pos, int len) throws IOException {
        int remainLen;
        if (this.byteArrayList == null) {
            throw new IOException("Stream is closed.");
        }
        if (len == 0) {
            return;
        }
        if (this.appendBytes == null || this.appendBytes.length == this.lastLen) {
            this.appendBytes = new byte[this.unitLength];
            this.byteArrayList.add(this.appendBytes);
            this.lastLen = 0;
        }
        int n = remainLen = len <= this.appendBytes.length - this.lastLen ? len : this.appendBytes.length - this.lastLen;
        while (remainLen > 0) {
            System.arraycopy(bytes, pos, this.appendBytes, this.lastLen, remainLen);
            this.lastLen += remainLen;
            pos += remainLen;
            this.available += remainLen;
            if ((len -= remainLen) <= 0) {
                return;
            }
            this.appendBytes = new byte[this.unitLength];
            this.byteArrayList.add(this.appendBytes);
            this.lastLen = 0;
            remainLen = len <= this.appendBytes.length ? len : this.appendBytes.length;
        }
    }

    private void updateCurrentBytes() {
        if (this.byteArrayList.size() > 0) {
            this.currentBytes = this.byteArrayList.remove(0);
            this.index = 0;
            this.lastBytes = this.byteArrayList.size() == 0;
        } else {
            this.currentBytes = null;
        }
    }
}

