/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthorizationInfo;
import HTTPClient.AuthorizationPrompter;
import HTTPClient.NVPair;
import HTTPClient.i18n.HTTPClientMessages;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;

class SimpleAuthPrompt
implements AuthorizationPrompter {
    SimpleAuthPrompt() {
    }

    public NVPair getUsernamePassword(AuthorizationInfo challenge, boolean forProxy) {
        String pass;
        String user;
        if (challenge.getScheme().equalsIgnoreCase("SOCKS5")) {
            System.out.println(HTTPClientMessages.msg_simpleAuthPrompt_socks5_line1(challenge.getHost()));
            System.out.println(HTTPClientMessages.msg_simpleAuthPrompt_socks5_line2());
        } else {
            System.out.println(HTTPClientMessages.msg_simpleAuthPrompt_other_line1(challenge.getRealm(), challenge.getHost(), challenge.getPort()));
            System.out.println(HTTPClientMessages.msg_simpleAuthPrompt_other_line2(challenge.getScheme()));
        }
        BufferedReader inp = new BufferedReader(new InputStreamReader(System.in));
        System.out.print(HTTPClientMessages.msg_simpleAuthPrompt_label_username());
        System.out.flush();
        try {
            user = inp.readLine();
        }
        catch (IOException ioe) {
            return null;
        }
        if (user == null || user.length() == 0) {
            return null;
        }
        SimpleAuthPrompt.echo(false);
        System.out.print(HTTPClientMessages.msg_simpleAuthPrompt_label_password());
        System.out.flush();
        try {
            pass = inp.readLine();
        }
        catch (IOException ioe) {
            return null;
        }
        System.out.println();
        SimpleAuthPrompt.echo(true);
        if (pass == null) {
            return null;
        }
        return new NVPair(user, pass);
    }

    private static void echo(boolean on) {
        String os = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("os.name");
            }
        });
        String[] cmd = null;
        if (os.equalsIgnoreCase("Windows 95") || os.equalsIgnoreCase("Windows NT")) {
            cmd = new String[]{"echo", on ? "on" : "off"};
        } else if (!(os.equalsIgnoreCase("Windows") || os.equalsIgnoreCase("16-bit Windows") || os.equalsIgnoreCase("OS/2") || os.equalsIgnoreCase("Mac OS") || os.equalsIgnoreCase("MacOS"))) {
            cmd = os.equalsIgnoreCase("OpenVMS") || os.equalsIgnoreCase("VMS") ? new String[]{"SET TERMINAL " + (on ? "/ECHO" : "/NOECHO")} : new String[]{"/bin/sh", "-c", "stty " + (on ? "echo" : "-echo") + " < /dev/tty"};
        }
        if (cmd != null) {
            try {
                Runtime.getRuntime().exec(cmd).waitFor();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static boolean canUseCLPrompt() {
        String os = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("os.name");
            }
        });
        return os.indexOf("Linux") >= 0 || os.indexOf("SunOS") >= 0 || os.indexOf("Solaris") >= 0 || os.indexOf("BSD") >= 0 || os.indexOf("AIX") >= 0 || os.indexOf("HP-UX") >= 0 || os.indexOf("IRIX") >= 0 || os.indexOf("OSF") >= 0 || os.indexOf("A/UX") >= 0 || os.indexOf("VMS") >= 0;
    }
}

