/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.HTTPConnection;
import HTTPClient.HttpClientLoggerFactory;
import java.net.InetAddress;
import java.security.Principal;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.directory.Attribute;
import javax.naming.ldap.LdapName;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

public class StandardHostnameVerifier
implements HostnameVerifier {
    private static final Logger logger = HttpClientLoggerFactory.getLogger(StandardHostnameVerifier.class.getName());
    private boolean recognizeWildcardCNs = true;

    public StandardHostnameVerifier() {
    }

    public StandardHostnameVerifier(boolean recognizeWildcardCNs) {
        this.setRecognizeWildcardCNs(recognizeWildcardCNs);
    }

    public boolean isRecognizeWildcardCNs() {
        return this.recognizeWildcardCNs;
    }

    public boolean setRecognizeWildcardCNs(boolean recognizeWildcardCNs) {
        boolean prev = this.recognizeWildcardCNs;
        this.recognizeWildcardCNs = recognizeWildcardCNs;
        return prev;
    }

    public boolean verify(String hostname, SSLSession sslSession) {
        String string = hostname = null == hostname ? "" : hostname.trim();
        if (null == sslSession) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Expected non-null SSLSession for host ''{0}''.", new Object[]{hostname});
            }
            return false;
        }
        if ("".equals(hostname)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Expected non-null, non-empty hostname.");
            }
            return false;
        }
        X509Certificate[] peerCertificateChain = null;
        try {
            peerCertificateChain = sslSession.getPeerCertificateChain();
            if (null == peerCertificateChain || 0 == peerCertificateChain.length) {
                throw new SSLPeerUnverifiedException("Found no server certificates.");
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Unable to obtain SSL session peer certificate chain for host '" + hostname + "'.", e);
            }
            return false;
        }
        StandardHostnameVerifier.dumpCertDNsToLog(peerCertificateChain, hostname);
        X509Certificate peerCertificate = peerCertificateChain[0];
        if (null == peerCertificate) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "First SSL certificate is null for hostname ''{0}''.", new Object[]{hostname});
            }
            return false;
        }
        Principal principal = peerCertificate.getSubjectDN();
        if (null == principal) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Principal in first SSL certificate is null for hostname ''{0}''.", new Object[]{hostname});
            }
            return false;
        }
        String dn = principal.getName();
        if (null == dn || "".equals(dn)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "First SSL certificate has null or empty Distinguished Name (DN) for hostname ''{0}''", new Object[]{hostname});
            }
            return false;
        }
        if (!this.isMatchesCN(hostname, dn)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "SSL certificate Distinguished Name (DN) ''{0}'' does not have a Common Name (CN) which matches hostname ''{1}''.", new Object[]{dn, hostname});
            }
            return false;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Successfully verified hostname ''{0}'' with SSL certificate Common Name (CN).", new Object[]{hostname});
        }
        return true;
    }

    private boolean isMatchesCN(String hostname, String dn) {
        block6: {
            try {
                LdapName ldapName = new LdapName(dn);
                int size = ldapName.size();
                for (int rdxIndex = size - 1; rdxIndex >= 0; --rdxIndex) {
                    Attribute cnValues = ldapName.getRdn(rdxIndex).toAttributes().get("CN");
                    if (null == cnValues) continue;
                    int len = cnValues.size();
                    for (int cnValueIndex = 0; cnValueIndex < len; ++cnValueIndex) {
                        int START_AT_INDEX;
                        InetAddress ia_2;
                        InetAddress ia_1;
                        String cnValueStr;
                        Object cnValueObj = cnValues.get(cnValueIndex);
                        if (null == cnValueObj || null == (cnValueStr = cnValueObj.toString())) continue;
                        if ((cnValueStr = cnValueStr.trim()).equalsIgnoreCase(hostname)) {
                            return true;
                        }
                        if (HTTPConnection.isStringAnIPv6(hostname) && HTTPConnection.isStringAnIPv6(cnValueStr) && (ia_1 = InetAddress.getByName(hostname)).equals(ia_2 = InetAddress.getByName(cnValueStr))) {
                            return true;
                        }
                        if (!this.recognizeWildcardCNs || !cnValueStr.startsWith("*.") || -1 == cnValueStr.indexOf(46, 2) || -1 != cnValueStr.indexOf(42, 2) || (START_AT_INDEX = hostname.length() - (cnValueStr.length() - 1)) < 0) continue;
                        String hostnameTail = hostname.substring(START_AT_INDEX);
                        if (!cnValueStr.substring(1).equalsIgnoreCase(hostnameTail)) continue;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINE)) break block6;
                logger.log(Level.FINE, "Unable to parse DN '" + dn + "' for hostname '" + hostname + "'.", e);
            }
        }
        return false;
    }

    private static void dumpCertDNsToLog(X509Certificate[] peerCertificateChain, String hostname) {
        Level LEVEL = Level.FINEST;
        if (logger.isLoggable(LEVEL)) {
            String string = hostname = null == hostname ? "" : hostname;
            if (null == peerCertificateChain || 0 == peerCertificateChain.length) {
                logger.log(LEVEL, "Null or empty peer certificate chain given for hostname ''{0}''", new Object[]{hostname});
            } else {
                StringBuilder buff = new StringBuilder(256);
                buff.append("Dump of SSL certificate DN values for Host '");
                buff.append(hostname);
                buff.append("': \n");
                for (X509Certificate cert : peerCertificateChain) {
                    if (null == cert) continue;
                    buff.append(cert.getSubjectDN().getName());
                    buff.append('\n');
                }
                buff.append("done---------\n");
                logger.log(LEVEL, buff.toString());
            }
        }
    }
}

