/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.ChunkedInputStream;
import HTTPClient.HTTPClientModule;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.HttpHeaderElement;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import HTTPClient.UncompressInputStream;
import HTTPClient.Util;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

class TransferEncodingModule
implements HTTPClientModule {
    private static final Logger logger = HttpClientLoggerFactory.getLogger(TransferEncodingModule.class.getName());

    TransferEncodingModule() {
    }

    public int requestHandler(Request req, Response[] resp) throws ModuleException {
        Vector<HttpHeaderElement> pte;
        int idx;
        NVPair[] hdrs = req.getHeaders();
        for (idx = 0; idx < hdrs.length && !hdrs[idx].getName().equalsIgnoreCase("TE"); ++idx) {
        }
        if (idx == hdrs.length) {
            hdrs = Util.resizeArray(hdrs, idx + 1);
            req.setHeaders(hdrs);
            pte = new Vector<HttpHeaderElement>();
        } else {
            try {
                pte = Util.parseHeader(hdrs[idx].getValue());
            }
            catch (ParseException pe) {
                throw new ModuleException(pe.toString());
            }
        }
        HttpHeaderElement all = Util.getElement(pte, "*");
        if (all != null) {
            NVPair[] params = all.getParams();
            for (idx = 0; idx < params.length && !params[idx].getName().equalsIgnoreCase("q"); ++idx) {
            }
            if (idx == params.length) {
                return 0;
            }
            if (params[idx].getValue() == null || params[idx].getValue().length() == 0) {
                throw new ModuleException("Invalid q value for \"*\" in TE header: ");
            }
            try {
                if ((double)Float.valueOf(params[idx].getValue()).floatValue() > 0.0) {
                    return 0;
                }
            }
            catch (NumberFormatException nfe) {
                throw new ModuleException("Invalid q value for \"*\" in TE header: " + nfe.getMessage());
            }
        }
        if (!pte.contains(new HttpHeaderElement("deflate"))) {
            pte.addElement(new HttpHeaderElement("deflate"));
        }
        if (!pte.contains(new HttpHeaderElement("gzip"))) {
            pte.addElement(new HttpHeaderElement("gzip"));
        }
        if (!pte.contains(new HttpHeaderElement("compress"))) {
            pte.addElement(new HttpHeaderElement("compress"));
        }
        hdrs[idx] = new NVPair("TE", Util.assembleHeader(pte));
        return 0;
    }

    public void responsePhase1Handler(Response resp, RoRequest req) {
    }

    public int responsePhase2Handler(Response resp, Request req) {
        return 10;
    }

    public void responsePhase3Handler(Response resp, RoRequest req) throws IOException, ModuleException {
        Vector pte;
        String te = resp.getHeader("Transfer-Encoding");
        if (te == null || req.getMethod().equals("HEAD")) {
            return;
        }
        try {
            pte = Util.parseHeader(te);
        }
        catch (ParseException pe) {
            throw new ModuleException(pe.toString());
        }
        while (pte.size() > 0) {
            String encoding = ((HttpHeaderElement)pte.lastElement()).getName();
            if (encoding.equalsIgnoreCase("gzip")) {
                logger.log(Level.FINE, "TEM:   pushing gzip-input-stream");
                resp.inp_stream = new GZIPInputStream(resp.inp_stream);
            } else if (encoding.equalsIgnoreCase("deflate")) {
                logger.log(Level.FINE, "TEM:   pushing inflater-input-stream");
                resp.inp_stream = new InflaterInputStream(resp.inp_stream);
            } else if (encoding.equalsIgnoreCase("compress")) {
                logger.log(Level.FINE, "TEM:   pushing uncompress-input-stream");
                resp.inp_stream = new UncompressInputStream(resp.inp_stream);
            } else if (encoding.equalsIgnoreCase("chunked")) {
                logger.log(Level.FINE, "TEM:   pushing chunked-input-stream");
                resp.inp_stream = new ChunkedInputStream(resp.inp_stream);
            } else if (encoding.equalsIgnoreCase("identity")) {
                logger.log(Level.FINE, "TEM:   ignoring 'identity' token");
            } else {
                logger.log(Level.FINE, "TEM:   Unknown transfer encoding ' {0} '", encoding);
                break;
            }
            pte.removeElementAt(pte.size() - 1);
        }
        if (pte.size() > 0) {
            resp.setHeader("Transfer-Encoding", Util.assembleHeader(pte));
        } else {
            resp.deleteHeader("Transfer-Encoding");
        }
    }

    public void trailerHandler(Response resp, RoRequest req) {
    }
}

