/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.ParseException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class URI {
    public static final boolean ENABLE_BACKWARDS_COMPATIBILITY = true;
    protected static final Map<String, Integer> defaultPorts;
    protected static final Map<String, Boolean> usesGenericSyntax;
    protected static final Map<String, Boolean> usesSemiGenericSyntax;
    private static final BitSet alphanumChar_pvt;
    private static final BitSet markChar_pvt;
    private static final BitSet reservedChar_pvt;
    private static final BitSet unreservedChar_pvt;
    private static final BitSet uricChar_pvt;
    private static final BitSet pcharChar_pvt;
    private static final BitSet userinfoChar_pvt;
    private static final BitSet schemeChar_pvt;
    private static final BitSet hostChar_pvt;
    private static final BitSet opaqueChar_pvt;
    private static final BitSet reg_nameChar_pvt;
    private static final BitSet resvdSchemeChar_pvt;
    private static final BitSet resvdUIChar_pvt;
    private static final BitSet resvdHostChar_pvt;
    private static final BitSet resvdPathChar_pvt;
    private static final BitSet resvdQueryChar_pvt;
    private static final BitSet escpdPathChar_pvt;
    private static final BitSet escpdQueryChar_pvt;
    private static final BitSet escpdFragChar_pvt;
    private static final char[] hex;
    @Deprecated
    protected static final BitSet alphanumChar;
    @Deprecated
    protected static final BitSet markChar;
    @Deprecated
    protected static final BitSet reservedChar;
    @Deprecated
    protected static final BitSet unreservedChar;
    @Deprecated
    protected static final BitSet uricChar;
    @Deprecated
    protected static final BitSet pcharChar;
    @Deprecated
    protected static final BitSet userinfoChar;
    @Deprecated
    protected static final BitSet schemeChar;
    @Deprecated
    protected static final BitSet hostChar;
    @Deprecated
    protected static final BitSet opaqueChar;
    @Deprecated
    protected static final BitSet reg_nameChar;
    @Deprecated
    public static final BitSet resvdSchemeChar;
    @Deprecated
    public static final BitSet resvdUIChar;
    @Deprecated
    public static final BitSet resvdHostChar;
    @Deprecated
    public static final BitSet resvdPathChar;
    @Deprecated
    public static final BitSet resvdQueryChar;
    @Deprecated
    public static final BitSet escpdPathChar;
    @Deprecated
    public static final BitSet escpdQueryChar;
    @Deprecated
    public static final BitSet escpdFragChar;
    protected static final int OPAQUE = 0;
    protected static final int SEMI_GENERIC = 1;
    protected static final int GENERIC = 2;
    protected int type;
    protected String scheme;
    protected String opaque;
    protected String userinfo;
    protected String host;
    protected int port = -1;
    protected String path;
    protected String query;
    protected String fragment;
    protected URL url = null;
    private int hashCode = -1;
    private static final String nl;

    public URI(String uri) throws ParseException {
        this((URI)null, uri);
    }

    public URI(URI base, String rel_uri) throws ParseException {
        this(base, rel_uri, true);
    }

    URI(URI base, String rel_uri, boolean escape_rel_uri) throws ParseException {
        int idx;
        int pos;
        char[] uri = rel_uri.toCharArray();
        int len = uri.length;
        for (pos = 0; pos < len && Character.isWhitespace(uri[pos]); ++pos) {
        }
        while (len > 0 && Character.isWhitespace(uri[len - 1])) {
            --len;
        }
        if (!(pos >= len - 3 || uri[pos + 3] != ':' || uri[pos + 0] != 'u' && uri[pos + 0] != 'U' || uri[pos + 1] != 'r' && uri[pos + 1] != 'R' || uri[pos + 2] != 'i' && uri[pos + 2] != 'I' && uri[pos + 2] != 'l' && uri[pos + 2] != 'L')) {
            pos += 4;
        }
        for (idx = pos; idx < len && uri[idx] != ':' && uri[idx] != '/' && uri[idx] != '?' && uri[idx] != '#'; ++idx) {
        }
        if (idx < len && uri[idx] == ':') {
            this.scheme = rel_uri.substring(pos, idx).trim().toLowerCase();
            pos = idx + 1;
        }
        String final_scheme = this.scheme;
        if (this.scheme == null) {
            if (base == null) {
                throw new ParseException("No scheme found");
            }
            final_scheme = base.scheme;
        }
        int n = URI.usesGenericSyntax(final_scheme) ? 2 : (this.type = URI.usesSemiGenericSyntax(final_scheme) ? 1 : 0);
        if (this.type == 0) {
            if (base != null && this.scheme == null) {
                throw new ParseException("Can't resolve relative URI for scheme " + final_scheme);
            }
            this.opaque = rel_uri.substring(pos);
            if (escape_rel_uri) {
                this.opaque = URI.escape(this.opaque, opaqueChar_pvt, true);
            }
            if (this.opaque.length() > 0 && this.opaque.charAt(0) == '/') {
                this.opaque = "%2F" + this.opaque.substring(1);
            }
            return;
        }
        if (pos + 1 < len && uri[pos] == '/' && uri[pos + 1] == '/') {
            for (idx = pos += 2; idx < len && uri[idx] != '/' && uri[idx] != '?' && uri[idx] != '#'; ++idx) {
            }
            this.parse_authority(rel_uri.substring(pos, idx), final_scheme, escape_rel_uri);
            pos = idx;
        }
        if (this.type == 1) {
            this.path = rel_uri.substring(pos);
            if (escape_rel_uri) {
                this.path = URI.escape(this.path, uricChar_pvt, true);
            }
            if (this.path.length() > 0 && this.path.charAt(0) != '/') {
                this.path = '/' + this.path;
            }
        } else {
            for (idx = pos; idx < len && uri[idx] != '?' && uri[idx] != '#'; ++idx) {
            }
            this.path = rel_uri.substring(pos, idx);
            if (escape_rel_uri) {
                this.path = URI.escape(this.path, escpdPathChar_pvt, true);
            }
            if ((pos = idx) < len && uri[pos] == '?') {
                for (idx = ++pos; idx < len && uri[idx] != '#'; ++idx) {
                }
                this.query = rel_uri.substring(pos, idx);
                if (escape_rel_uri) {
                    this.query = URI.escape(this.query, escpdQueryChar_pvt, true);
                }
                pos = idx;
            }
            if (pos < len && uri[pos] == '#') {
                this.fragment = rel_uri.substring(pos + 1, len);
                if (escape_rel_uri) {
                    this.fragment = URI.escape(this.fragment, escpdFragChar_pvt, true);
                }
            }
        }
        if (base != null) {
            if (this.scheme != null && !this.scheme.equals(base.scheme)) {
                return;
            }
            this.scheme = base.scheme;
            if (this.host != null) {
                return;
            }
            this.userinfo = base.userinfo;
            this.host = base.host;
            this.port = base.port;
            if (this.type == 1) {
                return;
            }
            if (this.path.length() == 0 && this.query == null) {
                this.path = base.path;
                this.query = base.query;
                return;
            }
            if (this.path.length() == 0 || this.path.charAt(0) != '/') {
                idx = base.path != null ? base.path.lastIndexOf(47) : -1;
                this.path = idx < 0 ? '/' + this.path : base.path.substring(0, idx + 1) + this.path;
                this.path = URI.canonicalizePath(this.path);
            }
        }
    }

    public static String canonicalizePath(String path) {
        int len = path.length();
        int idx = path.indexOf("/.");
        if (idx == -1 || idx != len - 2 && path.charAt(idx + 2) != '/' && (path.charAt(idx + 2) != '.' || idx != len - 3 && path.charAt(idx + 3) != '/')) {
            return path;
        }
        char[] p = new char[path.length()];
        path.getChars(0, p.length, p, 0);
        int beg = 0;
        for (idx = 1; idx < len; ++idx) {
            int end;
            if (p[idx] != '.' || p[idx - 1] != '/') continue;
            if (idx == len - 1) {
                end = idx++;
            } else if (p[idx + 1] == '/') {
                end = idx - 1;
                ++idx;
            } else {
                if (p[idx + 1] != '.' || idx != len - 2 && p[idx + 2] != '/') continue;
                if (idx < beg + 2) {
                    beg = idx + 2;
                    continue;
                }
                for (end = idx - 2; end > beg && p[end] != '/'; --end) {
                }
                if (p[end] != '/') continue;
                if (idx == len - 2) {
                    ++end;
                }
                idx += 2;
            }
            System.arraycopy(p, idx, p, end, len - idx);
            len -= idx - end;
            idx = end;
        }
        return new String(p, 0, len);
    }

    private void parse_authority(String authority, String scheme, boolean escapeAuthority) throws ParseException {
        int idx;
        char[] uri = authority.toCharArray();
        int pos = 0;
        int len = uri.length;
        for (idx = pos; idx < len && uri[idx] != '@'; ++idx) {
        }
        if (idx < len && uri[idx] == '@') {
            this.userinfo = authority.substring(pos, idx);
            if (escapeAuthority) {
                this.userinfo = URI.escape(this.userinfo, userinfoChar_pvt, true);
            }
            pos = idx + 1;
        }
        if ((idx = pos) < len && uri[idx] == '[') {
            while (idx < len && uri[idx] != ']') {
                ++idx;
            }
            if (idx == len) {
                throw new ParseException("No closing ']' found for opening '[' at position " + pos + " in authority `" + authority + "'");
            }
            this.host = authority.substring(pos + 1, idx);
            ++idx;
        } else {
            while (idx < len && uri[idx] != ':') {
                ++idx;
            }
            this.host = authority.substring(pos, idx);
            if (escapeAuthority) {
                this.host = URI.escape(this.host, uricChar_pvt, true);
            }
        }
        pos = idx;
        if (pos < len - 1 && uri[pos] == ':') {
            int p;
            try {
                p = Integer.parseInt(URI.unescape(authority.substring(pos + 1, len), null));
                if (p < 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                throw new ParseException(authority.substring(pos + 1, len) + " is an invalid port number");
            }
            this.port = p == URI.defaultPort(scheme) ? -1 : p;
        }
    }

    public URI(URL url) throws ParseException {
        this((URI)null, url.toExternalForm());
    }

    public URI(String scheme, String host, String path) throws ParseException {
        this(scheme, null, host, -1, path, null, null);
    }

    public URI(String scheme, String host, int port, String path) throws ParseException {
        this(scheme, null, host, port, path, null, null);
    }

    public URI(String scheme, String userinfo, String host, int port, String path, String query, String fragment) throws ParseException {
        if (scheme == null) {
            throw new ParseException("missing scheme");
        }
        this.scheme = URI.escape(scheme.trim().toLowerCase(), schemeChar_pvt, true);
        if (userinfo != null) {
            this.userinfo = URI.escape(userinfo.trim(), userinfoChar_pvt, true);
        }
        if (host != null) {
            String string = this.host = URI.isIPV6Addr(host = host.trim()) ? host : URI.escape(host, hostChar_pvt, true);
        }
        if (port != URI.defaultPort(scheme)) {
            this.port = port;
        }
        if (path != null) {
            this.path = URI.escape(path.trim(), escpdPathChar_pvt, true);
        }
        if (query != null) {
            this.query = URI.escape(query.trim(), escpdQueryChar_pvt, true);
        }
        if (fragment != null) {
            this.fragment = URI.escape(fragment.trim(), escpdFragChar_pvt, true);
        }
        this.type = URI.usesGenericSyntax(scheme) ? 2 : 1;
    }

    private static final boolean isIPV6Addr(String host) {
        if (host.indexOf(58) < 0) {
            return false;
        }
        for (int idx = 0; idx < host.length(); ++idx) {
            char ch = host.charAt(idx);
            if (ch >= '0' && ch <= '9' || ch == ':') continue;
            return false;
        }
        return true;
    }

    public URI(String scheme, String opaque) throws ParseException {
        if (scheme == null) {
            throw new ParseException("missing scheme");
        }
        this.scheme = URI.escape(scheme.trim().toLowerCase(), schemeChar_pvt, true);
        this.opaque = URI.escape(opaque, opaqueChar_pvt, true);
        this.type = 0;
    }

    public static boolean usesGenericSyntax(String scheme) {
        return usesGenericSyntax.containsKey(scheme.trim().toLowerCase());
    }

    public static boolean usesSemiGenericSyntax(String scheme) {
        return usesSemiGenericSyntax.containsKey(scheme.trim().toLowerCase());
    }

    public static final int defaultPort(String protocol) {
        Integer port = defaultPorts.get(protocol.trim().toLowerCase());
        return port != null ? port : 0;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserinfo() {
        return this.userinfo;
    }

    public String getPath() {
        return this.path;
    }

    public String getQueryString() {
        return this.query;
    }

    public String getPathAndQuery() {
        if (this.query == null) {
            return this.path;
        }
        if (this.path == null) {
            return "?" + this.query;
        }
        return this.path + "?" + this.query;
    }

    public String getFragment() {
        return this.fragment;
    }

    public boolean isGenericURI() {
        return this.type == 2;
    }

    public boolean isSemiGenericURI() {
        return this.type == 1;
    }

    public URL toURL() throws MalformedURLException {
        if (this.url != null) {
            return this.url;
        }
        if (this.opaque != null) {
            this.url = new URL(this.scheme + ":" + this.opaque);
            return this.url;
        }
        String hostinfo = this.userinfo != null && this.host != null ? this.userinfo + "@" + this.host : (this.userinfo != null ? this.userinfo + "@" : this.host);
        StringBuffer file = new StringBuffer(100);
        this.assemblePath(file, true, true, false);
        this.url = new URL(this.scheme, hostinfo, this.port, file.toString());
        return this.url;
    }

    private final void assemblePath(StringBuffer buf, boolean printEmpty, boolean incFragment, boolean unescape) {
        if ((this.path == null || this.path.length() == 0) && printEmpty) {
            buf.append('/');
        }
        if (this.path != null) {
            buf.append(unescape ? URI.unescapeNoPE(this.path, resvdPathChar_pvt) : this.path);
        }
        if (this.query != null) {
            buf.append('?');
            buf.append(unescape ? URI.unescapeNoPE(this.query, resvdQueryChar_pvt) : this.query);
        }
        if (this.fragment != null && incFragment) {
            buf.append('#');
            buf.append(unescape ? URI.unescapeNoPE(this.fragment, null) : this.fragment);
        }
    }

    private final String stringify(boolean unescape) {
        StringBuffer uri = new StringBuffer(100);
        if (this.scheme != null) {
            uri.append(unescape ? URI.unescapeNoPE(this.scheme, resvdSchemeChar_pvt) : this.scheme);
            uri.append(':');
        }
        if (this.opaque != null) {
            uri.append(unescape ? URI.unescapeNoPE(this.opaque, null) : this.opaque);
            return uri.toString();
        }
        if (this.userinfo != null || this.host != null || this.port != -1) {
            uri.append("//");
        }
        if (this.userinfo != null) {
            uri.append(unescape ? URI.unescapeNoPE(this.userinfo, resvdUIChar_pvt) : this.userinfo);
            uri.append('@');
        }
        if (this.host != null) {
            if (this.host.indexOf(58) < 0) {
                uri.append(unescape ? URI.unescapeNoPE(this.host, resvdHostChar_pvt) : this.host);
            } else {
                uri.append('[').append(this.host).append(']');
            }
        }
        if (this.port != -1) {
            uri.append(':');
            uri.append(this.port);
        }
        this.assemblePath(uri, false, true, unescape);
        return uri.toString();
    }

    public String toExternalForm() {
        return this.stringify(false);
    }

    public String toString() {
        return this.stringify(true);
    }

    public boolean equals(Object other) {
        if (other instanceof URI) {
            URI o = (URI)other;
            return this.scheme.equals(o.scheme) && (this.type == 0 && URI.areEqual(this.opaque, o.opaque) || this.type == 1 && URI.areEqual(this.userinfo, o.userinfo) && URI.areEqualIC(this.host, o.host) && this.port == o.port && URI.areEqual(this.path, o.path) || this.type == 2 && URI.areEqual(this.userinfo, o.userinfo) && URI.areEqualIC(this.host, o.host) && this.port == o.port && URI.pathsEqual(this.path, o.path) && URI.areEqual(this.query, o.query) && URI.areEqual(this.fragment, o.fragment));
        }
        if (other instanceof URL) {
            URL o = (URL)other;
            String h = this.userinfo != null ? this.userinfo + "@" + this.host : this.host;
            String f = this.getPathAndQuery();
            return this.scheme.equalsIgnoreCase(o.getProtocol()) && (this.type == 0 && this.opaque.equals(o.getFile()) || this.type == 1 && URI.areEqualIC(h, o.getHost()) && (this.port == o.getPort() || o.getPort() == URI.defaultPort(this.scheme)) && URI.areEqual(f, o.getFile()) || this.type == 2 && URI.areEqualIC(h, o.getHost()) && (this.port == o.getPort() || o.getPort() == URI.defaultPort(this.scheme)) && URI.pathsEqual(f, o.getFile()) && URI.areEqual(this.fragment, o.getRef()));
        }
        return false;
    }

    private static final boolean areEqual(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s2 != null && (s1.equals(s2) || URI.unescapeNoPE(s1, null).equals(URI.unescapeNoPE(s2, null)));
    }

    private static final boolean areEqualIC(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s2 != null && (s1.equalsIgnoreCase(s2) || URI.unescapeNoPE(s1, null).equalsIgnoreCase(URI.unescapeNoPE(s2, null)));
    }

    private static final boolean pathsEqual(String p1, String p2) {
        int pos2;
        if (p1 == null && p2 == null) {
            return true;
        }
        if (p1 == null || p2 == null) {
            return false;
        }
        if (p1.equals(p2)) {
            return true;
        }
        int pos1 = 0;
        int end1 = p1.length();
        int end2 = p2.length();
        for (pos2 = 0; pos1 < end1 && pos2 < end2; ++pos1, ++pos2) {
            char ch;
            int start1 = pos1;
            int start2 = pos2;
            while (pos1 < end1 && (ch = p1.charAt(pos1)) != '/' && ch != ';') {
                ++pos1;
            }
            while (pos2 < end2 && (ch = p2.charAt(pos2)) != '/' && ch != ';') {
                ++pos2;
            }
            if (pos1 == end1 && pos2 < end2 || pos2 == end2 && pos1 < end1 || pos1 < end1 && pos2 < end2 && p1.charAt(pos1) != p2.charAt(pos2)) {
                return false;
            }
            if (p1.regionMatches(start1, p2, start2, pos1 - start1) && pos1 - start1 == pos2 - start2 || URI.unescapeNoPE(p1.substring(start1, pos1), null).equals(URI.unescapeNoPE(p2.substring(start2, pos2), null))) continue;
            return false;
        }
        return pos1 == end1 && pos2 == end2;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = (this.scheme != null ? URI.unescapeNoPE(this.scheme, null).hashCode() : 0) + (this.type == 0 ? (this.opaque != null ? URI.unescapeNoPE(this.opaque, null).hashCode() : 0) * 7 : (this.host != null ? URI.unescapeNoPE(this.host, null).toLowerCase().hashCode() : 0) * 7 + (this.path != null ? URI.unescapeNoPE(this.path, null).hashCode() : 0) * 13 + (this.query != null ? URI.unescapeNoPE(this.query, null).hashCode() : 0) * 17);
        }
        return this.hashCode;
    }

    public static String escape(String elem, BitSet allowed_char, boolean utf8) {
        return new String(URI.escape(elem.toCharArray(), allowed_char, utf8));
    }

    public static char[] escape(char[] elem, BitSet allowed_char, boolean utf8) {
        return URI.escape(elem, allowed_char, utf8, EscapePercentMode.ACCEPT_ESCAPED);
    }

    public static String escape(String elem, BitSet allowed_char, boolean utf8, EscapePercentMode escapePercent) {
        return new String(URI.escape(elem.toCharArray(), allowed_char, utf8, escapePercent));
    }

    public static char[] escape(char[] elem, BitSet allowed_char, boolean utf8, EscapePercentMode escapePercent) {
        int cnt = 0;
        HashMap<Integer, Integer> percentsToBeEscapedMap = new HashMap<Integer, Integer>();
        for (int idx = 0; idx < elem.length; ++idx) {
            if (!allowed_char.get(elem[idx])) {
                cnt += 2;
                if (!utf8) continue;
                if (elem[idx] >= '\u0080') {
                    cnt += 3;
                }
                if (elem[idx] >= '\u0800') {
                    cnt += 3;
                }
                if ((elem[idx] & 0xFC00) != 55296 || idx + 1 >= elem.length || (elem[idx + 1] & 0xFC00) != 56320) continue;
                cnt -= 6;
                continue;
            }
            if (EscapePercentMode.NEVER == escapePercent || elem[idx] != '%' || EscapePercentMode.ALWAYS != escapePercent && URI.isEscapeSequence(idx, elem)) continue;
            cnt += 2;
            percentsToBeEscapedMap.put(new Integer(idx), new Integer(idx));
        }
        if (cnt == 0) {
            return elem;
        }
        char[] tmp = new char[elem.length + cnt];
        int pos = 0;
        for (int idx = 0; idx < elem.length; ++idx) {
            char c = elem[idx];
            if (allowed_char.get(c) && percentsToBeEscapedMap.get(new Integer(idx)) == null) {
                tmp[pos++] = c;
                continue;
            }
            if (utf8) {
                if (c <= '\u007f') {
                    pos = URI.enc(tmp, pos, c);
                    continue;
                }
                if (c <= '\u07ff') {
                    pos = URI.enc(tmp, pos, 0xC0 | c >> 6 & 0x1F);
                    pos = URI.enc(tmp, pos, 0x80 | c >> 0 & 0x3F);
                    continue;
                }
                if ((c & 0xFC00) != 55296 || idx + 1 >= elem.length || (elem[idx + 1] & 0xFC00) != 56320) {
                    pos = URI.enc(tmp, pos, 0xE0 | c >> 12 & 0xF);
                    pos = URI.enc(tmp, pos, 0x80 | c >> 6 & 0x3F);
                    pos = URI.enc(tmp, pos, 0x80 | c >> 0 & 0x3F);
                    continue;
                }
                int ch = (c & 0x3FF) << 10 | elem[++idx] & 0x3FF;
                pos = URI.enc(tmp, pos, 0xF0 | (ch += 65536) >> 18 & 7);
                pos = URI.enc(tmp, pos, 0x80 | ch >> 12 & 0x3F);
                pos = URI.enc(tmp, pos, 0x80 | ch >> 6 & 0x3F);
                pos = URI.enc(tmp, pos, 0x80 | ch >> 0 & 0x3F);
                continue;
            }
            pos = URI.enc(tmp, pos, c);
        }
        return tmp;
    }

    static boolean isEscapeSequence(int posOfPercent, char[] testSubject) {
        int SEQ_SIZE = 3;
        if (null == testSubject || testSubject.length < 3 || posOfPercent < 0 || posOfPercent > testSubject.length - 3 || testSubject[posOfPercent] != '%') {
            return false;
        }
        for (int i = posOfPercent + 1; i < posOfPercent + 3; ++i) {
            char hexChar = testSubject[i];
            if (-1 != Character.digit(hexChar, 16)) continue;
            return false;
        }
        return true;
    }

    private static final int enc(char[] out, int pos, int c) {
        out[pos++] = 37;
        out[pos++] = hex[c >> 4 & 0xF];
        out[pos++] = hex[c & 0xF];
        return pos;
    }

    public static final String unescape(String str, BitSet reserved) throws ParseException {
        if (str == null || str.indexOf(37) == -1) {
            return str;
        }
        char[] buf = str.toCharArray();
        char[] res = new char[buf.length];
        char[] utf = new char[4];
        int utf_idx = 0;
        int utf_len = -1;
        int didx = 0;
        for (int sidx = 0; sidx < buf.length; ++sidx) {
            if (buf[sidx] == '%') {
                int ch;
                try {
                    if (sidx + 3 > buf.length) {
                        throw new NumberFormatException();
                    }
                    ch = Integer.parseInt(str.substring(sidx + 1, sidx + 3), 16);
                    if (ch < 0) {
                        throw new NumberFormatException();
                    }
                    sidx += 2;
                }
                catch (NumberFormatException e) {
                    ch = buf[sidx];
                }
                if (utf_len > 0) {
                    if ((ch & 0xC0) != 128) {
                        didx = URI.copyBuf(utf, utf_idx, ch, res, didx, reserved, false);
                        utf_len = -1;
                        continue;
                    }
                    if (utf_idx == utf_len - 1) {
                        ch = (utf[0] & 0xE0) == 192 ? (utf[0] & 0x1F) << 6 | ch & 0x3F : ((utf[0] & 0xF0) == 224 ? (utf[0] & 0xF) << 12 | (utf[1] & 0x3F) << 6 | ch & 0x3F : (utf[0] & 7) << 18 | (utf[1] & 0x3F) << 12 | (utf[2] & 0x3F) << 6 | ch & 0x3F);
                        if (reserved != null && reserved.get(ch)) {
                            didx = URI.copyBuf(utf, utf_idx, ch, res, didx, null, true);
                        } else if (utf_len < 4) {
                            res[didx++] = (char)ch;
                        } else {
                            res[didx++] = (char)((ch -= 65536) >> 10 | 0xD800);
                            res[didx++] = (char)(ch & 0x3FF | 0xDC00);
                        }
                        utf_len = -1;
                        continue;
                    }
                    utf[utf_idx++] = (char)ch;
                    continue;
                }
                if ((ch & 0xE0) == 192 || (ch & 0xF0) == 224 || (ch & 0xF8) == 240) {
                    utf_len = (ch & 0xE0) == 192 ? 2 : ((ch & 0xF0) == 224 ? 3 : 4);
                    utf[0] = (char)ch;
                    utf_idx = 1;
                    continue;
                }
                if (reserved != null && reserved.get(ch)) {
                    res[didx++] = buf[sidx];
                    sidx -= 2;
                    continue;
                }
                res[didx++] = (char)ch;
                continue;
            }
            if (utf_len > 0) {
                didx = URI.copyBuf(utf, utf_idx, buf[sidx], res, didx, reserved, false);
                utf_len = -1;
                continue;
            }
            res[didx++] = buf[sidx];
        }
        if (utf_len > 0) {
            didx = URI.copyBuf(utf, utf_idx, -1, res, didx, reserved, false);
        }
        return new String(res, 0, didx);
    }

    protected static final BitSet getAlphanumChar() {
        return (BitSet)alphanumChar_pvt.clone();
    }

    protected static final BitSet getMarkChar() {
        return (BitSet)markChar_pvt.clone();
    }

    protected static final BitSet getReservedChar() {
        return (BitSet)reservedChar_pvt.clone();
    }

    protected static final BitSet getUnreservedChar() {
        return (BitSet)unreservedChar_pvt.clone();
    }

    protected static final BitSet getUricChar() {
        return (BitSet)uricChar_pvt.clone();
    }

    protected static final BitSet getPcharChar() {
        return (BitSet)pcharChar_pvt.clone();
    }

    protected static final BitSet getUserinfoChar() {
        return (BitSet)userinfoChar_pvt.clone();
    }

    protected static final BitSet getSchemeChar() {
        return (BitSet)schemeChar_pvt.clone();
    }

    protected static final BitSet getHostChar() {
        return (BitSet)hostChar_pvt.clone();
    }

    protected static final BitSet getOpaqueChar() {
        return (BitSet)opaqueChar_pvt.clone();
    }

    protected static final BitSet getReg_nameChar() {
        return (BitSet)reg_nameChar_pvt.clone();
    }

    public static final BitSet getResvdSchemeChar() {
        return (BitSet)resvdSchemeChar_pvt.clone();
    }

    public static final BitSet getResvdUIChar() {
        return (BitSet)resvdUIChar_pvt.clone();
    }

    public static final BitSet getResvdHostChar() {
        return (BitSet)resvdHostChar_pvt.clone();
    }

    public static final BitSet getResvdPathChar() {
        return (BitSet)resvdPathChar_pvt.clone();
    }

    public static final BitSet getResvdQueryChar() {
        return (BitSet)resvdQueryChar_pvt.clone();
    }

    public static final BitSet getEscpdPathChar() {
        return (BitSet)escpdPathChar_pvt.clone();
    }

    public static final BitSet getEscpdQueryChar() {
        return (BitSet)escpdQueryChar_pvt.clone();
    }

    public static final BitSet getEscpdFragChar() {
        return (BitSet)escpdFragChar_pvt.clone();
    }

    private static final int copyBuf(char[] utf, int utf_idx, int ch, char[] res, int didx, BitSet reserved, boolean escapeAll) {
        if (ch >= 0) {
            utf[utf_idx++] = (char)ch;
        }
        for (int idx = 0; idx < utf_idx; ++idx) {
            if (reserved != null && reserved.get(utf[idx]) || escapeAll) {
                didx = URI.enc(res, didx, utf[idx]);
                continue;
            }
            res[didx++] = utf[idx];
        }
        return didx;
    }

    private static final String unescapeNoPE(String str, BitSet reserved) {
        try {
            return URI.unescape(str, reserved);
        }
        catch (ParseException pe) {
            return str;
        }
    }

    public static void main(String[] args) throws Exception {
        System.err.println();
        System.err.println("*** URI Tests ...");
        URI base = new URI("http://a/b/c/d;p?q");
        URI.testParser(base, "g:h", "g:h");
        URI.testParser(base, "g", "http://a/b/c/g");
        URI.testParser(base, "./g", "http://a/b/c/g");
        URI.testParser(base, "g/", "http://a/b/c/g/");
        URI.testParser(base, "/g", "http://a/g");
        URI.testParser(base, "//g", "http://g");
        URI.testParser(base, "//[23:54]", "http://[23:54]");
        URI.testParser(base, "?y", "http://a/b/c/?y");
        URI.testParser(base, "g?y", "http://a/b/c/g?y");
        URI.testParser(base, "#s", "http://a/b/c/d;p?q#s");
        URI.testParser(base, "g#s", "http://a/b/c/g#s");
        URI.testParser(base, "g?y#s", "http://a/b/c/g?y#s");
        URI.testParser(base, ";x", "http://a/b/c/;x");
        URI.testParser(base, "g;x", "http://a/b/c/g;x");
        URI.testParser(base, "g;x?y#s", "http://a/b/c/g;x?y#s");
        URI.testParser(base, ".", "http://a/b/c/");
        URI.testParser(base, "./", "http://a/b/c/");
        URI.testParser(base, "..", "http://a/b/");
        URI.testParser(base, "../", "http://a/b/");
        URI.testParser(base, "../g", "http://a/b/g");
        URI.testParser(base, "../..", "http://a/");
        URI.testParser(base, "../../", "http://a/");
        URI.testParser(base, "../../g", "http://a/g");
        URI.testParser(base, "", "http://a/b/c/d;p?q");
        URI.testParser(base, "/./g", "http://a/./g");
        URI.testParser(base, "/../g", "http://a/../g");
        URI.testParser(base, "../../../g", "http://a/../g");
        URI.testParser(base, "../../../../g", "http://a/../../g");
        URI.testParser(base, "g.", "http://a/b/c/g.");
        URI.testParser(base, ".g", "http://a/b/c/.g");
        URI.testParser(base, "g..", "http://a/b/c/g..");
        URI.testParser(base, "..g", "http://a/b/c/..g");
        URI.testParser(base, "./../g", "http://a/b/g");
        URI.testParser(base, "./g/.", "http://a/b/c/g/");
        URI.testParser(base, "g/./h", "http://a/b/c/g/h");
        URI.testParser(base, "g/../h", "http://a/b/c/h");
        URI.testParser(base, "g;x=1/./y", "http://a/b/c/g;x=1/y");
        URI.testParser(base, "g;x=1/../y", "http://a/b/c/y");
        URI.testParser(base, "g?y/./x", "http://a/b/c/g?y/./x");
        URI.testParser(base, "g?y/../x", "http://a/b/c/g?y/../x");
        URI.testParser(base, "g#s/./x", "http://a/b/c/g#s/./x");
        URI.testParser(base, "g#s/../x", "http://a/b/c/g#s/../x");
        URI.testParser(base, "http:g", "http://a/b/c/g");
        URI.testParser(base, "http:", "http://a/b/c/d;p?q");
        URI.testParser(base, "./g:h", "http://a/b/c/g:h");
        base = new URI("http://a/b/c/d;p?q=1/2");
        URI.testParser(base, "g", "http://a/b/c/g");
        URI.testParser(base, "./g", "http://a/b/c/g");
        URI.testParser(base, "g/", "http://a/b/c/g/");
        URI.testParser(base, "/g", "http://a/g");
        URI.testParser(base, "//g", "http://g");
        URI.testParser(base, "//[23:54]", "http://[23:54]");
        URI.testParser(base, "?y", "http://a/b/c/?y");
        URI.testParser(base, "g?y", "http://a/b/c/g?y");
        URI.testParser(base, "g?y/./x", "http://a/b/c/g?y/./x");
        URI.testParser(base, "g?y/../x", "http://a/b/c/g?y/../x");
        URI.testParser(base, "g#s", "http://a/b/c/g#s");
        URI.testParser(base, "g#s/./x", "http://a/b/c/g#s/./x");
        URI.testParser(base, "g#s/../x", "http://a/b/c/g#s/../x");
        URI.testParser(base, "./", "http://a/b/c/");
        URI.testParser(base, "../", "http://a/b/");
        URI.testParser(base, "../g", "http://a/b/g");
        URI.testParser(base, "../../", "http://a/");
        URI.testParser(base, "../../g", "http://a/g");
        base = new URI("http://a/b/c/d;p=1/2?q");
        URI.testParser(base, "g", "http://a/b/c/d;p=1/g");
        URI.testParser(base, "./g", "http://a/b/c/d;p=1/g");
        URI.testParser(base, "g/", "http://a/b/c/d;p=1/g/");
        URI.testParser(base, "g?y", "http://a/b/c/d;p=1/g?y");
        URI.testParser(base, ";x", "http://a/b/c/d;p=1/;x");
        URI.testParser(base, "g;x", "http://a/b/c/d;p=1/g;x");
        URI.testParser(base, "g;x=1/./y", "http://a/b/c/d;p=1/g;x=1/y");
        URI.testParser(base, "g;x=1/../y", "http://a/b/c/d;p=1/y");
        URI.testParser(base, "./", "http://a/b/c/d;p=1/");
        URI.testParser(base, "../", "http://a/b/c/");
        URI.testParser(base, "../g", "http://a/b/c/g");
        URI.testParser(base, "../../", "http://a/b/");
        URI.testParser(base, "../../g", "http://a/b/g");
        base = new URI("fred:///s//a/b/c");
        URI.testParser(base, "g:h", "g:h");
        URI.testPE(base, "g");
        base = new URI("http:///s//a/b/c");
        URI.testParser(base, "g:h", "g:h");
        URI.testParser(base, "g", "http:///s//a/b/g");
        URI.testParser(base, "./g", "http:///s//a/b/g");
        URI.testParser(base, "g/", "http:///s//a/b/g/");
        URI.testParser(base, "/g", "http:///g");
        URI.testParser(base, "//g", "http://g");
        URI.testParser(base, "//[23:54]", "http://[23:54]");
        URI.testParser(base, "//g/x", "http://g/x");
        URI.testParser(base, "///g", "http:///g");
        URI.testParser(base, "./", "http:///s//a/b/");
        URI.testParser(base, "../", "http:///s//a/");
        URI.testParser(base, "../g", "http:///s//a/g");
        URI.testParser(base, "../../", "http:///s//");
        URI.testParser(base, "../../g", "http:///s//g");
        URI.testParser(base, "../../../g", "http:///s/g");
        URI.testParser(base, "../../../../g", "http:///g");
        base = new URI("http://s");
        URI.testParser(base, "ftp:h", "ftp:h");
        URI.testParser(base, "ftp://h", "ftp://h");
        URI.testParser(base, "//g", "http://g");
        URI.testParser(base, "//g?h", "http://g?h");
        URI.testParser(base, "g", "http://s/g");
        URI.testParser(base, "./g", "http://s/g");
        URI.testParser(base, "?g", "http://s/?g");
        URI.testParser(base, "#g", "http://s#g");
        base = new URI("http:");
        URI.testParser(base, "ftp:h", "ftp:h");
        URI.testParser(base, "ftp://h", "ftp://h");
        URI.testParser(base, "//g", "http://g");
        URI.testParser(base, "g", "http:/g");
        URI.testParser(base, "?g", "http:/?g");
        URI.testParser(base, "#g", "http:#g");
        base = new URI("http://s/t");
        URI.testParser(base, "ftp:/h", "ftp:/h");
        URI.testParser(base, "http:/h", "http://s/h");
        base = new URI("http://s/g?h/j");
        URI.testParser(base, "k", "http://s/k");
        URI.testParser(base, "k?l", "http://s/k?l");
        base = new URI("ldap:");
        URI.testParser(base, "ldap:", "ldap:");
        URI.testParser(base, "ldap://a", "ldap://a");
        URI.testParser(base, "ldap://a/b", "ldap://a/b");
        URI.testParser(base, "ldap:/b", "ldap:/b");
        URI.testParser(base, "ftp:h", "ftp:h");
        URI.testParser(base, "ftp://h", "ftp://h");
        URI.testParser(base, "//g", "ldap://g");
        URI.testParser(base, "//g?h", "ldap://g/?h");
        URI.testParser(base, "g", "ldap:/g");
        URI.testParser(base, "./g", "ldap:/./g");
        URI.testParser(base, "?g", "ldap:/?g");
        URI.testParser(base, "#g", "ldap:/%23g");
        base = new URI("ldap://s");
        URI.testParser(base, "ldap:", "ldap://s");
        URI.testParser(base, "ldap://a", "ldap://a");
        URI.testParser(base, "ldap://a/b", "ldap://a/b");
        URI.testParser(base, "ldap:/b", "ldap://s/b");
        URI.testParser(base, "ftp:h", "ftp:h");
        URI.testParser(base, "ftp://h", "ftp://h");
        URI.testParser(base, "//g", "ldap://g");
        URI.testParser(base, "//g?h", "ldap://g/?h");
        URI.testParser(base, "g", "ldap://s/g");
        URI.testParser(base, "./g", "ldap://s/./g");
        URI.testParser(base, "?g", "ldap://s/?g");
        URI.testParser(base, "#g", "ldap://s/%23g");
        base = new URI("ldap://s/t");
        URI.testParser(base, "ftp:/h", "ftp:/h");
        URI.testParser(base, "ldap:/h", "ldap://s/h");
        URI.testParser(base, "ldap:", "ldap://s");
        URI.testParser(base, "ldap://a", "ldap://a");
        URI.testParser(base, "ldap://a/b", "ldap://a/b");
        URI.testParser(base, "ftp:h", "ftp:h");
        URI.testParser(base, "ftp://h", "ftp://h");
        URI.testParser(base, "//g", "ldap://g");
        URI.testParser(base, "//g?h", "ldap://g/?h");
        URI.testParser(base, "g", "ldap://s/g");
        URI.testParser(base, "./g", "ldap://s/./g");
        URI.testParser(base, "?g", "ldap://s/?g");
        URI.testParser(base, "#g", "ldap://s/%23g");
        URI.testNotEqual("http://a/", "nntp://a/");
        URI.testNotEqual("http://a/", "https://a/");
        URI.testNotEqual("http://a/", "shttp://a/");
        URI.testEqual("http://a/", "Http://a/");
        URI.testEqual("http://a/", "hTTP://a/");
        URI.testEqual("url:http://a/", "hTTP://a/");
        URI.testEqual("urI:http://a/", "hTTP://a/");
        URI.testEqual("http://a/", "Http://A/");
        URI.testEqual("http://a.b.c/", "Http://A.b.C/");
        URI.testEqual("http:///", "Http:///");
        URI.testEqual("http://[]/", "Http:///");
        URI.testNotEqual("http:///", "Http://a/");
        URI.testNotEqual("http://[]/", "Http://a/");
        URI.testPE(null, "ftp://[23::43:1/");
        URI.testPE(null, "ftp://[/");
        URI.testEqual("http://a.b.c/", "Http://A.b.C:80/");
        URI.testEqual("http://a.b.c:/", "Http://A.b.C:80/");
        URI.testEqual("http://[23::45:::5:]/", "Http://[23::45:::5:]:80/");
        URI.testEqual("http://[23::45:::5:]:/", "Http://[23::45:::5:]:80/");
        URI.testEqual("nntp://a", "nntp://a:119");
        URI.testEqual("nntp://a:", "nntp://a:119");
        URI.testEqual("nntp://a/", "nntp://a:119/");
        URI.testNotEqual("nntp://a", "nntp://a:118");
        URI.testNotEqual("nntp://a", "nntp://a:0");
        URI.testNotEqual("nntp://a:", "nntp://a:0");
        URI.testEqual("telnet://:23/", "telnet:///");
        URI.testPE(null, "ftp://:a/");
        URI.testPE(null, "ftp://:-1/");
        URI.testPE(null, "ftp://::1/");
        URI.testNotEqual("ftp://me@a", "ftp://a");
        URI.testNotEqual("ftp://me@a", "ftp://Me@a");
        URI.testEqual("ftp://Me@a", "ftp://Me@a");
        URI.testEqual("ftp://Me:My@a:21", "ftp://Me:My@a");
        URI.testEqual("ftp://Me:My@a:", "ftp://Me:My@a");
        URI.testNotEqual("ftp://Me:My@a:21", "ftp://Me:my@a");
        URI.testNotEqual("ftp://Me:My@a:", "ftp://Me:my@a");
        URI.testEqual("ftp://a/b%2b/", "ftp://a/b+/");
        URI.testEqual("ftp://a/b%2b/", "ftp://a/b+/");
        URI.testEqual("ftp://a/b%5E/", "ftp://a/b^/");
        URI.testEqual("ftp://a/b%4C/", "ftp://a/bL/");
        URI.testNotEqual("ftp://a/b/", "ftp://a//b/");
        URI.testNotEqual("ftp://a/b/", "ftp://a/b//");
        URI.testNotEqual("ftp://a/b%4C/", "ftp://a/bl/");
        URI.testNotEqual("ftp://a/b%3f/", "ftp://a/b?/");
        URI.testNotEqual("ftp://a/b%2f/", "ftp://a/b//");
        URI.testNotEqual("ftp://a/b%2fc/", "ftp://a/b/c/");
        URI.testNotEqual("ftp://a/bc/", "ftp://a/b//");
        URI.testNotEqual("ftp://a/bc/", "ftp://a/b/");
        URI.testNotEqual("ftp://a/bc//", "ftp://a/b/");
        URI.testNotEqual("ftp://a/b/", "ftp://a/bc//");
        URI.testNotEqual("ftp://a/b/", "ftp://a/bc/");
        URI.testNotEqual("ftp://a/b//", "ftp://a/bc/");
        URI.testNotEqual("ftp://a/b;fc/", "ftp://a/bf;c/");
        URI.testNotEqual("ftp://a/b%3bfc/", "ftp://a/b;fc/");
        URI.testEqual("ftp://a/b;/;/", "ftp://a/b;/;/");
        URI.testNotEqual("ftp://a/b;/", "ftp://a/b//");
        URI.testNotEqual("ftp://a/b//", "ftp://a/b;/");
        URI.testNotEqual("ftp://a/b/;", "ftp://a/b//");
        URI.testNotEqual("ftp://a/b//", "ftp://a/b/;");
        URI.testNotEqual("ftp://a/b;/", "ftp://a/b;//");
        URI.testNotEqual("ftp://a/b;//", "ftp://a/b;/");
        URI.testEscape("hello\u1212there", "hello%E1%88%92there");
        URI.testEscape("hello\u0232there", "hello%C8%B2there");
        URI.testEscape("hello\uda42\udd42there", "hello%F2%A0%A5%82there");
        URI.testEscape("hello\uda42", "hello%ED%A9%82");
        URI.testEscape("hello\uda42there", "hello%ED%A9%82there");
        URI.testUnescape("hello%F2%A0%A5%82there", "hello\uda42\udd42there");
        URI.testUnescape("hello%F2%A0%A5there", "hello\u00f2\u00a0\u00a5there");
        URI.testUnescape("hello%F2%A0there", "hello\u00f2\u00a0there");
        URI.testUnescape("hello%F2there", "hello\u00f2there");
        URI.testUnescape("hello%F2%A0%A5%82", "hello\uda42\udd42");
        URI.testUnescape("hello%F2%A0%A5", "hello\u00f2\u00a0\u00a5");
        URI.testUnescape("hello%F2%A0", "hello\u00f2\u00a0");
        URI.testUnescape("hello%F2", "hello\u00f2");
        URI.testUnescape("hello%E1%88%92there", "hello\u1212there");
        URI.testUnescape("hello%E1%88there", "hello\u00e1\u0088there");
        URI.testUnescape("hello%E1there", "hello\u00e1there");
        URI.testUnescape("hello%E1%71there", "hello\u00e1qthere");
        URI.testUnescape("hello%E1%88", "hello\u00e1\u0088");
        URI.testUnescape("hello%E1%71", "hello\u00e1q");
        URI.testUnescape("hello%E1", "hello\u00e1");
        URI.testUnescape("hello%C8%B2there", "hello\u0232there");
        URI.testUnescape("hello%C8there", "hello\u00c8there");
        URI.testUnescape("hello%C8%71there", "hello\u00c8qthere");
        URI.testUnescape("hello%C8%71", "hello\u00c8q");
        URI.testUnescape("hello%C8", "hello\u00c8");
        URI.testUnescape("%71there", "qthere");
        URI.testUnescape("%B1there", "\u00b1there");
        System.err.println("*** Tests finished successfuly");
    }

    private static void testParser(URI base, String relURI, String result) throws Exception {
        if (!new URI(base, relURI).toExternalForm().equals(result)) {
            throw new Exception("Test failed: " + nl + "  base-URI = <" + base + ">" + nl + "  rel-URI  = <" + relURI + ">" + nl + "  expected   <" + result + ">" + nl + "  but got    <" + new URI(base, relURI) + ">");
        }
    }

    private static void testEqual(String one, String two) throws Exception {
        URI u1 = new URI(one);
        URI u2 = new URI(two);
        if (!u1.equals(u2)) {
            throw new Exception("Test failed: " + nl + "  <" + one + "> != <" + two + ">");
        }
        if (u1.hashCode() != u2.hashCode()) {
            throw new Exception("Test failed: " + nl + "  hashCode <" + one + "> != hashCode <" + two + ">");
        }
    }

    private static void testNotEqual(String one, String two) throws Exception {
        URI u1 = new URI(one);
        URI u2 = new URI(two);
        if (u1.equals(u2)) {
            throw new Exception("Test failed: " + nl + "  <" + one + "> == <" + two + ">");
        }
    }

    private static void testPE(URI base, String uri) throws Exception {
        boolean got_pe = false;
        try {
            new URI(base, uri);
        }
        catch (ParseException pe) {
            got_pe = true;
        }
        if (!got_pe) {
            throw new Exception("Test failed: " + nl + "  <" + uri + "> should be invalid");
        }
    }

    private static void testEscape(String raw, String escaped) throws Exception {
        String test = new String(URI.escape(raw.toCharArray(), uricChar_pvt, true));
        if (!test.equals(escaped)) {
            throw new Exception("Test failed: " + nl + "  raw-string: " + raw + nl + "  escaped:    " + test + nl + "  expected:   " + escaped);
        }
    }

    private static void testUnescape(String escaped, String raw) throws Exception {
        if (!URI.unescape(escaped, null).equals(raw)) {
            throw new Exception("Test failed: " + nl + "  escaped-string: " + escaped + nl + "  unescaped:      " + URI.unescape(escaped, null) + nl + "  expected:       " + raw);
        }
    }

    static {
        int ch;
        HashMap<String, Integer> tempDefaultPorts = new HashMap<String, Integer>();
        tempDefaultPorts.put("http", new Integer(80));
        tempDefaultPorts.put("shttp", new Integer(80));
        tempDefaultPorts.put("http-ng", new Integer(80));
        tempDefaultPorts.put("coffee", new Integer(80));
        tempDefaultPorts.put("https", new Integer(443));
        tempDefaultPorts.put("ftp", new Integer(21));
        tempDefaultPorts.put("telnet", new Integer(23));
        tempDefaultPorts.put("nntp", new Integer(119));
        tempDefaultPorts.put("news", new Integer(119));
        tempDefaultPorts.put("snews", new Integer(563));
        tempDefaultPorts.put("hnews", new Integer(80));
        tempDefaultPorts.put("smtp", new Integer(25));
        tempDefaultPorts.put("gopher", new Integer(70));
        tempDefaultPorts.put("wais", new Integer(210));
        tempDefaultPorts.put("whois", new Integer(43));
        tempDefaultPorts.put("whois++", new Integer(63));
        tempDefaultPorts.put("rwhois", new Integer(4321));
        tempDefaultPorts.put("imap", new Integer(143));
        tempDefaultPorts.put("pop", new Integer(110));
        tempDefaultPorts.put("prospero", new Integer(1525));
        tempDefaultPorts.put("irc", new Integer(194));
        tempDefaultPorts.put("ldap", new Integer(389));
        tempDefaultPorts.put("nfs", new Integer(2049));
        tempDefaultPorts.put("z39.50r", new Integer(210));
        tempDefaultPorts.put("z39.50s", new Integer(210));
        tempDefaultPorts.put("vemmi", new Integer(575));
        tempDefaultPorts.put("videotex", new Integer(516));
        tempDefaultPorts.put("cmp", new Integer(829));
        defaultPorts = Collections.unmodifiableMap(tempDefaultPorts);
        HashMap<String, Boolean> tempUsesGenericSyntax = new HashMap<String, Boolean>();
        tempUsesGenericSyntax.put("http", Boolean.TRUE);
        tempUsesGenericSyntax.put("https", Boolean.TRUE);
        tempUsesGenericSyntax.put("shttp", Boolean.TRUE);
        tempUsesGenericSyntax.put("coffee", Boolean.TRUE);
        tempUsesGenericSyntax.put("ftp", Boolean.TRUE);
        tempUsesGenericSyntax.put("file", Boolean.TRUE);
        tempUsesGenericSyntax.put("nntp", Boolean.TRUE);
        tempUsesGenericSyntax.put("news", Boolean.TRUE);
        tempUsesGenericSyntax.put("snews", Boolean.TRUE);
        tempUsesGenericSyntax.put("hnews", Boolean.TRUE);
        tempUsesGenericSyntax.put("imap", Boolean.TRUE);
        tempUsesGenericSyntax.put("wais", Boolean.TRUE);
        tempUsesGenericSyntax.put("nfs", Boolean.TRUE);
        tempUsesGenericSyntax.put("sip", Boolean.TRUE);
        tempUsesGenericSyntax.put("sips", Boolean.TRUE);
        tempUsesGenericSyntax.put("sipt", Boolean.TRUE);
        tempUsesGenericSyntax.put("sipu", Boolean.TRUE);
        usesGenericSyntax = Collections.unmodifiableMap(tempUsesGenericSyntax);
        HashMap<String, Boolean> tempUsesSemiGenericSyntax = new HashMap<String, Boolean>();
        tempUsesSemiGenericSyntax.put("ldap", Boolean.TRUE);
        tempUsesSemiGenericSyntax.put("irc", Boolean.TRUE);
        tempUsesSemiGenericSyntax.put("gopher", Boolean.TRUE);
        tempUsesSemiGenericSyntax.put("videotex", Boolean.TRUE);
        tempUsesSemiGenericSyntax.put("rwhois", Boolean.TRUE);
        tempUsesSemiGenericSyntax.put("whois++", Boolean.TRUE);
        tempUsesSemiGenericSyntax.put("smtp", Boolean.TRUE);
        tempUsesSemiGenericSyntax.put("telnet", Boolean.TRUE);
        tempUsesSemiGenericSyntax.put("prospero", Boolean.TRUE);
        tempUsesSemiGenericSyntax.put("pop", Boolean.TRUE);
        tempUsesSemiGenericSyntax.put("vemmi", Boolean.TRUE);
        tempUsesSemiGenericSyntax.put("z39.50r", Boolean.TRUE);
        tempUsesSemiGenericSyntax.put("z39.50s", Boolean.TRUE);
        tempUsesSemiGenericSyntax.put("stream", Boolean.TRUE);
        tempUsesSemiGenericSyntax.put("cmp", Boolean.TRUE);
        usesSemiGenericSyntax = Collections.unmodifiableMap(tempUsesSemiGenericSyntax);
        alphanumChar_pvt = new BitSet(128);
        for (ch = 48; ch <= 57; ++ch) {
            alphanumChar_pvt.set(ch);
        }
        for (ch = 65; ch <= 90; ++ch) {
            alphanumChar_pvt.set(ch);
        }
        for (ch = 97; ch <= 122; ++ch) {
            alphanumChar_pvt.set(ch);
        }
        markChar_pvt = new BitSet(128);
        markChar_pvt.set(45);
        markChar_pvt.set(95);
        markChar_pvt.set(46);
        markChar_pvt.set(33);
        markChar_pvt.set(126);
        markChar_pvt.set(42);
        markChar_pvt.set(39);
        markChar_pvt.set(40);
        markChar_pvt.set(41);
        reservedChar_pvt = new BitSet(128);
        reservedChar_pvt.set(59);
        reservedChar_pvt.set(47);
        reservedChar_pvt.set(63);
        reservedChar_pvt.set(58);
        reservedChar_pvt.set(64);
        reservedChar_pvt.set(38);
        reservedChar_pvt.set(61);
        reservedChar_pvt.set(43);
        reservedChar_pvt.set(36);
        reservedChar_pvt.set(44);
        unreservedChar_pvt = new BitSet(128);
        unreservedChar_pvt.or(alphanumChar_pvt);
        unreservedChar_pvt.or(markChar_pvt);
        uricChar_pvt = new BitSet(128);
        uricChar_pvt.or(unreservedChar_pvt);
        uricChar_pvt.or(reservedChar_pvt);
        uricChar_pvt.set(37);
        pcharChar_pvt = new BitSet(128);
        pcharChar_pvt.or(unreservedChar_pvt);
        pcharChar_pvt.set(37);
        pcharChar_pvt.set(58);
        pcharChar_pvt.set(64);
        pcharChar_pvt.set(38);
        pcharChar_pvt.set(61);
        pcharChar_pvt.set(43);
        pcharChar_pvt.set(36);
        pcharChar_pvt.set(44);
        userinfoChar_pvt = new BitSet(128);
        userinfoChar_pvt.or(unreservedChar_pvt);
        userinfoChar_pvt.set(37);
        userinfoChar_pvt.set(59);
        userinfoChar_pvt.set(58);
        userinfoChar_pvt.set(38);
        userinfoChar_pvt.set(61);
        userinfoChar_pvt.set(43);
        userinfoChar_pvt.set(36);
        userinfoChar_pvt.set(44);
        schemeChar_pvt = new BitSet(128);
        schemeChar_pvt.or(alphanumChar_pvt);
        schemeChar_pvt.set(43);
        schemeChar_pvt.set(45);
        schemeChar_pvt.set(46);
        opaqueChar_pvt = new BitSet(128);
        opaqueChar_pvt.or(uricChar_pvt);
        hostChar_pvt = new BitSet(128);
        hostChar_pvt.or(alphanumChar_pvt);
        hostChar_pvt.set(45);
        hostChar_pvt.set(46);
        reg_nameChar_pvt = new BitSet(128);
        reg_nameChar_pvt.or(unreservedChar_pvt);
        reg_nameChar_pvt.set(36);
        reg_nameChar_pvt.set(44);
        reg_nameChar_pvt.set(59);
        reg_nameChar_pvt.set(58);
        reg_nameChar_pvt.set(64);
        reg_nameChar_pvt.set(38);
        reg_nameChar_pvt.set(61);
        reg_nameChar_pvt.set(43);
        resvdSchemeChar_pvt = new BitSet(128);
        resvdSchemeChar_pvt.set(58);
        resvdUIChar_pvt = new BitSet(128);
        resvdUIChar_pvt.set(64);
        resvdHostChar_pvt = new BitSet(128);
        resvdHostChar_pvt.set(58);
        resvdHostChar_pvt.set(47);
        resvdHostChar_pvt.set(63);
        resvdHostChar_pvt.set(35);
        resvdPathChar_pvt = new BitSet(128);
        resvdPathChar_pvt.set(47);
        resvdPathChar_pvt.set(59);
        resvdPathChar_pvt.set(63);
        resvdPathChar_pvt.set(35);
        resvdQueryChar_pvt = new BitSet(128);
        resvdQueryChar_pvt.set(35);
        escpdPathChar_pvt = new BitSet(128);
        escpdPathChar_pvt.or(pcharChar_pvt);
        escpdPathChar_pvt.set(37);
        escpdPathChar_pvt.set(47);
        escpdPathChar_pvt.set(59);
        escpdQueryChar_pvt = new BitSet(128);
        escpdQueryChar_pvt.or(uricChar_pvt);
        escpdQueryChar_pvt.clear(35);
        escpdFragChar_pvt = new BitSet(128);
        escpdFragChar_pvt.or(uricChar_pvt);
        hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        alphanumChar = URI.getAlphanumChar();
        markChar = URI.getMarkChar();
        reservedChar = URI.getReservedChar();
        unreservedChar = URI.getUnreservedChar();
        uricChar = URI.getUricChar();
        pcharChar = URI.getPcharChar();
        userinfoChar = URI.getUserinfoChar();
        schemeChar = URI.getSchemeChar();
        hostChar = URI.getHostChar();
        opaqueChar = URI.getOpaqueChar();
        reg_nameChar = URI.getReg_nameChar();
        resvdSchemeChar = URI.getResvdSchemeChar();
        resvdUIChar = URI.getResvdUIChar();
        resvdHostChar = URI.getResvdHostChar();
        resvdPathChar = URI.getResvdPathChar();
        resvdQueryChar = URI.getResvdQueryChar();
        escpdPathChar = URI.getEscpdPathChar();
        escpdQueryChar = URI.getEscpdQueryChar();
        escpdFragChar = URI.getEscpdFragChar();
        nl = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("line.separator");
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EscapePercentMode {
        NEVER,
        ALWAYS,
        ACCEPT_ESCAPED;

    }
}

