/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.ParseException;
import HTTPClient.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

final class UUEncoder {
    private static final char[] UUEncMap;
    private static final byte[] UUDecMap;

    private UUEncoder() {
    }

    static final char[] encode(byte[] data) {
        int idx;
        if (data == null) {
            return null;
        }
        if (data.length == 0) {
            return new char[0];
        }
        int line_len = 45;
        char[] nl = UUEncoder.getPrivilegedPropertywithDefault("line.separator", "\n").toCharArray();
        char[] dest = new char[(data.length + 2) / 3 * 4 + (data.length + line_len - 1) / line_len * (nl.length + 1)];
        int sidx = 0;
        int didx = 0;
        while (sidx + line_len < data.length) {
            dest[didx++] = UUEncMap[line_len];
            int end = sidx + line_len;
            while (sidx < end) {
                dest[didx++] = UUEncMap[data[sidx] >>> 2 & 0x3F];
                dest[didx++] = UUEncMap[data[sidx + 1] >>> 4 & 0xF | data[sidx] << 4 & 0x3F];
                dest[didx++] = UUEncMap[data[sidx + 2] >>> 6 & 3 | data[sidx + 1] << 2 & 0x3F];
                dest[didx++] = UUEncMap[data[sidx + 2] & 0x3F];
                sidx += 3;
            }
            for (idx = 0; idx < nl.length; ++idx) {
                dest[didx++] = nl[idx];
            }
        }
        dest[didx++] = UUEncMap[data.length - sidx];
        while (sidx + 2 < data.length) {
            dest[didx++] = UUEncMap[data[sidx] >>> 2 & 0x3F];
            dest[didx++] = UUEncMap[data[sidx + 1] >>> 4 & 0xF | data[sidx] << 4 & 0x3F];
            dest[didx++] = UUEncMap[data[sidx + 2] >>> 6 & 3 | data[sidx + 1] << 2 & 0x3F];
            dest[didx++] = UUEncMap[data[sidx + 2] & 0x3F];
            sidx += 3;
        }
        if (sidx < data.length - 1) {
            dest[didx++] = UUEncMap[data[sidx] >>> 2 & 0x3F];
            dest[didx++] = UUEncMap[data[sidx + 1] >>> 4 & 0xF | data[sidx] << 4 & 0x3F];
            dest[didx++] = UUEncMap[data[sidx + 1] << 2 & 0x3F];
            dest[didx++] = UUEncMap[0];
        } else if (sidx < data.length) {
            dest[didx++] = UUEncMap[data[sidx] >>> 2 & 0x3F];
            dest[didx++] = UUEncMap[data[sidx] << 4 & 0x3F];
            dest[didx++] = UUEncMap[0];
            dest[didx++] = UUEncMap[0];
        }
        for (idx = 0; idx < nl.length; ++idx) {
            dest[didx++] = nl[idx];
        }
        if (didx != dest.length) {
            throw new Error("Calculated " + dest.length + " chars but wrote " + didx + " chars!");
        }
        return dest;
    }

    static final byte[] decode(BufferedReader rdr) throws ParseException, IOException {
        String line;
        while ((line = rdr.readLine()) != null && !line.startsWith("begin ")) {
        }
        if (line == null) {
            throw new ParseException("'begin' line not found");
        }
        StringTokenizer tok = new StringTokenizer(line);
        tok.nextToken();
        try {
            int file_mode = Integer.parseInt(tok.nextToken(), 8);
        }
        catch (Exception e) {
            throw new ParseException("Invalid mode on line: " + line);
        }
        try {
            String file_name = tok.nextToken();
        }
        catch (NoSuchElementException e) {
            throw new ParseException("No file name found on line: " + line);
        }
        byte[] body = new byte[1000];
        int off = 0;
        while ((line = rdr.readLine()) != null && !line.equals("end")) {
            byte[] tmp = UUEncoder.decode(line.toCharArray());
            if (off + tmp.length > body.length) {
                body = Util.resizeArray(body, off + 1000);
            }
            System.arraycopy(tmp, 0, body, off, tmp.length);
            off += tmp.length;
        }
        if (line == null) {
            throw new ParseException("'end' line not found");
        }
        return Util.resizeArray(body, off);
    }

    static final byte[] decode(char[] data) {
        if (data == null) {
            return null;
        }
        byte[] dest = new byte[data.length / 4 * 3];
        int sidx = 0;
        int didx = 0;
        while (sidx < data.length) {
            byte B;
            byte A;
            byte len = UUDecMap[data[sidx++]];
            int end = didx + len;
            while (didx < end - 2) {
                A = UUDecMap[data[sidx]];
                B = UUDecMap[data[sidx + 1]];
                byte C = UUDecMap[data[sidx + 2]];
                byte D = UUDecMap[data[sidx + 3]];
                dest[didx++] = (byte)(A << 2 & 0xFF | B >>> 4 & 3);
                dest[didx++] = (byte)(B << 4 & 0xFF | C >>> 2 & 0xF);
                dest[didx++] = (byte)(C << 6 & 0xFF | D & 0x3F);
                sidx += 4;
            }
            if (didx < end) {
                A = UUDecMap[data[sidx]];
                B = UUDecMap[data[sidx + 1]];
                dest[didx++] = (byte)(A << 2 & 0xFF | B >>> 4 & 3);
            }
            if (didx < end) {
                byte B2 = UUDecMap[data[sidx + 1]];
                byte C = UUDecMap[data[sidx + 2]];
                dest[didx++] = (byte)(B2 << 4 & 0xFF | C >>> 2 & 0xF);
            }
            while (sidx < data.length && data[sidx] != '\n' && data[sidx] != '\r') {
                ++sidx;
            }
            while (sidx < data.length && (data[sidx] == '\n' || data[sidx] == '\r')) {
                ++sidx;
            }
        }
        return Util.resizeArray(dest, didx);
    }

    private static String getPrivilegedPropertywithDefault(final String name, final String defaultValue) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(name, defaultValue);
            }
        });
    }

    static {
        int idx;
        UUEncMap = new char[64];
        for (idx = 0; idx < UUEncMap.length; ++idx) {
            UUEncoder.UUEncMap[idx] = (char)(idx + 32);
        }
        UUDecMap = new byte[128];
        for (idx = 0; idx < UUEncMap.length; ++idx) {
            UUEncoder.UUDecMap[UUEncoder.UUEncMap[idx]] = (byte)idx;
        }
    }
}

