/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthorizationInfo;
import HTTPClient.Cookie;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.HttpHeaderElement;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.URI;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Util {
    private static final BitSet Separators;
    private static final BitSet TokenChar;
    private static final BitSet UnsafeChar;
    private static final BitSet SafeChar;
    private static DateFormat http_format;
    private static DateFormat parse_1123;
    private static DateFormat parse_850;
    private static DateFormat parse_asctime;
    private static final Object http_format_lock;
    private static final Object http_parse_lock;
    private static final Logger logger;

    private Util() {
    }

    static final Object[] resizeArray(Object[] src, int new_size) {
        Class<?> compClass = src.getClass().getComponentType();
        Object[] tmp = (Object[])Array.newInstance(compClass, new_size);
        System.arraycopy(src, 0, tmp, 0, src.length < new_size ? src.length : new_size);
        return tmp;
    }

    static final NVPair[] resizeArray(NVPair[] src, int new_size) {
        NVPair[] tmp = new NVPair[new_size];
        System.arraycopy(src, 0, tmp, 0, src.length < new_size ? src.length : new_size);
        return tmp;
    }

    static final AuthorizationInfo[] resizeArray(AuthorizationInfo[] src, int new_size) {
        AuthorizationInfo[] tmp = new AuthorizationInfo[new_size];
        System.arraycopy(src, 0, tmp, 0, src.length < new_size ? src.length : new_size);
        return tmp;
    }

    static final Cookie[] resizeArray(Cookie[] src, int new_size) {
        Cookie[] tmp = new Cookie[new_size];
        System.arraycopy(src, 0, tmp, 0, src.length < new_size ? src.length : new_size);
        return tmp;
    }

    static final String[] resizeArray(String[] src, int new_size) {
        String[] tmp = new String[new_size];
        System.arraycopy(src, 0, tmp, 0, src.length < new_size ? src.length : new_size);
        return tmp;
    }

    static final boolean[] resizeArray(boolean[] src, int new_size) {
        boolean[] tmp = new boolean[new_size];
        System.arraycopy(src, 0, tmp, 0, src.length < new_size ? src.length : new_size);
        return tmp;
    }

    public static final byte[] resizeArray(byte[] src, int new_size) {
        byte[] tmp = new byte[new_size];
        System.arraycopy(src, 0, tmp, 0, src.length < new_size ? src.length : new_size);
        return tmp;
    }

    static final char[] resizeArray(char[] src, int new_size) {
        char[] tmp = new char[new_size];
        System.arraycopy(src, 0, tmp, 0, src.length < new_size ? src.length : new_size);
        return tmp;
    }

    static final int[] resizeArray(int[] src, int new_size) {
        int[] tmp = new int[new_size];
        System.arraycopy(src, 0, tmp, 0, src.length < new_size ? src.length : new_size);
        return tmp;
    }

    static String[] splitProperty(String prop) {
        if (prop == null) {
            return new String[0];
        }
        StringTokenizer tok = new StringTokenizer(prop, "|");
        String[] list = new String[tok.countTokens()];
        for (int idx = 0; idx < list.length; ++idx) {
            list[idx] = tok.nextToken().trim();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final Hashtable getList(WeakHashMap cntxt_list, Object cntxt) {
        WeakHashMap weakHashMap = cntxt_list;
        synchronized (weakHashMap) {
            Hashtable list = (Hashtable)cntxt_list.get(cntxt);
            if (list == null) {
                list = new Hashtable();
                cntxt_list.put(cntxt, list);
            }
            return list;
        }
    }

    static final int[] compile_search(byte[] search) {
        int[] cmp = new int[]{0, 1, 0, 1, 0, 1};
        for (int idx = 0; idx < search.length; ++idx) {
            int end;
            for (end = idx + 1; end < search.length && search[idx] != search[end]; ++end) {
            }
            if (end >= search.length) continue;
            if (end - idx > cmp[1]) {
                cmp[4] = cmp[2];
                cmp[5] = cmp[3];
                cmp[2] = cmp[0];
                cmp[3] = cmp[1];
                cmp[0] = idx;
                cmp[1] = end - idx;
                continue;
            }
            if (end - idx > cmp[3]) {
                cmp[4] = cmp[2];
                cmp[5] = cmp[3];
                cmp[2] = idx;
                cmp[3] = end - idx;
                continue;
            }
            if (end - idx <= cmp[3]) continue;
            cmp[4] = idx;
            cmp[5] = end - idx;
        }
        cmp[1] = cmp[1] + cmp[0];
        cmp[3] = cmp[3] + cmp[2];
        cmp[5] = cmp[5] + cmp[4];
        return cmp;
    }

    static final int findStr(byte[] search, int[] cmp, byte[] str, int beg, int end) {
        int c1f = cmp[0];
        int c1l = cmp[1];
        int d1 = c1l - c1f;
        int c2f = cmp[2];
        int c2l = cmp[3];
        int d2 = c2l - c2f;
        int c3f = cmp[4];
        int c3l = cmp[5];
        int d3 = c3l - c3f;
        while (beg + search.length <= end) {
            if (search[c1l] == str[beg + c1l]) {
                if (search[c1f] == str[beg + c1f]) {
                    boolean same = true;
                    for (int idx = 0; idx < search.length; ++idx) {
                        if (search[idx] == str[beg + idx]) continue;
                        same = false;
                        break;
                    }
                    if (same) break;
                }
                beg += d1;
                continue;
            }
            if (search[c2l] == str[beg + c2l]) {
                beg += d2;
                continue;
            }
            if (search[c3l] == str[beg + c3l]) {
                beg += d3;
                continue;
            }
            ++beg;
        }
        if (beg + search.length > end) {
            return -1;
        }
        return beg;
    }

    public static final String dequoteString(String str) {
        if (str.indexOf(92) == -1) {
            return str;
        }
        char[] buf = str.toCharArray();
        int num_deq = 0;
        for (int pos = 0; pos < buf.length; ++pos) {
            if (buf[pos] != '\\' || pos + 1 >= buf.length) continue;
            System.arraycopy(buf, pos + 1, buf, pos, buf.length - pos - 1);
            ++num_deq;
        }
        return new String(buf, 0, buf.length - num_deq);
    }

    public static final String quoteString(String str, String qlist) {
        int idx;
        char[] list = qlist.toCharArray();
        for (idx = 0; idx < list.length && str.indexOf(list[idx]) == -1; ++idx) {
        }
        if (idx == list.length) {
            return str;
        }
        int len = str.length();
        char[] buf = new char[len * 2];
        str.getChars(0, len, buf, 0);
        for (int pos = 0; pos < len; ++pos) {
            if (qlist.indexOf(buf[pos], 0) == -1) continue;
            if (len == buf.length) {
                buf = Util.resizeArray(buf, len + str.length());
            }
            System.arraycopy(buf, pos, buf, pos + 1, len - pos);
            ++len;
            buf[pos++] = 92;
        }
        return new String(buf, 0, len);
    }

    public static final Vector parseHeader(String header) throws ParseException {
        return Util.parseHeader(header, true);
    }

    public static final Vector parseHeader(String header, boolean dequote) throws ParseException {
        if (header == null) {
            return null;
        }
        char[] buf = header.toCharArray();
        Vector<HttpHeaderElement> elems = new Vector<HttpHeaderElement>();
        boolean first = true;
        int beg = -1;
        int end = 0;
        int len = buf.length;
        int[] abeg = new int[1];
        while (true) {
            String elem_value;
            if (!first) {
                beg = Util.skipSpace(buf, end);
                if (beg == len) break;
                if (buf[beg] != ',') {
                    throw new ParseException("Bad header format: '" + header + "'\nExpected \",\" at position " + beg);
                }
            }
            first = false;
            if ((beg = Util.skipSpace(buf, beg + 1)) == len) break;
            if (buf[beg] == ',') {
                end = beg;
                continue;
            }
            if (buf[beg] == '=' || buf[beg] == ';' || buf[beg] == '\"') {
                throw new ParseException("Bad header format: '" + header + "'\nEmpty element name at position " + beg);
            }
            for (end = beg + 1; end < len && !Character.isWhitespace(buf[end]) && buf[end] != '=' && buf[end] != ',' && buf[end] != ';'; ++end) {
            }
            String elem_name = new String(buf, beg, end - beg);
            beg = Util.skipSpace(buf, end);
            if (beg < len && buf[beg] == '=') {
                abeg[0] = beg + 1;
                elem_value = Util.parseValue(buf, abeg, header, dequote);
                end = abeg[0];
            } else {
                elem_value = null;
                end = beg;
            }
            NVPair[] params = new NVPair[]{};
            while ((beg = Util.skipSpace(buf, end)) != len && buf[beg] == ';') {
                String param_value;
                if ((beg = Util.skipSpace(buf, beg + 1)) == len || buf[beg] == ',') {
                    end = beg;
                    break;
                }
                if (buf[beg] == ';') {
                    end = beg;
                    continue;
                }
                if (buf[beg] == '=' || buf[beg] == '\"') {
                    throw new ParseException("Bad header format: '" + header + "'\nEmpty parameter name at position " + beg);
                }
                for (end = beg + 1; end < len && !Character.isWhitespace(buf[end]) && buf[end] != '=' && buf[end] != ',' && buf[end] != ';'; ++end) {
                }
                String param_name = new String(buf, beg, end - beg);
                beg = Util.skipSpace(buf, end);
                if (beg < len && buf[beg] == '=') {
                    abeg[0] = beg + 1;
                    param_value = Util.parseValue(buf, abeg, header, dequote);
                    end = abeg[0];
                } else {
                    param_value = null;
                    end = beg;
                }
                params = Util.resizeArray(params, params.length + 1);
                params[params.length - 1] = new NVPair(param_name, param_value);
            }
            elems.addElement(new HttpHeaderElement(elem_name, elem_value, params));
        }
        return elems;
    }

    private static String parseValue(char[] buf, int[] abeg, String header, boolean dequote) throws ParseException {
        String value;
        int beg;
        int end = beg = abeg[0];
        int len = buf.length;
        if ((beg = Util.skipSpace(buf, beg)) < len && buf[beg] == '\"') {
            char[] deq_buf = null;
            int deq_pos = 0;
            int lst_pos = beg;
            for (end = ++beg; end < len && buf[end] != '\"'; ++end) {
                if (buf[end] != '\\') continue;
                if (dequote) {
                    if (deq_buf == null) {
                        deq_buf = new char[buf.length];
                    }
                    System.arraycopy(buf, lst_pos, deq_buf, deq_pos, end - lst_pos);
                    deq_pos += end - lst_pos;
                    lst_pos = ++end;
                    continue;
                }
                ++end;
            }
            if (end == len) {
                throw new ParseException("Bad header format: '" + header + "'\nClosing <\"> for quoted-string" + " starting at position " + (beg - 1) + " not found");
            }
            if (deq_buf != null) {
                System.arraycopy(buf, lst_pos, deq_buf, deq_pos, end - lst_pos);
                value = new String(deq_buf, 0, deq_pos += end - lst_pos);
            } else {
                value = new String(buf, beg, end - beg);
            }
        } else {
            for (end = beg; end < len && !Character.isWhitespace(buf[end]) && buf[end] != ',' && buf[end] != ';'; ++end) {
            }
            value = new String(buf, beg, end - beg);
        }
        abeg[0] = ++end;
        return value;
    }

    public static final boolean hasToken(String header, String token) throws ParseException {
        if (header == null) {
            return false;
        }
        return Util.parseHeader(header).contains(new HttpHeaderElement(token));
    }

    public static final HttpHeaderElement getElement(Vector header, String name) {
        int idx = header.indexOf(new HttpHeaderElement(name));
        if (idx == -1) {
            return null;
        }
        return (HttpHeaderElement)header.elementAt(idx);
    }

    public static final String getParameter(String param, String hdr) throws ParseException {
        NVPair[] params = ((HttpHeaderElement)Util.parseHeader(hdr).firstElement()).getParams();
        for (int idx = 0; idx < params.length; ++idx) {
            if (!params[idx].getName().equalsIgnoreCase(param)) continue;
            return params[idx].getValue();
        }
        return null;
    }

    public static final String assembleHeader(Vector pheader) {
        StringBuffer hdr = new StringBuffer(200);
        int len = pheader.size();
        for (int idx = 0; idx < len; ++idx) {
            ((HttpHeaderElement)pheader.elementAt(idx)).appendTo(hdr);
            hdr.append(", ");
        }
        hdr.setLength(hdr.length() - 2);
        return hdr.toString();
    }

    static final int skipSpace(char[] str, int pos) {
        int len = str.length;
        while (pos < len && Character.isWhitespace(str[pos])) {
            ++pos;
        }
        return pos;
    }

    static final int findSpace(char[] str, int pos) {
        int len = str.length;
        while (pos < len && !Character.isWhitespace(str[pos])) {
            ++pos;
        }
        return pos;
    }

    static final int skipToken(char[] str, int pos) {
        int len = str.length;
        while (pos < len && TokenChar.get(str[pos])) {
            ++pos;
        }
        return pos;
    }

    static final boolean needsQuoting(String str) {
        int pos;
        int len = str.length();
        for (pos = 0; pos < len && TokenChar.get(str.charAt(pos)); ++pos) {
        }
        return pos < len;
    }

    public static final boolean sameHttpURL(URL url1, URL url2) {
        if (!url1.getProtocol().equalsIgnoreCase(url2.getProtocol())) {
            return false;
        }
        if (!url1.getHost().equalsIgnoreCase(url2.getHost())) {
            return false;
        }
        int port1 = url1.getPort();
        int port2 = url2.getPort();
        if (port1 == -1) {
            port1 = URI.defaultPort(url1.getProtocol());
        }
        if (port2 == -1) {
            port2 = URI.defaultPort(url1.getProtocol());
        }
        if (port1 != port2) {
            return false;
        }
        try {
            return URI.unescape(url1.getFile(), null).equals(URI.unescape(url2.getFile(), null));
        }
        catch (ParseException pe) {
            return url1.getFile().equals(url2.getFile());
        }
    }

    public static final int defaultPort(String protocol) {
        return URI.defaultPort(protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final Date parseHttpDate(String dstr) {
        Object object = http_parse_lock;
        synchronized (object) {
            if (parse_1123 == null) {
                Util.setupParsers();
            }
        }
        try {
            return parse_1123.parse(dstr);
        }
        catch (java.text.ParseException pe) {
            try {
                return parse_850.parse(dstr);
            }
            catch (java.text.ParseException pe2) {
                try {
                    return parse_asctime.parse(dstr);
                }
                catch (java.text.ParseException pe3) {
                    throw new IllegalArgumentException(pe3.toString());
                }
            }
        }
    }

    private static final void setupParsers() {
        parse_1123 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        parse_850 = new SimpleDateFormat("EEEE, dd-MMM-yy HH:mm:ss 'GMT'", Locale.US);
        parse_asctime = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.US);
        parse_1123.setTimeZone(new SimpleTimeZone(0, "GMT"));
        parse_850.setTimeZone(new SimpleTimeZone(0, "GMT"));
        parse_asctime.setTimeZone(new SimpleTimeZone(0, "GMT"));
        parse_1123.setLenient(true);
        parse_850.setLenient(true);
        parse_asctime.setLenient(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String httpDate(Date date) {
        Object object = http_format_lock;
        synchronized (object) {
            if (http_format == null) {
                Util.setupFormatter();
            }
        }
        return http_format.format(date);
    }

    private static final void setupFormatter() {
        http_format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        http_format.setTimeZone(new SimpleTimeZone(0, "GMT"));
    }

    static final String escapeUnsafeChars(String path) {
        boolean enableUtf8 = false;
        String escaped = URI.escape(path, SafeChar, false, URI.EscapePercentMode.NEVER);
        return escaped;
    }

    public static final String getPath(String resource) {
        int end = resource.length();
        int p = resource.indexOf(35);
        if (p != -1) {
            end = p;
        }
        if ((p = resource.indexOf(63)) != -1 && p < end) {
            end = p;
        }
        if ((p = resource.indexOf(59)) != -1 && p < end) {
            end = p;
        }
        return resource.substring(0, end);
    }

    public static final String getParams(String resource) {
        int beg = resource.indexOf(59);
        if (beg == -1) {
            return null;
        }
        int f = resource.indexOf(35);
        if (f != -1 && f < beg) {
            return null;
        }
        int q = resource.indexOf(63);
        if (q != -1 && q < beg) {
            return null;
        }
        if (q == -1 && f == -1) {
            return resource.substring(beg + 1);
        }
        if (f == -1 || q != -1 && q < f) {
            return resource.substring(beg + 1, q);
        }
        return resource.substring(beg + 1, f);
    }

    public static final String getQuery(String resource) {
        int beg = resource.indexOf(63);
        if (beg == -1) {
            return null;
        }
        int f = resource.indexOf(35);
        if (f != -1 && f < beg) {
            return null;
        }
        if (f == -1) {
            return resource.substring(beg + 1);
        }
        return resource.substring(beg + 1, f);
    }

    public static final String getFragment(String resource) {
        int beg = resource.indexOf(35);
        if (beg == -1) {
            return null;
        }
        return resource.substring(beg + 1);
    }

    public static final boolean wildcardMatch(String pattern, String name) {
        return Util.wildcardMatch(pattern, name, 0, 0, pattern.length(), name.length());
    }

    private static final boolean wildcardMatch(String pattern, String name, int ppos, int npos, int plen, int nlen) {
        int star = pattern.indexOf(42, ppos);
        if (star < 0) {
            return plen - ppos == nlen - npos && pattern.regionMatches(ppos, name, npos, plen - ppos);
        }
        if (!pattern.regionMatches(ppos, name, npos, star - ppos)) {
            return false;
        }
        if (star == plen - 1) {
            return true;
        }
        while (!Util.wildcardMatch(pattern, name, star + 1, npos, plen, nlen) && npos < nlen) {
            ++npos;
        }
        return npos < nlen;
    }

    static final byte[] buildByteArray(StringBuffer bufferToConvert) {
        int length = bufferToConvert.length();
        byte[] convertedBytes = new byte[length];
        char[] tempCharBuffer = new char[length];
        bufferToConvert.getChars(0, length, tempCharBuffer, 0);
        for (int i = 0; i < length; ++i) {
            convertedBytes[i] = (byte)tempCharBuffer[i];
        }
        return convertedBytes;
    }

    static byte[] string2arr(String ip) {
        InetAddress ia;
        byte[] ipArr;
        block3: {
            ipArr = null;
            ia = null;
            try {
                ia = InetAddress.getByName(ip);
            }
            catch (UnknownHostException uhe) {
                if (!logger.isLoggable(Level.FINE)) break block3;
                logger.log(Level.FINE, "Unable to resolve host name from IP: " + ip, uhe);
            }
        }
        if (ia != null) {
            ipArr = ia.getAddress();
        }
        return ipArr;
    }

    public static final URLClassLoader newPrivilegedURLClassLoader(final URL[] urls) {
        if (null == urls || 0 == urls.length) {
            throw new IllegalArgumentException("Non-null and non-empty URL[] expected.");
        }
        return (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new URLClassLoader(urls);
            }
        });
    }

    public static final URLClassLoader newPrivilegedURLClassLoader(final URL[] urls, final ClassLoader parent) {
        if (null == urls || 0 == urls.length) {
            throw new IllegalArgumentException("Non-null and non-empty URL[] expected.");
        }
        if (null == parent) {
            throw new IllegalArgumentException("Non-null parent ClassLoader expected.");
        }
        return (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new URLClassLoader(urls, parent);
            }
        });
    }

    public static final String formatMethodSignature(String methodName, Class[] formalParameters) {
        StringBuffer buff = new StringBuffer(256);
        if (null != methodName) {
            buff.append(methodName);
        }
        buff.append('(');
        if (null != formalParameters && formalParameters.length > 0) {
            for (int i = 0; i < formalParameters.length; ++i) {
                Class c;
                if (i > 0) {
                    buff.append(',');
                }
                if (null == (c = formalParameters[i])) continue;
                buff.append(c.getName());
            }
        }
        buff.append(')');
        return buff.toString();
    }

    public static String formatArray(String delimiter, Object[] array) {
        if (null == delimiter) {
            delimiter = "";
        }
        String output = null;
        if (null != array) {
            StringBuilder sb = new StringBuilder(array.length * 128);
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    sb.append(delimiter);
                }
                sb.append(array[i]);
            }
            output = sb.toString();
        }
        return output;
    }

    public static void logIOException(String prefix, IOException exception) {
        if (logger.isLoggable(Level.FINEST)) {
            StringWriter sw = new StringWriter();
            new Exception().printStackTrace(new PrintWriter(sw));
            logger.log(Level.FINEST, prefix + " : " + exception.toString() + " : The exception is reused at following point. " + sw.toString());
        }
    }

    static {
        int ch;
        Separators = new BitSet(128);
        TokenChar = new BitSet(128);
        UnsafeChar = new BitSet(128);
        SafeChar = new BitSet(128);
        http_format_lock = new Object();
        http_parse_lock = new Object();
        Separators.set(40);
        Separators.set(41);
        Separators.set(60);
        Separators.set(62);
        Separators.set(64);
        Separators.set(44);
        Separators.set(59);
        Separators.set(58);
        Separators.set(92);
        Separators.set(34);
        Separators.set(47);
        Separators.set(91);
        Separators.set(93);
        Separators.set(63);
        Separators.set(61);
        Separators.set(123);
        Separators.set(125);
        Separators.set(32);
        Separators.set(9);
        for (ch = 32; ch < 127; ++ch) {
            TokenChar.set(ch);
        }
        TokenChar.xor(Separators);
        for (ch = 0; ch < 32; ++ch) {
            UnsafeChar.set(ch);
        }
        UnsafeChar.set(32);
        UnsafeChar.set(60);
        UnsafeChar.set(62);
        UnsafeChar.set(34);
        UnsafeChar.set(123);
        UnsafeChar.set(125);
        UnsafeChar.set(124);
        UnsafeChar.set(92);
        UnsafeChar.set(94);
        UnsafeChar.set(126);
        UnsafeChar.set(91);
        UnsafeChar.set(93);
        UnsafeChar.set(96);
        UnsafeChar.set(127);
        SafeChar.set(0, 128);
        SafeChar.andNot(UnsafeChar);
        logger = HttpClientLoggerFactory.getLogger(Util.class.getName());
    }
}

