/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.Codecs;
import HTTPClient.HashVerifier;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.RoResponse;
import HTTPClient.i18n.HTTPClientMessages;
import java.io.IOException;
import java.util.logging.Logger;

class VerifyMD5
implements HashVerifier {
    private static final Logger logger = HttpClientLoggerFactory.getLogger(VerifyMD5.class.getName());
    RoResponse resp;

    public VerifyMD5(RoResponse resp) {
        this.resp = resp;
    }

    public void verifyHash(byte[] hash, long len) throws IOException {
        String hdr;
        try {
            hdr = this.resp.getHeader("Content-MD5");
            if (hdr == null) {
                hdr = this.resp.getTrailer("Content-MD5");
            }
        }
        catch (IOException ioe) {
            return;
        }
        if (hdr == null) {
            return;
        }
        byte[] ContMD5 = Codecs.base64Decode(hdr.trim().getBytes("8859_1"));
        for (int idx = 0; idx < hash.length; ++idx) {
            if (hash[idx] == ContMD5[idx]) continue;
            throw new IOException(HTTPClientMessages.msg_contentMd5DigestMismatch(VerifyMD5.hex(ContMD5), VerifyMD5.hex(hash)));
        }
        HTTPClientMessages.log_contentMd5HashVerified(logger);
    }

    private static String hex(byte[] buf) {
        StringBuffer str = new StringBuffer(buf.length * 3);
        for (int idx = 0; idx < buf.length; ++idx) {
            str.append(Character.forDigit(buf[idx] >>> 4 & 0xF, 16));
            str.append(Character.forDigit(buf[idx] & 0xF, 16));
            str.append(':');
        }
        str.setLength(str.length() - 1);
        return str.toString();
    }
}

