/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient.config;

import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.config.CommonCollectionWrappers;
import HTTPClient.config.Configuration;
import HTTPClient.config.Property;
import HTTPClient.config.PropertyInitializer;
import HTTPClient.config.SystemProperty;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

final class CommonPropertyInitializers {
    private static final Logger logger = HttpClientLoggerFactory.getLogger(CommonPropertyInitializers.class.getName());

    CommonPropertyInitializers() {
    }

    public static final class NewInstance
    implements PropertyInitializer {
        private final Class clazz;

        public NewInstance(final Class clazz) {
            if (null == clazz) {
                throw new IllegalArgumentException("Non-null class expected.");
            }
            this.clazz = clazz;
            Constructor constructor = null;
            try {
                constructor = AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor>(){

                    @Override
                    public Constructor run() throws NoSuchMethodException {
                        return clazz.getConstructor(null);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                NoSuchMethodException noMethodException = (NoSuchMethodException)e.getException();
                throw new IllegalArgumentException("No-argument constructor expected for class " + clazz.getName(), noMethodException);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to get Constructor for " + clazz.getName() + ".", e);
            }
            if (null == constructor) {
                throw new IllegalStateException("No-argument constructor expected for class " + clazz.getName() + ".");
            }
        }

        public void initialize(Property property, Configuration config) throws Exception {
            Object instance = null;
            try {
                instance = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws InstantiationException, IllegalAccessException {
                        return NewInstance.this.clazz.newInstance();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException("Unable to instantiate " + this.clazz.getName() + ".", e.getException());
            }
            if (null == instance) {
                throw new IllegalStateException("Expected non-null instance of " + this.clazz.getName() + ".");
            }
            config.setValue(property, instance);
        }
    }

    public static final class SetReadOnlyStringList_fromDelimitedString
    implements PropertyInitializer {
        private final String delimiter;

        public SetReadOnlyStringList_fromDelimitedString() {
            this(",");
        }

        public SetReadOnlyStringList_fromDelimitedString(String delimiter) {
            if (null == delimiter) {
                throw new IllegalArgumentException("Non-null delimiter expected.");
            }
            this.delimiter = delimiter;
        }

        public void initialize(Property property, Configuration config) throws Exception {
            if (!(property instanceof SystemProperty)) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "SetReadOnlyStringList_fromDelimitedString only applicable for system properties.");
                }
                return;
            }
            String rawSysPropValue = config.getRawSystemProperty(property.getName());
            if (null == rawSysPropValue || "".equals(rawSysPropValue.trim())) {
                config.setValue(property, null);
            } else {
                String[] arrayValue = rawSysPropValue.split(this.delimiter);
                List<String> listValue = Arrays.asList(arrayValue);
                CommonCollectionWrappers.List_String value = new CommonCollectionWrappers.List_String(Collections.unmodifiableList(listValue));
                config.setValue(property, value);
            }
        }
    }

    public static final class SetNull_ifEmptyString
    implements PropertyInitializer {
        public void initialize(Property property, Configuration config) throws Exception {
            Object value = config.getValue(property);
            if ("".equals(value)) {
                config.setValue(property, null);
            }
        }
    }
}

