/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient.config;

import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.config.ConfigurationFactory;
import HTTPClient.config.ConfigurationTemplate;
import HTTPClient.config.Property;
import HTTPClient.config.PropertyInitializer;
import HTTPClient.config.SystemProperty;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    private static final Logger logger = HttpClientLoggerFactory.getLogger(Configuration.class.getName());
    private static final int INIT_PROPERTY_VALUES_MAP_SIZE = 100;
    private final Map<Property, Object> propertyValues = new ConcurrentHashMap<Property, Object>(100);
    private Map<String, String> rawSystemProperties;
    private final String contextId;
    private final ConfigurationFactory factory;
    private volatile boolean initialized = false;

    public final Object getValue(Property key) {
        Configuration.checkNullKey(key);
        return this.propertyValues.get(key);
    }

    public final boolean getBoolean(Property key) {
        Object value = this.getValue(key);
        if (null == value) {
            return false;
        }
        String strValue = value.toString();
        if (null == strValue) {
            return false;
        }
        return strValue.equalsIgnoreCase("true");
    }

    public final Object setValue(Property key, Object value) {
        Class clazz;
        Configuration.checkNullKey(key);
        this.checkInitializedFinal(key);
        if (null != value && key.getValueClass() != null && !(clazz = key.getValueClass()).isInstance(value)) {
            throw new IllegalArgumentException("Class " + value.getClass().getName() + " of the given value is unassignable to property " + key.getName() + " expecting value of class " + key.getValueClass().getName() + ".");
        }
        if (null != value) {
            this.log_setValue(key, value);
            return this.propertyValues.put(key, value);
        }
        return this.removeValue(key);
    }

    public final Object removeValue(Property key) {
        Configuration.checkNullKey(key);
        this.checkInitializedFinal(key);
        this.log_setValue(key, null);
        return this.propertyValues.remove(key);
    }

    Configuration(ConfigurationFactory factory, String contextId) {
        this.factory = factory;
        this.contextId = contextId;
    }

    final void initializeFromTemplate(ConfigurationTemplate template) {
        if (this.isInitialized()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Attempted to initialize an initialized Configuration.");
            }
            return;
        }
        this.setRawSystemProperties(template.getRawSystemProperties());
        this.propertyValues.putAll(template.getPropertyValues());
        List<Property> props = Property.getPropertyList();
        for (Property prop : props) {
            PropertyInitializer initializer;
            if (!prop.isValid() || null == (initializer = prop.getPropertyInitializer())) continue;
            this.runInitializer(initializer, prop);
        }
        this.setInitialized();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "{0} initialized, from ConfigurationTemplate {1}.", new Object[]{this, template});
        }
    }

    public final Map<String, String> getRawSystemProperties() {
        return this.rawSystemProperties;
    }

    public final String getRawSystemProperty(String name) {
        if (null == name) {
            throw new IllegalArgumentException("Non-null name expected.");
        }
        String value = null;
        Map<String, String> rawSysProps = this.getRawSystemProperties();
        if (null != rawSysProps) {
            value = rawSysProps.get(name);
        }
        return value;
    }

    final void setRawSystemProperties(Map<String, String> rawSysProps) {
        this.rawSystemProperties = rawSysProps;
    }

    public final String getContextId() {
        return this.contextId;
    }

    final ConfigurationFactory getFactory() {
        return this.factory;
    }

    final Map<Property, Object> getPropertyValues() {
        return Collections.unmodifiableMap(this.propertyValues);
    }

    final boolean isInitialized() {
        return this.initialized;
    }

    final void setInitialized() {
        this.initialized = true;
    }

    final void runInitializer(PropertyInitializer initializer, Property prop) {
        try {
            initializer.initialize(prop, this);
        }
        catch (Exception e) {
            String msg = "Unable to initialize property \"" + prop + "\"";
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, msg, e);
            }
            throw new RuntimeException(msg, e);
        }
    }

    public String toString() {
        String output = MessageFormat.format("Configuration[contextId={0},instance={1}]", this.getContextId(), super.toString());
        return output;
    }

    private void log_setValue(Property prop, Object propValue) {
        if (logger.isLoggable(Level.CONFIG)) {
            String systemStr = "";
            if (prop instanceof SystemProperty) {
                systemStr = "system ";
            }
            logger.log(Level.CONFIG, "Configuration[contextId={0},instance={1}] {2}property \"{3}\" set to \"{4}\".", new Object[]{this.getContextId(), super.toString(), systemStr, prop.getName(), propValue});
        }
    }

    private void checkInitializedFinal(Property key) {
        Configuration.checkNullKey(key);
        if (this.isInitialized() && key.isFinal()) {
            String msg = MessageFormat.format("The Property {0} is defined as \"final\" and may not be modified after initialization.", key.toString());
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, msg);
            }
            throw new IllegalStateException(msg);
        }
    }

    private static void checkNullKey(Property key) {
        if (null == key) {
            throw new IllegalArgumentException("Non-null Property key expected.");
        }
    }
}

