/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient.config;

import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.config.Configuration;
import HTTPClient.config.ConfigurationContextProvider;
import HTTPClient.config.ConfigurationTemplate;
import HTTPClient.config.ContextRemovalListener;
import HTTPClient.config.HTTPClientProperties;
import HTTPClient.config.JRFContextProvider;
import HTTPClient.config.JVMSystemPropertiesProvider;
import HTTPClient.config.OC4JContextProvider;
import HTTPClient.config.Property;
import HTTPClient.config.SystemPropertiesProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ConfigurationFactory {
    private static final Logger logger;
    private static ConfigurationContextProvider contextProvider;
    private static SystemPropertiesProvider systemPropertiesProvider;
    public static final int INITIAL_CONFIGURATION_COUNT = 50;
    private final Map<String, Configuration> configMap = new HashMap<String, Configuration>(50);
    private static volatile boolean initStaticOk;
    private ConfigurationTemplate template = null;
    private final ThreadLocal<Configuration> threadLocalConfiguration = new ThreadLocal();

    public static ConfigurationFactory getInstance() {
        ConfigurationFactory.checkInitStatic();
        ConfigurationFactory factory = new ConfigurationFactory();
        factory.template = factory.createConfigurationTemplate();
        return factory;
    }

    public Configuration getConfiguration() {
        Configuration config = this.getThreadLocalConfiguration();
        if (null != config) {
            return config;
        }
        return this.getConfiguration(ConfigurationFactory.getContextId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Configuration getConfiguration(String contextId) {
        Configuration contextConfig;
        Map<String, Configuration> map = this.configMap;
        synchronized (map) {
            contextConfig = this.configMap.get(contextId);
            if (null == contextConfig) {
                try {
                    contextConfig = new Configuration(this, contextId);
                    this.configMap.put(contextId, contextConfig);
                    contextConfig.initializeFromTemplate(this.template);
                    if (null != contextId) {
                        this.registerContextRemovalListener();
                    }
                }
                catch (Exception e) {
                    String errMsg = "Unable to create Configuration from template.";
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, errMsg, e);
                    }
                    throw new IllegalStateException(errMsg, e);
                }
            }
        }
        return contextConfig;
    }

    public boolean setThreadLocalConfiguration(Configuration localCache) {
        if (this.getThreadLocalConfiguration() == null) {
            Configuration tlConfig;
            if (null != localCache && this != localCache.getFactory()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Attempting to cache Configuration from wrong factory, contextId=\"{0}\".", localCache.getContextId());
                }
                localCache = null;
            }
            if (null == localCache) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "No local cache to determine context id for thread-local Configuration.");
                }
                tlConfig = this.getConfiguration(ConfigurationFactory.getContextId());
            } else {
                String contextId = localCache.getContextId();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "Using local cache to determine context id \"{0}\" for thread-local Configuration.", contextId);
                }
                tlConfig = this.getConfiguration(contextId);
            }
            this.threadLocalConfiguration.set(tlConfig);
            return true;
        }
        return false;
    }

    public void clearThreadLocalConfiguration() {
        if (logger.isLoggable(Level.FINEST)) {
            Configuration config = this.getThreadLocalConfiguration();
            if (null == config) {
                logger.log(Level.FINEST, "clearThreadLocalConfiguration: previously null Configuration.");
            } else {
                logger.log(Level.FINEST, "clearThreadLocalConfiguration: previously Configuration for context id \"{0}\".", config.getContextId());
            }
        }
        this.threadLocalConfiguration.set(null);
    }

    public Configuration getThreadLocalConfiguration() {
        return this.threadLocalConfiguration.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rebuild() {
        Map<String, Configuration> map = this.configMap;
        synchronized (map) {
            ConfigurationTemplate newTemplate = this.createConfigurationTemplate();
            this.configMap.clear();
            this.template = newTemplate;
        }
    }

    static String getContextId() {
        if (null != contextProvider) {
            return contextProvider.getContextId();
        }
        return null;
    }

    private ConfigurationTemplate createConfigurationTemplate() {
        Map<String, String> rawSysProps = null;
        if (null != systemPropertiesProvider) {
            rawSysProps = systemPropertiesProvider.getProperties();
        }
        ConfigurationTemplate template = new ConfigurationTemplate();
        template.initializeTemplate(rawSysProps);
        return template;
    }

    static void checkInitStatic() {
        if (!ConfigurationFactory.isInitStaticOk()) {
            throw new IllegalStateException("ConfigurationFactory static initialization failed.");
        }
    }

    static boolean isInitStaticOk() {
        return initStaticOk;
    }

    static SystemPropertiesProvider getSystemPropertiesProvider() {
        return systemPropertiesProvider;
    }

    static ConfigurationContextProvider getConfigurationContextProvider() {
        return contextProvider;
    }

    static void initProperties() {
        String sysPropName = HTTPClientProperties.SysProp.PROXY_HOST.getName();
        String propName = HTTPClientProperties.Prop.HTTPCONNECTION_MUTABLE_STATICS.getName();
        if (null != sysPropName && null != propName && logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Successfully loaded class {0}.", HTTPClientProperties.class.getName());
        }
        if (!Property.isAllInitOk()) {
            throw new IllegalStateException(HTTPClientProperties.class.getName() + " failed to initialize. Enable logging for details.");
        }
    }

    static Object instantiateClass(String className, Class expectedInterface) {
        if (null == className || "".equals(className.trim())) {
            throw new IllegalArgumentException("Non-empty className expected.");
        }
        if (null == expectedInterface) {
            throw new IllegalArgumentException("Non-null expectedInterface expected.");
        }
        try {
            Class<?> cls = Class.forName(className);
            Object obj = cls.newInstance();
            if (!expectedInterface.isInstance(obj)) {
                throw new ClassCastException("Specified implementation " + className + " is not an instance of " + expectedInterface.getName() + ".");
            }
            return obj;
        }
        catch (Exception e) {
            String message = "Unable to instantiate " + className + ".";
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, message, e);
            }
            throw new RuntimeException(message, e);
        }
    }

    static void initSystemPropertiesProvider() {
        String className = JVMSystemPropertiesProvider.readSystemProperty("HTTPClient.config.systemPropertiesProvider");
        systemPropertiesProvider = null == className || "".equals(className.trim()) ? new JVMSystemPropertiesProvider() : (SystemPropertiesProvider)ConfigurationFactory.instantiateClass(className, SystemPropertiesProvider.class);
        if (null == systemPropertiesProvider || !systemPropertiesProvider.isAvailable()) {
            throw new IllegalStateException("An available SystemPropertiesProvider instance is required. " + className + " is unavailable.");
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "\"" + systemPropertiesProvider.getClass().getName() + "\" selected as SystemPropertiesProvider implementation.");
        }
    }

    static void initConfigurationContextProvider() {
        String className = JVMSystemPropertiesProvider.readSystemProperty("HTTPClient.config.configContextProvider");
        if (null == className) {
            contextProvider = ConfigurationFactory.selectDefaultContextProvider();
        } else if ("".equals(className.trim())) {
            contextProvider = null;
        } else {
            contextProvider = (ConfigurationContextProvider)ConfigurationFactory.instantiateClass(className, ConfigurationContextProvider.class);
            if (null == contextProvider || !contextProvider.isAvailable()) {
                throw new IllegalStateException("Required ConfigurationContextProvider unavailable: " + className);
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "{0} selected as ConfigurationContextProvider implementation.", null == contextProvider ? "Null" : contextProvider.getClass().getName());
        }
    }

    private static ConfigurationContextProvider selectDefaultContextProvider() {
        ConfigurationContextProvider provider = new JRFContextProvider();
        if (ConfigurationFactory.isDefaultContextProviderAvailable(provider)) {
            return provider;
        }
        provider = new OC4JContextProvider();
        if (ConfigurationFactory.isDefaultContextProviderAvailable(provider)) {
            return provider;
        }
        return null;
    }

    private static boolean isDefaultContextProviderAvailable(ConfigurationContextProvider provider) {
        if (null == provider) {
            return false;
        }
        if (provider.isAvailable()) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Default ConfigurationContextProvider {0} is available.", provider.getClass().getName());
            }
            return true;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Default ConfigurationContextProvider {0} is unavailable.", provider.getClass().getName());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpConfigMap(String contextId) {
        Map<String, Configuration> map = this.configMap;
        synchronized (map) {
            this.configMap.remove(contextId);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Successfully removed Configuration for contextId \"{0}\".", contextId);
            }
        }
    }

    private void registerContextRemovalListener() {
        ConfigurationContextProvider provider = ConfigurationFactory.getConfigurationContextProvider();
        if (null == provider) {
            return;
        }
        provider.registerContextRemovalListener(new ContextRemovalListenerImpl());
    }

    private ConfigurationFactory() {
    }

    static {
        block2: {
            logger = HttpClientLoggerFactory.getLogger(ConfigurationFactory.class.getName());
            initStaticOk = false;
            try {
                ConfigurationFactory.initProperties();
                ConfigurationFactory.initSystemPropertiesProvider();
                ConfigurationFactory.initConfigurationContextProvider();
                initStaticOk = true;
            }
            catch (Exception e) {
                initStaticOk = false;
                if (!logger.isLoggable(Level.FINE)) break block2;
                logger.log(Level.FINE, "Unable to init ConfigurationFactory", e);
            }
        }
    }

    private class ContextRemovalListenerImpl
    implements ContextRemovalListener {
        private ContextRemovalListenerImpl() {
        }

        public void contextRemoved(String contextId) {
            if (null != contextId) {
                ConfigurationFactory.this.cleanUpConfigMap(contextId);
            }
        }
    }
}

