/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient.config;

import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.config.Configuration;
import HTTPClient.config.Property;
import HTTPClient.config.PropertyInitializer;
import HTTPClient.config.SystemProperty;
import HTTPClient.config.SystemPropertyInitializer;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConfigurationTemplate
extends Configuration {
    private static final Logger logger = HttpClientLoggerFactory.getLogger(ConfigurationTemplate.class.getName());

    ConfigurationTemplate() {
        super(null, null);
    }

    void initializeTemplate(Map<String, String> rawSystemProperties) {
        if (this.isInitialized()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Attempted to initialize an initialized ConfigurationTemplate.");
            }
            return;
        }
        if (this.getPropertyValues().size() > 0) {
            throw new IllegalStateException("Expected empty propertyValues.");
        }
        this.setRawSystemProperties(rawSystemProperties);
        List<Property> props = Property.getPropertyList();
        if (this.getRawSystemProperties() != null) {
            for (Property prop : props) {
                PropertyInitializer initializer;
                if (!prop.isValid() || !(prop instanceof SystemProperty) || null == (initializer = SystemPropertyInitializer.getAssignableTo(prop.getValueClass()))) continue;
                this.runInitializer(initializer, prop);
            }
        }
        for (Property prop : props) {
            Object defaultValue;
            if (!prop.isValid() || null != this.getValue(prop) || null == (defaultValue = prop.getDefaultValue())) continue;
            this.setValue(prop, defaultValue);
        }
        this.setInitialized();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "ConfigurationTemplate {0} initialized.", this);
        }
    }
}

