/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient.config;

import HTTPClient.AuthenticationSchemeRegistry;
import HTTPClient.AuthorizationInfo;
import HTTPClient.AuthorizationModule;
import HTTPClient.Cookie;
import HTTPClient.CookieModule;
import HTTPClient.DefaultAuthHandler;
import HTTPClient.HTTPClientSSLFactory;
import HTTPClient.HTTPConnection;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.HttpURLConnection;
import HTTPClient.RedirectionModule;
import HTTPClient.SuppliedUPAuthHandler;
import HTTPClient.config.CommonCollectionWrappers;
import HTTPClient.config.CommonPropertyInitializers;
import HTTPClient.config.Property;
import HTTPClient.config.SystemProperty;
import HTTPClient.loadbalance.LoadBalanceProvider;
import HTTPClient.loadbalance.PropertyLoadBalanceProvider;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class HTTPClientProperties {
    private static final Logger logger = HttpClientLoggerFactory.getLogger(HTTPClientProperties.class.getName());

    private HTTPClientProperties() {
    }

    private static Property newMutableStaticsProperty(Class mutableStaticsClass) {
        try {
            if (null == mutableStaticsClass) {
                throw new IllegalArgumentException("Non-null mutableStaticsClass expected.");
            }
            return new Property(mutableStaticsClass.getName(), mutableStaticsClass, null, new CommonPropertyInitializers.NewInstance(mutableStaticsClass), true);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Unable to define the Property based on MutableStatics class {0}.", mutableStaticsClass);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, msg, e);
            }
            throw new RuntimeException(msg, e);
        }
    }

    static /* synthetic */ Property access$000(Class x0) {
        return HTTPClientProperties.newMutableStaticsProperty(x0);
    }

    public static final class Prop {
        public static final Property NON_PROXY_HOSTS = new Property("HTTPConnection.nonProxyHosts", CommonCollectionWrappers.List_String.class, null, new HTTPConnection.NonProxyHostsPropertyInitializer(), true);
        public static final Property HTTPCONNECTION_MUTABLE_STATICS = HTTPClientProperties.access$000(HTTPConnection.MutableStatics.class);
        public static final Property AUTHORIZATIONINFO_MUTABLE_STATICS = HTTPClientProperties.access$000(AuthorizationInfo.MutableStatics.class);
        public static final Property AUTHORIZATIONMODULE_MUTABLE_STATICS = HTTPClientProperties.access$000(AuthorizationModule.MutableStatics.class);
        public static final Property COOKIEMODULE_MUTABLE_STATICS = HTTPClientProperties.access$000(CookieModule.MutableStatics.class);
        public static final Property DEFAULTAUTHHANDLER_MUTABLE_STATICS = HTTPClientProperties.access$000(DefaultAuthHandler.MutableStatics.class);
        public static final Property HTTPCLIENTSSLFACTORY_MUTABLE_STATICS = HTTPClientProperties.access$000(HTTPClientSSLFactory.MutableStatics.class);
        public static final Property HTTPURLCONNECTION_MUTABLE_STATICS = HTTPClientProperties.access$000(HttpURLConnection.MutableStatics.class);
        public static final Property REDIRECTIONMODULE_MUTABLE_STATICS = HTTPClientProperties.access$000(RedirectionModule.MutableStatics.class);
        public static final Property SUPPLIEDUPAUTHHANDLER_MUTABLE_STATICS = HTTPClientProperties.access$000(SuppliedUPAuthHandler.MutableStatics.class);

        private Prop() {
        }
    }

    public static final class SysProp {
        public static final SystemProperty DONT_CHUNK_REQUESTS = new SystemProperty("HTTPClient.dontChunkRequests", Boolean.class, Boolean.FALSE, null, true);
        public static final SystemProperty FORCE_1_0 = new SystemProperty("HTTPClient.forceHTTP_1.0", Boolean.class, Boolean.FALSE, null, true);
        public static final SystemProperty NEVER_PIPELINE = new SystemProperty("HTTPClient.disable_pipelining", Boolean.class, Boolean.FALSE, null, true);
        public static final SystemProperty NO_KEEP_ALIVES = new SystemProperty("HTTPClient.disableKeepAlives", Boolean.class, Boolean.FALSE, null, true);
        public static final SystemProperty DEFER_STREAMED = new SystemProperty("HTTPClient.deferStreamed", Boolean.class, Boolean.FALSE, null, true);
        public static final SystemProperty ENABLE_NAGLE_ALGORITHM = new SystemProperty("HTTPClient.Nagle", Boolean.class, Boolean.FALSE, null, true);
        public static final SystemProperty PROXY_HOST = new SystemProperty("http.proxyHost", String.class, null, null, true);
        public static final SystemProperty PROXY_PORT = new SystemProperty("http.proxyPort", Integer.class, -1, null, true);
        public static final SystemProperty SOCKS_HOST = new SystemProperty("HTTPClient.socksHost", String.class, null, null, true);
        public static final SystemProperty SOCKS_PORT = new SystemProperty("HTTPClient.socksPort", Integer.class, -1, null, true);
        public static final SystemProperty SOCKS_VERSION = new SystemProperty("HTTPClient.socksVersion", Integer.class, -1, null, true);
        public static final SystemProperty SOCKET_IDLE_TIMEOUT = new SystemProperty("HTTPClient.socket.idleTimeout", Integer.class, 60, null, false);
        public static final SystemProperty CONNECTION_TIMEOUT = new SystemProperty("HTTPClient.socket.connectionTimeout", Integer.class, 0, null, false);
        public static final SystemProperty SOCKET_READ_TIMEOUT = new SystemProperty("HTTPClient.socket.readTimeout", Integer.class, 0, null, false);
        public static final SystemProperty MAXIMUM_AUTHORIZATION_RETRIES = new SystemProperty("HTTPClient.authorization.MaxRetry", Integer.class, 4, null, true);
        public static final SystemProperty DISABLE_EXECUTION_CONTEXT = new SystemProperty("HTTPClient.disableExecutionContext", Boolean.class, Boolean.FALSE, null, true);
        public static final SystemProperty ENABLE_STALE_SOCKET_CHECK = new SystemProperty("HTTPClient.socket.staleCheck", Boolean.class, Boolean.FALSE, null, false);
        public static final SystemProperty DEFAULT_NTLM_DOMAIN_NAME = new SystemProperty("HTTPClient.ntlm.defaultDomainName", String.class, "", null, true);
        public static final SystemProperty DEFAULT_NTLM_AUTH_METHOD = new SystemProperty("HTTPClient.ntlm.defaultAuthMethod", String.class, "AUTO", null, true);
        public static final SystemProperty DEFAULT_HOSTNAME_VERIFIER = new SystemProperty("HTTPClient.defaultHostnameVerifier", String.class, "", null, true);
        public static final SystemProperty DEFAULT_MODULES = new SystemProperty("HTTPClient.Modules", String.class, "HTTPClient.RetryModule|HTTPClient.CookieModule|HTTPClient.RedirectionModule|HTTPClient.AuthorizationModule|HTTPClient.DefaultModule|HTTPClient.TransferEncodingModule|HTTPClient.ContentMD5Module|HTTPClient.ContentEncodingModule|HTTPClient.ExecutionContextModule", null, true);
        public static final SystemProperty HTTPCLIENT_NON_PROXY_HOSTS = new SystemProperty("HTTPClient.nonProxyHosts", String.class, null, null, true);
        public static final SystemProperty HTTP_NON_PROXY_HOSTS = new SystemProperty("http.nonProxyHosts", String.class, null, null, true);
        public static final SystemProperty LOAD_BALANCE_PROVIDER = new SystemProperty("HTTPClient.loadbalance.loadBalanceProvider", String.class, null, new CommonPropertyInitializers.SetNull_ifEmptyString(), true);
        public static final SystemProperty DEFAULT_LOAD_BALANCE_METHOD = new SystemProperty("HTTPClient.loadbalance.defaultMethod", LoadBalanceProvider.LoadBalanceMethod.class, null, new PropertyLoadBalanceProvider.PropertyInitializer_DefaultLoadBalanceMethod(), true);
        public static final SystemProperty LOAD_BALANCE_SERVER_CLUSTERS = new SystemProperty("HTTPClient.loadbalance.serverCluster.", PropertyLoadBalanceProvider.List_LoadBalanceEndpoint.class, null, new PropertyLoadBalanceProvider.PropertyInitializer_LoadBalanceServerClusters(), true);
        public static final SystemProperty AUTHENTICATION_SCHEMES = new SystemProperty("HTTPClient.authenticationScheme.", CommonCollectionWrappers.List_NVPair.class, null, new AuthenticationSchemeRegistry.PropertyInitializer_AuthenticationSchemes(), true);
        public static final SystemProperty JSSE_CIPHERSUITES = new SystemProperty("https.cipherSuites", CommonCollectionWrappers.List_String.class, null, new CommonPropertyInitializers.SetReadOnlyStringList_fromDelimitedString(), true);
        public static final SystemProperty ENABLE_COOKIES_SAVE = new SystemProperty("HTTPClient.cookies.save", Boolean.class, Boolean.FALSE, null, true);
        public static final SystemProperty PERSISTED_COOKIES_PATH = new SystemProperty("HTTPClient.cookies.jar", String.class, null, new CookieModule.PersistedCookiesPathPropertyInitializer(), true);
        public static final SystemProperty COOKIES_HOSTS_ACCEPT = new SystemProperty("HTTPClient.cookies.hosts.accept", String.class, null, null, true);
        public static final SystemProperty COOKIES_HOSTS_REJECT = new SystemProperty("HTTPClient.cookies.hosts.reject", String.class, null, null, true);
        public static final SystemProperty COOKIES_EXTENDED_TLDS = new SystemProperty("HTTPClient.cookies.extendedTLDs", CommonCollectionWrappers.List_String.class, null, new Cookie.CookiesExtendedTLDsPropertyInitializer(), true);
        public static final SystemProperty HTTPURLCONNECTION_ALLOWUI = new SystemProperty("HTTPClient.HttpURLConnection.AllowUI", Boolean.class, Boolean.FALSE, null, true);
        public static final SystemProperty HTTP_AGENT = new SystemProperty("http.agent", String.class, null, null, true);
        public static final SystemProperty HTTPURLCONNECTION_MAX_CACHED_CONNECTIONS = new SystemProperty("HTTPClient.HttpUrlConnection.maxCacheSize", Integer.class, 50, null, true);
        public static final SystemProperty DISABLE_TIMEOUT_FOR_RESPONSE_BODY = new SystemProperty("HTTPClient.dontTimeoutRespBody", Boolean.class, Boolean.FALSE, null, true);
        public static final SystemProperty MAX_REQUEST_TRY_COUNT = new SystemProperty("HTTPClient.maxRequestTryCount", Integer.class, 3, null, true);
        public static final SystemProperty RETRY_NON_IDEMPOTENT_REQUEST = new SystemProperty("HTTPClient.retryNonIdempotentRequest", Boolean.class, Boolean.TRUE, null, true);

        private SysProp() {
        }
    }

    public static final class SysPropName {
        public static final String SYSTEM_PROPERTIES_PROVIDER = "HTTPClient.config.systemPropertiesProvider";
        public static final String CONFIG_CONTEXT_PROVIDER = "HTTPClient.config.configContextProvider";
        public static final String LOG_LEVEL = "HTTPClient.log.level";
        public static final String ENABLE_VERBOSE_LOGGING = "HTTPClient.log.verbose";

        private SysPropName() {
        }
    }
}

