/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient.config;

import HTTPClient.ClassDetector;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.config.ConfigurationContextProvider;
import HTTPClient.config.ContextRemovalListener;
import HTTPClient.config.JRFUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import oracle.as.jmx.framework.PortableMBeanFactory;
import oracle.as.jmx.framework.annotations.Description;

class JRFContextProvider
implements ConfigurationContextProvider {
    private static final Logger LOGGER = HttpClientLoggerFactory.getLogger(JRFContextProvider.class.getName());
    private static final String JMX_IMPLEMENTATION_CLASSNAME = "oracle.as.jmx.framework.PortableMBeanFactory";
    private static final ClassDetector jmxImplementationDetector = new ClassDetector("oracle.as.jmx.framework.PortableMBeanFactory");
    private static final int INIT_APP_UNDEPLOY_DETECTOR_MAP_SIZE = 100;
    private final Map<String, AppUndeployDetector> appUndeployDetectorMap = new HashMap<String, AppUndeployDetector>(100);

    JRFContextProvider() {
    }

    public String getContextId() {
        return JRFUtils.getContextId();
    }

    public boolean isAvailable() {
        return JRFUtils.isAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerContextRemovalListener(ContextRemovalListener listener) {
        AppUndeployDetector detector;
        JRFUtils.checkAvailable();
        if (null == listener) {
            throw new IllegalArgumentException("Unexpected null ContextRemovalListener");
        }
        if (!jmxImplementationDetector.isClassAvailable()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "JMX is unavailable, unable to register ContextRemovalListener.");
            }
            return;
        }
        String contextId = this.getContextId();
        if (null == contextId) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Bad (null) context id, unable to register ContextRemovalListener.");
            }
            return;
        }
        Map<String, AppUndeployDetector> map = this.appUndeployDetectorMap;
        synchronized (map) {
            detector = this.appUndeployDetectorMap.get(contextId);
            if (null == detector) {
                String mbeanName = null;
                try {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Attempting to create and register MBean {0} for contextId=\"{1}\".", new Object[]{AppUndeployDetectorMXBean.class.getName(), contextId});
                    }
                    Object portableMBeanFactory = jmxImplementationDetector.getResolvedClass().newInstance();
                    MBeanServer platformMBeanServer = ((PortableMBeanFactory)portableMBeanFactory).getMBeanServer();
                    ObjectName runtimeMBeanName = ((PortableMBeanFactory)portableMBeanFactory).translateObjectNameToGlobalNameSpace(new ObjectName("com.oracle.HTTPClient.config:type=AppUndeployDetector,name=main"));
                    mbeanName = runtimeMBeanName.getCanonicalName();
                    detector = new AppUndeployDetector(contextId, mbeanName);
                    Object mbean = ((PortableMBeanFactory)portableMBeanFactory).createMBean((Object)detector, AppUndeployDetectorMXBean.class);
                    platformMBeanServer.registerMBean(mbean, runtimeMBeanName);
                    this.appUndeployDetectorMap.put(contextId, detector);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Successfully created and registered MBean named \"{0}\" for contextId \"{1}\".", new Object[]{mbeanName, contextId});
                    }
                }
                catch (Exception e) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        String msg = MessageFormat.format("Unable to create and register MBean {0} named \"{1}\" for contextId \"{2}\".", AppUndeployDetectorMXBean.class.getName(), mbeanName, contextId);
                        LOGGER.log(Level.FINE, msg, e);
                    }
                    detector = null;
                }
            } else if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Using existing MBean named \"{0}\" for contextId \"{1}\".", new Object[]{detector.getMBeanName(), contextId});
            }
        }
        if (null != detector) {
            detector.addListener(listener);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Successfully registered ContextRemovalListener for contextId \"{0}\".", contextId);
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Unable to register ContextRemovalListener for contextId \"{0}\". No MBean available.", contextId);
        }
    }

    private class AppUndeployDetector
    implements AppUndeployDetectorMXBean,
    MBeanRegistration {
        private final String contextId;
        private final String mBeanName;
        private static final int INIT_CAPACITY_LISTENERS_LIST = 4;
        private final ArrayList<ContextRemovalListener> listeners = new ArrayList(4);

        private AppUndeployDetector(String contextId, String mBeanName) {
            this.contextId = contextId;
            this.mBeanName = mBeanName;
        }

        public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
            return null;
        }

        public void postRegister(Boolean registrationDone) {
        }

        public void preDeregister() throws Exception {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postDeregister() {
            ArrayList tempListeners;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "MBean named \"{0}\" in postDeregister, started notifying all ContextRemovalListener instances for contextId \"{1}\".", new Object[]{this.getMBeanName(), this.contextId});
            }
            Object object = this.listeners;
            synchronized (object) {
                tempListeners = (ArrayList)this.listeners.clone();
            }
            for (ContextRemovalListener listener : tempListeners) {
                listener.contextRemoved(this.contextId);
            }
            object = JRFContextProvider.this.appUndeployDetectorMap;
            synchronized (object) {
                JRFContextProvider.this.appUndeployDetectorMap.remove(this.contextId);
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "MBean named \"{0}\" in postDeregister, completed notifying all ContextRemovalListener instances for contextId \"{1}\".", new Object[]{this.getMBeanName(), this.contextId});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addListener(ContextRemovalListener listener) {
            if (null == listener) {
                throw new IllegalArgumentException("Unexpected null ContextRemovalListener.");
            }
            ArrayList<ContextRemovalListener> arrayList = this.listeners;
            synchronized (arrayList) {
                if (!this.listeners.contains(listener)) {
                    this.listeners.add(listener);
                }
            }
        }

        private String getMBeanName() {
            return this.mBeanName;
        }
    }

    @Description(resourceKey="J2EE HTTPC-12012", resourceBundleBaseName="HTTPClient.i18n.HTTPClientMessageBundle")
    private static interface AppUndeployDetectorMXBean {
    }
}

