/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient.config;

import HTTPClient.ClassDetector;
import HTTPClient.HttpClientLoggerFactory;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jrf.ServerPlatformSupport;
import oracle.jrf.ServerPlatformSupportFactory;

public class JRFUtils {
    private static final Logger LOGGER = HttpClientLoggerFactory.getLogger(JRFUtils.class.getName());
    private static final String JRF_SPS_CLASSNAME = "oracle.jrf.ServerPlatformSupport";
    private static final ClassDetector jrfSPSDetector = new ClassDetector("oracle.jrf.ServerPlatformSupport");

    public static boolean isExalogicOptimizationsEnabled() {
        boolean exOptEnabled;
        block5: {
            exOptEnabled = false;
            if (jrfSPSDetector.isClassAvailable()) {
                try {
                    exOptEnabled = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                        @Override
                        public Boolean run() throws Exception {
                            ServerPlatformSupport jrfSPS = ServerPlatformSupportFactory.getInstance();
                            return jrfSPS.isExalogicOptimizationsEnabled();
                        }
                    });
                }
                catch (Exception e) {
                    if (e instanceof PrivilegedActionException) {
                        e = ((PrivilegedActionException)e).getException();
                    }
                    if (!LOGGER.isLoggable(Level.FINE)) break block5;
                    LOGGER.log(Level.FINE, "Unable to determine the Exalogic Optimization flag.", e);
                }
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Exalogic optimization enabled is \"{0}\".", exOptEnabled);
        }
        return exOptEnabled;
    }

    public static String getContextId() {
        String contextId;
        block4: {
            JRFUtils.checkAvailable();
            contextId = null;
            try {
                contextId = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() throws Exception {
                        ServerPlatformSupport helper = ServerPlatformSupportFactory.getInstance();
                        return helper.getApplicationIdentifier().getDisplayName();
                    }
                });
            }
            catch (Exception e) {
                if (e instanceof PrivilegedActionException) {
                    e = ((PrivilegedActionException)e).getException();
                }
                if (!LOGGER.isLoggable(Level.FINE)) break block4;
                LOGGER.log(Level.FINE, "Unable to read application runtime name for context id.", e);
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Current reported context id \"{0}\".", contextId);
        }
        return contextId;
    }

    static void checkAvailable() {
        if (!JRFUtils.isAvailable()) {
            throw new IllegalStateException("oracle.jrf.ServerPlatformSupport is unavailable.");
        }
    }

    public static boolean isAvailable() {
        return jrfSPSDetector.isClassAvailable();
    }
}

