/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient.config;

import HTTPClient.config.SystemPropertiesProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JVMSystemPropertiesProvider
implements SystemPropertiesProvider {
    JVMSystemPropertiesProvider() {
    }

    @Override
    public String getValue(String name) {
        return JVMSystemPropertiesProvider.readSystemProperty(name);
    }

    @Override
    public Map<String, String> getProperties() {
        Properties sysprops = (Properties)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperties();
            }
        });
        return JVMSystemPropertiesProvider.toUnmodifiableMap(sysprops);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    static String readSystemProperty(final String name) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(name);
            }
        });
    }

    static Map<String, String> toUnmodifiableMap(Properties sysprops) {
        HashMap<String, String> map = new HashMap<String, String>(sysprops.size());
        Enumeration<?> e = sysprops.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            map.put(key, sysprops.getProperty(key));
        }
        return Collections.unmodifiableMap(map);
    }
}

