/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient.config;

import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.config.ConfigurationContextProvider;
import HTTPClient.config.ContextRemovalListener;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;

class OC4JContextProvider
implements ConfigurationContextProvider {
    private static final String IMPLEMENTATION_CLASSNAME = "oracle.security.jazn.ApplicationServerProxy";
    private static final String IMPLEMENTATION_METHODNAME = "getApplicationName";
    private static final Logger LOGGER = HttpClientLoggerFactory.getLogger(OC4JContextProvider.class.getName());
    private static final Method GET_APPLICATION_NAME_METHOD;

    OC4JContextProvider() {
    }

    public String getContextId() {
        this.checkAvailable();
        String contextId = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String appName;
                block2: {
                    appName = null;
                    try {
                        appName = (String)GET_APPLICATION_NAME_METHOD.invoke(null, null);
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block2;
                        LOGGER.log(Level.FINE, "OC4JContextProvider implementation failed execution, oracle.security.jazn.ApplicationServerProxy.getApplicationName", e);
                    }
                }
                return appName;
            }
        });
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Current reported context id \"{0}\".", contextId);
        }
        return contextId;
    }

    public boolean isAvailable() {
        return GET_APPLICATION_NAME_METHOD != null;
    }

    public void registerContextRemovalListener(ContextRemovalListener listener) {
    }

    private void checkAvailable() {
        if (!this.isAvailable()) {
            throw new IllegalStateException(this.getClass().getName() + " is unavailable, since " + IMPLEMENTATION_CLASSNAME + "." + IMPLEMENTATION_METHODNAME + " is unavailable.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Method method = null;
        try {
            method = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    Class<?> clazz = Class.forName(OC4JContextProvider.IMPLEMENTATION_CLASSNAME);
                    if (null != clazz) {
                        return clazz.getMethod(OC4JContextProvider.IMPLEMENTATION_METHODNAME, null);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof PrivilegedActionException) {
                e = ((PrivilegedActionException)e).getException();
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "OC4JContextProvider implementation is unavailable, oracle.security.jazn.ApplicationServerProxy.getApplicationName", e);
            }
        }
        finally {
            GET_APPLICATION_NAME_METHOD = method;
        }
    }
}

