/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient.config;

import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.config.PropertyInitializer;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Property {
    private static final Logger logger = HttpClientLoggerFactory.getLogger(Property.class.getName());
    private static final List<Property> propertyList = new CopyOnWriteArrayList<Property>();
    private static volatile boolean allInitOk = true;
    private final String name;
    private final Class valueClass;
    private final Object defaultValue;
    private final PropertyInitializer propertyInitializer;
    private final boolean valid;
    private final boolean isFinal;

    Property(String name, Class valueClass, Object defaultValue, PropertyInitializer propertyInitializer, boolean isFinal) {
        boolean valid;
        block2: {
            valid = true;
            try {
                this.coreValidation(name, valueClass, defaultValue);
                this.additionalValidation(name, valueClass, defaultValue, propertyInitializer);
            }
            catch (Exception e) {
                valid = false;
                allInitOk = false;
                if (!logger.isLoggable(Level.FINE)) break block2;
                logger.log(Level.FINE, "Unable to init Property \"" + name + "\".", e);
            }
        }
        this.valid = valid;
        this.name = name;
        this.valueClass = valueClass;
        this.defaultValue = defaultValue;
        this.propertyInitializer = propertyInitializer;
        this.isFinal = isFinal;
        propertyList.add(this);
    }

    public final boolean isValid() {
        return this.valid;
    }

    public final String getName() {
        return this.name;
    }

    public final Class getValueClass() {
        return this.valueClass;
    }

    public final Object getDefaultValue() {
        return this.defaultValue;
    }

    public final PropertyInitializer getPropertyInitializer() {
        return this.propertyInitializer;
    }

    public final boolean isFinal() {
        return this.isFinal;
    }

    public final String toString() {
        return this.getName();
    }

    public final boolean equals(Object that) {
        return super.equals(that);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public static final boolean isAllInitOk() {
        return allInitOk;
    }

    static final void setAllInitOk(boolean value) {
        allInitOk = value;
    }

    private void coreValidation(String name, Class valueClass, Object defaultValue) throws Exception {
        if (null == valueClass) {
            throw new IllegalArgumentException("Non-null valueClass expected.");
        }
        if (null != defaultValue && !valueClass.isInstance(defaultValue)) {
            throw new IllegalArgumentException("defaultValue \"" + defaultValue + "\" is unassignable to property \"" + name + "\" expecting value of class \"" + valueClass.getName() + "\".");
        }
    }

    void additionalValidation(String name, Class valueClass, Object defaultValue, PropertyInitializer propertyInitializer) throws Exception {
    }

    public static final List<Property> getPropertyList() {
        return Collections.unmodifiableList(propertyList);
    }
}

