/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient.config;

import HTTPClient.config.Property;
import HTTPClient.config.PropertyInitializer;
import HTTPClient.config.SystemPropertyInitializer;
import java.util.List;

public final class SystemProperty
extends Property {
    SystemProperty(String name, Class valueClass, Object defaultValue, PropertyInitializer propertyInitializer, boolean isFinal) {
        super(name, valueClass, defaultValue, propertyInitializer, isFinal);
    }

    void additionalValidation(String name, Class valueClass, Object defaultValue, PropertyInitializer propertyInitializer) throws Exception {
        if (null == name || "".equals(name.trim())) {
            throw new IllegalArgumentException("A system property must have a name.");
        }
        if (null == SystemPropertyInitializer.getAssignableTo(valueClass) && null == propertyInitializer) {
            throw new IllegalArgumentException("System property \"" + name + "\" cannot be initialized to class \"" + valueClass + "\" without a propertyInitializer.");
        }
        List<Property> props = Property.getPropertyList();
        for (Property prop : props) {
            if (!prop.isValid() || !(prop instanceof SystemProperty) || !prop.getName().equals(name)) continue;
            throw new IllegalArgumentException("System property \"" + name + "\" has a non-unique name among SystemProperty instances.");
        }
    }
}

