/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient.config;

import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.config.Configuration;
import HTTPClient.config.Property;
import HTTPClient.config.PropertyInitializer;
import HTTPClient.config.SystemProperty;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SystemPropertyInitializer
implements PropertyInitializer {
    public static final SystemPropertyInitializer STRING_INITIALIZER = new String();
    public static final SystemPropertyInitializer DOUBLE_INITIALIZER = new Double();
    private static final ConcurrentHashMap<Class, SystemPropertyInitializer> resultClassMap = new ConcurrentHashMap(20);
    private static final Logger logger;

    SystemPropertyInitializer() {
    }

    static final PropertyInitializer getInitializer(Class clazz) {
        if (null == clazz) {
            throw new IllegalArgumentException("Non-null class expected.");
        }
        return resultClassMap.get(clazz);
    }

    static final PropertyInitializer getAssignableTo(Class fieldClass) {
        if (null == fieldClass) {
            throw new IllegalArgumentException("Non-null fieldClass expected.");
        }
        PropertyInitializer initializer = SystemPropertyInitializer.getInitializer(fieldClass);
        if (initializer != null) {
            return initializer;
        }
        if (fieldClass.isAssignableFrom(java.lang.String.class)) {
            return STRING_INITIALIZER;
        }
        return null;
    }

    @Override
    public final void initialize(Property property, Configuration config) throws Exception {
        if (null == property) {
            throw new IllegalArgumentException("Non-null property expected");
        }
        if (null == config) {
            throw new IllegalArgumentException("Non-null Configuration expected");
        }
        if (!property.isValid()) {
            throw new IllegalArgumentException(property + " property is not valid.");
        }
        if (!(property instanceof SystemProperty)) {
            throw new IllegalArgumentException(property + " must be a system property.");
        }
        Map<java.lang.String, java.lang.String> rawSysProps = config.getRawSystemProperties();
        if (null == rawSysProps) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Unable to initialize {0} due to null system properties.", property);
            }
        } else {
            Object currValue;
            Object result;
            block11: {
                java.lang.String propValue = rawSysProps.get(property.getName());
                result = null;
                if (null != propValue) {
                    try {
                        result = this.convertValue(propValue);
                    }
                    catch (NumberFormatException e) {
                        if (!logger.isLoggable(Level.FINE)) break block11;
                        logger.log(Level.FINE, "System Property {0} has value \"{1}\" which is badly formatted for {2}.", new Object[]{property.getName(), propValue, property.getValueClass()});
                    }
                }
            }
            if (null == (currValue = config.getValue(property)) && null != result || null != currValue && null == result || null != currValue && null != result && !currValue.equals(result)) {
                config.setValue(property, result);
            }
        }
    }

    protected abstract Object convertValue(java.lang.String var1) throws Exception;

    static final Map<Class, SystemPropertyInitializer> getResultClassMap() {
        return Collections.unmodifiableMap(resultClassMap);
    }

    static {
        resultClassMap.put(java.lang.Boolean.class, new Boolean());
        resultClassMap.put(java.lang.Byte.class, new Byte());
        resultClassMap.put(java.lang.Double.class, DOUBLE_INITIALIZER);
        resultClassMap.put(java.lang.Float.class, new Float());
        resultClassMap.put(java.lang.Integer.class, new Integer());
        resultClassMap.put(java.lang.Long.class, new Long());
        resultClassMap.put(java.lang.Short.class, new Short());
        resultClassMap.put(java.lang.String.class, STRING_INITIALIZER);
        resultClassMap.put(Object.class, STRING_INITIALIZER);
        resultClassMap.put(Number.class, DOUBLE_INITIALIZER);
        logger = HttpClientLoggerFactory.getLogger(SystemPropertyInitializer.class.getName());
    }

    private static class String
    extends SystemPropertyInitializer {
        private String() {
        }

        protected Object convertValue(java.lang.String systemPropertyValue) throws Exception {
            return systemPropertyValue;
        }
    }

    private static class Short
    extends SystemPropertyInitializer {
        private Short() {
        }

        protected Object convertValue(java.lang.String systemPropertyValue) throws Exception {
            return java.lang.Short.valueOf(systemPropertyValue);
        }
    }

    private static class Long
    extends SystemPropertyInitializer {
        private Long() {
        }

        protected Object convertValue(java.lang.String systemPropertyValue) throws Exception {
            return java.lang.Long.valueOf(systemPropertyValue);
        }
    }

    private static class Integer
    extends SystemPropertyInitializer {
        private Integer() {
        }

        protected Object convertValue(java.lang.String systemPropertyValue) throws Exception {
            return java.lang.Integer.valueOf(systemPropertyValue);
        }
    }

    private static class Float
    extends SystemPropertyInitializer {
        private Float() {
        }

        protected Object convertValue(java.lang.String systemPropertyValue) throws Exception {
            return java.lang.Float.valueOf(systemPropertyValue);
        }
    }

    private static class Double
    extends SystemPropertyInitializer {
        private Double() {
        }

        protected Object convertValue(java.lang.String systemPropertyValue) throws Exception {
            return java.lang.Double.valueOf(systemPropertyValue);
        }
    }

    private static class Byte
    extends SystemPropertyInitializer {
        private Byte() {
        }

        protected Object convertValue(java.lang.String systemPropertyValue) throws Exception {
            return java.lang.Byte.valueOf(systemPropertyValue);
        }
    }

    private static class Boolean
    extends SystemPropertyInitializer {
        private Boolean() {
        }

        protected Object convertValue(java.lang.String systemPropertyValue) throws Exception {
            return java.lang.Boolean.valueOf(systemPropertyValue);
        }
    }
}

