/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient.crypto;

public final class MD4 {
    private MD4State state = new MD4State();
    private MD4State old = new MD4State();
    private byte[] digestBits = new byte[16];
    private boolean digestValid = false;

    public int blockSize() {
        return 64;
    }

    public void init() {
        if (this.state != null) {
            this.state.init();
        }
        this.digestValid = false;
    }

    public void update(byte b) {
        byte[] buf = this.state.buf;
        int[] M = this.state.M;
        if (this.state.count == 64) {
            this.bytesToWords(buf, M);
            this.transform();
            this.state.count = 0;
        }
        buf[this.state.count++] = b;
        this.state.length += 8L;
        this.digestValid = false;
    }

    public void update(byte[] input, int off, int len) {
        this.digestValid = false;
        byte[] b = this.state.buf;
        int[] M = this.state.M;
        this.state.length += (long)(len << 3);
        while (len > 0) {
            int block = 64 - this.state.count;
            if (len < block) {
                System.arraycopy(input, off, b, this.state.count, len);
                this.state.count += len;
                len = 0;
                continue;
            }
            System.arraycopy(input, off, b, this.state.count, block);
            len -= block;
            off += block;
            this.bytesToWords(b, M);
            this.transform();
            this.state.count = 0;
        }
    }

    public void update(byte[] input) {
        this.update(input, 0, input.length);
    }

    public void computeCurrent() {
        this.state.copyTo(this.old);
        byte[] b = this.state.buf;
        int[] M = this.state.M;
        this.pad();
        this.update((byte)this.old.length);
        this.update((byte)(this.old.length >> 8));
        this.update((byte)(this.old.length >> 16));
        this.update((byte)(this.old.length >> 24));
        this.update((byte)(this.old.length >> 32));
        this.update((byte)(this.old.length >> 40));
        this.update((byte)(this.old.length >> 48));
        this.update((byte)(this.old.length >> 56));
        this.bytesToWords(b, M);
        this.transform();
        this.wordsToBytes(this.state.D, this.digestBits);
        this.digestValid = true;
        MD4State t = this.state;
        this.state = this.old;
        this.old = t;
    }

    public String algName() {
        return "MD4";
    }

    public int getDigestLength() {
        return 16;
    }

    public byte[] getDigestBits() {
        return (byte[])this.getDigestBitsInternal().clone();
    }

    byte[] getDigestBitsInternal() {
        return this.digestBits;
    }

    public boolean isValid() {
        return this.digestValid;
    }

    public Object clone() {
        MD4 md4 = new MD4();
        this.state.copyTo(md4.state);
        System.arraycopy(this.digestBits, 0, md4.digestBits, 0, this.digestBits.length);
        md4.digestValid = this.digestValid;
        return md4;
    }

    public byte[] computeDigest(byte[] bytes) {
        this.init();
        this.update(bytes);
        this.computeCurrent();
        return this.getDigestBits();
    }

    private int bytesToWord(byte b1, byte b2, byte b3, byte b4) {
        return b1 & 0xFF | (b2 & 0xFF) << 8 | (b3 & 0xFF) << 16 | (b4 & 0xFF) << 24;
    }

    private void bytesToWords(byte[] b, int[] w) {
        int len = w.length;
        int j = 0;
        for (int i = 0; i < len; ++i) {
            w[i] = b[j++] & 0xFF | (b[j++] & 0xFF) << 8 | (b[j++] & 0xFF) << 16 | (b[j++] & 0xFF) << 24;
        }
    }

    private void wordsToBytes(int[] w, byte[] b) {
        int len = w.length;
        int j = 0;
        for (int i = 0; i < len; ++i) {
            b[j++] = (byte)w[i];
            b[j++] = (byte)(w[i] >> 8);
            b[j++] = (byte)(w[i] >> 16);
            b[j++] = (byte)(w[i] >> 24);
        }
    }

    private static int rotl(int x, int s) {
        return x << s | x >>> 32 - s;
    }

    private static int FF(int a, int b, int c, int d, int[] M, int k, int s) {
        return MD4.rotl(a + (b & c | ~b & d) + M[k], s);
    }

    private static int GG(int a, int b, int c, int d, int[] M, int k, int s) {
        return MD4.rotl(a + (b & c | b & d | c & d) + M[k] + 1518500249, s);
    }

    private static int HH(int a, int b, int c, int d, int[] M, int k, int s) {
        return MD4.rotl(a + (b ^ c ^ d) + M[k] + 1859775393, s);
    }

    private void pad() {
        this.update((byte)-128);
        if (this.state.count > 56) {
            this.update(new byte[64 - this.state.count + 56]);
        } else if (this.state.count < 56) {
            this.update(new byte[56 - this.state.count]);
        }
    }

    private void transform() {
        int A = this.state.D[0];
        int B = this.state.D[1];
        int C = this.state.D[2];
        int D = this.state.D[3];
        int[] M = this.state.M;
        A = MD4.FF(A, B, C, D, M, 0, 3);
        D = MD4.FF(D, A, B, C, M, 1, 7);
        C = MD4.FF(C, D, A, B, M, 2, 11);
        B = MD4.FF(B, C, D, A, M, 3, 19);
        A = MD4.FF(A, B, C, D, M, 4, 3);
        D = MD4.FF(D, A, B, C, M, 5, 7);
        C = MD4.FF(C, D, A, B, M, 6, 11);
        B = MD4.FF(B, C, D, A, M, 7, 19);
        A = MD4.FF(A, B, C, D, M, 8, 3);
        D = MD4.FF(D, A, B, C, M, 9, 7);
        C = MD4.FF(C, D, A, B, M, 10, 11);
        B = MD4.FF(B, C, D, A, M, 11, 19);
        A = MD4.FF(A, B, C, D, M, 12, 3);
        D = MD4.FF(D, A, B, C, M, 13, 7);
        C = MD4.FF(C, D, A, B, M, 14, 11);
        B = MD4.FF(B, C, D, A, M, 15, 19);
        A = MD4.GG(A, B, C, D, M, 0, 3);
        D = MD4.GG(D, A, B, C, M, 4, 5);
        C = MD4.GG(C, D, A, B, M, 8, 9);
        B = MD4.GG(B, C, D, A, M, 12, 13);
        A = MD4.GG(A, B, C, D, M, 1, 3);
        D = MD4.GG(D, A, B, C, M, 5, 5);
        C = MD4.GG(C, D, A, B, M, 9, 9);
        B = MD4.GG(B, C, D, A, M, 13, 13);
        A = MD4.GG(A, B, C, D, M, 2, 3);
        D = MD4.GG(D, A, B, C, M, 6, 5);
        C = MD4.GG(C, D, A, B, M, 10, 9);
        B = MD4.GG(B, C, D, A, M, 14, 13);
        A = MD4.GG(A, B, C, D, M, 3, 3);
        D = MD4.GG(D, A, B, C, M, 7, 5);
        C = MD4.GG(C, D, A, B, M, 11, 9);
        B = MD4.GG(B, C, D, A, M, 15, 13);
        A = MD4.HH(A, B, C, D, M, 0, 3);
        D = MD4.HH(D, A, B, C, M, 8, 9);
        C = MD4.HH(C, D, A, B, M, 4, 11);
        B = MD4.HH(B, C, D, A, M, 12, 15);
        A = MD4.HH(A, B, C, D, M, 2, 3);
        D = MD4.HH(D, A, B, C, M, 10, 9);
        C = MD4.HH(C, D, A, B, M, 6, 11);
        B = MD4.HH(B, C, D, A, M, 14, 15);
        A = MD4.HH(A, B, C, D, M, 1, 3);
        D = MD4.HH(D, A, B, C, M, 9, 9);
        C = MD4.HH(C, D, A, B, M, 5, 11);
        B = MD4.HH(B, C, D, A, M, 13, 15);
        A = MD4.HH(A, B, C, D, M, 3, 3);
        D = MD4.HH(D, A, B, C, M, 11, 9);
        C = MD4.HH(C, D, A, B, M, 7, 11);
        B = MD4.HH(B, C, D, A, M, 15, 15);
        this.state.D[0] = this.state.D[0] + A;
        this.state.D[1] = this.state.D[1] + B;
        this.state.D[2] = this.state.D[2] + C;
        this.state.D[3] = this.state.D[3] + D;
    }

    protected MD4State getState() {
        return this.state;
    }

    protected void setState(MD4State state) {
        state.copyTo(this.state);
        this.digestValid = false;
    }

    final class MD4State {
        byte[] buf = new byte[64];
        int[] M = new int[16];
        int[] D = new int[4];
        long length;
        int count;

        MD4State() {
            this.init();
        }

        public void init() {
            this.D[0] = 1732584193;
            this.D[1] = -271733879;
            this.D[2] = -1732584194;
            this.D[3] = 271733878;
            this.count = 0;
            this.length = 0;
        }

        public Object clone() {
            MD4State n = new MD4State();
            this.copyTo(n);
            return n;
        }

        public void copyTo(MD4State s) {
            if (this.getClass() != s.getClass()) {
                throw new IllegalArgumentException("MD4State required");
            }
            MD4State n = s;
            n.length = this.length;
            n.count = this.count;
            System.arraycopy(this.buf, 0, n.buf, 0, 64);
            System.arraycopy(this.D, 0, n.D, 0, 4);
        }
    }
}

