/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient.i18n;

import HTTPClient.AuthorizationInfo;
import HTTPClient.Cookie;
import HTTPClient.HTTPConnection;
import HTTPClient.URI;
import HTTPClient.i18n.HTTPClientMessageBundle;
import HTTPClient.i18n.HTTPClientMessageID;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.annotation.logging.MessageInfo;
import oracle.annotation.logging.Publish;
import oracle.annotation.logging.Severity;

public class HTTPClientMessages
implements HTTPClientMessageID {
    public static final String BASE_MESSAGE_BUNDLE_NAME = HTTPClientMessageBundle.class.getName();

    static String getString(String key) {
        ResourceBundle bundle;
        if (null == key) {
            key = "";
        }
        if (null == (bundle = ResourceBundle.getBundle(BASE_MESSAGE_BUNDLE_NAME))) {
            throw new IllegalStateException("Expected to find Resource Bundle based on '" + BASE_MESSAGE_BUNDLE_NAME + "'.");
        }
        return bundle.getString(key);
    }

    static String getFormattedString(String key, Object ... arguments) {
        String pattern = HTTPClientMessages.getString(key);
        String output = MessageFormat.format(pattern, arguments);
        return output;
    }

    static Logger getLogger(Logger logger) {
        if (null == logger) {
            throw new IllegalArgumentException("Unexpected null logger.");
        }
        return logger;
    }

    @MessageInfo(id="J2EE HTTPC-00000", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_testMessage() {
        return HTTPClientMessages.getString("J2EE HTTPC-00000");
    }

    @MessageInfo(id="J2EE HTTPC-00001", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_unexpectedNullOrEmptyString(String name) {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-00001", name);
    }

    @MessageInfo(id="J2EE HTTPC-00002", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_unexpectedNullObject(String name) {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-00002", name);
    }

    @MessageInfo(id="J2EE HTTPC-00003", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_objectNotInstanceOfClass(String objectName, String objectClassName, String expectedAncestorClassName) {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-00003", objectName, objectClassName, expectedAncestorClassName);
    }

    @MessageInfo(id="J2EE HTTPC-01000", severity=Severity.FINER, publish=Publish.YES)
    public static void log_unableToRegisterBuiltInAuthenticationScheme(Logger logger, String schemeClassName, Exception e) {
        HTTPClientMessages.getLogger(logger).log(Level.FINER, HTTPClientMessages.getFormattedString("J2EE HTTPC-01000", schemeClassName), e);
    }

    @MessageInfo(id="J2EE HTTPC-01001", severity=Severity.FINER, publish=Publish.YES)
    public static void log_unableToRegisterAuthenticationScheme(Logger logger, String schemeClassName, String schemeName, Exception e) {
        HTTPClientMessages.getLogger(logger).log(Level.FINER, HTTPClientMessages.getFormattedString("J2EE HTTPC-01001", schemeClassName, schemeName), e);
    }

    @MessageInfo(id="J2EE HTTPC-00004", severity=Severity.FINER, publish=Publish.YES)
    public static void log_unableToParseHeaderValue(Logger logger, String headerName, String headerValue, Exception e) {
        HTTPClientMessages.getLogger(logger).log(Level.FINER, HTTPClientMessages.getFormattedString("J2EE HTTPC-00004", headerName, headerValue), e);
    }

    @MessageInfo(id="J2EE HTTPC-01002", severity=Severity.FINER, publish=Publish.YES)
    public static void log_unableToAddNtlm_authorizationHandler_not_authenticationSchemeRegistryHolder(Logger logger) {
        HTTPClientMessages.getLogger(logger).log(Level.FINER, HTTPClientMessages.getFormattedString("J2EE HTTPC-01002", new Object[0]));
    }

    @MessageInfo(id="J2EE HTTPC-01003", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_authorizationHandler_not_authenticationSchemeRegistryHolder() {
        return HTTPClientMessages.getString("J2EE HTTPC-01003");
    }

    @MessageInfo(id="J2EE HTTPC-01004", severity=Severity.FINER, publish=Publish.YES)
    public static void log_unableToAddNtlm_unregisteredScheme(Logger logger) {
        HTTPClientMessages.getLogger(logger).log(Level.FINER, HTTPClientMessages.getFormattedString("J2EE HTTPC-01004", new Object[0]));
    }

    @MessageInfo(id="J2EE HTTPC-01005", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_ntlm_unregisteredScheme() {
        return HTTPClientMessages.getString("J2EE HTTPC-01005");
    }

    @MessageInfo(id="J2EE HTTPC-00005", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_unexpectedHttpStatusCode(int statusCode) {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-00005", statusCode);
    }

    @MessageInfo(id="J2EE HTTPC-01006", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_badAuthenticationHeader_comma(String challenge, int position) {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-01006", challenge, position);
    }

    @MessageInfo(id="J2EE HTTPC-01007", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_badAuthenticationHeader_eol(String challenge, int position) {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-01007", challenge, position);
    }

    @MessageInfo(id="J2EE HTTPC-01008", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_badAuthenticationHeader_token(String challenge, int position) {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-01008", challenge, position);
    }

    @MessageInfo(id="J2EE HTTPC-01009", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_badAuthenticationHeader_quote(String challenge, int position) {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-01009", challenge, position);
    }

    @MessageInfo(id="J2EE HTTPC-01010", severity=Severity.FINEST, publish=Publish.YES)
    public static void log_deferredAuthChallenge(Logger logger) {
        HTTPClientMessages.getLogger(logger).log(Level.FINEST, HTTPClientMessages.getFormattedString("J2EE HTTPC-01010", new Object[0]));
    }

    @MessageInfo(id="J2EE HTTPC-01011", severity=Severity.FINEST, publish=Publish.YES)
    public static void log_sendingAuthorization(Logger logger, AuthorizationInfo authorization) {
        HTTPClientMessages.getLogger(logger).log(Level.FINEST, HTTPClientMessages.getFormattedString("J2EE HTTPC-01011", authorization));
    }

    @MessageInfo(id="J2EE HTTPC-01012", severity=Severity.FINEST, publish=Publish.YES)
    public static void log_sendingAuthorization_forProxy(Logger logger, AuthorizationInfo authorization) {
        HTTPClientMessages.getLogger(logger).log(Level.FINEST, HTTPClientMessages.getFormattedString("J2EE HTTPC-01012", authorization));
    }

    @MessageInfo(id="J2EE HTTPC-01013", severity=Severity.FINEST, publish=Publish.YES)
    public static void log_preemptivelySendingAuthorization_forProxy(Logger logger, AuthorizationInfo authorization) {
        HTTPClientMessages.getLogger(logger).log(Level.FINEST, HTTPClientMessages.getFormattedString("J2EE HTTPC-01013", authorization));
    }

    @MessageInfo(id="J2EE HTTPC-01014", severity=Severity.FINEST, publish=Publish.YES)
    public static void log_preemptivelySendingAuthorization(Logger logger, AuthorizationInfo authorization) {
        HTTPClientMessages.getLogger(logger).log(Level.FINEST, HTTPClientMessages.getFormattedString("J2EE HTTPC-01014", authorization));
    }

    @MessageInfo(id="J2EE HTTPC-01015", severity=Severity.FINEST, publish=Publish.YES)
    public static void log_serverRefusedAuthorization(Logger logger, int tryCount) {
        HTTPClientMessages.getLogger(logger).log(Level.FINEST, HTTPClientMessages.getFormattedString("J2EE HTTPC-01015", tryCount));
    }

    @MessageInfo(id="J2EE HTTPC-01016", severity=Severity.FINEST, publish=Publish.YES)
    public static void log_unhandledAuthStatusWithStream(Logger logger, int statusCode) {
        HTTPClientMessages.getLogger(logger).log(Level.FINEST, HTTPClientMessages.getFormattedString("J2EE HTTPC-01016", statusCode));
    }

    @MessageInfo(id="J2EE HTTPC-01017", severity=Severity.FINEST, publish=Publish.YES)
    public static void log_deferredHandlingAuthStatusCauseStream(Logger logger, int statusCode) {
        HTTPClientMessages.getLogger(logger).log(Level.FINEST, HTTPClientMessages.getFormattedString("J2EE HTTPC-01017", statusCode));
    }

    @MessageInfo(id="J2EE HTTPC-01018", severity=Severity.FINEST, publish=Publish.YES)
    public static void log_handlingAuthStatus(Logger logger, int statusCode, String reasonLine) {
        HTTPClientMessages.getLogger(logger).log(Level.FINEST, HTTPClientMessages.getFormattedString("J2EE HTTPC-01018", statusCode, reasonLine));
    }

    @MessageInfo(id="J2EE HTTPC-01019", severity=Severity.FINEST, publish=Publish.YES)
    public static void log_resendingAuthorization(Logger logger, AuthorizationInfo authorization) {
        HTTPClientMessages.getLogger(logger).log(Level.FINEST, HTTPClientMessages.getFormattedString("J2EE HTTPC-01019", authorization));
    }

    @MessageInfo(id="J2EE HTTPC-01020", severity=Severity.FINEST, publish=Publish.YES)
    public static void log_resendingAuthorization_forProxy(Logger logger, AuthorizationInfo authorization) {
        HTTPClientMessages.getLogger(logger).log(Level.FINEST, HTTPClientMessages.getFormattedString("J2EE HTTPC-01020", authorization));
    }

    @MessageInfo(id="J2EE HTTPC-01021", severity=Severity.FINEST, publish=Publish.YES)
    public static void log_unhandledAuthStatusNoAuthInfo(Logger logger, int statusCode) {
        HTTPClientMessages.getLogger(logger).log(Level.FINEST, HTTPClientMessages.getFormattedString("J2EE HTTPC-01021", statusCode));
    }

    @MessageInfo(id="J2EE HTTPC-01022", severity=Severity.FINEST, publish=Publish.YES)
    public static void log_parsedAuthChallenges_title(Logger logger, int challengeCount) {
        HTTPClientMessages.getLogger(logger).log(Level.FINEST, HTTPClientMessages.getFormattedString("J2EE HTTPC-01022", challengeCount));
    }

    @MessageInfo(id="J2EE HTTPC-01023", severity=Severity.FINEST, publish=Publish.YES)
    public static void log_parsedAuthChallenges_item(Logger logger, AuthorizationInfo challenge) {
        HTTPClientMessages.getLogger(logger).log(Level.FINEST, HTTPClientMessages.getFormattedString("J2EE HTTPC-01023", challenge));
    }

    @MessageInfo(id="J2EE HTTPC-01024", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_missingWwwAuthenticateHeader() {
        return HTTPClientMessages.getString("J2EE HTTPC-01024");
    }

    @MessageInfo(id="J2EE HTTPC-01025", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_missingProxyAuthenticateHeader() {
        return HTTPClientMessages.getString("J2EE HTTPC-01025");
    }

    @MessageInfo(id="J2EE HTTPC-00006", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_bufferIsFull() {
        return HTTPClientMessages.getString("J2EE HTTPC-00006");
    }

    @MessageInfo(id="J2EE HTTPC-00007", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_prematureEndOfFile() {
        return HTTPClientMessages.getString("J2EE HTTPC-00007");
    }

    @MessageInfo(id="J2EE HTTPC-00008", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_chunkedTransferEncodedLengthDiscrepancy(int expectedLength, int writtenLength) {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-00008", expectedLength, writtenLength);
    }

    @MessageInfo(id="J2EE HTTPC-00009", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_chunkedTransferChunksTooLong(long maxLength, long actualLength) {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-00009", maxLength, actualLength);
    }

    @MessageInfo(id="J2EE HTTPC-00010", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_chunkedTransferReadPrematureEof(int expectedLength, int actualLength) {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-00010", expectedLength, actualLength);
    }

    @MessageInfo(id="J2EE HTTPC-00011", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_chunkedTransferBadFooterFormat(String line) {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-00011", line);
    }

    @MessageInfo(id="J2EE HTTPC-00012", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_chunkedTransferPrematureEofReadingLength() {
        return HTTPClientMessages.getString("J2EE HTTPC-00012");
    }

    @MessageInfo(id="J2EE HTTPC-00013", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_chunkedTransferInvalidLengthValue(String value) {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-00013", value);
    }

    @MessageInfo(id="J2EE HTTPC-00014", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_missingTokenInContext(String token, String context) {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-00014", token, context);
    }

    @MessageInfo(id="J2EE HTTPC-02000", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_contentEncodingInvalidQValue(String additionalDetail) {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-02000", additionalDetail);
    }

    @MessageInfo(id="J2EE HTTPC-02001", severity=Severity.FINEST, publish=Publish.YES)
    public static void log_contentEncodingUsingGzip(Logger logger) {
        HTTPClientMessages.getLogger(logger).log(Level.FINEST, HTTPClientMessages.getFormattedString("J2EE HTTPC-02001", new Object[0]));
    }

    @MessageInfo(id="J2EE HTTPC-02002", severity=Severity.FINEST, publish=Publish.YES)
    public static void log_contentEncodingUsingDeflate(Logger logger) {
        HTTPClientMessages.getLogger(logger).log(Level.FINEST, HTTPClientMessages.getFormattedString("J2EE HTTPC-02002", new Object[0]));
    }

    @MessageInfo(id="J2EE HTTPC-02003", severity=Severity.FINEST, publish=Publish.YES)
    public static void log_contentEncodingUsingCompress(Logger logger) {
        HTTPClientMessages.getLogger(logger).log(Level.FINEST, HTTPClientMessages.getFormattedString("J2EE HTTPC-02003", new Object[0]));
    }

    @MessageInfo(id="J2EE HTTPC-02004", severity=Severity.FINEST, publish=Publish.YES)
    public static void log_contentEncodingIgnoringIdentity(Logger logger) {
        HTTPClientMessages.getLogger(logger).log(Level.FINEST, HTTPClientMessages.getFormattedString("J2EE HTTPC-02004", new Object[0]));
    }

    @MessageInfo(id="J2EE HTTPC-03000", severity=Severity.FINEST, publish=Publish.YES)
    public static void log_contentMd5ReceivedDigest(Logger logger, String digest) {
        HTTPClientMessages.getLogger(logger).log(Level.FINEST, HTTPClientMessages.getFormattedString("J2EE HTTPC-03000", digest));
    }

    @MessageInfo(id="J2EE HTTPC-03001", severity=Severity.FINEST, publish=Publish.YES)
    public static void log_contentMd5ExpectingDigestInTrailer(Logger logger) {
        HTTPClientMessages.getLogger(logger).log(Level.FINEST, HTTPClientMessages.getFormattedString("J2EE HTTPC-03001", new Object[0]));
    }

    @MessageInfo(id="J2EE HTTPC-03002", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_contentMd5DigestMismatch(String expected, String actual) {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-03002", expected, actual);
    }

    @MessageInfo(id="J2EE HTTPC-04000", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_cookieMissingName() {
        return HTTPClientMessages.getString("J2EE HTTPC-04000");
    }

    @MessageInfo(id="J2EE HTTPC-04001", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_cookieMissingValue() {
        return HTTPClientMessages.getString("J2EE HTTPC-04001");
    }

    @MessageInfo(id="J2EE HTTPC-04002", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_cookieMissingDomain() {
        return HTTPClientMessages.getString("J2EE HTTPC-04002");
    }

    @MessageInfo(id="J2EE HTTPC-04003", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_cookieMissingPath() {
        return HTTPClientMessages.getString("J2EE HTTPC-04003");
    }

    @MessageInfo(id="J2EE HTTPC-04004", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_cookieBadSetCookieNoEquals(String headerValue, int position) {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-04004", headerValue, position);
    }

    @MessageInfo(id="J2EE HTTPC-04005", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_cookieBadSetCookieNoCommaSemicolon(String headerValue, int position) {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-04005", headerValue, position);
    }

    @MessageInfo(id="J2EE HTTPC-04006", severity=Severity.FINE, publish=Publish.YES)
    public static void log_cookieBadSetCookieNoEquals_published(Logger logger, String headerValue, int position) {
        HTTPClientMessages.getLogger(logger).log(Level.FINE, HTTPClientMessages.getFormattedString("J2EE HTTPC-04006", headerValue, position));
    }

    @MessageInfo(id="J2EE HTTPC-04009", severity=Severity.FINE, publish=Publish.YES)
    public static void log_cookieBadSetCookieMaxAgeNegative(Logger logger, String headerValue, String maxAgeString) {
        HTTPClientMessages.getLogger(logger).log(Level.FINE, HTTPClientMessages.getFormattedString("J2EE HTTPC-04009", headerValue, maxAgeString));
    }

    @MessageInfo(id="J2EE HTTPC-04010", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_cookieBadSetCookieMaxAgeNotANumber(String headerValue, String maxAgeString) {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-04010", headerValue, maxAgeString);
    }

    @MessageInfo(id="J2EE HTTPC-02005", severity=Severity.FINE, publish=Publish.YES)
    public static void log_contentEncodingUnknown(Logger logger, String encoding) {
        HTTPClientMessages.getLogger(logger).log(Level.FINE, HTTPClientMessages.getFormattedString("J2EE HTTPC-02005", encoding));
    }

    @MessageInfo(id="J2EE HTTPC-04007", severity=Severity.FINE, publish=Publish.YES)
    public static void log_cookieIgnoringCookie(Logger logger, Cookie cookie) {
        HTTPClientMessages.getLogger(logger).log(Level.FINE, HTTPClientMessages.getFormattedString("J2EE HTTPC-04007", cookie));
    }

    @MessageInfo(id="J2EE HTTPC-04008", severity=Severity.FINE, publish=Publish.YES)
    public static void log_cookieBadSetCookieBadDate(Logger logger, String headerValue, String dateString) {
        HTTPClientMessages.getLogger(logger).log(Level.FINE, HTTPClientMessages.getFormattedString("J2EE HTTPC-04008", headerValue, dateString));
    }

    @MessageInfo(id="J2EE HTTPC-04011", severity=Severity.FINE, publish=Publish.YES)
    public static void log_cookieBadSetCookieDomainEmpty(Logger logger, String headerValue) {
        HTTPClientMessages.getLogger(logger).log(Level.FINE, HTTPClientMessages.getFormattedString("J2EE HTTPC-04011", headerValue));
    }

    @MessageInfo(id="J2EE HTTPC-04012", severity=Severity.FINE, publish=Publish.YES)
    public static void log_cookieBadSetCookieDomainMismatch(Logger logger, String headerValue, String currentDomain, String givenDomain) {
        HTTPClientMessages.getLogger(logger).log(Level.FINE, HTTPClientMessages.getFormattedString("J2EE HTTPC-04012", headerValue, currentDomain, givenDomain));
    }

    @MessageInfo(id="J2EE HTTPC-04013", severity=Severity.FINE, publish=Publish.YES)
    public static void log_cookieBadSetCookieDomainInsufficient(Logger logger, String headerValue, String givenDomain) {
        HTTPClientMessages.getLogger(logger).log(Level.FINE, HTTPClientMessages.getFormattedString("J2EE HTTPC-04013", headerValue, givenDomain));
    }

    @MessageInfo(id="J2EE HTTPC-04014", severity=Severity.FINE, publish=Publish.YES)
    public static void log_cookieBadSetCookieDomainTooDistant(Logger logger, String headerValue, String givenDomain, String currentDomain) {
        HTTPClientMessages.getLogger(logger).log(Level.FINE, HTTPClientMessages.getFormattedString("J2EE HTTPC-04014", headerValue, givenDomain, currentDomain));
    }

    @MessageInfo(id="J2EE HTTPC-04020", severity=Severity.FINE, publish=Publish.YES)
    public static void log_cookieRemoveTLDFromExtendedTLDs(Logger logger, String domain) {
        HTTPClientMessages.getLogger(logger).log(Level.FINE, HTTPClientMessages.getFormattedString("J2EE HTTPC-04020", domain));
    }

    @MessageInfo(id="J2EE HTTPC-04015", severity=Severity.FINE, publish=Publish.YES)
    public static void log_cookie2_badSetCookie2_pathNotPrefix(Logger logger, String headerValue, String path, String uri) {
        HTTPClientMessages.getLogger(logger).log(Level.FINE, HTTPClientMessages.getFormattedString("J2EE HTTPC-04015", headerValue, path, uri));
    }

    @MessageInfo(id="J2EE HTTPC-04016", severity=Severity.FINE, publish=Publish.YES)
    public static void log_cookie2_badSetCookie2_domainInsufficient(Logger logger, String headerValue, String domain) {
        HTTPClientMessages.getLogger(logger).log(Level.FINE, HTTPClientMessages.getFormattedString("J2EE HTTPC-04016", headerValue, domain));
    }

    @MessageInfo(id="J2EE HTTPC-04017", severity=Severity.FINE, publish=Publish.YES)
    public static void log_cookie2_badSetCookie2_domainDoesntMatchHost(Logger logger, String headerValue, String domain, String host) {
        HTTPClientMessages.getLogger(logger).log(Level.FINE, HTTPClientMessages.getFormattedString("J2EE HTTPC-04017", headerValue, domain, host));
    }

    @MessageInfo(id="J2EE HTTPC-04018", severity=Severity.FINE, publish=Publish.YES)
    public static void log_cookie2_badSetCookie2_domainTooDistant(Logger logger, String headerValue, String domain, String host) {
        HTTPClientMessages.getLogger(logger).log(Level.FINE, HTTPClientMessages.getFormattedString("J2EE HTTPC-04018", headerValue, domain, host));
    }

    @MessageInfo(id="J2EE HTTPC-04019", severity=Severity.FINE, publish=Publish.YES)
    public static void log_cookie2_badSetCookie2_unlistedPort(Logger logger, String headerValue, int port) {
        HTTPClientMessages.getLogger(logger).log(Level.FINE, HTTPClientMessages.getFormattedString("J2EE HTTPC-04019", headerValue, port));
    }

    @MessageInfo(id="J2EE HTTPC-11000", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_simpleAuthPopup_socks5_line1() {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11000", new Object[0]);
    }

    @MessageInfo(id="J2EE HTTPC-11001", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_simpleAuthPopup_socks5_line2(String host) {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11001", host);
    }

    @MessageInfo(id="J2EE HTTPC-11002", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_simpleAuthPopup_socks5_line3() {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11002", new Object[0]);
    }

    @MessageInfo(id="J2EE HTTPC-11003", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_simpleAuthPopup_other_line1(String realm) {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11003", realm);
    }

    @MessageInfo(id="J2EE HTTPC-11004", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_simpleAuthPopup_other_line2(String host, int port) {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11004", host, port);
    }

    @MessageInfo(id="J2EE HTTPC-11005", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_simpleAuthPopup_other_line3(String scheme) {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11005", scheme);
    }

    @MessageInfo(id="J2EE HTTPC-11006", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_simpleAuthPopup_title() {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11006", new Object[0]);
    }

    @MessageInfo(id="J2EE HTTPC-11007", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_simpleAuthPopup_label_username() {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11007", new Object[0]);
    }

    @MessageInfo(id="J2EE HTTPC-11008", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_simpleAuthPopup_label_password() {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11008", new Object[0]);
    }

    @MessageInfo(id="J2EE HTTPC-11009", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_simpleAuthPopup_button_ok() {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11009", new Object[0]);
    }

    @MessageInfo(id="J2EE HTTPC-11010", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_simpleAuthPopup_button_clear() {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11010", new Object[0]);
    }

    @MessageInfo(id="J2EE HTTPC-11011", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_simpleAuthPopup_button_cancel() {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11011", new Object[0]);
    }

    @MessageInfo(id="J2EE HTTPC-11100", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_simpleAuthPrompt_socks5_line1(String host) {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11100", host);
    }

    @MessageInfo(id="J2EE HTTPC-11101", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_simpleAuthPrompt_socks5_line2() {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11101", new Object[0]);
    }

    @MessageInfo(id="J2EE HTTPC-11102", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_simpleAuthPrompt_other_line1(String realm, String host, int port) {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11102", realm, host, port);
    }

    @MessageInfo(id="J2EE HTTPC-11103", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_simpleAuthPrompt_other_line2(String scheme) {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11103", scheme);
    }

    @MessageInfo(id="J2EE HTTPC-11104", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_simpleAuthPrompt_label_username() {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11104", new Object[0]);
    }

    @MessageInfo(id="J2EE HTTPC-11105", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_simpleAuthPrompt_label_password() {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11105", new Object[0]);
    }

    @MessageInfo(id="J2EE HTTPC-11200", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_basicCookieBox_title() {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11200", new Object[0]);
    }

    @MessageInfo(id="J2EE HTTPC-11201", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_basicCookieBox_intro() {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11201", new Object[0]);
    }

    @MessageInfo(id="J2EE HTTPC-11202", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_basicCookieBox_namevalue() {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11202", new Object[0]);
    }

    @MessageInfo(id="J2EE HTTPC-11203", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_basicCookieBox_domain() {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11203", new Object[0]);
    }

    @MessageInfo(id="J2EE HTTPC-11204", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_basicCookieBox_path() {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11204", new Object[0]);
    }

    @MessageInfo(id="J2EE HTTPC-11205", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_basicCookieBox_expires() {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11205", new Object[0]);
    }

    @MessageInfo(id="J2EE HTTPC-11206", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_basicCookieBox_ports() {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11206", new Object[0]);
    }

    @MessageInfo(id="J2EE HTTPC-11207", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_basicCookieBox_securenote() {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11207", new Object[0]);
    }

    @MessageInfo(id="J2EE HTTPC-11208", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_basicCookieBox_discardnote() {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11208", new Object[0]);
    }

    @MessageInfo(id="J2EE HTTPC-11209", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_basicCookieBox_comment() {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11209", new Object[0]);
    }

    @MessageInfo(id="J2EE HTTPC-11210", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_basicCookieBox_button_accept() {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11210", new Object[0]);
    }

    @MessageInfo(id="J2EE HTTPC-11211", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_basicCookieBox_button_reject() {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11211", new Object[0]);
    }

    @MessageInfo(id="J2EE HTTPC-11212", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_basicCookieBox_acceptrejectallfromdomain() {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11212", new Object[0]);
    }

    @MessageInfo(id="J2EE HTTPC-11213", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_basicCookieBox_hostdomain() {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11213", new Object[0]);
    }

    @MessageInfo(id="J2EE HTTPC-11214", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_basicCookieBox_domainleadingdot() {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11214", new Object[0]);
    }

    @MessageInfo(id="J2EE HTTPC-11215", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_basicCookieBox_emptymatchesallhosts() {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11215", new Object[0]);
    }

    @MessageInfo(id="J2EE HTTPC-11216", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_basicCookieBox_button_acceptall() {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11216", new Object[0]);
    }

    @MessageInfo(id="J2EE HTTPC-11217", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_basicCookieBox_button_rejectall() {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11217", new Object[0]);
    }

    @MessageInfo(id="J2EE HTTPC-11218", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_basicCookieBox_never() {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11218", new Object[0]);
    }

    @MessageInfo(id="J2EE HTTPC-11219", severity=Severity.SKIP, publish=Publish.NO)
    public static String msg_basicCookieBox_formoreinfo(URI commentUri) {
        return HTTPClientMessages.getFormattedString("J2EE HTTPC-11219", commentUri);
    }

    @MessageInfo(id="J2EE HTTPC-12000", severity=Severity.CONFIG, publish=Publish.YES)
    public static void log_config_maxAuthRetries(Logger logger, int maxRetries) {
        HTTPClientMessages.getLogger(logger).log(Level.CONFIG, HTTPClientMessages.getFormattedString("J2EE HTTPC-12000", maxRetries));
    }

    @MessageInfo(id="J2EE HTTPC-05000", severity=Severity.FINE, publish=Publish.YES)
    public static void log_unhandledStatus(Logger logger, int status, String reason) {
        HTTPClientMessages.getLogger(logger).log(Level.FINE, HTTPClientMessages.getFormattedString("J2EE HTTPC-05000", status, reason));
    }

    @MessageInfo(id="J2EE HTTPC-05001", severity=Severity.FINE, publish=Publish.YES)
    public static void log_status411(Logger logger, String message) {
        HTTPClientMessages.getLogger(logger).log(Level.FINE, HTTPClientMessages.getFormattedString("J2EE HTTPC-05001", message));
    }

    @MessageInfo(id="J2EE HTTPC-00015", severity=Severity.FINE, publish=Publish.YES)
    public static void log_unableToReadResponse_methodPath(Logger logger, String method, String pathAndQuery, Exception e) {
        HTTPClientMessages.getLogger(logger).log(Level.FINE, HTTPClientMessages.getFormattedString("J2EE HTTPC-00015", method, pathAndQuery), e);
    }

    @MessageInfo(id="J2EE HTTPC-00016", severity=Severity.FINE, publish=Publish.YES)
    public static void log_unableToReadResponse_streamHash(Logger logger, int hashcode, Exception e) {
        HTTPClientMessages.getLogger(logger).log(Level.FINE, HTTPClientMessages.getFormattedString("J2EE HTTPC-00016", hashcode), e);
    }

    @MessageInfo(id="J2EE HTTPC-00017", severity=Severity.FINE, publish=Publish.YES)
    public static void log_socks_v4RequestFailed(Logger logger, String message, Exception e) {
        HTTPClientMessages.getLogger(logger).log(Level.FINE, HTTPClientMessages.getFormattedString("J2EE HTTPC-00017", message), e);
    }

    @MessageInfo(id="J2EE HTTPC-03003", severity=Severity.FINEST, publish=Publish.YES)
    public static void log_contentMd5HashVerified(Logger logger) {
        HTTPClientMessages.getLogger(logger).log(Level.FINEST, HTTPClientMessages.getString("J2EE HTTPC-03003"));
    }

    @MessageInfo(id="J2EE HTTPC-12001", severity=Severity.CONFIG, publish=Publish.YES)
    public static void log_config_feature_enabled(Logger logger, String feature) {
        HTTPClientMessages.getLogger(logger).log(Level.CONFIG, HTTPClientMessages.getFormattedString("J2EE HTTPC-12001", feature));
    }

    @MessageInfo(id="J2EE HTTPC-12002", severity=Severity.CONFIG, publish=Publish.YES)
    public static void log_config_feature_disabled(Logger logger, String feature) {
        HTTPClientMessages.getLogger(logger).log(Level.CONFIG, HTTPClientMessages.getFormattedString("J2EE HTTPC-12002", feature));
    }

    @MessageInfo(id="J2EE HTTPC-12003", severity=Severity.CONFIG, publish=Publish.YES)
    public static void log_config_version(Logger logger, String version) {
        HTTPClientMessages.getLogger(logger).log(Level.CONFIG, HTTPClientMessages.getFormattedString("J2EE HTTPC-12003", version));
    }

    @MessageInfo(id="J2EE HTTPC-12004", severity=Severity.CONFIG, publish=Publish.YES)
    public static void log_config_deferResponseHandlingForStreamedRequests(Logger logger) {
        HTTPClientMessages.getLogger(logger).log(Level.CONFIG, HTTPClientMessages.getString("J2EE HTTPC-12004"));
    }

    @MessageInfo(id="J2EE HTTPC-12005", severity=Severity.CONFIG, publish=Publish.YES)
    public static void log_config_socketIdleTimeout(Logger logger, int seconds) {
        HTTPClientMessages.getLogger(logger).log(Level.CONFIG, HTTPClientMessages.getFormattedString("J2EE HTTPC-12005", seconds));
    }

    @MessageInfo(id="J2EE HTTPC-12010", severity=Severity.CONFIG, publish=Publish.YES)
    public static void log_config_socketConnectionTimeout(Logger logger, int seconds) {
        HTTPClientMessages.getLogger(logger).log(Level.CONFIG, HTTPClientMessages.getFormattedString("J2EE HTTPC-12010", seconds));
    }

    @MessageInfo(id="J2EE HTTPC-12011", severity=Severity.CONFIG, publish=Publish.YES)
    public static void log_config_socketReadTimeout(Logger logger, int seconds) {
        HTTPClientMessages.getLogger(logger).log(Level.CONFIG, HTTPClientMessages.getFormattedString("J2EE HTTPC-12011", seconds));
    }

    @MessageInfo(id="J2EE HTTPC-12006", severity=Severity.CONFIG, publish=Publish.YES)
    public static void log_config_addedModule(Logger logger, String moduleName) {
        HTTPClientMessages.getLogger(logger).log(Level.CONFIG, HTTPClientMessages.getFormattedString("J2EE HTTPC-12006", moduleName));
    }

    @MessageInfo(id="J2EE HTTPC-12007", severity=Severity.CONFIG, publish=Publish.YES)
    public static void log_config_addedModuleToList(Logger logger, String moduleName, String listName) {
        HTTPClientMessages.getLogger(logger).log(Level.CONFIG, HTTPClientMessages.getFormattedString("J2EE HTTPC-12007", moduleName, listName));
    }

    @MessageInfo(id="J2EE HTTPC-12008", severity=Severity.CONFIG, publish=Publish.YES)
    public static void log_config_removedModuleFromList(Logger logger, String moduleName, String listName) {
        HTTPClientMessages.getLogger(logger).log(Level.CONFIG, HTTPClientMessages.getFormattedString("J2EE HTTPC-12008", moduleName, listName));
    }

    @MessageInfo(id="J2EE HTTPC-12009", severity=Severity.CONFIG, publish=Publish.YES)
    public static void log_config_defaultProxy(Logger logger, String host, int port) {
        HTTPClientMessages.getLogger(logger).log(Level.CONFIG, HTTPClientMessages.getFormattedString("J2EE HTTPC-12009", host, port));
    }

    @MessageInfo(id="J2EE HTTPC-09000", severity=Severity.FINEST, publish=Publish.YES)
    public static void log_connection_chunkingEnabled(Logger logger, HTTPConnection conn, boolean enabled) {
        if (logger.isLoggable(Level.FINEST)) {
            HTTPClientMessages.getLogger(logger).log(Level.FINEST, HTTPClientMessages.getFormattedString("J2EE HTTPC-09000", conn, enabled));
        }
    }

    @MessageInfo(id="J2EE HTTPC-09001", severity=Severity.FINEST, publish=Publish.YES)
    public static void log_connection_chunkSize(Logger logger, HTTPConnection conn, int chunkSize) {
        if (logger.isLoggable(Level.FINEST)) {
            HTTPClientMessages.getLogger(logger).log(Level.FINEST, HTTPClientMessages.getFormattedString("J2EE HTTPC-09001", conn, chunkSize));
        }
    }
}

