/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient.loadbalance;

import HTTPClient.i18n.HTTPClientMessages;
import HTTPClient.loadbalance.LoadBalanceEndpoint;
import HTTPClient.loadbalance.LoadBalanceProvider;
import HTTPClient.loadbalance.LoadBalanceProviderBase;
import java.text.MessageFormat;

public class LoadBalanceEndpointBase
implements LoadBalanceEndpoint {
    private static final int NO_PORT_VALUE = -1;
    private static final String TO_STRING_TEMPLATE = "LoadBalanceEndpointBase: provider={0}, virtualServerHost={1}, virtualServerPort={2,number,0}, endpointHost={3}, endpointPort={4,number,0}.";
    private String virtualServerHost = null;
    private int virtualServerPort = -1;
    private String endpointHost = null;
    private int endpointPort = -1;
    private LoadBalanceProvider provider = null;
    private Integer hashCode = null;

    public String getVirtualServerHost() {
        return this.virtualServerHost;
    }

    public int getVirtualServerPort() {
        return this.virtualServerPort;
    }

    public String getEndpointHost() {
        return this.endpointHost;
    }

    public int getEndpointPort() {
        return this.endpointPort;
    }

    public LoadBalanceProvider getLoadBalanceProvider() {
        return this.provider;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LoadBalanceEndpoint)) {
            return false;
        }
        LoadBalanceEndpoint otherEndpoint = (LoadBalanceEndpoint)obj;
        if (otherEndpoint.getLoadBalanceProvider() != this.provider) {
            return false;
        }
        return otherEndpoint.getVirtualServerHost().equals(this.getVirtualServerHost()) && otherEndpoint.getVirtualServerPort() == this.getVirtualServerPort() && otherEndpoint.getEndpointHost().equals(this.getEndpointHost()) && otherEndpoint.getEndpointPort() == this.getEndpointPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        if (null == this.hashCode) {
            LoadBalanceEndpointBase loadBalanceEndpointBase = this;
            synchronized (loadBalanceEndpointBase) {
                if (null == this.hashCode) {
                    StringBuffer buff = new StringBuffer(256);
                    buff.append(this.getVirtualServerHost());
                    buff.append(':');
                    buff.append(this.getVirtualServerPort());
                    buff.append(',');
                    buff.append(this.getEndpointHost());
                    buff.append(':');
                    buff.append(this.getEndpointPort());
                    String hostPort = buff.toString();
                    this.hashCode = new Integer(hostPort.hashCode());
                }
            }
        }
        return this.hashCode;
    }

    public String toString() {
        String output = MessageFormat.format(TO_STRING_TEMPLATE, this.provider, this.virtualServerHost, this.virtualServerPort, this.endpointHost, this.endpointPort);
        return output;
    }

    protected LoadBalanceEndpointBase(Builder builder) {
        if (null == builder) {
            throw new IllegalArgumentException(HTTPClientMessages.msg_unexpectedNullObject("Builder"));
        }
        this.provider = builder.provider;
        this.virtualServerHost = builder.virtualServerHost;
        this.virtualServerPort = builder.virtualServerPort;
        this.endpointHost = builder.endpointHost;
        this.endpointPort = builder.endpointPort;
    }

    public static class Builder {
        private String virtualServerHost = null;
        private int virtualServerPort = -1;
        private String endpointHost = null;
        private int endpointPort = -1;
        private LoadBalanceProvider provider = null;

        public Builder(LoadBalanceProvider provider, String virtualServerHost, int virtualServerPort, String endpointHost, int endpointPort) {
            virtualServerHost = LoadBalanceProviderBase.normalizeHost(virtualServerHost);
            LoadBalanceProviderBase.validate(virtualServerHost, virtualServerPort, "virtual server");
            endpointHost = LoadBalanceProviderBase.normalizeHost(endpointHost);
            LoadBalanceProviderBase.validate(endpointHost, endpointPort, "endpoint");
            this.provider = provider;
            this.virtualServerHost = virtualServerHost;
            this.virtualServerPort = virtualServerPort;
            this.endpointHost = endpointHost;
            this.endpointPort = endpointPort;
        }

        public LoadBalanceEndpointBase build() {
            return new LoadBalanceEndpointBase(this);
        }
    }
}

