/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient.loadbalance;

import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.loadbalance.LoadBalanceProvider;
import HTTPClient.loadbalance.ProviderUnavailableException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class LoadBalanceProviderBase
implements LoadBalanceProvider {
    private static final Logger LOGGER = HttpClientLoggerFactory.getLogger(LoadBalanceProviderBase.class.getName());
    private Hashtable<String, LoadBalanceProvider.LoadBalanceMethod> clusterToMethodMap = new Hashtable(20);

    protected static void validate(String hostname, int port, String errorMessageModifier) throws IllegalArgumentException {
        if (null == errorMessageModifier) {
            errorMessageModifier = "";
        }
        if (null == hostname || "".equals(hostname)) {
            throw new IllegalArgumentException("Non-empty " + errorMessageModifier + " host expected.");
        }
        if (port < 0) {
            throw new IllegalArgumentException("Non-negative " + errorMessageModifier + " port number expected.");
        }
    }

    protected static String normalizeHost(String host) {
        if (null == host) {
            return null;
        }
        return host.trim().toLowerCase();
    }

    protected static String toHostPortKey(String hostname, int port) {
        hostname = LoadBalanceProviderBase.normalizeHost(hostname);
        LoadBalanceProviderBase.validate(hostname, port, "toHostPortKey");
        StringBuffer buff = new StringBuffer(256);
        buff.append(hostname);
        buff.append(':');
        buff.append(port);
        return buff.toString();
    }

    public LoadBalanceProvider.LoadBalanceMethod getLoadBalanceMethod(String virtualHost, int virtualPort) {
        String key = LoadBalanceProviderBase.toHostPortKey(virtualHost, virtualPort);
        LoadBalanceProvider.LoadBalanceMethod method = this.clusterToMethodMap.get(key);
        if (null == method) {
            return LoadBalanceProvider.LoadBalanceMethod.DEFAULT;
        }
        return method;
    }

    public LoadBalanceProvider.LoadBalanceMethod setLoadBalanceMethod(String virtualHost, int virtualPort, LoadBalanceProvider.LoadBalanceMethod method) {
        String key = LoadBalanceProviderBase.toHostPortKey(virtualHost, virtualPort);
        if (null == method) {
            method = LoadBalanceProvider.LoadBalanceMethod.DEFAULT;
        }
        LoadBalanceProvider.LoadBalanceMethod prevMethod = null;
        prevMethod = LoadBalanceProvider.LoadBalanceMethod.DEFAULT.equals((Object)method) ? this.clusterToMethodMap.remove(key) : this.clusterToMethodMap.put(key, method);
        if (null == prevMethod) {
            return LoadBalanceProvider.LoadBalanceMethod.DEFAULT;
        }
        return prevMethod;
    }

    public boolean isLoadBalanceMethodSettable() {
        return true;
    }

    public static LoadBalanceProvider.SupportedProtocol toSupportedProtocol(String protocol) {
        if (null == protocol) {
            return null;
        }
        protocol = protocol.trim().toUpperCase();
        LoadBalanceProvider.SupportedProtocol output = null;
        try {
            output = LoadBalanceProvider.SupportedProtocol.valueOf(protocol);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return output;
    }

    public boolean isAvailable() {
        return true;
    }

    protected void checkAvailable(String methodName) {
        if (!this.isAvailable()) {
            if (null == methodName) {
                methodName = "";
            }
            if ("".equals(methodName)) {
                methodName = "<unknown>";
            }
            String message = "Unable to execute '" + methodName + "', LoadBalanceProvider is unavailable.";
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, message);
            }
            throw new ProviderUnavailableException(message);
        }
    }
}

