/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient.loadbalance;

import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.loadbalance.LoadBalanceProvider;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoadBalanceProviderFactory {
    private static final Logger logger = HttpClientLoggerFactory.getLogger(LoadBalanceProviderFactory.class.getName());

    public static LoadBalanceProvider getInstance(String implementationKey) {
        if (null == implementationKey || "".equals(implementationKey)) {
            throw new IllegalArgumentException("Expected non-null and non-empty implementationKey.");
        }
        LoadBalanceProvider output = null;
        try {
            Class<?> cls = Class.forName(implementationKey);
            Object obj = cls.newInstance();
            if (!(obj instanceof LoadBalanceProvider)) {
                throw new ClassCastException("Specified implementation '" + implementationKey + "' is not an instance of '" + LoadBalanceProvider.class.getName() + "'.");
            }
            output = (LoadBalanceProvider)obj;
        }
        catch (Exception e) {
            String message = "Unable to instantiate '" + implementationKey + "'.";
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, message, e);
            }
            throw new RuntimeException(message, e);
        }
        return output;
    }

    private LoadBalanceProviderFactory() {
    }
}

