/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient.loadbalance;

import HTTPClient.HttpClientConfiguration;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.ParseException;
import HTTPClient.config.Configuration;
import HTTPClient.config.HTTPClientProperties;
import HTTPClient.config.Property;
import HTTPClient.config.PropertyInitializer;
import HTTPClient.i18n.HTTPClientMessages;
import HTTPClient.loadbalance.LoadBalanceEndpoint;
import HTTPClient.loadbalance.LoadBalanceEndpointBase;
import HTTPClient.loadbalance.LoadBalanceProvider;
import HTTPClient.loadbalance.LoadBalanceProviderBase;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyLoadBalanceProvider
extends LoadBalanceProviderBase {
    private static final Logger logger = HttpClientLoggerFactory.getLogger(PropertyLoadBalanceProvider.class.getName());
    private LoadBalanceProvider.LoadBalanceMethod defaultLoadBalanceMethod;
    private HashMap<String, VirtualServerEndpoints> virtualServerToEndpointMap;
    private Random random;

    public PropertyLoadBalanceProvider() {
        block10: {
            block9: {
                this.defaultLoadBalanceMethod = LoadBalanceProvider.LoadBalanceMethod.ROUND_ROBIN;
                this.virtualServerToEndpointMap = new HashMap(16);
                this.random = new Random(new Date().getTime());
                try {
                    LoadBalanceProvider.LoadBalanceMethod tempDefaultLoadBalanceMethod = HttpClientConfiguration.getDefaultLoadBalanceMethod();
                    if (null != tempDefaultLoadBalanceMethod && !LoadBalanceProvider.LoadBalanceMethod.DEFAULT.equals((Object)tempDefaultLoadBalanceMethod)) {
                        this.defaultLoadBalanceMethod = tempDefaultLoadBalanceMethod;
                    }
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.FINE)) break block9;
                    logger.log(Level.FINE, "Unable to init defaultLoadBalanceMethod.", e);
                }
            }
            try {
                List<LoadBalanceEndpoint> clusters = HttpClientConfiguration.getLoadBalanceServerClusters();
                if (null != clusters) {
                    for (LoadBalanceEndpoint entry : clusters) {
                        try {
                            String virtualHost = entry.getVirtualServerHost();
                            int virtualPort = entry.getVirtualServerPort();
                            String endpointHost = entry.getEndpointHost();
                            int endpointPort = entry.getEndpointPort();
                            this.setEndpoint(virtualHost, virtualPort, endpointHost, endpointPort);
                        }
                        catch (Exception e) {
                            if (!logger.isLoggable(Level.FINE)) continue;
                            logger.log(Level.FINE, "Unable to init server cluster endpoint mapping from configuration.", e);
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINE)) break block10;
                logger.log(Level.FINE, "Unable to init virtualServerToEndpointMap from configuration.", e);
            }
        }
    }

    public LoadBalanceProvider.LoadBalanceMethod getDefaultLoadBalanceMethod() {
        return this.defaultLoadBalanceMethod;
    }

    public LoadBalanceProvider.LoadBalanceMethod setDefaultLoadBalanceMethod(LoadBalanceProvider.LoadBalanceMethod method) throws IllegalArgumentException {
        if (null == method || LoadBalanceProvider.LoadBalanceMethod.DEFAULT.equals((Object)method)) {
            throw new IllegalArgumentException("Null or DEFAULT method not allowed.");
        }
        LoadBalanceProvider.LoadBalanceMethod previous = this.defaultLoadBalanceMethod;
        this.defaultLoadBalanceMethod = method;
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LoadBalanceEndpoint getNextEndpoint(LoadBalanceProvider.SupportedProtocol expectedProtocol, String virtualHost, int virtualPort) {
        String key;
        VirtualServerEndpoints endpointData;
        LoadBalanceEndpoint endpoint = null;
        LoadBalanceProvider.LoadBalanceMethod method = this.getLoadBalanceMethod(virtualHost, virtualPort);
        if (null == method) {
            method = LoadBalanceProvider.LoadBalanceMethod.DEFAULT;
        }
        if (LoadBalanceProvider.LoadBalanceMethod.DEFAULT.equals((Object)method)) {
            method = this.getDefaultLoadBalanceMethod();
        }
        if (null == (endpointData = this.virtualServerToEndpointMap.get(key = PropertyLoadBalanceProvider.toHostPortKey(virtualHost, virtualPort)))) {
            return null;
        }
        VirtualServerEndpoints virtualServerEndpoints = endpointData;
        synchronized (virtualServerEndpoints) {
            ArrayList<LoadBalanceEndpoint> endpointList = endpointData.getEndpointList();
            int lastIndex = endpointData.getLastSelectedEndpointIndex();
            int nextIndex = -1;
            int listSize = endpointList.size();
            block2 : switch (listSize) {
                case 0: {
                    return null;
                }
                case 1: {
                    nextIndex = 0;
                    break;
                }
                case 2: {
                    if (0 == lastIndex) {
                        nextIndex = 1;
                        break;
                    }
                    nextIndex = 0;
                    break;
                }
                default: {
                    switch (method) {
                        case RANDOM: {
                            nextIndex = this.random.nextInt(listSize - 1);
                            if (nextIndex != lastIndex) break block2;
                            ++nextIndex;
                            break block2;
                        }
                        case ROUND_ROBIN: {
                            nextIndex = lastIndex + 1 >= listSize ? 0 : lastIndex + 1;
                            break block2;
                        }
                        default: {
                            throw new IllegalStateException("Unknown LoadBalanceMethod: " + (Object)((Object)method));
                        }
                    }
                }
            }
            if (nextIndex < 0 || nextIndex >= listSize) {
                throw new IllegalStateException("LoadBalanceMethod '" + (Object)((Object)method) + "' returned illegal index " + nextIndex + " for list size " + listSize + ".");
            }
            endpoint = (LoadBalanceEndpoint)endpointList.get(nextIndex);
            if (null == endpoint) {
                throw new IllegalStateException("Endpoint list index " + nextIndex + " for list size " + listSize + " returned null value.");
            }
            endpointData.setLastSelectedEndpoint(endpoint);
        }
        return endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LoadBalanceEndpoint> getEndpoints(String virtualHost, int virtualPort) {
        String key = PropertyLoadBalanceProvider.toHostPortKey(virtualHost, virtualPort);
        VirtualServerEndpoints endpointData = this.virtualServerToEndpointMap.get(key);
        ArrayList endpointList = null;
        if (null != endpointData) {
            VirtualServerEndpoints virtualServerEndpoints = endpointData;
            synchronized (virtualServerEndpoints) {
                endpointList = endpointData.getEndpointList();
                endpointList = endpointList.isEmpty() ? null : (ArrayList)endpointList.clone();
            }
        }
        return endpointList;
    }

    @Override
    public LoadBalanceEndpoint getNextEndpoint(LoadBalanceEndpoint lastEndpoint) {
        if (null == lastEndpoint) {
            throw new IllegalArgumentException(HTTPClientMessages.msg_unexpectedNullObject("LoadBalanceEndpoint"));
        }
        LoadBalanceEndpoint returnValue = this.getNextEndpoint(null, lastEndpoint.getVirtualServerHost(), lastEndpoint.getVirtualServerPort());
        return returnValue;
    }

    public void setEndpoint(String virtualHost, int virtualPort, String endpointHost, int endpointPort) {
        LoadBalanceEndpointBase endpoint = new LoadBalanceEndpointBase.Builder(this, virtualHost, virtualPort, endpointHost, endpointPort).build();
        this.setEndpoint(endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEndpoint(LoadBalanceEndpoint endpoint) {
        Object object;
        int virtualPort;
        if (null == endpoint) {
            throw new IllegalArgumentException(HTTPClientMessages.msg_unexpectedNullObject("LoadBalanceEndpoint"));
        }
        String virtualHost = endpoint.getVirtualServerHost();
        String key = PropertyLoadBalanceProvider.toHostPortKey(virtualHost, virtualPort = endpoint.getVirtualServerPort());
        VirtualServerEndpoints endpointData = this.virtualServerToEndpointMap.get(key);
        if (null == endpointData) {
            object = this.virtualServerToEndpointMap;
            synchronized (object) {
                endpointData = this.virtualServerToEndpointMap.get(key);
                if (null == endpointData) {
                    endpointData = new VirtualServerEndpoints();
                    this.virtualServerToEndpointMap.put(key, endpointData);
                }
            }
        }
        object = endpointData;
        synchronized (object) {
            ArrayList<LoadBalanceEndpoint> endpointList = endpointData.getEndpointList();
            if (!endpointList.contains(endpoint)) {
                endpointList.add(endpoint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearEndpoint(String virtualHost, int virtualPort, String endpointHost, int endpointPort) {
        String key = PropertyLoadBalanceProvider.toHostPortKey(virtualHost, virtualPort);
        VirtualServerEndpoints endpointData = this.virtualServerToEndpointMap.get(key);
        if (null == endpointData) {
            return false;
        }
        LoadBalanceEndpointBase endpoint = new LoadBalanceEndpointBase.Builder(this, virtualHost, virtualPort, endpointHost, endpointPort).build();
        boolean found = false;
        VirtualServerEndpoints virtualServerEndpoints = endpointData;
        synchronized (virtualServerEndpoints) {
            ArrayList<LoadBalanceEndpoint> endpointList = endpointData.getEndpointList();
            found = endpointList.remove(endpoint);
            LoadBalanceEndpoint lastSelectedEndpoint = endpointData.getLastSelectedEndpoint();
            if (null != lastSelectedEndpoint && lastSelectedEndpoint.equals(endpoint)) {
                endpointData.setLastSelectedEndpoint(null);
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEndpoint(String virtualHost, int virtualPort, String endpointHost, int endpointPort) {
        String key = PropertyLoadBalanceProvider.toHostPortKey(virtualHost, virtualPort);
        LoadBalanceEndpointBase endpoint = new LoadBalanceEndpointBase.Builder(this, virtualHost, virtualPort, endpointHost, endpointPort).build();
        VirtualServerEndpoints endpointData = this.virtualServerToEndpointMap.get(key);
        if (null == endpointData) {
            return false;
        }
        VirtualServerEndpoints virtualServerEndpoints = endpointData;
        synchronized (virtualServerEndpoints) {
            ArrayList<LoadBalanceEndpoint> endpointList = endpointData.getEndpointList();
            return endpointList.contains(endpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasEndpoints(String virtualHost, int virtualPort) {
        String key = PropertyLoadBalanceProvider.toHostPortKey(virtualHost, virtualPort);
        VirtualServerEndpoints endpointData = this.virtualServerToEndpointMap.get(key);
        if (null == endpointData) {
            return false;
        }
        VirtualServerEndpoints virtualServerEndpoints = endpointData;
        synchronized (virtualServerEndpoints) {
            ArrayList<LoadBalanceEndpoint> endpointList = endpointData.getEndpointList();
            return !endpointList.isEmpty();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class List_LoadBalanceEndpoint {
        private final List<LoadBalanceEndpoint> list;

        private List_LoadBalanceEndpoint(List<LoadBalanceEndpoint> list) {
            this.list = list;
        }

        public List<LoadBalanceEndpoint> getList() {
            return this.list;
        }
    }

    public static final class PropertyInitializer_LoadBalanceServerClusters
    implements PropertyInitializer {
        public void initialize(Property property, Configuration config) throws Exception {
            if (!property.equals(HTTPClientProperties.SysProp.LOAD_BALANCE_SERVER_CLUSTERS)) {
                return;
            }
            String sysPropNamePrefix = HTTPClientProperties.SysProp.LOAD_BALANCE_SERVER_CLUSTERS.getName();
            int sysPropNamePrefixLength = sysPropNamePrefix.length();
            String uri_scheme = "http://";
            int initialClusterCount = 4;
            ArrayList<LoadBalanceEndpointBase> list = null;
            Map<String, String> rawSysProps = config.getRawSystemProperties();
            if (null != rawSysProps) {
                for (String propName : rawSysProps.keySet()) {
                    if (!propName.startsWith(sysPropNamePrefix)) continue;
                    String propValue = "";
                    try {
                        String virtualServerHostPort = propName.substring(sysPropNamePrefixLength).trim();
                        propValue = rawSysProps.get(propName);
                        String endpointsHostPortList = propValue.trim();
                        URI virtualServerUri = new URI("http://" + virtualServerHostPort);
                        String virtualHost = virtualServerUri.getHost();
                        int virtualPort = virtualServerUri.getPort();
                        String[] endpointArray = endpointsHostPortList.split("\\|", 0);
                        if (0 == endpointArray.length) {
                            throw new ParseException("Empty endpoint list.");
                        }
                        for (String endpointEntry : endpointArray) {
                            URI endpointUri = new URI("http://" + endpointEntry);
                            String endpointHost = endpointUri.getHost();
                            int endpointPort = endpointUri.getPort();
                            LoadBalanceEndpointBase endpoint = new LoadBalanceEndpointBase.Builder(null, virtualHost, virtualPort, endpointHost, endpointPort).build();
                            if (null == list) {
                                list = new ArrayList<LoadBalanceEndpointBase>(4);
                            }
                            list.add(endpoint);
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(Level.FINE)) continue;
                        propName = null == propName ? "" : propName;
                        propValue = null == propValue ? "" : propValue;
                        logger.log(Level.FINE, "Unable to parse the system property '" + propName + "'='" + propValue + "'.", e);
                    }
                }
            }
            List_LoadBalanceEndpoint readOnlyList = null;
            if (null != list) {
                readOnlyList = new List_LoadBalanceEndpoint(Collections.unmodifiableList(list));
            }
            config.setValue(HTTPClientProperties.SysProp.LOAD_BALANCE_SERVER_CLUSTERS, readOnlyList);
        }
    }

    public static final class PropertyInitializer_DefaultLoadBalanceMethod
    implements PropertyInitializer {
        public void initialize(Property property, Configuration config) throws Exception {
            if (!property.equals(HTTPClientProperties.SysProp.DEFAULT_LOAD_BALANCE_METHOD)) {
                return;
            }
            String strValue = config.getRawSystemProperty(HTTPClientProperties.SysProp.DEFAULT_LOAD_BALANCE_METHOD.getName());
            if (null == strValue) {
                config.setValue(HTTPClientProperties.SysProp.DEFAULT_LOAD_BALANCE_METHOD, null);
            } else if (strValue.equalsIgnoreCase(LoadBalanceProvider.LoadBalanceMethod.RANDOM.toString())) {
                config.setValue(HTTPClientProperties.SysProp.DEFAULT_LOAD_BALANCE_METHOD, (Object)LoadBalanceProvider.LoadBalanceMethod.RANDOM);
            } else if (strValue.equalsIgnoreCase(LoadBalanceProvider.LoadBalanceMethod.ROUND_ROBIN.toString())) {
                config.setValue(HTTPClientProperties.SysProp.DEFAULT_LOAD_BALANCE_METHOD, (Object)LoadBalanceProvider.LoadBalanceMethod.ROUND_ROBIN);
            } else {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "System property {0} has invalid value \"{1}\", reverting to predetermined default.", new Object[]{HTTPClientProperties.SysProp.DEFAULT_LOAD_BALANCE_METHOD, strValue});
                }
                config.setValue(HTTPClientProperties.SysProp.DEFAULT_LOAD_BALANCE_METHOD, null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VirtualServerEndpoints {
        private ArrayList<LoadBalanceEndpoint> endpointList = new ArrayList(4);
        private LoadBalanceEndpoint lastSelectedEndpoint = null;

        private VirtualServerEndpoints() {
        }

        public LoadBalanceEndpoint getLastSelectedEndpoint() {
            return this.lastSelectedEndpoint;
        }

        public void setLastSelectedEndpoint(LoadBalanceEndpoint lastSelectedEndpoint) {
            this.lastSelectedEndpoint = lastSelectedEndpoint;
        }

        public int getLastSelectedEndpointIndex() {
            if (null != this.lastSelectedEndpoint) {
                return this.endpointList.indexOf(this.lastSelectedEndpoint);
            }
            return -1;
        }

        public ArrayList<LoadBalanceEndpoint> getEndpointList() {
            return this.endpointList;
        }
    }
}

