/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient.negotiate;

import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.negotiate.GSSSpnegoCredentials;
import HTTPClient.negotiate.KrbGSSCallbackHandler;
import HTTPClient.negotiate.SPNEGONegTokenUtils;
import HTTPClient.negotiate.TicketAgent;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

class KrbServiceTicketAgent
implements TicketAgent {
    private static final Logger logger = HttpClientLoggerFactory.getLogger(KrbServiceTicketAgent.class.getName());
    private static final String SPNEGO_OID = "1.3.6.1.5.5.2";
    private static final String KRB5_OID = "1.2.840.113554.1.2.2";
    private static final String KRB5_PRINCIPAL_OID = "1.2.840.113554.1.2.2.1";
    private static Oid KRB5_MECHANISM;
    private static Oid KRB5_PRINCIPAL_NAME_TYPE;
    private static Oid SPNEGO_MECHANISM;
    private Subject subject;
    private GSSContext gssContext;
    private byte[] krbServiceTicket = new byte[0];
    private GSSSpnegoCredentials spnegoCred;
    private static Oid[] MECH_TYPES;

    KrbServiceTicketAgent(GSSSpnegoCredentials spnegoCred) {
        this.spnegoCred = spnegoCred;
    }

    public byte[] getTicket(String negTokenTarg) {
        try {
            this.obtainKrb5ServiceTicket(negTokenTarg);
        }
        catch (LoginException e) {
            logger.log(Level.SEVERE, "Error authenticating with the Kerberos KDC: " + e);
        }
        catch (GSSException e) {
            logger.log(Level.SEVERE, "Error getting Kerberos service ticket: " + e);
        }
        return this.krbServiceTicket;
    }

    private void login() throws LoginException {
        LoginContext loginCtx = null;
        loginCtx = new LoginContext("HTTPClient", new KrbGSSCallbackHandler(this.spnegoCred.getUserName(), this.spnegoCred.getUserPassword()));
        loginCtx.login();
        this.subject = loginCtx.getSubject();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "User " + this.spnegoCred.getUserName() + " logged in.");
        }
    }

    private void obtainKrb5ServiceTicket(final String negTokenTarg) throws LoginException, GSSException {
        if (this.gssContext == null) {
            this.createGSSContext();
        }
        if (this.subject == null) {
            this.login();
        }
        try {
            Subject.doAs(this.subject, new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws GSSException {
                    KrbServiceTicketAgent.this.gssContext.requestMutualAuth(KrbServiceTicketAgent.this.spnegoCred.getMutualAuth());
                    KrbServiceTicketAgent.this.gssContext.requestCredDeleg(KrbServiceTicketAgent.this.spnegoCred.getCredentialDelegation());
                    byte[] inToken = negTokenTarg == null ? new byte[]{} : SPNEGONegTokenUtils.decodeSPNEGOToken(SPNEGONegTokenUtils.base64Decode(negTokenTarg.trim()));
                    byte[] outputToken = KrbServiceTicketAgent.this.gssContext.initSecContext(inToken, 0, inToken.length);
                    KrbServiceTicketAgent.access$202(KrbServiceTicketAgent.this, outputToken);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pac) {
            GSSException gssEx = (GSSException)pac.getException();
            logger.log(Level.SEVERE, "Error getting Kerberos service ticket: " + gssEx);
            throw gssEx;
        }
    }

    void createGSSContext() throws GSSException {
        GSSManager manager = GSSManager.getInstance();
        GSSName serverName = null;
        serverName = manager.createName(this.spnegoCred.getServicePrincipalName(), KRB5_PRINCIPAL_NAME_TYPE);
        for (int i = 0; i < MECH_TYPES.length; ++i) {
            Oid oid = MECH_TYPES[i];
            try {
                this.gssContext = manager.createContext(serverName, oid, null, 0);
                break;
            }
            catch (GSSException gssEx) {
                if (i != MECH_TYPES.length - 1) continue;
                throw gssEx;
            }
        }
    }

    static /* synthetic */ byte[] access$202(KrbServiceTicketAgent x0, byte[] x1) {
        x0.krbServiceTicket = x1;
        return x1;
    }

    static {
        try {
            KRB5_MECHANISM = new Oid(KRB5_OID);
            KRB5_PRINCIPAL_NAME_TYPE = new Oid(KRB5_PRINCIPAL_OID);
            SPNEGO_MECHANISM = new Oid(SPNEGO_OID);
            MECH_TYPES = new Oid[]{KRB5_MECHANISM};
        }
        catch (GSSException gssEx) {
            logger.log(Level.SEVERE, "Error instantiating the Oid Objects: " + gssEx);
        }
    }
}

