/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient.negotiate;

import HTTPClient.AuthenticationSchemeBase;
import HTTPClient.AuthorizationInfo;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.RoRequest;
import HTTPClient.RoResponse;
import HTTPClient.negotiate.GSSSpnegoCredentials;
import HTTPClient.negotiate.KrbClient;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class NegotiateAuthenticationScheme
extends AuthenticationSchemeBase {
    public static final String DEFAULT_SCHEME_NAME = "Negotiate";
    public static final String KRB5_REALM = "REALM";
    public static final String USER_NAME = "USER_NAME";
    public static final String PASSWORD = "PASSWORD";
    public static final String SPN = "SERVICE_PRINCIPAL_NAME";
    public static final String KDC = "KEY_DISTRIBUTION_CENTER";
    private static final Logger logger = HttpClientLoggerFactory.getLogger(NegotiateAuthenticationScheme.class.getName());
    private static final String EMPTY_REALM = "";

    public NegotiateAuthenticationScheme() {
        this(DEFAULT_SCHEME_NAME, true);
    }

    public NegotiateAuthenticationScheme(String schemeName, boolean isConnectionOriented) throws IllegalArgumentException {
        super(schemeName, isConnectionOriented);
    }

    public AuthorizationInfo createAuthorizationInfo(String host, int port, String realm, String username, String password) {
        HashMap<String, String> credentials = new HashMap<String, String>();
        credentials.put(USER_NAME, username);
        credentials.put(PASSWORD, password);
        AuthorizationInfo ai = new AuthorizationInfo(host, port, this.getSchemeName(), EMPTY_REALM, null, credentials);
        return ai;
    }

    public AuthorizationInfo getAuthorization(AuthorizationInfo credentials, RoRequest request, AuthorizationInfo challenge, RoResponse response) {
        AuthorizationInfo ai = null;
        KrbClient krbClient = null;
        if (credentials != null && challenge != null) {
            Object extraInfo = credentials.getExtraInfo();
            if (extraInfo == null || !(extraInfo instanceof GSSSpnegoCredentials)) {
                logger.log(Level.FINER, "credentials ExtraInfo property expected to be an instance of " + GSSSpnegoCredentials.class.getName());
            } else {
                GSSSpnegoCredentials spnegoCred = (GSSSpnegoCredentials)extraInfo;
                String negTokenTarg = challenge.getCookie();
                krbClient = new KrbClient(spnegoCred);
                String negotiateToken = krbClient.getNegotiateToken(negTokenTarg);
                ai = new AuthorizationInfo(credentials.getHost(), credentials.getPort(), credentials.getScheme(), credentials.getRealm(), negotiateToken);
            }
        }
        return ai;
    }
}

