/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient.negotiate;

import HTTPClient.Codecs;
import HTTPClient.HttpClientLoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

class SPNEGONegTokenUtils {
    private static final int ONEOCTET = 256;
    private static final int TWOOCTETS = 65536;
    private static final int THREEOCTETS = 0x1000000;
    private static final byte ONEOCTETSIZE = -127;
    private static final byte TWOOCTETSIZE = -126;
    private static final byte THREEOCTETSIZE = -125;
    private static final byte FOUROCTETSIZE = -124;
    private static final int ACO = 96;
    private static final int SEQUENCE = 48;
    private static final int OCTET_STRING = 4;
    private static final int BIT_STRING = 3;
    private static final int ENUMERATED = 10;
    private static final int NEG_TOKEN_INIT = 160;
    private static final int NEG_TOKEN_TARG = 161;
    private static final int MECH_TYPE_LIST = 160;
    private static final int CONTEXT_FLAGS = 161;
    private static final int NEG_RESULT = 160;
    private static final int SUPPORTED_MECH = 161;
    private static final int RESPONSE_TOKEN = 162;
    private static final int MECH_TOKEN = 162;
    private static final int ACCEPT_COMPLETED = 0;
    private static final int ACCEPT_INCOMPLETE = 1;
    private static final int REJECTED = 2;
    private static final byte[] SPNEGO_OID = new byte[]{6, 6, 43, 6, 1, 5, 5, 2};
    private static final byte[] STATIC_MECHTYPELIST_SEQUENCE = new byte[]{-96, 24, 48, 22, 6, 9, 42, -122, 72, -126, -9, 18, 1, 2, 2, 6, 9, 42, -122, 72, -122, -9, 18, 1, 2, 2};
    private static final int CONTEXT_FLAG_MUTUAL = 2;
    private static final byte[] STATIC_CONTEXTFLAGSMUTUAL = new byte[]{-95, 4, 3, 2, 0, 2};
    private static final Logger logger = HttpClientLoggerFactory.getLogger(SPNEGONegTokenUtils.class.getName());

    SPNEGONegTokenUtils() {
    }

    private static void encodeBytes(ByteArrayOutputStream theOutput, byte[] theBytes) throws IOException {
        if (theBytes != null) {
            for (int i = 0; i < theBytes.length; ++i) {
                theOutput.write(theBytes[i]);
            }
        }
    }

    private static void encodeLength(ByteArrayOutputStream theOutput, int theLength) throws IOException {
        if (theLength < 128 && theLength >= 0) {
            theOutput.write((byte)theLength);
            return;
        }
        if (theLength >= 0x1000000) {
            theOutput.write(-124);
            theOutput.write((byte)(theLength >> 24));
            theOutput.write((byte)(theLength >> 16));
            theOutput.write((byte)(theLength >> 8));
        } else if (theLength >= 65536) {
            theOutput.write(-125);
            theOutput.write((byte)(theLength >> 16));
            theOutput.write((byte)(theLength >> 8));
        } else if (theLength >= 256) {
            theOutput.write(-126);
            theOutput.write((byte)(theLength >> 8));
        } else {
            theOutput.write(-127);
        }
        theOutput.write((byte)theLength);
    }

    private static int getLengthDER(ByteArrayInputStream is) {
        int len = 0;
        int b = is.read();
        if (b == -1) {
            return -1;
        }
        if (b < 128 && b >= 0) {
            len = b;
        } else {
            int numOctets = b & 0x7F;
            if (is.available() < numOctets - 1) {
                return -1;
            }
            switch (numOctets) {
                case 1: {
                    len = is.read() & 0xFF;
                    break;
                }
                case 2: {
                    len = is.read() << 8 & 0xFF00 | is.read() & 0xFF;
                    break;
                }
                case 3: {
                    len = is.read() << 16 & 0xFF0000 | is.read() << 8 & 0xFF00 | is.read() & 0xFF;
                    break;
                }
                case 4: {
                    len = is.read() << 24 & 0xFF000000 | is.read() << 16 & 0xFF0000 | is.read() << 8 & 0xFF00 | is.read() & 0xFF;
                    break;
                }
            }
        }
        return len;
    }

    static String base64Encode(byte[] theRawBytes) {
        String str = null;
        if (theRawBytes != null) {
            str = new String(Codecs.base64Encode(theRawBytes));
        }
        return str;
    }

    static byte[] base64Decode(String theEncodedBytes) {
        return Codecs.base64Decode(theEncodedBytes).getBytes();
    }

    static byte[] encodeKrbServiceTicketIntoSPNEGOToken(byte[] krbServiceTicket, boolean mutualAuth) {
        byte[] token = null;
        if (krbServiceTicket != null) {
            try {
                ByteArrayOutputStream datastream = new ByteArrayOutputStream();
                datastream.write(4);
                SPNEGONegTokenUtils.encodeLength(datastream, krbServiceTicket.length);
                SPNEGONegTokenUtils.encodeBytes(datastream, krbServiceTicket);
                byte[] derEncodedData = datastream.toByteArray();
                datastream = new ByteArrayOutputStream();
                datastream.write(162);
                SPNEGONegTokenUtils.encodeLength(datastream, derEncodedData.length);
                SPNEGONegTokenUtils.encodeBytes(datastream, derEncodedData);
                derEncodedData = datastream.toByteArray();
                if (mutualAuth) {
                    datastream = new ByteArrayOutputStream();
                    SPNEGONegTokenUtils.encodeBytes(datastream, STATIC_CONTEXTFLAGSMUTUAL);
                    SPNEGONegTokenUtils.encodeBytes(datastream, derEncodedData);
                    derEncodedData = datastream.toByteArray();
                }
                datastream = new ByteArrayOutputStream();
                datastream.write(48);
                SPNEGONegTokenUtils.encodeLength(datastream, STATIC_MECHTYPELIST_SEQUENCE.length + derEncodedData.length);
                SPNEGONegTokenUtils.encodeBytes(datastream, STATIC_MECHTYPELIST_SEQUENCE);
                SPNEGONegTokenUtils.encodeBytes(datastream, derEncodedData);
                derEncodedData = datastream.toByteArray();
                datastream = new ByteArrayOutputStream();
                SPNEGONegTokenUtils.encodeBytes(datastream, SPNEGO_OID);
                datastream.write(160);
                SPNEGONegTokenUtils.encodeLength(datastream, derEncodedData.length);
                SPNEGONegTokenUtils.encodeBytes(datastream, derEncodedData);
                derEncodedData = datastream.toByteArray();
                datastream = new ByteArrayOutputStream();
                datastream.write(96);
                SPNEGONegTokenUtils.encodeLength(datastream, derEncodedData.length);
                SPNEGONegTokenUtils.encodeBytes(datastream, derEncodedData);
                token = derEncodedData = datastream.toByteArray();
            }
            catch (IOException ioe) {
                logger.log(Level.SEVERE, "Error while encoding the Kerberos service ticket: " + ioe);
            }
        }
        return token;
    }

    static byte[] decodeSPNEGOToken(byte[] spnegoToken) {
        byte[] decodedToken;
        block4: {
            int choice;
            int len;
            ByteArrayInputStream is;
            block14: {
                block8: {
                    block11: {
                        block13: {
                            block12: {
                                block10: {
                                    block9: {
                                        block7: {
                                            block6: {
                                                block5: {
                                                    decodedToken = null;
                                                    if (spnegoToken == null) break block4;
                                                    is = new ByteArrayInputStream(spnegoToken);
                                                    if (is.read() == 161) break block5;
                                                    logger.log(Level.WARNING, "Not a SPNEGO NegTokenTarg token");
                                                    break block4;
                                                }
                                                len = SPNEGONegTokenUtils.getLengthDER(is);
                                                if (is.read() == 48) break block6;
                                                logger.log(Level.WARNING, "Invalid token format, sequence not found");
                                                break block4;
                                            }
                                            len = SPNEGONegTokenUtils.getLengthDER(is);
                                            choice = is.read();
                                            if (choice != -1) break block7;
                                            logger.log(Level.WARNING, "Invalid token format, choice not found");
                                            break block4;
                                        }
                                        if (choice != 160) break block8;
                                        len = SPNEGONegTokenUtils.getLengthDER(is);
                                        if (len == 3 && is.read() == 10 && is.read() == 1) break block9;
                                        logger.log(Level.WARNING, "negResult appears invalid");
                                        break block4;
                                    }
                                    choice = is.read();
                                    if (choice != 0) break block10;
                                    logger.log(Level.INFO, "negResult is ACCEPT_COMPLETED");
                                    break block11;
                                }
                                if (choice != 1) break block12;
                                logger.log(Level.INFO, "negResult is ACCEPT_INCOMPLETE");
                                break block11;
                            }
                            if (choice == 2) break block13;
                            logger.log(Level.WARNING, "negResult is unknown, invalid token");
                            break block4;
                        }
                        logger.log(Level.INFO, "negResult is REJECTED");
                    }
                    choice = is.read();
                    if (choice != -1) break block8;
                    logger.log(Level.WARNING, "Invalid token format, invalid choice");
                    break block4;
                }
                if (choice != 161) break block14;
                len = SPNEGONegTokenUtils.getLengthDER(is);
                is.skip(len);
                choice = is.read();
                if (choice != -1) break block14;
                logger.log(Level.WARNING, "Invalid token format, invalid choice again.");
                break block4;
            }
            if (choice != 162) break block4;
            len = SPNEGONegTokenUtils.getLengthDER(is);
            if (is.read() != 4) {
                logger.log(Level.WARNING, "Response token invalid, not octet string");
            } else {
                len = SPNEGONegTokenUtils.getLengthDER(is);
                byte[] respToken = new byte[len];
                if (is.read(respToken, 0, len) == -1) {
                    logger.log(Level.WARNING, "Response token invalid - EOF");
                } else {
                    logger.log(Level.INFO, "Response token found");
                    decodedToken = respToken;
                }
            }
        }
        return decodedToken;
    }
}

