/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient.ntlm;

import HTTPClient.AuthenticationSchemeBase;
import HTTPClient.AuthorizationInfo;
import HTTPClient.HttpClientConfiguration;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.RoRequest;
import HTTPClient.RoResponse;
import HTTPClient.ntlm.NtlmCore;
import HTTPClient.ntlm.NtlmSupportFlags;
import HTTPClient.ntlm.NtlmType2Message;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class NtlmAuthenticationScheme
extends AuthenticationSchemeBase {
    public static final String DEFAULT_SCHEME_NAME = "NTLM";
    public static final String NTLM_REALM = "";
    private static final Logger logger = HttpClientLoggerFactory.getLogger(NtlmAuthenticationScheme.class.getName());

    public NtlmAuthenticationScheme() throws IllegalArgumentException {
        super(DEFAULT_SCHEME_NAME, true);
    }

    public NtlmAuthenticationScheme(String schemeName) throws IllegalArgumentException {
        super(schemeName, true);
    }

    public AuthorizationInfo createAuthorizationInfo(String host, int port, String ntlmAuthMethod, String username, String password) throws IllegalArgumentException {
        if (null == host || NTLM_REALM.equals(host)) {
            throw new IllegalArgumentException("Expected non-null, non-empty host name.");
        }
        if (null == username) {
            username = NTLM_REALM;
        }
        if (null == password) {
            password = NTLM_REALM;
        }
        String domain = NTLM_REALM;
        String parsedUsername = username.trim();
        int index = -1;
        index = username.indexOf(92);
        if (-1 != index) {
            domain = parsedUsername.substring(0, index);
            parsedUsername = parsedUsername.substring(index + 1);
        }
        if (NTLM_REALM.equals(domain)) {
            domain = HttpClientConfiguration.getDefaultNtlmDomainName();
        }
        byte[] lmPasswordHash = new byte[]{};
        try {
            lmPasswordHash = NtlmCore.generateLmV1Hash(password);
        }
        catch (Exception e) {
            logger.log(Level.FINER, "Unable to generate the LM version 1 hash.", e);
        }
        byte[] ntPasswordHash = new byte[]{};
        try {
            ntPasswordHash = NtlmCore.generateNtlmV1Hash(password);
        }
        catch (Exception e) {
            logger.log(Level.FINER, "Unable to generate the NTLM version 1 hash.", e);
        }
        HashMap<String, Object> credentials = new HashMap<String, Object>(4);
        credentials.put("USER_DOMAIN", domain);
        credentials.put("USER_NAME", parsedUsername);
        credentials.put("LM_PASSWORD_HASH", lmPasswordHash);
        credentials.put("NTLM_PASSWORD_HASH", ntPasswordHash);
        if (ntlmAuthMethod != null) {
            credentials.put("NTLM_AUTH_METHOD", ntlmAuthMethod);
        }
        AuthorizationInfo output = new AuthorizationInfo(host, port, this.getSchemeName(), NTLM_REALM, null, credentials);
        return output;
    }

    public AuthorizationInfo getAuthorization(AuthorizationInfo credentials, RoRequest request, AuthorizationInfo challenge, RoResponse response) {
        if (null == credentials) {
            return null;
        }
        if (null == challenge) {
            return null;
        }
        AuthorizationInfo output = null;
        String cookie = challenge.getCookie();
        if (null == cookie) {
            cookie = NTLM_REALM;
        }
        cookie = cookie.trim();
        Object extraInfo = credentials.getExtraInfo();
        if (!(extraInfo instanceof Map)) {
            logger.log(Level.FINER, "credentials ExtraInfo property expected to be an instance of java.util.Map object.");
            return null;
        }
        Map credentialsMap = (Map)extraInfo;
        String ntlmAuthMethod = NtlmCore.getNtlmAuthMethod((String)credentialsMap.get("NTLM_AUTH_METHOD"));
        if (NTLM_REALM.equals(cookie)) {
            cookie = NtlmCore.formatType1Message(null, null, ntlmAuthMethod);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "getAuthorization() called with empty cookie. Generated Type 1 message. Host={0}, Port={1}, Type 1 Message=''{2}''.", new Object[]{credentials.getHost(), String.valueOf(credentials.getPort()), cookie});
            }
            output = new AuthorizationInfo(credentials.getHost(), credentials.getPort(), credentials.getScheme(), credentials.getRealm(), cookie);
        } else {
            NtlmType2Message type2Message = NtlmCore.parseType2Message(cookie);
            if (null == type2Message) {
                logger.log(Level.FINER, "Unable to parse NTLM type 2 message.");
                return null;
            }
            String clientHostName = null;
            String userDomain = (String)credentialsMap.get("USER_DOMAIN");
            String username = (String)credentialsMap.get("USER_NAME");
            byte[] lmPasswordHash = (byte[])credentialsMap.get("LM_PASSWORD_HASH");
            byte[] ntPasswordHash = (byte[])credentialsMap.get("NTLM_PASSWORD_HASH");
            cookie = NtlmCore.formatType3Message(clientHostName, userDomain, username, lmPasswordHash, ntPasswordHash, type2Message, ntlmAuthMethod);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "getAuthorization() called with populated cookie (Type 2 message). Generated Type 3 message. Host={0}, Port={1}, Type 3 Message=''{2}''.", new Object[]{credentials.getHost(), String.valueOf(credentials.getPort()), cookie});
                NtlmSupportFlags flags = type2Message.getFlags();
                logger.log(Level.FINEST, "Server set NTLMv2 Session flag: {0}", new Boolean(flags.anyFlagsOn(524288)));
                logger.log(Level.FINEST, "Server set NTLM flag: {0}", new Boolean(flags.anyFlagsOn(512)));
                logger.log(Level.FINEST, "Server set OEM Charset flag: {0}", new Boolean(flags.anyFlagsOn(2)));
                logger.log(Level.FINEST, "Server set Unicode Charset flag: {0}", new Boolean(flags.anyFlagsOn(1)));
            }
            output = new AuthorizationInfo(credentials.getHost(), credentials.getPort(), credentials.getScheme(), credentials.getRealm(), cookie);
        }
        return output;
    }

    public static interface AuthInfoParams {
        public static final String USER_DOMAIN = "USER_DOMAIN";
        public static final String USER_NAME = "USER_NAME";
        public static final String LM_PASSWORD_HASH = "LM_PASSWORD_HASH";
        public static final String NTLM_PASSWORD_HASH = "NTLM_PASSWORD_HASH";
        public static final String NTLM_AUTH_METHOD = "NTLM_AUTH_METHOD";
    }
}

