/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient.ntlm;

import HTTPClient.Codecs;
import HTTPClient.HttpClientConfiguration;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.Util;
import HTTPClient.crypto.MD4;
import HTTPClient.ntlm.NtlmSupportFlags;
import HTTPClient.ntlm.NtlmType2Message;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.Key;
import java.security.MessageDigest;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public final class NtlmCore {
    private static final Logger logger = HttpClientLoggerFactory.getLogger(NtlmCore.class.getName());
    public static final String OEM_CHARSET = "ISO-8859-1";
    public static final String UNICODE_CHARSET = "UTF-16LE";
    public static final String ASCII_CHARSET = "US-ASCII";
    static final boolean USE_OEM = true;
    static final boolean SILENTLY = true;
    static final byte[] NTLMSSP_BYTES = NtlmCore.toNtlmBytes("NTLMSSP", true);
    private static final int INITIAL_FORMAT_BUFFER_SIZE = 1024;
    private static final byte[] MAGIC = new byte[]{75, 71, 83, 33, 64, 35, 36, 37};
    static final short LM_RESPONSE_LENGTH = 24;
    static final short NTLM_RESPONSE_LENGTH = 24;
    static final short LM_HASH_LENGTH = 16;
    static final short NTLM_HASH_LENGTH = 16;
    public static final String AUTH_METHOD_DEFAULT = "AUTO";
    private static final String[] SUPPORTED_NTLM_AUTH_METHODS = new String[]{"AUTO", "NTLMV2", "NTLMV2_SESSION", "NTLMV1"};
    private static final Random RANDOM_GENERATOR;

    private static URLClassLoader newPrivilegedURLClassLoader(final URL[] urls) {
        if (null == urls || 0 == urls.length) {
            throw new IllegalArgumentException("Non-null and non-empty URL[] expected.");
        }
        return (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new URLClassLoader(urls);
            }
        });
    }

    private static byte[] toNtlmBytes(short input) {
        byte byte1 = (byte)(input >>> 8);
        byte byte0 = (byte)input;
        byte[] output = new byte[]{byte0, byte1};
        return output;
    }

    private static byte[] toNtlmBytes(String input, boolean useOemEncoding) {
        byte[] NULL_OUTPUT;
        byte[] output = NULL_OUTPUT = new byte[0];
        if (null == input || "".equals(input)) {
            return output;
        }
        if (useOemEncoding) {
            try {
                output = input.getBytes(OEM_CHARSET);
            }
            catch (UnsupportedEncodingException e) {
                logger.log(Level.FINER, "The OEM character set ''ISO-8859-1' is not supported.", e);
            }
        } else {
            try {
                output = input.getBytes(UNICODE_CHARSET);
            }
            catch (UnsupportedEncodingException e) {
                logger.log(Level.FINER, "The Unicode character set ''UTF-16LE' is not supported.", e);
            }
        }
        return output;
    }

    private static void applyOddParity(byte[] input) {
        if (null == input) {
            throw new IllegalArgumentException("Non-null input expected.");
        }
        for (int i = 0; i < input.length; ++i) {
            boolean needsParity;
            byte inputByte = input[i];
            boolean bl = needsParity = ((inputByte >>> 7 ^ inputByte >>> 6 ^ inputByte >>> 5 ^ inputByte >>> 4 ^ inputByte >>> 3 ^ inputByte >>> 2 ^ inputByte >>> 1) & 1) == 0;
            if (needsParity) {
                int n = i;
                input[n] = (byte)(input[n] | 1);
                continue;
            }
            int n = i;
            input[n] = (byte)(input[n] & 0xFFFFFFFE);
        }
    }

    private static Key generateDESKey(byte[] keySource, int offset) {
        if (null == keySource || keySource.length < 7) {
            throw new IllegalArgumentException("Expected keySource array to be non-null and at least 7 bytes long.");
        }
        if (offset < 0 || offset > keySource.length - 7) {
            throw new IllegalArgumentException("Offset expected to be >= 0 and <= (keySource.length-7): offset=" + offset + ", keySource.length=" + keySource.length + ".");
        }
        byte[] inputBytes = new byte[7];
        System.arraycopy(keySource, offset, inputBytes, 0, 7);
        byte[] keyMaterial = new byte[]{inputBytes[0], (byte)(inputBytes[0] << 7 | (inputBytes[1] & 0xFF) >>> 1), (byte)(inputBytes[1] << 6 | (inputBytes[2] & 0xFF) >>> 2), (byte)(inputBytes[2] << 5 | (inputBytes[3] & 0xFF) >>> 3), (byte)(inputBytes[3] << 4 | (inputBytes[4] & 0xFF) >>> 4), (byte)(inputBytes[4] << 3 | (inputBytes[5] & 0xFF) >>> 5), (byte)(inputBytes[5] << 2 | (inputBytes[6] & 0xFF) >>> 6), (byte)(inputBytes[6] << 1)};
        NtlmCore.applyOddParity(keyMaterial);
        return new SecretKeySpec(keyMaterial, "DES");
    }

    public static byte[] generateLmV1Hash(String password) throws Exception {
        if (null == password) {
            password = "";
        }
        password = password.toUpperCase();
        byte[] passwordBytes = NtlmCore.toNtlmBytes(password, true);
        byte[] fixedPassword = new byte[14];
        int minLength = Math.min(passwordBytes.length, 14);
        System.arraycopy(passwordBytes, 0, fixedPassword, 0, minLength);
        Key lowKey = NtlmCore.generateDESKey(fixedPassword, 0);
        Key highKey = NtlmCore.generateDESKey(fixedPassword, 7);
        Cipher des = Cipher.getInstance("DES/ECB/NoPadding");
        des.init(1, lowKey);
        byte[] lowHash = des.doFinal(MAGIC);
        des.init(1, highKey);
        byte[] highHash = des.doFinal(MAGIC);
        byte[] output = new byte[16];
        System.arraycopy(lowHash, 0, output, 0, 8);
        System.arraycopy(highHash, 0, output, 8, 8);
        return output;
    }

    private static byte[] generateMd4Hash(byte[] input) throws Exception {
        if (null == input) {
            throw new IllegalArgumentException("Non-null input expected.");
        }
        MD4 md4 = new MD4();
        return md4.computeDigest(input);
    }

    public static byte[] generateNtlmV1Hash(String password) throws Exception {
        if (null == password) {
            password = "";
        }
        byte[] passwordBytes = NtlmCore.toNtlmBytes(password, false);
        return NtlmCore.generateMd4Hash(passwordBytes);
    }

    public static byte[] generateLmV1Response(byte[] passwordHash, byte[] nonce) throws Exception {
        if (null == passwordHash || 16 != passwordHash.length) {
            throw new IllegalArgumentException("Expected non-null, 16 byte passwordHash.");
        }
        if (null == nonce || 8 != nonce.length) {
            throw new IllegalArgumentException("Expected non-null, 8 byte nonce.");
        }
        byte[] extendedHash = new byte[21];
        System.arraycopy(passwordHash, 0, extendedHash, 0, 16);
        Key key0 = NtlmCore.generateDESKey(extendedHash, 0);
        Key key1 = NtlmCore.generateDESKey(extendedHash, 7);
        Key key2 = NtlmCore.generateDESKey(extendedHash, 14);
        Cipher des = Cipher.getInstance("DES/ECB/NoPadding");
        des.init(1, key0);
        byte[] response0 = des.doFinal(nonce);
        des.init(1, key1);
        byte[] response1 = des.doFinal(nonce);
        des.init(1, key2);
        byte[] response2 = des.doFinal(nonce);
        byte[] output = new byte[24];
        System.arraycopy(response0, 0, output, 0, 8);
        System.arraycopy(response1, 0, output, 8, 8);
        System.arraycopy(response2, 0, output, 16, 8);
        return output;
    }

    private static byte[] generateHmacMd5Hash(byte[] data, byte[] key) throws Exception {
        int i;
        byte[] ipad = new byte[64];
        byte[] opad = new byte[64];
        for (i = 0; i < 64; ++i) {
            ipad[i] = 54;
            opad[i] = 92;
        }
        for (i = key.length - 1; i >= 0; --i) {
            int n = i;
            ipad[n] = (byte)(ipad[n] ^ key[i]);
            int n2 = i;
            opad[n2] = (byte)(opad[n2] ^ key[i]);
        }
        byte[] content = new byte[data.length + 64];
        System.arraycopy(ipad, 0, content, 0, 64);
        System.arraycopy(data, 0, content, 64, data.length);
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        data = md5.digest(content);
        content = new byte[data.length + 64];
        System.arraycopy(opad, 0, content, 0, 64);
        System.arraycopy(data, 0, content, 64, data.length);
        return md5.digest(content);
    }

    public static byte[] generateNtlmV2Hash(String target, String user, byte[] ntlmV1PasswordHash) throws Exception {
        String identity = user.toUpperCase() + target;
        return NtlmCore.generateHmacMd5Hash(identity.getBytes("UnicodeLittleUnmarked"), ntlmV1PasswordHash);
    }

    public static byte[] generateLmV2Response(String target, String user, byte[] ntlmV1PasswordHash, byte[] challenge, byte[] clientNonce) throws Exception {
        byte[] ntlmv2Hash = NtlmCore.generateNtlmV2Hash(target, user, ntlmV1PasswordHash);
        return NtlmCore.lmv2Response(ntlmv2Hash, clientNonce, challenge);
    }

    public static byte[] generateNtlmV2Response(String target, String user, byte[] ntlmV1PasswordHash, byte[] targetInformation, byte[] challenge, byte[] clientNonce) throws Exception {
        byte[] ntlmv2Hash = NtlmCore.generateNtlmV2Hash(target, user, ntlmV1PasswordHash);
        byte[] blob = NtlmCore.generateBlob(targetInformation, clientNonce);
        return NtlmCore.lmv2Response(ntlmv2Hash, blob, challenge);
    }

    private static byte[] lmv2Response(byte[] hash, byte[] clientData, byte[] challenge) throws Exception {
        byte[] data = new byte[challenge.length + clientData.length];
        System.arraycopy(challenge, 0, data, 0, challenge.length);
        System.arraycopy(clientData, 0, data, challenge.length, clientData.length);
        byte[] mac = NtlmCore.generateHmacMd5Hash(data, hash);
        byte[] lmv2Response = new byte[mac.length + clientData.length];
        System.arraycopy(mac, 0, lmv2Response, 0, mac.length);
        System.arraycopy(clientData, 0, lmv2Response, mac.length, clientData.length);
        return lmv2Response;
    }

    private static byte[] generateBlob(byte[] targetInformation, byte[] clientNonce) {
        byte[] blobSignature = new byte[]{1, 1, 0, 0};
        byte[] reserved = new byte[]{0, 0, 0, 0};
        byte[] unknown1 = new byte[]{0, 0, 0, 0};
        byte[] unknown2 = new byte[]{0, 0, 0, 0};
        long time = System.currentTimeMillis();
        time += 11644473600000L;
        time *= 10000L;
        byte[] timeStamp = new byte[8];
        for (int i = 0; i < 8; ++i) {
            timeStamp[i] = (byte)time;
            time >>>= 8;
        }
        byte[] blob = new byte[blobSignature.length + reserved.length + timeStamp.length + clientNonce.length + unknown1.length + targetInformation.length + unknown2.length];
        int offset = 0;
        System.arraycopy(blobSignature, 0, blob, offset, blobSignature.length);
        System.arraycopy(reserved, 0, blob, offset += blobSignature.length, reserved.length);
        System.arraycopy(timeStamp, 0, blob, offset += reserved.length, timeStamp.length);
        System.arraycopy(clientNonce, 0, blob, offset += timeStamp.length, clientNonce.length);
        System.arraycopy(unknown1, 0, blob, offset += clientNonce.length, unknown1.length);
        System.arraycopy(targetInformation, 0, blob, offset += unknown1.length, targetInformation.length);
        System.arraycopy(unknown2, 0, blob, offset += targetInformation.length, unknown2.length);
        return blob;
    }

    public static byte[] generateNtlm2SessionResponse(byte[] ntlmHash, byte[] challenge, byte[] clientNonce) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(challenge);
        md5.update(clientNonce);
        byte[] sessionHash = new byte[8];
        System.arraycopy(md5.digest(), 0, sessionHash, 0, 8);
        return NtlmCore.generateLmV1Response(ntlmHash, sessionHash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] generateClientNonce() {
        byte[] randomValue = new byte[8];
        Random random = RANDOM_GENERATOR;
        synchronized (random) {
            RANDOM_GENERATOR.nextBytes(randomValue);
        }
        return randomValue;
    }

    public static String formatType1Message(String clientHostName, String clientHostDomain, String ntlmAuthMethod) {
        if (null == clientHostName) {
            clientHostName = "";
        }
        if (null == clientHostDomain) {
            clientHostDomain = "";
        }
        clientHostName = clientHostName.toUpperCase();
        clientHostDomain = clientHostDomain.toUpperCase();
        byte[] clientHostNameBytes = NtlmCore.toNtlmBytes(clientHostName, true);
        byte[] clientHostDomainBytes = NtlmCore.toNtlmBytes(clientHostDomain, true);
        short clientHostDomainLength = (short)clientHostDomainBytes.length;
        short clientHostNameLength = (short)clientHostNameBytes.length;
        int clientHostNameOffset = 32;
        short clientHostDomainOffset = (short)(32 + clientHostNameLength);
        NtlmSupportFlags supportFlags = new NtlmSupportFlags(0x8004 | (clientHostNameLength > 0 ? 8192 : 0) | (clientHostDomainLength > 0 ? 4096 : 0) | (ntlmAuthMethod.equalsIgnoreCase("NTLMV2_SESSION") || ntlmAuthMethod.equalsIgnoreCase(AUTH_METHOD_DEFAULT) ? 524288 : 0) | 0x200 | 2 | 1);
        ByteArrayOutputStream baOS = new ByteArrayOutputStream(1024);
        DataOutputStream dataOS = new DataOutputStream(baOS);
        String output = "";
        try {
            dataOS.write(NTLMSSP_BYTES);
            dataOS.writeByte(0);
            dataOS.writeByte(1);
            dataOS.writeByte(0);
            dataOS.writeByte(0);
            dataOS.writeByte(0);
            dataOS.write(supportFlags.getNtlmBytes());
            dataOS.write(NtlmCore.toNtlmBytes(clientHostDomainLength));
            dataOS.write(NtlmCore.toNtlmBytes(clientHostDomainLength));
            dataOS.write(NtlmCore.toNtlmBytes(clientHostDomainOffset));
            dataOS.writeByte(0);
            dataOS.writeByte(0);
            dataOS.write(NtlmCore.toNtlmBytes(clientHostNameLength));
            dataOS.write(NtlmCore.toNtlmBytes(clientHostNameLength));
            dataOS.write(NtlmCore.toNtlmBytes((short)32));
            dataOS.writeByte(0);
            dataOS.writeByte(0);
            dataOS.write(clientHostNameBytes);
            dataOS.write(clientHostDomainBytes);
            dataOS.flush();
            byte[] outputBytes = baOS.toByteArray();
            byte[] encodedOutputBytes = Codecs.base64Encode(outputBytes);
            output = new String(encodedOutputBytes, ASCII_CHARSET);
        }
        catch (IOException e) {
            logger.log(Level.FINER, "Trying to format an NTLM Type 1 message.", e);
        }
        return output;
    }

    public static NtlmType2Message parseType2Message(String messageStr) {
        try {
            return new NtlmType2Message(messageStr);
        }
        catch (IllegalArgumentException ie) {
            Throwable causeException = ie.getCause();
            if (causeException != null) {
                logger.log(Level.FINER, ie.getMessage(), causeException);
            } else {
                logger.log(Level.FINER, ie.getMessage());
            }
            return null;
        }
    }

    public static String formatType3Message(String clientHostName, String userDomain, String username, byte[] lmPasswordHash, byte[] ntlmPasswordHash, NtlmType2Message challenge, String ntlmAuthMethod) {
        byte[] lmResponseBytes;
        byte[] ntlmResponseBytes;
        byte[] usernameBytes;
        byte[] userDomainBytes;
        byte[] clientHostNameBytes;
        block12: {
            boolean useOem;
            if (null == challenge) {
                throw new IllegalArgumentException("Non-null NtlmType2Message object expected.");
            }
            if (null == clientHostName) {
                clientHostName = "";
            }
            if (null == userDomain || userDomain.isEmpty()) {
                String string = userDomain = challenge.getTarget() != null ? challenge.getTarget() : "";
            }
            if (null == username) {
                username = "";
            }
            String originalUserDomain = userDomain;
            String originalUsername = username;
            boolean bl = useOem = !challenge.getFlags().anyFlagsOn(1);
            if (useOem) {
                clientHostName = clientHostName.toUpperCase();
                userDomain = userDomain.toUpperCase();
                username = username.toUpperCase();
            }
            clientHostNameBytes = NtlmCore.toNtlmBytes(clientHostName, useOem);
            userDomainBytes = NtlmCore.toNtlmBytes(userDomain, useOem);
            usernameBytes = NtlmCore.toNtlmBytes(username, useOem);
            byte[] nonce = challenge.getNonce();
            ntlmResponseBytes = new byte[]{};
            lmResponseBytes = new byte[]{};
            logger.log(Level.FINEST, "Client will use {0} authorization method.", ntlmAuthMethod);
            try {
                byte[] clientNonce;
                if (ntlmAuthMethod.equalsIgnoreCase("NTLMV2") || challenge.getTargetInformation() != null && !userDomain.isEmpty() && ntlmAuthMethod.equalsIgnoreCase(AUTH_METHOD_DEFAULT)) {
                    logger.log(Level.FINEST, "NTLMv2 response is calculated.");
                    clientNonce = NtlmCore.generateClientNonce();
                    lmResponseBytes = NtlmCore.generateLmV2Response(originalUserDomain, originalUsername, ntlmPasswordHash, nonce, clientNonce);
                    ntlmResponseBytes = NtlmCore.generateNtlmV2Response(originalUserDomain, originalUsername, ntlmPasswordHash, challenge.getTargetInformation(), nonce, clientNonce);
                    break block12;
                }
                if (ntlmAuthMethod.equalsIgnoreCase("NTLMV2_SESSION") || challenge.getFlags().anyFlagsOn(524288) && ntlmAuthMethod.equalsIgnoreCase(AUTH_METHOD_DEFAULT)) {
                    logger.log(Level.FINEST, "NTLM2 Session response is calculated.");
                    clientNonce = NtlmCore.generateClientNonce();
                    lmResponseBytes = Util.resizeArray(clientNonce, 24);
                    Arrays.fill(lmResponseBytes, 8, 24, (byte)0);
                    ntlmResponseBytes = NtlmCore.generateNtlm2SessionResponse(ntlmPasswordHash, nonce, clientNonce);
                    break block12;
                }
                if (ntlmAuthMethod.equalsIgnoreCase("NTLMV1") || ntlmAuthMethod.equalsIgnoreCase(AUTH_METHOD_DEFAULT)) {
                    logger.log(Level.FINEST, "NTLMv1 response is calculated.");
                    lmResponseBytes = NtlmCore.generateLmV1Response(lmPasswordHash, nonce);
                    ntlmResponseBytes = NtlmCore.generateLmV1Response(ntlmPasswordHash, nonce);
                    break block12;
                }
                String msgInvalidNtlmAuthMethod = "Invalid NTLM Authorization method: " + ntlmAuthMethod;
                logger.log(Level.FINER, msgInvalidNtlmAuthMethod);
                throw new IllegalArgumentException(msgInvalidNtlmAuthMethod);
            }
            catch (Exception e) {
                String msgIncorrectResponse = "Unable to generate Correct response.";
                logger.log(Level.FINER, msgIncorrectResponse, e);
                throw new IllegalArgumentException(msgIncorrectResponse + " " + e.getMessage());
            }
        }
        short lmResponseLength = (short)lmResponseBytes.length;
        short ntlmResponseLength = (short)ntlmResponseBytes.length;
        short clientHostNameLength = (short)clientHostNameBytes.length;
        short userDomainLength = (short)userDomainBytes.length;
        short usernameLength = (short)usernameBytes.length;
        short lmResponseOffset = 64;
        short ntlmResponseOffset = (short)(lmResponseOffset + lmResponseLength);
        short userDomainOffset = (short)(ntlmResponseOffset + ntlmResponseLength);
        short usernameOffset = (short)(userDomainOffset + userDomainLength);
        short clientHostNameOffset = (short)(usernameOffset + usernameLength);
        short sessionKeyOffset = (short)(clientHostNameOffset + clientHostNameLength);
        ByteArrayOutputStream baOS = new ByteArrayOutputStream(1024);
        DataOutputStream dataOS = new DataOutputStream(baOS);
        String output = "";
        try {
            dataOS.write(NTLMSSP_BYTES);
            dataOS.writeByte(0);
            dataOS.writeByte(3);
            dataOS.writeByte(0);
            dataOS.writeByte(0);
            dataOS.writeByte(0);
            dataOS.write(NtlmCore.toNtlmBytes(lmResponseLength));
            dataOS.write(NtlmCore.toNtlmBytes(lmResponseLength));
            dataOS.write(NtlmCore.toNtlmBytes(lmResponseOffset));
            dataOS.writeByte(0);
            dataOS.writeByte(0);
            dataOS.write(NtlmCore.toNtlmBytes(ntlmResponseLength));
            dataOS.write(NtlmCore.toNtlmBytes(ntlmResponseLength));
            dataOS.write(NtlmCore.toNtlmBytes(ntlmResponseOffset));
            dataOS.writeByte(0);
            dataOS.writeByte(0);
            dataOS.write(NtlmCore.toNtlmBytes(userDomainLength));
            dataOS.write(NtlmCore.toNtlmBytes(userDomainLength));
            dataOS.write(NtlmCore.toNtlmBytes(userDomainOffset));
            dataOS.writeByte(0);
            dataOS.writeByte(0);
            dataOS.write(NtlmCore.toNtlmBytes(usernameLength));
            dataOS.write(NtlmCore.toNtlmBytes(usernameLength));
            dataOS.write(NtlmCore.toNtlmBytes(usernameOffset));
            dataOS.writeByte(0);
            dataOS.writeByte(0);
            dataOS.write(NtlmCore.toNtlmBytes(clientHostNameLength));
            dataOS.write(NtlmCore.toNtlmBytes(clientHostNameLength));
            dataOS.write(NtlmCore.toNtlmBytes(clientHostNameOffset));
            dataOS.writeByte(0);
            dataOS.writeByte(0);
            dataOS.writeShort(0);
            dataOS.writeShort(0);
            dataOS.write(NtlmCore.toNtlmBytes(sessionKeyOffset));
            dataOS.writeByte(0);
            dataOS.writeByte(0);
            dataOS.write(challenge.getFlags().getNtlmBytes());
            dataOS.write(lmResponseBytes);
            dataOS.write(ntlmResponseBytes);
            dataOS.write(userDomainBytes);
            dataOS.write(usernameBytes);
            dataOS.write(clientHostNameBytes);
            dataOS.flush();
            byte[] outputBytes = baOS.toByteArray();
            byte[] encodedOutputBytes = Codecs.base64Encode(outputBytes);
            output = new String(encodedOutputBytes, ASCII_CHARSET);
        }
        catch (IOException e) {
            logger.log(Level.FINER, "Trying to format an NTLM Type 3 message.", e);
        }
        return output;
    }

    public static byte[] getNtlmSspBytes() {
        byte[] output = new byte[NTLMSSP_BYTES.length];
        System.arraycopy(NTLMSSP_BYTES, 0, output, 0, NTLMSSP_BYTES.length);
        return output;
    }

    static String getNtlmAuthMethod(String ntlmAuthMethod) {
        if (ntlmAuthMethod == null || ntlmAuthMethod.isEmpty() || !NtlmCore.isNtlmAuthMethodValid(ntlmAuthMethod)) {
            return HttpClientConfiguration.getDefaultNtlmAuthMethod();
        }
        return ntlmAuthMethod;
    }

    private static boolean isNtlmAuthMethodValid(String ntlmAuthMethod) {
        boolean supported = false;
        for (int i = 0; i < SUPPORTED_NTLM_AUTH_METHODS.length; ++i) {
            if (!SUPPORTED_NTLM_AUTH_METHODS[i].equalsIgnoreCase(ntlmAuthMethod)) continue;
            supported = true;
            break;
        }
        return supported;
    }

    static {
        Random randomInstance = null;
        try {
            randomInstance = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception e) {
            randomInstance = new Random();
        }
        RANDOM_GENERATOR = randomInstance;
    }

    public static interface AuthMethod {
        public static final String AUTO = "AUTO";
        public static final String NTLMV2 = "NTLMV2";
        public static final String NTLMV2_SESSION = "NTLMV2_SESSION";
        public static final String NTLMV1 = "NTLMV1";
    }
}

