/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient.ntlm;

import HTTPClient.Codecs;
import HTTPClient.HttpClientLoggerFactory;
import HTTPClient.ntlm.NtlmCore;
import HTTPClient.ntlm.NtlmSupportFlags;
import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;

public final class NtlmType2Message {
    private static final Logger logger = HttpClientLoggerFactory.getLogger(NtlmType2Message.class.getName());
    private NtlmSupportFlags flags = null;
    private byte[] nonce = null;
    private String target = null;
    private byte[] targetInformation = null;

    public NtlmType2Message(String messageStr) throws IllegalArgumentException {
        byte[] messageBytes = null;
        try {
            messageBytes = messageStr.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Ntlm is not supported, since ASCII ('US-ASCII') is not supported.", e);
        }
        byte[] decodedMessageBytes = null;
        try {
            decodedMessageBytes = Codecs.base64Decode(messageBytes);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Corrupt type 2 message given, unable to base-64 decode, '" + messageStr + "'.", e);
        }
        if (decodedMessageBytes.length < 32) {
            throw new IllegalArgumentException("NTLM Type 2 message expected to be at least 32 bytes long, was " + decodedMessageBytes.length + " bytes long. Base64Encoded Message ''" + messageStr + "''");
        }
        for (int i = 0; i < NtlmCore.NTLMSSP_BYTES.length; ++i) {
            if (decodedMessageBytes[i] == NtlmCore.NTLMSSP_BYTES[i]) continue;
            throw new IllegalArgumentException("NTLM Type 2 message expected to start with ''NTLMSSP''. Base64Encoded Message ''" + messageStr + "''");
        }
        byte[] TYPE_2_MESSAGE_TYPE = new byte[]{2, 0, 0, 0};
        for (int i = 0; i < TYPE_2_MESSAGE_TYPE.length; ++i) {
            if (decodedMessageBytes[i + 8] == TYPE_2_MESSAGE_TYPE[i]) continue;
            throw new IllegalArgumentException("NTLM Type 2 message expected to indicate Type 2. Base64Encoded Message ''" + messageStr + "''");
        }
        byte[] flagNtlmBytes = new byte[4];
        NtlmType2Message.extractBytes(decodedMessageBytes, flagNtlmBytes, 20);
        this.flags = new NtlmSupportFlags(flagNtlmBytes);
        byte[] nonce = new byte[8];
        NtlmType2Message.extractBytes(decodedMessageBytes, nonce, 24);
        this.nonce = nonce;
        byte[] target = NtlmType2Message.extractSecurityBuffer(decodedMessageBytes, 12);
        if (target != null && target.length != 0) {
            try {
                this.target = new String(target, "UnicodeLittleUnmarked");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        this.targetInformation = NtlmType2Message.extractSecurityBuffer(decodedMessageBytes, 40);
    }

    private static void extractBytes(byte[] src, byte[] dst, int index) throws IllegalArgumentException {
        if (src.length < index + dst.length) {
            throw new IllegalArgumentException("NTLM Type 2 message too short");
        }
        System.arraycopy(src, index, dst, 0, dst.length);
    }

    private static int getLength(byte[] src, int index) throws IllegalArgumentException {
        if (src.length < index + 2) {
            throw new IllegalArgumentException("NTLM Type 2 message security buffer length too small at position " + index);
        }
        return src[index] & 0xFF | (src[index + 1] & 0xFF) << 8;
    }

    private static int getOffset(byte[] src, int index) throws IllegalArgumentException {
        if (src.length < index + 4) {
            throw new IllegalArgumentException("NTLM Type 2 message security buffer offset data too small at position " + index);
        }
        return src[index] & 0xFF | (src[index + 1] & 0xFF) << 8 | (src[index + 2] & 0xFF) << 16 | (src[index + 3] & 0xFF) << 24;
    }

    private static byte[] extractSecurityBuffer(byte[] src, int index) throws IllegalArgumentException {
        int length;
        byte[] buffer = null;
        if (src.length >= index + 8 && (length = NtlmType2Message.getLength(src, index)) > 0) {
            int offset = NtlmType2Message.getOffset(src, index + 4);
            if (src.length < offset + length) {
                throw new IllegalArgumentException("NTLM Type2 message security buffer too small for data item at offset " + offset);
            }
            buffer = new byte[length];
            System.arraycopy(src, offset, buffer, 0, length);
        }
        return buffer;
    }

    public NtlmSupportFlags getFlags() {
        return this.flags;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public String getTarget() {
        return this.target;
    }

    public byte[] getTargetInformation() {
        return this.targetInformation;
    }
}

